/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.idea.AppMode;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.fus.JupyterFeatureCollectorManager;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterConsoleUtil;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorCustomizer;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditorProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewBuilder;
import com.intellij.jupyter.core.premium.JupyterFearureAvailabilityInfoProvider;
import com.intellij.jupyter.core.premium.JupyterFeatureAvailabilityCheckerKt;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.StructureViewFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.JComponentFileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0016J0\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001e\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J \u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0016R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/AsyncFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/ex/StructureViewFileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "createJupyterFileEditor", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "createFileEditor", "document", "Lcom/intellij/openapi/editor/Document;", "editorCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createEditorInternal", "notebookSourceFile", "proNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "initProFeatures", "", "editor", "updateNotificationPanel", "panel", "checkEditorAndPsi", "Lcom/intellij/openapi/editor/Editor;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "disposeEditor", "moveCaret", "textEditor", "accept", "", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileEditorProvider.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterFileEditorProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n23#2:220\n23#2:222\n23#2:223\n23#2:226\n1#3:221\n1869#4,2:224\n*S KotlinDebug\n*F\n+ 1 JupyterFileEditorProvider.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterFileEditorProvider\n*L\n54#1:220\n82#1:222\n114#1:223\n188#1:226\n125#1:224,2\n*E\n"})
public abstract class JupyterFileEditorProvider
implements AsyncFileEditorProvider,
StructureViewFileEditorProvider,
DumbAware {
    @Nullable
    private EditorNotificationPanel proNotificationPanel;

    @NotNull
    public abstract JupyterFileEditor createJupyterFileEditor(@NotNull Project var1, @NotNull BackedNotebookVirtualFile var2);

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor fileEditor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JupyterFileEditorProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterFileEditorProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Creating editor for file " + file.getPath() + " in blocking process");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        BackedNotebookVirtualFile notebookVirtualFile2 = BackedNotebookVirtualFile.Companion.getOrLoadForDisposable(file, disposable2);
        try {
            FileEditor it = fileEditor = this.createEditorInternal(file, project, notebookVirtualFile2);
            boolean bl = false;
            Disposer.register((Disposable)((Disposable)it), (Disposable)disposable2);
        }
        catch (Throwable t) {
            Disposer.dispose((Disposable)disposable2);
            throw t;
        }
        return fileEditor;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiFile jupyterPsiFile = psiFile;
        if (!(jupyterPsiFile instanceof JupyterFile)) {
            return null;
        }
        return (StructureViewBuilder)new JupyterStructureViewBuilder((JupyterFile)jupyterPsiFile);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createFileEditor(@NotNull Project project, @NotNull VirtualFile file, @Nullable Document document, @NotNull CoroutineScope editorCoroutineScope, @NotNull Continuation<? super FileEditor> $completion) {
        if (!($completion instanceof createFileEditor.1)) ** GOTO lbl-1000
        var12_6 = $completion;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ JupyterFileEditorProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createFileEditor(null, null, null, null, (Continuation<? super FileEditor>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = Disposer.newDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"newDisposable(...)");
                disposable = v0;
                v1 = document;
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-JupyterFileEditorProvider$createFileEditor$fileDoc$1 = false;
                    v2 = FileDocumentManager.getInstance().getFile(it);
                } else {
                    v2 = fileDoc = null;
                }
                if (!Intrinsics.areEqual((Object)fileDoc, (Object)file)) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v3 = Logger.getInstance(JupyterFileEditorProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                    v3.warn("Files is not the save for editor and document!");
                }
                $continuation.L$0 = project;
                $continuation.L$1 = file;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)document);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)editorCoroutineScope);
                $continuation.L$4 = disposable;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)fileDoc);
                $continuation.label = 1;
                v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BackedNotebookVirtualFile>, Object>(file, disposable, null){
                    int label;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ Disposable $disposable;
                    {
                        this.$file = $file;
                        this.$disposable = $disposable;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return BackedNotebookVirtualFile.Companion.getOrLoadForDisposable(this.$file, this.$disposable);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super BackedNotebookVirtualFile> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v4 == var13_8) {
                    return var13_8;
                }
                ** GOTO lbl48
            }
            case 1: {
                fileDoc = (VirtualFile)$continuation.L$5;
                disposable = (Disposable)$continuation.L$4;
                editorCoroutineScope = (CoroutineScope)$continuation.L$3;
                document = (Document)$continuation.L$2;
                file = (VirtualFile)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl48:
                // 2 sources

                notebookVirtualFile = (BackedNotebookVirtualFile)v4;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)file);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)document);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)editorCoroutineScope);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)disposable);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)fileDoc);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)notebookVirtualFile);
                $continuation.label = 2;
                v5 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FileEditor>, Object>(this, file, project, notebookVirtualFile, disposable, null){
                    int label;
                    final /* synthetic */ JupyterFileEditorProvider this$0;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ BackedNotebookVirtualFile $notebookVirtualFile;
                    final /* synthetic */ Disposable $disposable;
                    {
                        this.this$0 = $receiver;
                        this.$file = $file;
                        this.$project = $project;
                        this.$notebookVirtualFile = $notebookVirtualFile;
                        this.$disposable = $disposable;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                FileEditor fileEditor;
                                ResultKt.throwOnFailure((Object)$result);
                                try {
                                    fileEditor = JupyterFileEditorProvider.access$createEditorInternal(this.this$0, this.$file, this.$project, this.$notebookVirtualFile);
                                    Disposable disposable = this.$disposable;
                                    FileEditor it = fileEditor;
                                    boolean bl = false;
                                    Disposer.register((Disposable)((Disposable)it), (Disposable)disposable);
                                }
                                catch (Throwable t) {
                                    Disposer.dispose((Disposable)this.$disposable);
                                    throw t;
                                }
                                return fileEditor;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super FileEditor> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v5 == var13_8) {
                    return var13_8;
                }
                ** GOTO lbl71
            }
            case 2: {
                notebookVirtualFile = (BackedNotebookVirtualFile)$continuation.L$6;
                fileDoc = (VirtualFile)$continuation.L$5;
                disposable = (Disposable)$continuation.L$4;
                editorCoroutineScope = (CoroutineScope)$continuation.L$3;
                document = (Document)$continuation.L$2;
                file = (VirtualFile)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl71:
                // 2 sources

                return v5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final FileEditor createEditorInternal(VirtualFile file, Project project, BackedNotebookVirtualFile notebookSourceFile) {
        JupyterFileEditor jupyterFileEditor;
        JupyterFeatureCollectorManager.Companion.getInstance().startLoadNotebook(file);
        try {
            BackedNotebookVirtualFile backedNotebookVirtualFile = notebookSourceFile;
            Intrinsics.checkNotNull((Object)backedNotebookVirtualFile);
            jupyterFileEditor = this.createJupyterFileEditor(project, backedNotebookVirtualFile);
        }
        catch (Throwable t) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel(JupyterBundle.message("jupyter.corrupted.file.message", new Object[0]), 0), "Center");
            JupyterFileEditorProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFileEditorProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Jupyter editor for file " + file.getPath() + " is corrupted", t);
            return (FileEditor)new JComponentFileEditor(file, (JComponent)panel);
        }
        JupyterFileEditor editor = jupyterFileEditor;
        if (!JupyterConsoleUtil.INSTANCE.isJupyterConsoleView(file)) {
            Disposer.register((Disposable)NotebookDisposable.Companion.forProject(project), (Disposable)((Disposable)editor));
        }
        if (!AppMode.isRemoteDevHost()) {
            this.moveCaret(editor);
        }
        Iterable $this$forEach$iv = JupyterEditorCustomizer.Companion.getEP().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterEditorCustomizer customizer = (JupyterEditorCustomizer)element$iv;
            boolean bl = false;
            customizer.onEditorCreated(project, editor, notebookSourceFile);
        }
        jupyterFileEditor = editor.getEditor().getProject();
        if (jupyterFileEditor != null) {
            JupyterFileEditor it = jupyterFileEditor;
            boolean bl = false;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)it);
            if (psiDocumentManager != null) {
                psiDocumentManager.performForCommittedDocument(editor.getEditor().getDocument(), () -> JupyterFileEditorProvider.createEditorInternal$lambda$2(this, editor, notebookSourceFile));
            }
        }
        file.putUserData(JupyterCellLinesExtensionsKt.getJUPYTER_EDITOR_KEY(), new WeakReference<Editor>(editor.getEditor()));
        file.putUserData(JupyterCellLinesExtensionsKt.getNOTEBOOK_VIRTUAL_FILE_KEY(), (Object)notebookSourceFile);
        this.initProFeatures(editor, project);
        return (FileEditor)editor;
    }

    private final void initProFeatures(JupyterFileEditor editor, Project project) {
        Editor editor2 = editor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        JupyterFearureAvailabilityInfoProvider premiumChecker = JupyterFeatureAvailabilityCheckerKt.getJupyterFeatureAvailabilityChecker(editor2);
        boolean isViewOnly = premiumChecker.isViewOnly();
        if (isViewOnly) {
            EditorNotificationPanel panel;
            if (this.proNotificationPanel == null && (panel = premiumChecker.createNotificationPanel(editor)) != null) {
                this.updateNotificationPanel(project, editor, panel);
                this.proNotificationPanel = panel;
            }
        } else if (this.proNotificationPanel != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            FileEditor fileEditor = (FileEditor)editor;
            EditorNotificationPanel editorNotificationPanel = this.proNotificationPanel;
            Intrinsics.checkNotNull((Object)editorNotificationPanel);
            fileEditorManager.removeTopComponent(fileEditor, (JComponent)editorNotificationPanel);
            this.proNotificationPanel = null;
        }
        Editor editor3 = editor.getEditor();
        Intrinsics.checkNotNull((Object)editor3, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor3).setViewer(isViewOnly);
    }

    private final void updateNotificationPanel(Project project, JupyterFileEditor editor, EditorNotificationPanel panel) {
        if (editor.getEditor().getContentComponent().isShowing()) {
            FileEditorManager.getInstance((Project)project).addTopComponent((FileEditor)editor, (JComponent)panel);
        } else {
            JComponent jComponent = editor.getEditor().getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            UiNotifyConnector.Companion.doWhenFirstShown$default((UiNotifyConnector.Companion)UiNotifyConnector.Companion, (Component)jComponent, (boolean)false, () -> JupyterFileEditorProvider.updateNotificationPanel$lambda$0(editor, this, project), (int)2, null);
        }
    }

    private final void checkEditorAndPsi(Editor editor, JupyterNotebook notebook) {
        Project project = editor.getProject();
        if (!(project != null)) {
            boolean $i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$32 = false;
            String $i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$32 = "project must be not null";
            throw new IllegalStateException($i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$32.toString());
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (!(psiFile instanceof JupyterFile)) {
            boolean $i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$42 = false;
            String $i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$42 = "psi file must be Jupyter File, but it isn't. The actual value is: " + psiFile;
            throw new IllegalStateException($i$a$-check-JupyterFileEditorProvider$checkEditorAndPsi$42.toString());
        }
        List intervals = (List)ActionsKt.runReadAction(() -> JupyterFileEditorProvider.checkEditorAndPsi$lambda$2(editor));
        if (notebook.cellsCount() != intervals.size()) {
            JupyterFileEditorProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFileEditorProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("size of intervals should be equal to the size of nb cells");
        }
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super.disposeEditor(editor);
            VirtualFile virtualFile = editor.getFile();
            if (virtualFile == null || (virtualFile = JupyterFileExtensionsKt.getOriginalVirtualFile(virtualFile)) == null) break block0;
            virtualFile.putUserData(JupyterCellLinesExtensionsKt.getJUPYTER_EDITOR_KEY(), null);
        }
    }

    private final void moveCaret(JupyterFileEditor textEditor) {
        JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(textEditor, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int label;
            final /* synthetic */ JupyterFileEditor $textEditor;
            {
                this.$textEditor = $textEditor;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.$textEditor.isValid()) {
                            return Unit.INSTANCE;
                        }
                        Editor editor = this.$textEditor.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                        Editor editor2 = editor;
                        List<NotebookCellLines.Interval> list = JupyterHelper.INSTANCE.getCellIntervals(editor2);
                        if (list == null) {
                            return Unit.INSTANCE;
                        }
                        List<NotebookCellLines.Interval> cells = list;
                        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull(cells, (int)0);
                        if (interval == null) {
                            return Unit.INSTANCE;
                        }
                        NotebookCellLines.Interval firstCell = interval;
                        int offset = firstCell.getContentRange(editor2).getStartOffset();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)editor2);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(cells);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)firstCell);
                        this.I$0 = offset;
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> moveCaret.1.invokeSuspend$lambda$0(editor2, offset), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        int offset = this.I$0;
                        NotebookCellLines.Interval firstCell = (NotebookCellLines.Interval)this.L$2;
                        List cells = (List)this.L$1;
                        Editor editor = (Editor)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Editor $editor, int $offset) {
                $editor.getCaretModel().getPrimaryCaret().moveToOffset($offset);
                return Unit.INSTANCE;
            }
        }));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getFileType() == JupyterFileType.INSTANCE;
    }

    @NotNull
    public String getEditorTypeId() {
        return "jupyter-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (FileEditorState)new TextEditorState();
    }

    private static final void createEditorInternal$lambda$2(JupyterFileEditorProvider this$0, JupyterFileEditor $editor, BackedNotebookVirtualFile $notebookSourceFile) {
        Editor editor = $editor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        this$0.checkEditorAndPsi(editor, $notebookSourceFile.getNotebook());
    }

    private static final Unit updateNotificationPanel$lambda$0(JupyterFileEditor $editor, JupyterFileEditorProvider this$0, Project $project) {
        if (!$editor.getEditor().isDisposed() && this$0.proNotificationPanel != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
            FileEditor fileEditor = (FileEditor)$editor;
            EditorNotificationPanel editorNotificationPanel = this$0.proNotificationPanel;
            Intrinsics.checkNotNull((Object)editorNotificationPanel);
            fileEditorManager.addTopComponent(fileEditor, (JComponent)editorNotificationPanel);
        }
        return Unit.INSTANCE;
    }

    private static final List checkEditorAndPsi$lambda$2(Editor $editor) {
        return NotebookCellLines.Companion.get($editor).getIntervals();
    }

    public static final /* synthetic */ FileEditor access$createEditorInternal(JupyterFileEditorProvider $this, VirtualFile file, Project project, BackedNotebookVirtualFile notebookSourceFile) {
        return $this.createEditorInternal(file, project, notebookSourceFile);
    }
}

