/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.sql.backend.core.psi.stubs.SqlTableNameIndex;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlAllNameIndex;
import com.intellij.sql.psi.stubs.SqlColumnNameIndex;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlGoToSymbolContributor
implements GotoClassContributor,
ChooseByNameContributorEx {
    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(1);
        }
        GlobalSearchScope adjusted = SqlGoToSymbolContributor.adjustScope(scope);
        StubIndex index = StubIndex.getInstance();
        DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> {
            if (!index.processAllKeys(SqlTableNameIndex.KEY, processor, adjusted, filter)) {
                return;
            }
            if (!index.processAllKeys(SqlColumnNameIndex.KEY, processor, adjusted, filter)) {
                return;
            }
            if (!index.processAllKeys(SqlAllNameIndex.KEY, processor, adjusted, filter)) {
                return;
            }
        });
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(4);
        }
        List dataSources = DbSrcUtilsCore.getDataSources((Project)parameters.getProject());
        Map filterMap = JBIterable.from((Iterable)dataSources).toMap(ds -> DbImplUtilCore.buildFilter((DasDataSource)ds));
        FilteringProcessor processorWithFilter = new FilteringProcessor(e -> {
            if (!(e instanceof PsiObject)) {
                return true;
            }
            for (DbDataSource dataSource : SqlImplUtil.getDataSources((PsiElement)((PsiObject)e))) {
                Condition filter = (Condition)filterMap.get(DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dataSource));
                if (filter == null || filter.value((Object)((PsiObject)e))) continue;
                return false;
            }
            return true;
        }, processor);
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> SqlGoToSymbolContributor.doProcessElementsWithName(name, (Processor<? super NavigationItem>)processorWithFilter, parameters));
    }

    private static void doProcessElementsWithName(@NotNull String name, Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        IdFilter filter;
        GlobalSearchScope scope;
        Project project;
        StubIndex index;
        if (name == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(6);
        }
        if (!(index = StubIndex.getInstance()).processElements(SqlTableNameIndex.KEY, (Object)name, project = parameters.getProject(), scope = SqlGoToSymbolContributor.adjustScope(parameters.getSearchScope()), filter = parameters.getIdFilter(), SqlDefinition.class, processor)) {
            return;
        }
        if (!index.processElements(SqlColumnNameIndex.KEY, (Object)name, project, scope, filter, SqlDefinition.class, processor)) {
            return;
        }
        if (!index.processElements(SqlAllNameIndex.KEY, (Object)name, project, scope, filter, SqlDefinition.class, processor)) {
            return;
        }
    }

    @NotNull
    private static GlobalSearchScope adjustScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(7);
        }
        return new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DbSrcUtilsCore.isDbSrcFile((VirtualFile)file)) {
                    return false;
                }
                return super.contains(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlGoToSymbolContributor$1", "contains"));
            }
        };
    }

    @Nullable
    public String getQualifiedName(@NotNull NavigationItem item) {
        if (item == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(8);
        }
        if (!(item instanceof SqlDefinition)) {
            return null;
        }
        return QNameUtil.getQualifiedName((DasObject)((SqlDefinition)item));
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return ".";
    }

    @NotNull
    public String getElementKind() {
        String string = DatabaseBundle.message((String)"go.to.table.kind.text", (Object[])new Object[0]);
        if (string == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public List<String> getElementKindsPluralized() {
        List<String> list = List.of(DatabaseBundle.message((String)"go.to.table.kind.text.pluralized.tables", (Object[])new Object[0]), DatabaseBundle.message((String)"go.to.table.kind.text.pluralized.views", (Object[])new Object[0]), DatabaseBundle.message((String)"go.to.table.kind.text.pluralized.routines", (Object[])new Object[0]));
        if (list == null) {
            SqlGoToSymbolContributor.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public Language getElementLanguage() {
        return SqlLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlGoToSymbolContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlGoToSymbolContributor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementKindsPluralized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doProcessElementsWithName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

