/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.psi.XPathVariableDeclaration;
import org.intellij.lang.xpath.psi.XPathVariableHolder;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.psi.impl.PrefixedNameImpl;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathVariableReferenceImpl
extends XPathElementImpl
implements XPathVariableReference {
    private static final TokenSet QNAME_FILTER = TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.VARIABLE_PREFIX, XPathTokenTypes.VARIABLE_NAME});

    public XPathVariableReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getReferencedName() {
        String string = this.getText().substring(1);
        if (string == null) {
            XPathVariableReferenceImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathVariable xPathVariable = this.resolve();
        if (xPathVariable != null) {
            XPathType xPathType = xPathVariable.getType();
            if (xPathType == null) {
                XPathVariableReferenceImpl.$$$reportNull$$$0(1);
            }
            return xPathType;
        }
        XPathType xPathType = XPathType.UNKNOWN;
        if (xPathType == null) {
            XPathVariableReferenceImpl.$$$reportNull$$$0(2);
        }
        return xPathType;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public PsiElement getElement() {
        XPathVariableReferenceImpl xPathVariableReferenceImpl = this;
        if (xPathVariableReferenceImpl == null) {
            XPathVariableReferenceImpl.$$$reportNull$$$0(3);
        }
        return xPathVariableReferenceImpl;
    }

    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)1, (int)(this.getTextLength() - 1));
        if (textRange == null) {
            XPathVariableReferenceImpl.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Override
    @Nullable
    public XPathVariable resolve() {
        VariableContext context;
        if (this.getContainingFile().getLanguage() == XPathFileType.XPATH2.getLanguage()) {
            XPathVariableHolder f = (XPathVariableHolder)PsiTreeUtil.getParentOfType((PsiElement)this, XPathVariableHolder.class, (boolean)true);
            while (f != null) {
                XPathVariable variable = XPathVariableReferenceImpl.findVariable(f.getVariables(), this.getReferencedName());
                if (variable != null) {
                    return variable;
                }
                f = (XPathVariableHolder)PsiTreeUtil.getParentOfType((PsiElement)f, XPathVariableHolder.class, (boolean)true);
            }
        }
        if ((context = this.getXPathContext().getVariableContext()) == null) {
            return null;
        }
        return context.resolve(this);
    }

    @Nullable
    private static XPathVariable findVariable(XPathVariableDeclaration[] declarations, String referencedName) {
        for (XPathVariableDeclaration decl : declarations) {
            XPathVariable v = decl.getVariable();
            if (v == null || !referencedName.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            XPathVariableReferenceImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            XPathVariableReferenceImpl.$$$reportNull$$$0(6);
        }
        this.renameTo(newElementName);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            XPathVariableReferenceImpl.$$$reportNull$$$0(7);
        }
        this.renameTo(((PsiNamedElement)element).getName());
        return this;
    }

    private void renameTo(String newElementName) {
        XPathVariableReference child = XPathChangeUtil.createVariableReference(this, newElementName);
        PrefixedNameImpl newName = (PrefixedNameImpl)child.getQName();
        PrefixedNameImpl oldName = (PrefixedNameImpl)this.getQName();
        assert (newName != null);
        assert (oldName != null);
        ASTNode localNode = newName.getLocalNode();
        this.getNode().replaceChild(oldName.getLocalNode(), localNode);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        VariableContext context;
        if (element == null) {
            XPathVariableReferenceImpl.$$$reportNull$$$0(8);
        }
        if (element instanceof XPathVariable) {
            XPathVariable resolved = this.resolve();
            if (this.getReferencedName().equals(((XPathVariable)element).getName()) && element.equals((Object)resolved)) {
                return true;
            }
        }
        if ((context = this.getXPathContext().getVariableContext()) != null) {
            return context.isReferenceTo(element, this);
        }
        return false;
    }

    public boolean isSoft() {
        return true;
    }

    @Override
    @Nullable
    public PrefixedName getQName() {
        ASTNode[] nodes = this.getNode().getChildren(QNAME_FILTER);
        if (nodes.length == 1) {
            return new PrefixedNameImpl(nodes[0]);
        }
        if (nodes.length == 2) {
            return new PrefixedNameImpl(nodes[0], nodes[1]);
        }
        return null;
    }

    public int hashCode() {
        return this.getReferencedName().hashCode();
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathVariableReference(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/psi/impl/XPathVariableReferenceImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/psi/impl/XPathVariableReferenceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

