/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.lexer;

import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesManager;
import com.intellij.httpClient.http.request.lexer.HttpRequestLexerDistributionDetailsService;
import com.intellij.httpClient.http.request.lexer._HttpRequestFileLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsServiceImpl;", "Lcom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsService;", "fileVariablesAvailable", "", "<init>", "(Z)V", "()V", "provideExtensionsLexemesManager", "Lcom/intellij/httpClient/http/request/lexer/HttpClientExtensionLexemesManager;", "allSupportedMethods", "", "", "project", "Lcom/intellij/openapi/project/Project;", "getDefaultScheme", "method", "getDefaultMethod", "scheme", "HttpClientExtensionLexemesManagerImpl", "intellij.httpClient.executor"})
@ApiStatus.Internal
public final class HttpRequestLexerDistributionDetailsServiceImpl
implements HttpRequestLexerDistributionDetailsService {
    private final boolean fileVariablesAvailable;

    public HttpRequestLexerDistributionDetailsServiceImpl(boolean fileVariablesAvailable) {
        this.fileVariablesAvailable = fileVariablesAvailable;
    }

    public HttpRequestLexerDistributionDetailsServiceImpl() {
        this(Registry.Companion.is("http.client.file.variables.available"));
    }

    @Override
    @NotNull
    public HttpClientExtensionLexemesManager provideExtensionsLexemesManager() {
        return new HttpClientExtensionLexemesManagerImpl(this.fileVariablesAvailable);
    }

    @Override
    @NotNull
    public Collection<String> allSupportedMethods(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RequestExecutionSupport.All.allSupportedMethods(project);
    }

    @Override
    @Nullable
    public String getDefaultScheme(@NotNull String method, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RequestExecutionSupport.All.getDefaultScheme(method, project);
    }

    @Override
    @Nullable
    public String getDefaultMethod(@NotNull String scheme, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RequestExecutionSupport.All.getDefaultMethod(scheme, project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsServiceImpl$HttpClientExtensionLexemesManagerImpl;", "Lcom/intellij/httpClient/http/request/lexer/HttpClientExtensionLexemesManager;", "isFileVariablesAvailable", "", "<init>", "(Z)V", "()Z", "currentExecutionSupport", "", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "reset", "", "setExecutionSupport", "lexer", "Lcom/intellij/httpClient/http/request/lexer/_HttpRequestFileLexer;", "getSchemeType", "Lcom/intellij/httpClient/http/request/lexer/HttpClientExtensionLexemesManager$SchemeType;", "tryFindAndRememberExecutorsForSchema", "schema", "", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestLexerDistributionDetailsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestLexerDistributionDetailsServiceImpl.kt\ncom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsServiceImpl$HttpClientExtensionLexemesManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1374#2:67\n1460#2,5:68\n*S KotlinDebug\n*F\n+ 1 HttpRequestLexerDistributionDetailsServiceImpl.kt\ncom/intellij/httpClient/http/request/lexer/HttpRequestLexerDistributionDetailsServiceImpl$HttpClientExtensionLexemesManagerImpl\n*L\n50#1:67\n50#1:68,5\n*E\n"})
    private static final class HttpClientExtensionLexemesManagerImpl
    implements HttpClientExtensionLexemesManager {
        private final boolean isFileVariablesAvailable;
        @NotNull
        private List<? extends RequestExecutionSupport<?>> currentExecutionSupport;

        public HttpClientExtensionLexemesManagerImpl(boolean isFileVariablesAvailable) {
            this.isFileVariablesAvailable = isFileVariablesAvailable;
            this.currentExecutionSupport = CollectionsKt.emptyList();
        }

        @Override
        public boolean isFileVariablesAvailable() {
            return this.isFileVariablesAvailable;
        }

        @Override
        public void reset() {
            this.currentExecutionSupport = CollectionsKt.emptyList();
        }

        @Override
        public void setExecutionSupport(@NotNull _HttpRequestFileLexer lexer) {
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            CharSequence method = lexer.yytext();
            this.currentExecutionSupport = RequestExecutionSupport.All.forMethod$default(RequestExecutionSupport.All, method, null, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HttpClientExtensionLexemesManager.SchemeType getSchemeType(@NotNull _HttpRequestFileLexer lexer) {
            CharSequence text2;
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            CharSequence charSequence = text2 = lexer.yytext();
            String strText = charSequence != null ? ((Object)charSequence).toString() : null;
            this.tryFindAndRememberExecutorsForSchema(strText);
            List<? extends RequestExecutionSupport<?>> support = this.currentExecutionSupport;
            if (!((Collection)support).isEmpty()) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = support;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    RequestExecutionSupport it = (RequestExecutionSupport)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getSupportedSchemes();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                if (CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)strText)) {
                    HttpClientExtensionLexemesManager.SchemeType schemeType = HttpClientExtensionLexemesManager.Companion.httpScheme(strText);
                    if (schemeType == null) {
                        schemeType = HttpClientExtensionLexemesManager.SchemeType.CUSTOM;
                    }
                    return schemeType;
                }
            } else {
                HttpClientExtensionLexemesManager.SchemeType schemeType = HttpClientExtensionLexemesManager.Companion.httpScheme(strText);
                if (schemeType == null) {
                    schemeType = HttpClientExtensionLexemesManager.SchemeType.NONE;
                }
                return schemeType;
            }
            return HttpClientExtensionLexemesManager.SchemeType.NONE;
        }

        private final void tryFindAndRememberExecutorsForSchema(String schema) {
            if (this.currentExecutionSupport.isEmpty() && schema != null) {
                this.currentExecutionSupport = RequestExecutionSupport.All.forSchema(schema);
            }
        }
    }
}

