/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import one.util.streamex.StreamEx;

public enum SourceLanguage {
    GROOVY("Groovy", "groovy", "Groovy", "groovy"),
    JAVA("Java", "java", "JAVA", "java"),
    KOTLIN("Kotlin", "kt", "kotlin", "kotlin");

    private final String ext;
    private final String name;
    private final String languageName;
    private final String sourceRoot;

    private SourceLanguage(String name, String ext, String languageName, String sourceRoot) {
        this.ext = ext;
        this.name = name;
        this.languageName = languageName;
        this.sourceRoot = sourceRoot;
    }

    public static SourceLanguage from(Language language) {
        return StreamEx.of((Object[])SourceLanguage.values()).findFirst(sourceLanguage -> language.getID().equals(sourceLanguage.languageName)).orElse(null);
    }

    public static SourceLanguage from(PsiElement psiElement) {
        return SourceLanguage.from(psiElement.getLanguage());
    }

    public String getExt() {
        return this.ext;
    }

    public String getName() {
        return this.name;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public Language getLanguage() {
        return Language.findLanguageByID((String)this.languageName);
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public String toString() {
        return this.name;
    }

    public static SourceLanguage fromExt(String ext) {
        for (SourceLanguage st : SourceLanguage.values()) {
            if (!st.ext.equals(ext)) continue;
            return st;
        }
        return null;
    }

    public static String[] allExtensions() {
        return (String[])StreamEx.of((Object[])SourceLanguage.values()).map(sourceLanguage -> sourceLanguage.ext).toArray((Object[])new String[0]);
    }
}

