/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.ift.lesson.editor;

import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.javascript.ift.JsLessonsBundle;
import com.intellij.javascript.ift.lesson.JSLessonUtilsKt;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.learn.course.KLesson;
import training.learn.js.JSCommonLessonUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/ift/lesson/editor/NavigationLesson;", "Ltraining/learn/course/KLesson;", "<init>", "()V", "thisOwnerName", "", "thisName", "favoriteTreat", "sample", "Ltraining/dsl/LessonSample;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "sampleFilePath", "getSampleFilePath", "()Ljava/lang/String;", "intellij.javascript.featuresTrainer"})
public final class NavigationLesson
extends KLesson {
    @NotNull
    private final String thisOwnerName;
    @NotNull
    private final String thisName;
    @NotNull
    private final String favoriteTreat;
    @NotNull
    private final LessonSample sample;
    @NotNull
    private final String sampleFilePath;

    public NavigationLesson() {
        super("Secrets of Efficient Navigation", JsLessonsBundle.INSTANCE.message("js.editor.navigation.title", new Object[0]));
        this.thisOwnerName = "${this.ownerName}";
        this.thisName = "${this.name}";
        this.favoriteTreat = "${favoriteTreat}";
        this.sample = LessonSampleKt.parseLessonSample((String)StringsKt.trimIndent((String)("\n        import {Pet} from './pet';\n        \n        export class Dog extends Pet {\n            constructor(name, ownerName, breed) {\n                super(name, ownerName);\n                this.breed = breed;\n            }\n        \n            giveTreat(favoriteTreat) {\n                console.log(`" + this.thisOwnerName + " gives " + this.thisName + " " + this.favoriteTreat + "`)\n            }\n        }\n        \n        let snoopy = new Dog('Snoopy', 'Charlie', 'Beagle');\n        \n        snoopy.giveTreat('pizza');\n\n        ")));
        this.sampleFilePath = "navigation.js";
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return arg_0 -> NavigationLesson._get_lessonContent_$lambda$0(this, arg_0);
    }

    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    private static final Unit _get_lessonContent_$lambda$0(NavigationLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        JSLessonUtilsKt.setLanguageLevel(lessonContext);
        LessonContext.prepareRuntimeTask$default((LessonContext)lessonContext, null, NavigationLesson::_get_lessonContent_$lambda$0$0, (int)1, null);
        LessonContext.prepareSample$default((LessonContext)lessonContext, (LessonSample)this$0.sample, (boolean)false, (int)2, null);
        lessonContext.task("RecentFiles", NavigationLesson::_get_lessonContent_$lambda$0$1);
        lessonContext.task(NavigationLesson::_get_lessonContent_$lambda$0$2);
        lessonContext.task("ActivateStructureToolWindow", NavigationLesson::_get_lessonContent_$lambda$0$3);
        lessonContext.task("FindUsages", NavigationLesson::_get_lessonContent_$lambda$0$4);
        lessonContext.task("HideActiveWindow", NavigationLesson::_get_lessonContent_$lambda$0$5);
        lessonContext.task("SearchEverywhere", NavigationLesson::_get_lessonContent_$lambda$0$6);
        lessonContext.task("GotoAction", NavigationLesson::_get_lessonContent_$lambda$0$7);
        lessonContext.task(NavigationLesson::_get_lessonContent_$lambda$0$8);
        lessonContext.task("GotoDeclaration", NavigationLesson::_get_lessonContent_$lambda$0$9);
        Object[] objectArray = new Object[]{lessonContext.strong(JsLessonsBundle.INSTANCE.message("js.editor.basics.module.name", new Object[0])), "https://resources.jetbrains.com/storage/products/webstorm/docs/WebStorm_ReferenceCard.pdf"};
        lessonContext.text(JsLessonsBundle.INSTANCE.message("js.editor.navigation.keymap.reference", objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit _get_lessonContent_$lambda$0$0(TaskRuntimeContext $this$prepareRuntimeTask) {
        block0: {
            ToolWindow toolWindow;
            Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance($this$prepareRuntimeTask.getProject()).getToolWindow("Structure");
            if (toolWindow2 == null) break block0;
            toolWindow2.setSplitMode(true, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _get_lessonContent_$lambda$0$1(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[2];
        objectArray[0] = $this$task.action(it);
        String string = IdeBundle.message((String)"title.popup.recent.files", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[1] = $this$task.strong(string);
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.recent.files", objectArray), null, (int)2, null);
        $this$task.trigger(it);
        return Unit.INSTANCE;
    }

    private static final Unit _get_lessonContent_$lambda$0$2(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[1];
        String string = UIBundle.message((String)"tool.window.name.structure", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = $this$task.strong(string);
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.choose.structure", objectArray), null, (int)2, null);
        $this$task.stateCheck(NavigationLesson::_get_lessonContent_$lambda$0$2$0);
        return Unit.INSTANCE;
    }

    private static final boolean _get_lessonContent_$lambda$0$2$0(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        Component component = $this$stateCheck.getFocusOwner();
        return StringsKt.contains$default((CharSequence)String.valueOf(component != null ? component.getClass() : null), (CharSequence)"structureView.newStructureView.StructureViewComponent", (boolean)false, (int)2, null);
    }

    private static final Unit _get_lessonContent_$lambda$0$3(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[4];
        String string = UIBundle.message((String)"tool.window.name.structure", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = $this$task.strong(string);
        objectArray[1] = $this$task.code("giveTreat");
        objectArray[2] = $this$task.action("EditorEnter");
        objectArray[3] = $this$task.action(it);
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.activate.structure", objectArray), null, (int)2, null);
        $this$task.stateCheck(NavigationLesson::_get_lessonContent_$lambda$0$3$0);
        return Unit.INSTANCE;
    }

    private static final boolean _get_lessonContent_$lambda$0$3$0(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return JSCommonLessonUtilsKt.textAtCaretEqualsTo((TaskRuntimeContext)$this$stateCheck, (String)"giveTreat") && $this$stateCheck.getFocusOwner() instanceof EditorComponentImpl;
    }

    private static final Unit _get_lessonContent_$lambda$0$4(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.code("giveTreat"), $this$task.action(it)};
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.find.usages", objectArray), null, (int)2, null);
        $this$task.stateCheck(NavigationLesson::_get_lessonContent_$lambda$0$4$0);
        $this$task.trigger(it);
        return Unit.INSTANCE;
    }

    private static final boolean _get_lessonContent_$lambda$0$4$0(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return JSCommonLessonUtilsKt.textAtCaretEqualsTo((TaskRuntimeContext)$this$stateCheck, (String)"giveTreat");
    }

    private static final Unit _get_lessonContent_$lambda$0$5(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.hide.tool.window", objectArray), null, (int)2, null);
        LessonUtilKt.checkToolWindowState((TaskContext)$this$task, (String)"Find", (boolean)false);
        return Unit.INSTANCE;
    }

    private static final Unit _get_lessonContent_$lambda$0$6(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.shortcut(JSCommonLessonUtilsKt.shiftSymbol())};
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.search.everywhere", objectArray), null, (int)2, null);
        $this$task.trigger(it);
        return Unit.INSTANCE;
    }

    private static final Unit _get_lessonContent_$lambda$0$7(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[6];
        String string = ActionsBundle.message((String)"action.SearchEverywhere.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = $this$task.strong(string);
        objectArray[1] = $this$task.action("EditorTab");
        String string2 = IdeBundle.message((String)"searcheverywhere.all.elements.tab.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[2] = $this$task.strong(string2);
        String string3 = IdeBundle.message((String)"search.everywhere.group.name.actions", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[3] = $this$task.strong(string3);
        String string4 = IdeBundle.message((String)"search.everywhere.group.name.files", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        objectArray[4] = $this$task.strong(string4);
        objectArray[5] = $this$task.action(it);
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.search.everywhere.tabs", objectArray), null, (int)2, null);
        $this$task.trigger(it);
        return Unit.INSTANCE;
    }

    private static final Unit _get_lessonContent_$lambda$0$8(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[2];
        String string = IdeBundle.message((String)"search.everywhere.group.name.actions", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = $this$task.strong(string);
        String string2 = ActionsBundle.message((String)"action.GotoDeclaration.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[1] = $this$task.strong(string2);
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.search.action", objectArray), null, (int)2, null);
        $this$task.stateCheck(NavigationLesson::_get_lessonContent_$lambda$0$8$0);
        return Unit.INSTANCE;
    }

    private static final boolean _get_lessonContent_$lambda$0$8$0(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return JSCommonLessonUtilsKt.checkWordInSearchEverywhereInput((TaskRuntimeContext)$this$stateCheck, (String)"go to d");
    }

    private static final Unit _get_lessonContent_$lambda$0$9(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.action(it), $this$task.code("snoopy")};
        TaskContext.text$default((TaskContext)$this$task, (String)JsLessonsBundle.INSTANCE.message("js.editor.navigation.go.to.declaration", objectArray), null, (int)2, null);
        $this$task.stateCheck(NavigationLesson::_get_lessonContent_$lambda$0$9$0);
        $this$task.trigger(it);
        return Unit.INSTANCE;
    }

    private static final boolean _get_lessonContent_$lambda$0$9$0(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return JSCommonLessonUtilsKt.textAtCaretEqualsTo((TaskRuntimeContext)$this$stateCheck, (String)"snoopy");
    }
}

