/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNodePackageRefResolver
implements NodePackageRefResolver {
    private final Project myProject;
    private final NodePackageDescriptor myDescriptor;
    private final Supplier<? extends NodeJsInterpreter> myInterpreterSupplier;
    private final Map<String, NodePackage> myCache;
    private volatile NodeJsInterpreter myLastInterpreter;
    private volatile long myLastExternalChangesCount;

    public DefaultNodePackageRefResolver(@Nullable Project project, @NotNull NodePackageDescriptor descriptor, @Nullable Supplier<? extends NodeJsInterpreter> interpreterSupplier) {
        if (descriptor == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(0);
        }
        this.myCache = new HashMap<String, NodePackage>();
        this.myProject = project;
        this.myDescriptor = descriptor;
        this.myInterpreterSupplier = interpreterSupplier;
    }

    @Override
    @Nullable
    public NodePackage resolve(@NotNull NodePackageRef ref2) {
        NodePackage pkg;
        if (ref2 == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(1);
        }
        if ((pkg = ref2.getConstantPackage()) != null) {
            return pkg;
        }
        return this.resolve(ref2, this.myInterpreterSupplier != null ? this.myInterpreterSupplier.get() : null);
    }

    @Override
    @Nullable
    public NodePackage resolve(@NotNull NodePackageRef ref2, @Nullable NodeJsInterpreter interpreter2) {
        NodePackage pkg;
        if (ref2 == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(2);
        }
        if (this.myProject != null) {
            ref2 = this.myDescriptor.dereferenceIfProjectRef(this.myProject, ref2);
        }
        if ((pkg = ref2.getConstantPackage()) != null) {
            return pkg;
        }
        long externalChangesCount = SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
        if (!Objects.equals(interpreter2, this.myLastInterpreter) || this.myLastExternalChangesCount != externalChangesCount) {
            this.myCache.clear();
        }
        this.myLastInterpreter = interpreter2;
        this.myLastExternalChangesCount = externalChangesCount;
        String name = ref2.getReferenceName();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return null;
        }
        pkg = this.myCache.get(name);
        if (pkg == null) {
            pkg = this.doResolveRef(interpreter2, name);
            this.myCache.put(name, pkg);
        }
        return pkg;
    }

    @Nullable
    protected NodePackage doResolveRef(@Nullable NodeJsInterpreter interpreter2, @NotNull String referenceName) {
        if (referenceName == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Override
    public boolean isValidPackage(@NotNull NodePackageRef ref2, @Nullable NodePackage pkg, @Nullable NodeJsInterpreter interpreter2) {
        if (ref2 == null) {
            DefaultNodePackageRefResolver.$$$reportNull$$$0(4);
        }
        return pkg != null && (this.myProject != null ? pkg.isValid(this.myProject, interpreter2) : pkg.isValid());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/util/DefaultNodePackageRefResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doResolveRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

