/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.systemjs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemJSIndexingHandler
extends FrameworkIndexingHandler {
    public static final String KEY = "System.config";
    public static final String SYSTEM_TEXT = "System";
    public static final String SYSTEM_JS_TEXT = "SystemJS";

    @NotNull
    public List<String> getMarkers(@NotNull PsiElement element2) {
        if (element2 == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(0);
        }
        if (SystemJSIndexingHandler.isObjectLiteralInSystemConfigCall(element2)) {
            List<String> list = Collections.singletonList(KEY);
            if (list == null) {
                SystemJSIndexingHandler.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static boolean isObjectLiteralInSystemConfigCall(PsiElement elementToIndex) {
        if (!(elementToIndex instanceof JSObjectLiteralExpression)) {
            return false;
        }
        PsiElement parent = elementToIndex.getParent();
        if (parent instanceof JSArgumentList) {
            parent = parent.getParent();
        }
        if (!(parent instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression call = (JSCallExpression)parent;
        return SystemJSIndexingHandler.checkIndexedDataInCallExpression(call);
    }

    private static boolean checkIndexedDataInCallExpression(JSCallExpression call) {
        Map strings;
        JSElementIndexingData data2 = call.getIndexingData();
        return data2 != null && (strings = data2.getUserStrings()) != null && strings.containsKey(KEY);
    }

    private static boolean checkIsSystemConfigCall(@NotNull JSCallExpression call) {
        JSExpression expression;
        if (call == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(3);
        }
        if ((expression = call.getMethodExpression()) instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            if (!(qualifier instanceof JSReferenceExpression) || ((JSReferenceExpression)qualifier).getQualifier() != null) {
                return false;
            }
            String text = ((JSReferenceExpression)expression).getReferenceName();
            String qualifierText = ((JSReferenceExpression)qualifier).getReferenceName();
            return SystemJSIndexingHandler.isSystemConfigReference(text, qualifierText);
        }
        return false;
    }

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(4);
        }
        if (SystemJSIndexingHandler.checkIsSystemConfigCall(callExpression)) {
            this.putUserString(outData, "");
        }
        super.processCallExpression(callExpression, outData);
    }

    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        ASTNode methodExpression;
        if (node == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(5);
        }
        if ((methodExpression = node.getFirstChildNode()).getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        ASTNode qualifier = methodExpression.getFirstChildNode();
        if (qualifier == null) {
            return false;
        }
        CharSequence qualifierText = qualifier.getChars();
        CharSequence refText = referencedNameElement.getChars();
        return SystemJSIndexingHandler.isSystemConfigReference(refText, qualifierText);
    }

    private static boolean isSystemConfigReference(@Nullable CharSequence refText, @Nullable CharSequence qualifierText) {
        return StringUtil.equals((CharSequence)"config", (CharSequence)refText) && (StringUtil.equalsIgnoreCase((CharSequence)SYSTEM_TEXT, (CharSequence)qualifierText) || StringUtil.equalsIgnoreCase((CharSequence)SYSTEM_JS_TEXT, (CharSequence)qualifierText));
    }

    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        if (expression == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(6);
        }
        return this.shouldCreateStubForLiteral(expression.getNode());
    }

    private boolean checkInSystemConfigArgumentList(@Nullable ASTNode parent) {
        if (parent != null && parent.getElementType() == JSElementTypes.ARGUMENT_LIST) {
            ASTNode grandParent = parent.getTreeParent();
            return grandParent != null && grandParent.getElementType() == JSElementTypes.CALL_EXPRESSION && this.shouldCreateStubForCallExpression(grandParent);
        }
        return false;
    }

    public boolean shouldCreateStubForLiteral(@NotNull ASTNode node) {
        ASTNode objectLiteral;
        if (node == null) {
            SystemJSIndexingHandler.$$$reportNull$$$0(7);
        }
        if ((objectLiteral = SystemJSIndexingHandler.getLiteralParentNode(node)) == null) {
            return false;
        }
        if (this.checkInSystemConfigArgumentList(objectLiteral.getTreeParent())) {
            return true;
        }
        ASTNode grandObjectLiteral = SystemJSIndexingHandler.getLiteralParentNode(objectLiteral);
        if (grandObjectLiteral == null) {
            return false;
        }
        return this.checkInSystemConfigArgumentList(grandObjectLiteral.getTreeParent());
    }

    @Nullable
    private static ASTNode getLiteralParentNode(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        if (parent == null || !(parent.getElementType() instanceof JSPropertyElementType)) {
            return null;
        }
        ASTNode grandParent = parent.getTreeParent();
        return grandParent != null && grandParent.getElementType() == JSElementTypes.OBJECT_LITERAL_EXPRESSION ? grandParent : null;
    }

    @Nullable
    protected String getJSElementIndexingDataUserStringKey() {
        return KEY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSIndexingHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/systemjs/SystemJSIndexingHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMarkers";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkIsSystemConfigCall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForCallExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasSignificantValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

