/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalCandidatesCollector;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalSymbolsPass;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public class JSUnusedGlobalSymbolsInspection
extends JSInspection
implements PairedUnfairLocalInspectionTool {
    public static final String SHORT_NAME = JSUnusedGlobalSymbolsInspection.calcShortNameFromClass(JSUnusedGlobalSymbolsInspection.class);
    public boolean myReportUnusedDefinitions;
    public boolean myReportUnusedProperties;
    private static final Key<Set<PsiElement>> CANDIDATE_ELEMENTS_KEY = Key.create((String)"js.unused.global.symbols.candidates");

    @NotNull
    protected JSElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(1);
        }
        if (this.myOnTheFly) {
            JSElementVisitor jSElementVisitor = JSElementVisitor.NOP_ELEMENT_VISITOR;
            if (jSElementVisitor == null) {
                JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(2);
            }
            return jSElementVisitor;
        }
        HashSet candidates = new HashSet();
        session.putUserData(CANDIDATE_ELEMENTS_KEY, candidates);
        return new JSUnusedGlobalCandidatesCollector(candidates, this);
    }

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(4);
        }
        if (problemsHolder == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(5);
        }
        if (this.myOnTheFly) {
            return;
        }
        ConcurrentLinkedQueue unusedSymbols = new ConcurrentLinkedQueue();
        Set candidates = (Set)session.getUserData(CANDIDATE_ELEMENTS_KEY);
        if (candidates == null) {
            return;
        }
        ReadAction.run(() -> {
            JSUnusedGlobalSymbolsPass.searchForUnusedSymbols(session.getFile(), candidates, unusedSymbols);
            for (PsiElement unusedSymbol : unusedSymbols) {
                JSUnusedGlobalSymbolsPass.JSUnusedSymbolProblemDescriptor descriptor = JSUnusedGlobalSymbolsPass.registerProblem(unusedSymbol);
                if (descriptor == null) continue;
                TextRange range = descriptor.myRange;
                if (range != null) {
                    range = range.shiftLeft(descriptor.myIdentifier.getTextRange().getStartOffset());
                }
                problemsHolder.registerProblem(descriptor.myIdentifier, range, descriptor.myMessage, descriptor.myFixes);
            }
        });
    }

    @NotNull
    public static GlobalSearchScope skipLibraryFiles(final @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        if (project == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(6);
        }
        if (scope2 == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(7);
        }
        return new DelegatingGlobalSearchScope(scope2){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile((VirtualFile)file, (Project)project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection$1", "contains"));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myReportUnusedProperties", (String)JavaScriptBundle.message((String)"javascript.report.unused.properties", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myReportUnusedDefinitions", (String)JavaScriptBundle.message((String)"javascript.report.unused.definitions", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSUnusedGlobalSymbolsInspection.$$$reportNull$$$0(8);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedGlobalSymbolsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionForBatchShortName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipLibraryFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8 -> new IllegalStateException(string);
        };
    }
}

