/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProviderSupport;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/library/BackendJSCorePredefinedLibrariesProviderSupport;", "Lcom/intellij/lang/javascript/library/JSCorePredefinedLibrariesProviderSupport;", "<init>", "()V", "getReactPredefinedLibraryFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getReactLibraryFile", "getLibFilesByIO", "", "libFolder", "Ljava/io/File;", "includeCondition", "Ljava/util/function/Predicate;", "", "includeInvalid", "", "isLibraryElement", "element", "Lcom/intellij/psi/PsiElement;", "isCoreLibraryFile", "libFile", "isECMAScriptLibraryFileName", "fileName", "getAllJSPredefinedLibraryFiles", "isNodeLibraryFile", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.analysis.impl"})
public final class BackendJSCorePredefinedLibrariesProviderSupport
implements JSCorePredefinedLibrariesProviderSupport {
    @NotNull
    public Set<VirtualFile> getReactPredefinedLibraryFiles() {
        Set<VirtualFile> set = JSCorePredefinedLibrariesProvider.getReactPredefinedLibraryFiles();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getReactPredefinedLibraryFiles(...)");
        return set;
    }

    @NotNull
    public VirtualFile getReactLibraryFile() {
        VirtualFile virtualFile = JSCorePredefinedLibrariesProvider.getReactLibraryFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getReactLibraryFile(...)");
        return virtualFile;
    }

    @NotNull
    public List<VirtualFile> getLibFilesByIO(@NotNull File libFolder, @NotNull Predicate<? super String> includeCondition, boolean includeInvalid) {
        Intrinsics.checkNotNullParameter((Object)libFolder, (String)"libFolder");
        Intrinsics.checkNotNullParameter(includeCondition, (String)"includeCondition");
        List<VirtualFile> list = JSCorePredefinedLibrariesProvider.getLibFilesByIO(libFolder, includeCondition, includeInvalid);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLibFilesByIO(...)");
        return list;
    }

    public boolean isLibraryElement(@Nullable PsiElement element2) {
        return JSCorePredefinedLibrariesProvider.isLibraryElement(element2);
    }

    public boolean isCoreLibraryFile(@Nullable VirtualFile libFile) {
        return JSCorePredefinedLibrariesProvider.isCoreLibraryFile(libFile);
    }

    public boolean isECMAScriptLibraryFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return JSCorePredefinedLibrariesProvider.isECMAScriptLibraryFileName(fileName);
    }

    @NotNull
    public Set<VirtualFile> getAllJSPredefinedLibraryFiles() {
        Set<VirtualFile> set = JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllJSPredefinedLibraryFiles(...)");
        return set;
    }

    public boolean isNodeLibraryFile(@NotNull Project project, @NotNull VirtualFile libFile) {
        SyntheticLibrary syntheticLibrary;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)libFile, (String)"libFile");
        ScriptingLibraryModel libraryModel = JSLibraryManager.getInstance(project).getLibraryByName("Node.js Core");
        if (libraryModel instanceof ScriptingLibraryModelBackedBySyntheticLibrary && (syntheticLibrary = ((ScriptingLibraryModelBackedBySyntheticLibrary)libraryModel).getSyntheticLibrary()) != null) {
            Collection collection = syntheticLibrary.getAllRoots();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllRoots(...)");
            if (VfsUtilCore.isUnder((VirtualFile)libFile, (Set)CollectionsKt.toSet((Iterable)collection))) {
                return true;
            }
        }
        return false;
    }
}

