/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportPlaceInfo {
    private final ResolveResult @NotNull [] myResults;
    @NotNull
    private final PsiElement myPlace;
    @Nullable
    private final PsiElement myParent;
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final PsiElement myContainer;
    @NotNull
    private final ImportContext myImportContext;
    @NotNull
    private final JSCompletionPlaceFilter myPlaceFilter;
    private final boolean myStrictContext;

    @NotNull
    private static ImportContext detectContext(@NotNull PsiElement place) {
        if (place == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(0);
        }
        if (place instanceof XmlTag) {
            ImportContext importContext = ImportContext.TAG;
            if (importContext == null) {
                JSImportPlaceInfo.$$$reportNull$$$0(1);
            }
            return importContext;
        }
        if (place instanceof ES6ImportSpecifier) {
            ImportContext importContext = ImportContext.SPECIFIER;
            if (importContext == null) {
                JSImportPlaceInfo.$$$reportNull$$$0(2);
            }
            return importContext;
        }
        if (!(place instanceof ES6ImportedBinding)) {
            ImportContext importContext = ImportContext.SIMPLE;
            if (importContext == null) {
                JSImportPlaceInfo.$$$reportNull$$$0(3);
            }
            return importContext;
        }
        ES6ImportDeclaration declaration = ((ES6ImportedBinding)place).getDeclaration();
        if (declaration == null) {
            ImportContext importContext = ImportContext.BINDING;
            if (importContext == null) {
                JSImportPlaceInfo.$$$reportNull$$$0(4);
            }
            return importContext;
        }
        ES6NamedImports namedImports = declaration.getNamedImports();
        ImportContext importContext = namedImports != null ? ImportContext.BINDING : ImportContext.SIMPLE;
        if (importContext == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(5);
        }
        return importContext;
    }

    public static boolean needToCheckConfigAccess(@NotNull PsiElement element2, boolean isTypeScript) {
        if (element2 == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(6);
        }
        if (isTypeScript && element2 instanceof TypeScriptModule && ((TypeScriptModule)element2).isExternal()) {
            return false;
        }
        PsiFile file = element2.getContainingFile();
        return isTypeScript && (!(file instanceof JSModuleStatusOwner) || !((JSModuleStatusOwner)file).isCommonJSModule());
    }

    public static boolean isAcceptableExportSpecifier(@NotNull ES6ExportSpecifier specifier) {
        ES6ExportDeclaration declaration;
        if (specifier == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(7);
        }
        if ((declaration = specifier.getDeclaration()) == null) {
            return false;
        }
        if (specifier.getAlias() != null) {
            return true;
        }
        PsiElement context2 = declaration.getContext();
        if (!(context2 instanceof PsiFile)) {
            return true;
        }
        VirtualFile vFile = ((PsiFile)context2).getVirtualFile();
        if (ES6CreateImportUtil.isIndexFile(context2)) {
            PsiElement element2;
            if (declaration.isReExport()) {
                return false;
            }
            String name = specifier.getReferenceName();
            if (name != null && (element2 = JSStubBasedPsiTreeUtil.resolveLocally((String)name, (PsiElement)specifier)) instanceof ES6ImportSpecifier) {
                return false;
            }
        }
        if (declaration.isReExport()) {
            return !JSLibraryUtil.isProbableLibraryFile((VirtualFile)vFile);
        }
        return true;
    }

    public JSImportPlaceInfo(@NotNull PsiElement place, ResolveResult @NotNull [] results) {
        if (place == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(8);
        }
        if (results == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(9);
        }
        this.myPlace = place;
        this.myParent = place.getParent();
        this.myFile = place.getContainingFile().getOriginalFile().getVirtualFile();
        this.myContainer = ES6PsiUtil.getExportScope((PsiElement)place);
        this.myStrictContext = place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)((JSReferenceExpression)place));
        this.myResults = results;
        this.myImportContext = JSImportPlaceInfo.detectContext(place);
        this.myPlaceFilter = JSCompletionPlaceFilter.forPlace(place);
    }

    @NotNull
    public PsiElement getPlace() {
        PsiElement psiElement = this.myPlace;
        if (psiElement == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    public boolean isStrictTypeContext() {
        return this.myStrictContext;
    }

    @Nullable
    public PsiElement getParentElement() {
        return this.myParent;
    }

    public boolean isAcceptable(@Nullable PsiElement element2) {
        return !(element2 instanceof JSElement) || this.myPlaceFilter.isAcceptable(element2);
    }

    @Nullable
    public PsiElement getContainer() {
        return this.myContainer;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    public ResolveResult @NotNull [] getResolveResults() {
        if (this.myResults == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(12);
        }
        return this.myResults;
    }

    @NotNull
    public ImportContext getImportContext() {
        ImportContext importContext = this.myImportContext;
        if (importContext == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(13);
        }
        return importContext;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPlace.getProject();
        if (project == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(14);
        }
        return project;
    }

    public boolean isAvailableForImport(@NotNull PsiElement candidate) {
        if (candidate == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(15);
        }
        if (!this.isScopeAcceptable(candidate)) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)candidate);
        if (JSImportPlaceInfo.needToCheckConfigAccess(candidate, DialectDetector.isTypeScript((PsiElement)this.myPlace)) && file != null && !TypeScriptConfigService.Provider.isAccessible((Project)this.myPlace.getProject(), (VirtualFile)this.myFile, (VirtualFile)file)) {
            return false;
        }
        if (this.myImportContext != ImportContext.SPECIFIER && candidate instanceof TypeScriptModule && ((TypeScriptModule)candidate).isExternal()) {
            return true;
        }
        if (this.myImportContext != ImportContext.BINDING && candidate instanceof ES6ExportSpecifier && ((ES6ExportSpecifier)candidate).getAlias() != null) {
            return true;
        }
        if (this.myImportContext == ImportContext.SPECIFIER && candidate instanceof JSPsiElementBase) {
            return ((JSPsiElementBase)candidate).isExported() && ES6PsiUtil.findExternalModule((PsiElement)candidate) != null;
        }
        if (this.myImportContext == ImportContext.BINDING) {
            if (candidate instanceof JSElementBase && ((JSElementBase)candidate).isExportedWithDefault()) {
                return true;
            }
            return candidate instanceof ES6ExportDefaultAssignment;
        }
        if (candidate instanceof ES6ExportSpecifier && !JSImportPlaceInfo.isAcceptableExportSpecifier((ES6ExportSpecifier)candidate)) {
            return false;
        }
        if (candidate instanceof JSExportAssignment) {
            return true;
        }
        if (this.myImportContext == ImportContext.SPECIFIER && candidate instanceof JSElement) {
            return ES6ImportHandler.isExternalModuleExport((JSElement)((JSElement)candidate));
        }
        if (!ES6PsiUtil.isElementCanBeExported((PsiElement)candidate) && !(candidate instanceof ES6ExportSpecifier)) {
            return false;
        }
        DialectOptionHolder holder = this.getDialectForImporting();
        if (holder == null) {
            return false;
        }
        if (holder.isTypeScript && !TypeScriptAutoImportUtil.isContextAcceptable(candidate, this)) {
            return false;
        }
        JSElement scope2 = ES6PsiUtil.getExportScope((PsiElement)candidate);
        if (scope2 == null || scope2 == this.getContainer()) {
            return false;
        }
        if (holder.isECMA6) {
            if (!holder.isFlow && candidate instanceof TypeScriptCompileTimeType) {
                return false;
            }
            if (TypeScriptPsiUtil.isAugmentationModule((PsiElement)scope2)) {
                return false;
            }
            if (scope2 instanceof TypeScriptModule ? ((TypeScriptModule)scope2).isInternal() && !((TypeScriptModule)scope2).isExportedWithDefault() : !(scope2 instanceof JSModuleStatusOwner) || !((JSModuleStatusOwner)scope2).isCommonJSModule()) {
                return false;
            }
        }
        return TypeScriptAutoImportUtil.isExportedElement(candidate, this);
    }

    protected DialectOptionHolder getDialectForImporting() {
        return DialectDetector.dialectOfElement((PsiElement)this.getPlace());
    }

    public boolean isScopeAcceptable(@NotNull PsiElement candidate) {
        JSElement container;
        if (candidate == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(16);
        }
        return (container = ES6PsiUtil.getExportScope((PsiElement)candidate)) != this.myContainer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSImportPlaceInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportPlaceInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectContext";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "needToCheckConfigAccess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableExportSpecifier";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForImport";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isScopeAcceptable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static enum ImportContext {
        SIMPLE,
        SPECIFIER,
        BINDING,
        TAG;

    }
}

