/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.editing.JavaScriptInlayParameterHintsProvider;
import com.intellij.lang.typescript.editing.TypeScriptInlayHintsSupportedService;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class TypeScriptInlayParameterHintsProvider
extends JavaScriptInlayParameterHintsProvider {
    public static final Option NAMES_FOR_LITERAL_ARGS = new Option("ts.param.hints.show.names.for.literal.args", JavaScriptBundle.messagePointer((String)"ts.param.hints.show.names.for.literal.args", (Object[])new Object[0]), true);
    public static final Option NAMES_FOR_ALL_ARGS = new Option("js.param.hints.show.names.for.all.args", JavaScriptBundle.messagePointer((String)"js.param.hints.show.names.for.all.args", (Object[])new Object[0]), false);
    public static final Option NAMES_FOR_TAGGED_TEMPLATES = new Option("js.param.hints.show.names.for.tagged", JavaScriptBundle.messagePointer((String)"js.param.hints.show.names.for.tagged", (Object[])new Object[0]), true);
    private final Predicate<PsiElement> myAllowed;

    public TypeScriptInlayParameterHintsProvider() {
        this(el -> TypeScriptInlayHintsSupportedService.Companion.getSupported(el.getContainingFile()).getUseOwn());
    }

    public TypeScriptInlayParameterHintsProvider(Predicate<PsiElement> allowed) {
        this.myAllowed = allowed;
    }

    @Override
    protected Option getShowNameForLiteralArgsOption() {
        return NAMES_FOR_LITERAL_ARGS;
    }

    @Override
    protected Option getShowNameForAllArgsOption() {
        return NAMES_FOR_ALL_ARGS;
    }

    @Override
    protected Option getShowNameForTaggedOption() {
        return NAMES_FOR_TAGGED_TEMPLATES;
    }

    @Override
    @NotNull
    public List<Option> getSupportedOptions() {
        List<Option> list = Arrays.asList(this.getShowNameForLiteralArgsOption(), this.getShowNameForAllArgsOption(), this.getShowNameForTaggedOption());
        if (list == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public String getBlacklistExplanationHTML() {
        return JavaScriptBundle.message((String)"ts.param.hints.blacklist.pattern.explanation", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"ShowIntentionActions")});
    }

    @Override
    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element2) {
        if (element2 == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(1);
        }
        if (this.myAllowed.test(element2)) {
            List<InlayInfo> list = super.getParameterHints(element2);
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<InlayInfo> list = Collections.emptyList();
        if (list == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/editing/TypeScriptInlayParameterHintsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/editing/TypeScriptInlayParameterHintsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterHints";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

