/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import org.jetbrains.annotations.NotNull;

public class ControlFlowOptions {
    private static final ControlFlowOptions[] DATA = new ControlFlowOptions[]{new ControlFlowOptions(false, false, false), new ControlFlowOptions(false, false, true), new ControlFlowOptions(false, true, false), new ControlFlowOptions(false, true, true), new ControlFlowOptions(true, false, false), new ControlFlowOptions(true, false, true), new ControlFlowOptions(true, true, false), new ControlFlowOptions(true, true, true)};
    @NotNull
    public static final ControlFlowOptions NO_CONST_EVALUATE = ControlFlowOptions.create(false, false, true);
    private final boolean myEnableShortCircuit;
    private final boolean myEvaluateConstantIfCondition;
    private final boolean myExceptionAfterAssignment;

    public static ControlFlowOptions create(boolean enableShortCircuit, boolean evaluateConstantIfCondition, boolean exceptionAfterAssignment) {
        return DATA[(enableShortCircuit ? 4 : 0) + (evaluateConstantIfCondition ? 2 : 0) + (exceptionAfterAssignment ? 1 : 0)];
    }

    private ControlFlowOptions(boolean enableShortCircuit, boolean evaluateConstantIfCondition, boolean exceptionAfterAssignment) {
        this.myEnableShortCircuit = enableShortCircuit;
        this.myEvaluateConstantIfCondition = evaluateConstantIfCondition;
        this.myExceptionAfterAssignment = exceptionAfterAssignment;
    }

    public boolean enableShortCircuit() {
        return this.myEnableShortCircuit;
    }

    public boolean shouldEvaluateConstantIfCondition() {
        return this.myEvaluateConstantIfCondition;
    }

    public boolean isExceptionAfterAssignment() {
        return this.myExceptionAfterAssignment;
    }

    public ControlFlowOptions dontEvaluateConstantIfCondition() {
        return this.myEvaluateConstantIfCondition ? ControlFlowOptions.create(this.myEnableShortCircuit, false, this.myExceptionAfterAssignment) : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControlFlowOptions options = (ControlFlowOptions)o;
        return this.myEnableShortCircuit == options.myEnableShortCircuit && this.myEvaluateConstantIfCondition == options.myEvaluateConstantIfCondition && this.myExceptionAfterAssignment == options.myExceptionAfterAssignment;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.myEnableShortCircuit ? 1231 : 1237);
        result = 31 * result + (this.myEvaluateConstantIfCondition ? 1231 : 1237);
        result = 31 * result + (this.myExceptionAfterAssignment ? 1231 : 1237);
        return result;
    }
}

