/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.VisibilityIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightDefaultConstructor
extends LightMethod
implements SyntheticElement {
    private static final Key<PsiMethod> DEFAULT_CONSTRUCTOR = new Key("default_constructor");

    private LightDefaultConstructor(@NotNull PsiMethod method, @NotNull PsiClass containingClass) {
        if (method == null) {
            LightDefaultConstructor.$$$reportNull$$$0(0);
        }
        if (containingClass == null) {
            LightDefaultConstructor.$$$reportNull$$$0(1);
        }
        super(method.getManager(), method, containingClass);
    }

    public PsiElement getParent() {
        return this.getContainingClass();
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return this.getContainingClass().getNameIdentifier();
    }

    public int getTextOffset() {
        return this.getNavigationElement().getTextOffset();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiClass psiClass = this.getContainingClass();
        if (psiClass == null) {
            LightDefaultConstructor.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.getContainingClass().getContainingFile();
    }

    @Override
    public Icon getElementIcon(int flags) {
        Icon icon = IconManager.getInstance().getPlatformIcon(PlatformIcons.Method);
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, icon, ElementPresentationUtil.getFlags(this, false));
        if (BitUtil.isSet((int)flags, (int)1)) {
            VisibilityIcons.setVisibilityIcon(this.getContainingClass().getModifierList(), baseIcon);
        }
        return baseIcon;
    }

    @Override
    public boolean isDefaultConstructor() {
        return true;
    }

    @Override
    public String toString() {
        return "LightDefaultConstructor:" + this.getName();
    }

    @Nullable
    public static PsiMethod create(PsiClass aClass) {
        PsiMethod constructor = (PsiMethod)aClass.getUserData(DEFAULT_CONSTRUCTOR);
        if (constructor != null) {
            return constructor;
        }
        if (aClass.isInterface() || aClass.isRecord() || aClass instanceof PsiAnonymousClass || aClass instanceof PsiImplicitClass || aClass instanceof PsiTypeParameter || aClass instanceof PsiCompiledElement || aClass.getContainingFile() instanceof PsiCompiledElement) {
            return null;
        }
        String className = aClass.getName();
        if (className == null || aClass.getConstructors().length > 0) {
            return null;
        }
        PsiMethod nonPhysical = JavaPsiFacade.getElementFactory(aClass.getProject()).createConstructor(className, aClass);
        PsiModifierList classModifierList = aClass.getModifierList();
        if (classModifierList != null) {
            String modifier = PsiUtil.getAccessModifier(PsiUtil.getAccessLevel(classModifierList));
            nonPhysical.getModifierList().setModifierProperty(modifier, true);
        }
        LightDefaultConstructor defaultConstructor = new LightDefaultConstructor(nonPhysical, aClass);
        aClass.putUserData(DEFAULT_CONSTRUCTOR, defaultConstructor);
        return defaultConstructor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightDefaultConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightDefaultConstructor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

