/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.report.NotValidatedSarif;
import org.jetbrains.qodana.report.ReportParser;
import org.jetbrains.qodana.report.ReportResult;
import org.jetbrains.qodana.report.ReportValidator;
import org.jetbrains.qodana.report.ValidatedSarif;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/report/ReportReader;", "", "<init>", "()V", "readReport", "Lorg/jetbrains/qodana/report/ReportResult;", "Lorg/jetbrains/qodana/report/ValidatedSarif;", "Lorg/jetbrains/qodana/report/ReportReader$ReaderError;", "path", "Ljava/nio/file/Path;", "ReaderError", "FailedParsing", "FailedValidation", "intellij.qodana"})
public final class ReportReader {
    @NotNull
    public static final ReportReader INSTANCE = new ReportReader();

    private ReportReader() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ReportResult<ValidatedSarif, ReaderError> readReport(@NotNull Path path) {
        ReportResult reportResult;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ReportResult<NotValidatedSarif, ReportParser.ParserError> parsedReport = ReportParser.INSTANCE.parseReport(path);
        if (parsedReport instanceof ReportResult.Fail) {
            return new ReportResult.Fail<ReportResult.Error>(new FailedParsing((ReportParser.ParserError)((ReportResult.Fail)parsedReport).getError()));
        }
        if (!(parsedReport instanceof ReportResult.Success)) throw new NoWhenBranchMatchedException();
        ReportResult validatedReport = ReportValidator.INSTANCE.validateReport(((NotValidatedSarif)((ReportResult.Success)parsedReport).getLoadedSarifReport()).getSarif());
        if (validatedReport instanceof ReportResult.Fail) {
            reportResult = new ReportResult.Fail<ReportResult.Error>(new FailedValidation((ReportValidator.ValidatorError)((ReportResult.Fail)validatedReport).getError()));
            return reportResult;
        } else {
            if (!(validatedReport instanceof ReportResult.Success)) throw new NoWhenBranchMatchedException();
            reportResult = validatedReport;
        }
        return reportResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/report/ReportReader$FailedParsing;", "Lorg/jetbrains/qodana/report/ReportReader$ReaderError;", "parserError", "Lorg/jetbrains/qodana/report/ReportParser$ParserError;", "<init>", "(Lorg/jetbrains/qodana/report/ReportParser$ParserError;)V", "getParserError", "()Lorg/jetbrains/qodana/report/ReportParser$ParserError;", "throwException", "", "spawnNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "contentProvider", "Lkotlin/Function1;", "", "intellij.qodana"})
    public static final class FailedParsing
    implements ReaderError {
        @NotNull
        private final ReportParser.ParserError parserError;

        public FailedParsing(@NotNull ReportParser.ParserError parserError) {
            Intrinsics.checkNotNullParameter((Object)parserError, (String)"parserError");
            this.parserError = parserError;
        }

        @NotNull
        public final ReportParser.ParserError getParserError() {
            return this.parserError;
        }

        @Override
        @NotNull
        public Void throwException() {
            this.parserError.throwException();
            throw new KotlinNothingValueException();
        }

        @Override
        public void spawnNotification(@Nullable Project project, @NotNull Function1<? super ReaderError, String> contentProvider) {
            Intrinsics.checkNotNullParameter(contentProvider, (String)"contentProvider");
            this.parserError.spawnNotification(project, (Function1<? super ReportParser.ParserError, String>)((Function1)arg_0 -> FailedParsing.spawnNotification$lambda$0(contentProvider, arg_0)));
        }

        private static final String spawnNotification$lambda$0(Function1 $contentProvider, ReportParser.ParserError error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return (String)$contentProvider.invoke((Object)new FailedParsing(error));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/report/ReportReader$FailedValidation;", "Lorg/jetbrains/qodana/report/ReportReader$ReaderError;", "validatorError", "Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;", "<init>", "(Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;)V", "getValidatorError", "()Lorg/jetbrains/qodana/report/ReportValidator$ValidatorError;", "throwException", "", "spawnNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "contentProvider", "Lkotlin/Function1;", "", "intellij.qodana"})
    public static final class FailedValidation
    implements ReaderError {
        @NotNull
        private final ReportValidator.ValidatorError validatorError;

        public FailedValidation(@NotNull ReportValidator.ValidatorError validatorError) {
            Intrinsics.checkNotNullParameter((Object)validatorError, (String)"validatorError");
            this.validatorError = validatorError;
        }

        @NotNull
        public final ReportValidator.ValidatorError getValidatorError() {
            return this.validatorError;
        }

        @Override
        @NotNull
        public Void throwException() {
            this.validatorError.throwException();
            throw new KotlinNothingValueException();
        }

        @Override
        public void spawnNotification(@Nullable Project project, @NotNull Function1<? super ReaderError, String> contentProvider) {
            Intrinsics.checkNotNullParameter(contentProvider, (String)"contentProvider");
            this.validatorError.spawnNotification(project, (Function1<? super ReportValidator.ValidatorError, String>)((Function1)arg_0 -> FailedValidation.spawnNotification$lambda$0(contentProvider, arg_0)));
        }

        private static final String spawnNotification$lambda$0(Function1 $contentProvider, ReportValidator.ValidatorError error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return (String)$contentProvider.invoke((Object)new FailedValidation(error));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001\u0082\u0001\u0002\u0002\u0003\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/qodana/report/ReportReader$ReaderError;", "Lorg/jetbrains/qodana/report/ReportResult$Error;", "Lorg/jetbrains/qodana/report/ReportReader$FailedParsing;", "Lorg/jetbrains/qodana/report/ReportReader$FailedValidation;", "intellij.qodana"})
    public static sealed interface ReaderError
    extends ReportResult.Error<ReaderError>
    permits FailedParsing, FailedValidation {
    }
}

