/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.handler;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CssPropertyNameInsertHandler
implements InsertHandler<LookupElement> {
    private final boolean myAddDeclarationTerminator;

    public CssPropertyNameInsertHandler(boolean declarationTerminator) {
        this.myAddDeclarationTerminator = declarationTerminator;
    }

    protected String getPropertyNameValueDelimiter(@NotNull InsertionContext context) {
        if (context == null) {
            CssPropertyNameInsertHandler.$$$reportNull$$$0(0);
        }
        return ":";
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            CssPropertyNameInsertHandler.$$$reportNull$$$0(1);
        }
        if (item == null) {
            CssPropertyNameInsertHandler.$$$reportNull$$$0(2);
        }
        context.setAddCompletionChar(false);
        PsiElement elementAtCaret = context.getFile().findElementAt(context.getStartOffset());
        if (elementAtCaret == null) {
            return;
        }
        PsiElement nextVisibleSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)elementAtCaret);
        PsiElement prevVisibleSibling = PsiTreeUtil.prevLeaf((PsiElement)elementAtCaret, (boolean)true);
        if (nextVisibleSibling == null || !nextVisibleSibling.getText().equals(":")) {
            Editor editor = context.getEditor();
            int offset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            if (!(document.getTextLength() < offset || prevVisibleSibling != null && prevVisibleSibling.getText().equals(":"))) {
                CodeStyleSettings globalSettings = CodeStyle.getSettings((PsiFile)context.getFile());
                CssCodeStyleSettings settings = (CssCodeStyleSettings)globalSettings.getCustomSettings(CssCodeStyleSettings.class);
                String delimiter = this.getPropertyNameValueDelimiter(context);
                Object elementTerminator = settings.SPACE_AFTER_COLON ? delimiter + " " : delimiter;
                String declarationsTerminator = this.myAddDeclarationTerminator ? CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)elementAtCaret) : "";
                int lineNumber = document.getLineNumber(offset);
                boolean isLastStatementInLine = nextVisibleSibling == null || document.getLineEndOffset(lineNumber) < nextVisibleSibling.getTextRange().getStartOffset();
                document.insertString(offset, (CharSequence)elementTerminator);
                if (isLastStatementInLine) {
                    document.insertString(offset + ((String)elementTerminator).length(), (CharSequence)declarationsTerminator);
                }
                editor.getCaretModel().moveToOffset(offset + ((String)elementTerminator).length());
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            } else if (document.getTextLength() >= offset) {
                document.insertString(offset, (CharSequence)" ");
                editor.getCaretModel().moveToOffset(offset + 1);
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/completion/handler/CssPropertyNameInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNameValueDelimiter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

