function processAsyncapiEndpoint(element, className) {
    let endpointName
    if (className === "mb-12") {
        endpointName = getEndpointName(element)
    }

    if (!endpointName) return null
    return "Endpoint#" + endpointName;
}

function processAsyncapiModel(element, className) {
    let modelName
    if (className === "mb-4") {
        modelName = getModelName(element)
    }

    if (!modelName) return null
    return "Model#" + sanitize(modelName);
}

function getModelName(element) {
    let rawId = element.id
    let lastDelimiter = rawId.indexOf("-");
    if (lastDelimiter === -1) {
        return rawId
    } else {
        return rawId.substring(lastDelimiter + 1)
    }
}

function getEndpointName(element) {
    let rawId = element.id
    let noPrefix = rawId.replace(/^operation-/, '')
    let lastDelimiter = noPrefix.indexOf("-");
    if (lastDelimiter === -1) {
        return null
    } else {
        let operation = noPrefix.substring(0, lastDelimiter).toUpperCase();
        let path = noPrefix.substring(lastDelimiter + 1);
        return sanitize(operation) + "#" + sanitize(path)
    }
}

function sanitize(string) {
    return string.replace(/[^a-zA-Z0-9{}_\-\/]/g, '')
}