/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiTypes {
    private static final List<PsiPrimitiveType> PRIMITIVE_TYPES = Collections.unmodifiableList(Arrays.asList(PsiTypes.booleanType(), PsiTypes.byteType(), PsiTypes.charType(), PsiTypes.shortType(), PsiTypes.intType(), PsiTypes.longType(), PsiTypes.floatType(), PsiTypes.doubleType()));
    private static final Map<String, PsiPrimitiveType> PRIMITIVE_TYPES_BY_NAME = Collections.unmodifiableMap(PRIMITIVE_TYPES.stream().collect(Collectors.toMap(PsiPrimitiveType::getName, Function.identity())));

    @NotNull
    public static PsiPrimitiveType byteType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.BYTE;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(0);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiPrimitiveType charType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.CHAR;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(1);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiPrimitiveType doubleType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.DOUBLE;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(2);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiPrimitiveType floatType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.FLOAT;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(3);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiPrimitiveType intType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(4);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiPrimitiveType longType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.LONG;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(5);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiPrimitiveType shortType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.SHORT;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(6);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiPrimitiveType booleanType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.BOOLEAN;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(7);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiPrimitiveType voidType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(8);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static List<PsiPrimitiveType> primitiveTypes() {
        List<PsiPrimitiveType> list = PRIMITIVE_TYPES;
        if (list == null) {
            PsiTypes.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public static PsiPrimitiveType primitiveTypeByName(@NotNull String name) {
        if (name == null) {
            PsiTypes.$$$reportNull$$$0(10);
        }
        return PRIMITIVE_TYPES_BY_NAME.get(name);
    }

    @NotNull
    public static Set<String> primitiveTypeNames() {
        Set<String> set = PRIMITIVE_TYPES_BY_NAME.keySet();
        if (set == null) {
            PsiTypes.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public static PsiType nullType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
        if (psiPrimitiveType == null) {
            PsiTypes.$$$reportNull$$$0(12);
        }
        return psiPrimitiveType;
    }

    private PsiTypes() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiTypes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "byteType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "charType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doubleType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "floatType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "intType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "longType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "shortType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "booleanType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "voidType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "primitiveTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "primitiveTypeNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "nullType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "primitiveTypeByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

