/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.networks;

import com.github.dockerjava.api.model.Network;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.ui.components.ComboBoxWithAutoCompletion;
import com.intellij.docker.ui.components.LookupElement;
import com.intellij.docker.ui.fragmentedDialog.FragmentedDialog;
import com.intellij.docker.ui.fragmentedDialog.optionBuilders.FragmentedDialogCommandlineBuilder;
import com.intellij.docker.ui.fragmentedDialog.optionBuilders.FragmentedDialogStaticOptionBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"CONNECT_COMMAND", "", "showConnectNetworkDialogAndGetResult", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "network", "Lcom/github/dockerjava/api/model/Network;", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nConnectNetworkDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectNetworkDialog.kt\ncom/intellij/docker/action/networks/ConnectNetworkDialogKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1208#2,2:74\n1236#2,4:76\n1#3:80\n*S KotlinDebug\n*F\n+ 1 ConnectNetworkDialog.kt\ncom/intellij/docker/action/networks/ConnectNetworkDialogKt\n*L\n26#1:74,2\n26#1:76,4\n*E\n"})
public final class ConnectNetworkDialogKt {
    @NlsSafe
    @NotNull
    private static final String CONNECT_COMMAND = "docker network connect";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresEdt
    @Nullable
    public static final String showConnectNetworkDialogAndGetResult(@NotNull Project project, @NotNull DockerRuntimeContext context, @NotNull Network network) {
        Comparable comparable;
        ComboBoxWithAutoCompletion $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Iterable $this$associateBy$iv = context.getRuntimesManager().getContainers().values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            DockerApplicationRuntime dockerApplicationRuntime = (DockerApplicationRuntime)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            String string = dockerApplicationRuntime.getContainerName();
            map2.put(string != null ? StringsKt.drop((String)string, (int)1) : null, element$iv$iv);
        }
        Map containers2 = destination$iv$iv;
        List containerNames = CollectionsKt.filterNotNull((Iterable)containers2.keySet());
        Set alreadyUsedContainerIds = network.getContainers().keySet();
        ComboBoxWithAutoCompletion $this$showConnectNetworkDialogAndGetResult_u24lambda_u242 = $this$associateByTo$iv$iv = new ComboBoxWithAutoCompletion(new CollectionComboBoxModel(containerNames), project, DockerBundle.message((String)"ConnectNetworkDialog.specify.container", (Object[])new Object[0]), arg_0 -> ConnectNetworkDialogKt.showConnectNetworkDialogAndGetResult$lambda$1(containers2, arg_0));
        boolean bl = false;
        $this$showConnectNetworkDialogAndGetResult_u24lambda_u242.setRenderer(BuilderKt.listCellRenderer(arg_0 -> ConnectNetworkDialogKt.showConnectNetworkDialogAndGetResult$lambda$2$0(containers2, arg_0)));
        Object object = containerNames;
        CharSequence charSequence = "#";
        ComboBoxWithAutoCompletion comboBoxWithAutoCompletion = $this$showConnectNetworkDialogAndGetResult_u24lambda_u242;
        Iterator bl2 = object.iterator();
        if (!bl2.hasNext()) {
            comparable = null;
        } else {
            String it = (String)bl2.next();
            boolean bl3 = false;
            Comparable comparable2 = Integer.valueOf(it.length());
            while (bl2.hasNext()) {
                String it2 = (String)bl2.next();
                $i$a$-maxOfOrNull-ConnectNetworkDialogKt$showConnectNetworkDialogAndGetResult$containersComboBox$2$2 = false;
                Comparable comparable3 = Integer.valueOf(it2.length());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Comparable comparable4 = comparable;
        Integer n = (Integer)comparable4;
        comboBoxWithAutoCompletion.setPrototypeDisplayValue((Object)StringsKt.repeat((CharSequence)charSequence, (int)(n != null ? n : 0)));
        ComboBoxWithAutoCompletion containersComboBox = $this$associateByTo$iv$iv;
        String string = DockerBundle.message((String)"ConnectNetworkDialog.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        String string3 = DockerBundle.message((String)"ConnectNetworkDialog.popup.title", (Object[])new Object[0]);
        object = DockerBundle.message((String)"ConnectNetworkDialog.ok.button.text", (Object[])new Object[0]);
        charSequence = new Ref((Object)"");
        FragmentedDialog.Commandline dialog = new FragmentedDialog.Commandline(project, string2, CONNECT_COMMAND, (Object)charSequence, null, arg_0 -> ConnectNetworkDialogKt.showConnectNetworkDialogAndGetResult$lambda$3(network, arg_0), string3, (String)object, null, "org.jetbrains.docker.engine/reference/commandline/network_connect/", arg_0 -> ConnectNetworkDialogKt.showConnectNetworkDialogAndGetResult$lambda$4(containersComboBox, network, containers2, alreadyUsedContainerIds, arg_0), 272, null);
        Ref ref = (Ref)dialog.showAndGet();
        Object object2 = ref;
        if (ref == null) return null;
        String string4 = (String)object2.get();
        object2 = string4;
        if (string4 == null) return null;
        Object object3 = object2;
        boolean bl4 = false;
        DockerApplicationRuntime dockerApplicationRuntime = (DockerApplicationRuntime)containers2.get(object3);
        object2 = dockerApplicationRuntime;
        if (dockerApplicationRuntime == null) return null;
        String string5 = ((DockerContainerRuntime)object2).getId();
        return string5;
    }

    private static final LookupElement showConnectNetworkDialogAndGetResult$lambda$1(Map $containers, String it) {
        Intrinsics.checkNotNull((Object)it);
        DockerApplicationRuntime dockerApplicationRuntime = (DockerApplicationRuntime)$containers.get(it);
        return new LookupElement(it, dockerApplicationRuntime != null && (dockerApplicationRuntime = dockerApplicationRuntime.getStatus()) != null ? dockerApplicationRuntime.getIcon() : null, null, null, 12, null);
    }

    private static final Unit showConnectNetworkDialogAndGetResult$lambda$2$0(Map $containers, LcrRow $this$listCellRenderer) {
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        Object object = (DockerApplicationRuntime)$containers.get($this$listCellRenderer.getValue());
        if (object != null && (object = ((DockerRuntime)object).getStatus()) != null && (object = object.getIcon()) != null) {
            Object it = object;
            boolean bl = false;
            LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)it, null, (int)2, null);
        }
        Object object2 = $this$listCellRenderer.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-value>(...)");
        LcrRow.text$default((LcrRow)$this$listCellRenderer, (String)((String)object2), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final String showConnectNetworkDialogAndGetResult$lambda$3(Network $network, Ref it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "docker network connect " + $network.getName() + " " + it.get();
    }

    private static final Unit showConnectNetworkDialogAndGetResult$lambda$4(ComboBoxWithAutoCompletion $containersComboBox, Network $network, Map $containers, Set $alreadyUsedContainerIds, FragmentedDialogCommandlineBuilder $this$Commandline) {
        Intrinsics.checkNotNullParameter((Object)$this$Commandline, (String)"$this$Commandline");
        ComboBox comboBox = (ComboBox)$containersComboBox;
        String string = $network.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        FragmentedDialogCommandlineBuilder.staticComboBoxWithLabel$default((FragmentedDialogCommandlineBuilder)$this$Commandline, (ComboBox)comboBox, (String)string, (boolean)false, arg_0 -> ConnectNetworkDialogKt.showConnectNetworkDialogAndGetResult$lambda$4$0($containers, $alreadyUsedContainerIds, $network, arg_0), (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit showConnectNetworkDialogAndGetResult$lambda$4$0(Map $containers, Set $alreadyUsedContainerIds, Network $network, FragmentedDialogStaticOptionBuilder $this$staticComboBoxWithLabel) {
        Intrinsics.checkNotNullParameter((Object)$this$staticComboBoxWithLabel, (String)"$this$staticComboBoxWithLabel");
        $this$staticComboBoxWithLabel.setApply(ConnectNetworkDialogKt::showConnectNetworkDialogAndGetResult$lambda$4$0$0);
        $this$staticComboBoxWithLabel.setValidation((arg_0, arg_1) -> ConnectNetworkDialogKt.showConnectNetworkDialogAndGetResult$lambda$4$0$1($containers, $alreadyUsedContainerIds, $network, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit showConnectNetworkDialogAndGetResult$lambda$4$0$0(FragmentedDialogCommandlineBuilder.ComponentWithLabel c, Ref s) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object object = ((ComboBoxWithAutoCompletion)c.getComponent()).getSelectedItem();
        if ((object == null || (object = object.toString()) == null) && (object = ((ComboBoxWithAutoCompletion)c.getComponent()).getText()) == null) {
            object = "";
        }
        s.set(object);
        return Unit.INSTANCE;
    }

    private static final ValidationInfo showConnectNetworkDialogAndGetResult$lambda$4$0$1(Map $containers, Set $alreadyUsedContainerIds, Network $network, FragmentedDialogCommandlineBuilder.ComponentWithLabel componentWithLabel, Ref s) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)componentWithLabel, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object object = s.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (StringsKt.isBlank((CharSequence)((CharSequence)object))) {
            validationInfo = new ValidationInfo(DockerBundle.message((String)"ConnectNetworkDialog.validation.empty.container.name", (Object[])new Object[0]));
        } else if ($containers.get(s.get()) == null) {
            validationInfo = new ValidationInfo(DockerBundle.message((String)"ConnectNetworkDialog.validation.container.not.exist", (Object[])new Object[0]));
        } else {
            DockerApplicationRuntime dockerApplicationRuntime = (DockerApplicationRuntime)$containers.get(s.get());
            boolean bl = dockerApplicationRuntime != null ? !dockerApplicationRuntime.isRunning() : false;
            if (bl) {
                validationInfo = new ValidationInfo(DockerBundle.message((String)"ConnectNetworkDialog.validation.container.not.running", (Object[])new Object[0]));
            } else {
                Object v = $containers.get(s.get());
                Intrinsics.checkNotNull(v);
                if ($alreadyUsedContainerIds.contains(((DockerApplicationRuntime)v).getId())) {
                    Object[] objectArray = new Object[]{s.get(), $network.getName()};
                    ValidationInfo validationInfo2 = new ValidationInfo(DockerBundle.message((String)"ConnectNetworkDialog.validation.endpoint.already.exists", (Object[])objectArray));
                    validationInfo = validationInfo2;
                } else {
                    validationInfo = null;
                }
            }
        }
        return validationInfo;
    }
}

