/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners;

import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.ProvenanceEvents;
import com.intellij.code.provenance.core.events.listeners.ProvenanceDocumentListener;
import com.intellij.code.provenance.core.events.listeners.inline.completion.InlineCompletionListener;
import com.intellij.code.provenance.core.events.utils.Path_utilsKt;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceEditorListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorTypeSupported", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nProvenanceEditorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceEditorListener.kt\ncom/intellij/code/provenance/core/events/listeners/ProvenanceEditorListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class ProvenanceEditorListener
implements EditorFactoryListener {
    public void editorCreated(@NotNull EditorFactoryEvent event) {
        boolean bl;
        VirtualFile virtualFile;
        Project project;
        Editor editor;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
                    return;
                }
                if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
                    return;
                }
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                editor = editor2;
                project = editor.getProject();
                if (project == null || editor.isDisposed() || !(editor instanceof EditorImpl) || !this.editorTypeSupported(editor) && !ApplicationKt.getApplication().isUnitTestMode()) break block8;
                Project project2 = ((EditorImpl)editor).getProject();
                if (project2 != null ? !project2.isDisposed() : false) break block9;
            }
            return;
        }
        CoroutineScope scope = ProvenanceEvents.Companion.getInstance(project).getScope();
        Disposable editorDisposable = UtilsKt.newEditorDisposable(editor, scope);
        VirtualFile virtualFile2 = virtualFile = FileDocumentManager.getInstance().getFile((Document)((EditorImpl)editor).getDocument());
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl2 = false;
            bl = !Path_utilsKt.isSourceFile(it);
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        ProvenanceDocumentListener documentListener = new ProvenanceDocumentListener((EditorImpl)editor, project, virtualFile);
        Disposer.register((Disposable)editorDisposable, (Disposable)documentListener);
        ((EditorImpl)editor).getDocument().addDocumentListener((DocumentListener)documentListener, editorDisposable);
        ProvenanceEvents provenanceEvents = ProvenanceEvents.Companion.getInstance(project);
        ((EditorImpl)editor).getCaretModel().addCaretListener(new CaretListener(scope, provenanceEvents){
            final /* synthetic */ CoroutineScope $scope;
            final /* synthetic */ ProvenanceEvents $provenanceEvents;
            {
                this.$scope = $scope;
                this.$provenanceEvents = $provenanceEvents;
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                int oldLine = event.getOldPosition().line;
                int newLine = event.getNewPosition().line;
                if (oldLine != newLine) {
                    BuildersKt.launch$default((CoroutineScope)this.$scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$provenanceEvents, null){
                        int label;
                        final /* synthetic */ ProvenanceEvents $provenanceEvents;
                        {
                            this.$provenanceEvents = $provenanceEvents;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.$provenanceEvents.flushDeferred((Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }
            }
        }, editorDisposable);
        ((EditorImpl)editor).getContentComponent().addFocusListener((FocusListener)new FocusAdapter(scope, provenanceEvents){
            final /* synthetic */ CoroutineScope $scope;
            final /* synthetic */ ProvenanceEvents $provenanceEvents;
            {
                this.$scope = $scope;
                this.$provenanceEvents = $provenanceEvents;
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BuildersKt.launch$default((CoroutineScope)this.$scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$provenanceEvents, null){
                    int label;
                    final /* synthetic */ ProvenanceEvents $provenanceEvents;
                    {
                        this.$provenanceEvents = $provenanceEvents;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$provenanceEvents.flushDeferred((Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        });
        InlineCompletionListener.INSTANCE.register(editor, editorDisposable);
    }

    private final boolean editorTypeSupported(Editor editor) {
        return editor.getEditorKind() == EditorKind.MAIN_EDITOR;
    }
}

