/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.listeners.ProvenanceListenersKt;
import com.intellij.code.provenance.core.events.listeners.ProvenanceRefactoringListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000*\u0001\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/ProvenanceRefactoringListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "listener", "com/intellij/code/provenance/core/events/listeners/ProvenanceRefactoringListener$listener$1", "Lcom/intellij/code/provenance/core/events/listeners/ProvenanceRefactoringListener$listener$1;", "dispose", "", "intellij.code.provenance.core"})
public final class ProvenanceRefactoringListener
implements Disposable {
    @NotNull
    private final listener.1 listener;

    public ProvenanceRefactoringListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.listener = new RefactoringEventListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void refactoringStarted(String refactoringId, RefactoringEventData beforeData) {
                Intrinsics.checkNotNullParameter((Object)refactoringId, (String)"refactoringId");
                if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
                    return;
                }
                this.$project.putUserData(ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY(), (Object)DocumentChangesKind.REFACTORING);
            }

            public void refactoringDone(String refactoringId, RefactoringEventData afterData) {
                Intrinsics.checkNotNullParameter((Object)refactoringId, (String)"refactoringId");
                RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)this.$project), ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY());
            }
        };
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = RefactoringEventListener.REFACTORING_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"REFACTORING_EVENT_TOPIC");
        messageBusConnection.subscribe(topic, (Object)this.listener);
    }

    public void dispose() {
    }
}

