/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.network.LoadingFailedEventData;
import org.jetbrains.wip.protocol.network.NetworkKt;
import org.jetbrains.wip.protocol.network.RequestWillBeSentEventData;
import org.jetbrains.wip.protocol.network.ResponseReceivedEventData;
import org.jetbrains.wip.protocol.network.ResponseValue;
import org.jetbrains.wip.protocol.page.FrameDetachedEventData;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\tR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/wip/WipNetworkManager;", "", "eventMap", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "<init>", "(Lorg/jetbrains/jsonProtocol/EventMap;)V", "idToRequest", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/wip/RequestInfo;", "enable", "Lorg/jetbrains/concurrency/Promise;", "", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "retrieveRequest", "requestId", "intellij.javascript.wip.backend"})
public final class WipNetworkManager {
    @NotNull
    private final ConcurrentHashMap<String, RequestInfo> idToRequest;

    public WipNetworkManager(@NotNull EventMap<ProtocolResponseReader> eventMap) {
        Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
        this.idToRequest = new ConcurrentHashMap();
        eventMap.add((EventType)RequestWillBeSentEventData.TYPE, arg_0 -> WipNetworkManager._init_$lambda$0(this, arg_0));
        eventMap.add((EventType)LoadingFailedEventData.TYPE, arg_0 -> WipNetworkManager._init_$lambda$1(this, arg_0));
        eventMap.add((EventType)ResponseReceivedEventData.TYPE, arg_0 -> WipNetworkManager._init_$lambda$2(this, arg_0));
        eventMap.add((EventType)FrameDetachedEventData.TYPE, arg_0 -> WipNetworkManager._init_$lambda$3(this, arg_0));
        eventMap.add((EventType)FrameNavigatedEventData.TYPE, arg_0 -> WipNetworkManager._init_$lambda$4(this, arg_0));
    }

    @NotNull
    public final Promise<Unit> enable(@NotNull WipCommandProcessor commandProcessor) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandProcessor), (String)"commandProcessor");
        return commandProcessor.send((Request)NetworkKt.Enable$default(null, null, null, (int)7, null));
    }

    @Nullable
    public final RequestInfo retrieveRequest(@Nullable String requestId) {
        CharSequence charSequence = requestId;
        return charSequence == null || charSequence.length() == 0 ? null : this.idToRequest.remove(requestId);
    }

    private static final Unit _init_$lambda$0(WipNetworkManager this$0, RequestWillBeSentEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Map)this$0.idToRequest).put(it.requestId(), new RequestInfo(it.getFrameId(), it.request(), it.initiator(), it.loaderId()));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(WipNetworkManager this$0, LoadingFailedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RequestInfo request = this$0.idToRequest.get(it.requestId());
        if (request != null) {
            request.setFailed$intellij_javascript_wip_backend(true);
            request.setFailDescription$intellij_javascript_wip_backend(it.errorText());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(WipNetworkManager this$0, ResponseReceivedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResponseValue response = it.response();
        if (response.headers().isEmpty() || ((CharSequence)response.mimeType()).length() == 0 || response.getStatus() == 0) {
            return Unit.INSTANCE;
        }
        this$0.idToRequest.remove(it.requestId());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(WipNetworkManager this$0, FrameDetachedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String frameId = it.frameId();
        Iterator<RequestInfo> iterator = this$0.idToRequest.values().iterator();
        while (iterator.hasNext()) {
            RequestInfo item;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (!Intrinsics.areEqual((Object)item.getFrameId(), (Object)frameId)) continue;
            iterator.remove();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(WipNetworkManager this$0, FrameNavigatedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String frameId = it.frame().id();
        String loaderId = it.frame().loaderId();
        Iterator<RequestInfo> iterator = this$0.idToRequest.values().iterator();
        while (iterator.hasNext()) {
            RequestInfo item;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (!Intrinsics.areEqual((Object)item.getFrameId(), (Object)frameId) || Intrinsics.areEqual((Object)item.getLoaderId(), (Object)loaderId)) continue;
            iterator.remove();
        }
        return Unit.INSTANCE;
    }
}

