/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopAspect;
import com.intellij.aop.AopBundle;
import com.intellij.aop.AopCommonIcons;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.AopProvider;
import com.intellij.aop.jam.AopAdviceImpl;
import com.intellij.aop.jam.AopIntroductionImpl;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.jam.utils.AopModelSearchers;
import com.intellij.aop.jam.utils.AopModelUtils;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.navigation.JamNavigationGutterIconBuilder;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

public final class AopUastAnnotator
extends LineMarkerProviderDescriptor {
    @NlsSafe
    public String getName() {
        return "AOP (Java/Kotlin)";
    }

    public Icon getIcon() {
        return AopCommonIcons.Abstract_advice;
    }

    private static Icon createFromIcon(@NotNull Icon icon) {
        if (icon == null) {
            AopUastAnnotator.$$$reportNull$$$0(0);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(icon, 0);
        layeredIcon.setIcon(AopCommonIcons.From_arrow, 1);
        return layeredIcon;
    }

    private static Icon createToIcon(@NotNull Icon icon) {
        if (icon == null) {
            AopUastAnnotator.$$$reportNull$$$0(1);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(icon, 0);
        layeredIcon.setIcon(AopCommonIcons.To_arrow, 1);
        return layeredIcon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            AopUastAnnotator.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            AopUastAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            AopUastAnnotator.$$$reportNull$$$0(4);
        }
        if (elements.isEmpty()) {
            return;
        }
        PsiElement first = elements.iterator().next();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)first);
        if (module == null || !AopUastAnnotator.hasAnnotations(module)) {
            return;
        }
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            AopUastAnnotator.annotate(psiElement, result);
        }
    }

    private static boolean hasAnnotations(@NotNull Module module) {
        if (module == null) {
            AopUastAnnotator.$$$reportNull$$$0(5);
        }
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.aspectj.lang.annotation.Aspect");
    }

    private static void annotate(PsiElement psiElement, Collection<? super LineMarkerInfo<?>> result) {
        UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
        if (uParent == null) {
            return;
        }
        PsiElement psiParent = uParent.getJavaPsi();
        if (psiParent == null) {
            return;
        }
        if (uParent instanceof UMethod) {
            AopAdviceImpl advice;
            UMethod uMethod = (UMethod)uParent;
            if (uMethod.isConstructor()) {
                return;
            }
            UClass containingClass = UastUtils.getContainingUClass((UElement)uParent);
            if (containingClass == null) {
                return;
            }
            PsiClass containingPsiClass = containingClass.getJavaPsi();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            List<AopProvider> providers = AopModelSearchers.getAopProviders(containingPsiClass);
            if (providers.isEmpty()) {
                return;
            }
            PsiIdentifier nameIdentifier = uMethod.getJavaPsi().getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            if (AopUastAnnotator.isAcceptableAdviceMethod(containingPsiClass, providers) && (advice = JamAopModel.getAdvice(uMethod.getJavaPsi())) != null) {
                AopUastAnnotator.annotateAdviceMethod(result, advice, nameIdentifier);
                return;
            }
            Set<AopAspect> aspects = AopModelUtils.getAspects(containingPsiClass);
            Map<AopAdvice, Integer> boundAdvices = AopModelUtils.addBoundAdvices(uMethod.getJavaPsi(), aspects, providers);
            if (!boundAdvices.isEmpty()) {
                result.add((LineMarkerInfo<?>)AopUastAnnotator.addNavigationToBoundAdvices(boundAdvices).createLineMarkerInfo((PsiElement)nameIdentifier));
            }
        } else if (uParent instanceof UClass) {
            UClass uClass = (UClass)uParent;
            PsiClass psiClass = uClass.getJavaPsi();
            if (psiClass.hasModifierProperty("abstract")) {
                return;
            }
            PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
            if (nameIdentifier != psiElement) {
                return;
            }
            List<AopIntroduction> boundIntros = AopUastAnnotator.getBoundIntroductions(psiClass);
            if (!boundIntros.isEmpty()) {
                result.add((LineMarkerInfo<?>)AopUastAnnotator.addNavigationToBoundIntroductions(boundIntros).createLineMarkerInfo((PsiElement)nameIdentifier));
            }
        } else if (uParent instanceof UFieldEx) {
            NavigationGutterIconBuilder<PsiElement> builder;
            UFieldEx uField = (UFieldEx)uParent;
            PsiIdentifier nameIdentifier = uField.getJavaPsi().getNameIdentifier();
            List<AopProvider> providers = AopUastAnnotator.getAopProviders(uParent);
            if (providers == null || providers.isEmpty()) {
                return;
            }
            AopIntroductionImpl introduction = JamAopModel.getIntroduction(uField.getJavaPsi());
            if (introduction != null && (builder = AopUastAnnotator.addNavigationToIntroducedClasses(introduction)) != null) {
                result.add((LineMarkerInfo<?>)builder.createLineMarkerInfo((PsiElement)nameIdentifier));
            }
        }
    }

    @Nullable
    private static List<AopProvider> getAopProviders(@NotNull UElement uElement) {
        UClass uClass;
        if (uElement == null) {
            AopUastAnnotator.$$$reportNull$$$0(6);
        }
        if ((uClass = UastUtils.getContainingUClass((UElement)uElement)) == null) {
            return null;
        }
        PsiClass containingPsiClass = uClass.getJavaPsi();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingPsiClass);
        if (module == null) {
            return null;
        }
        return AopModelSearchers.getAopProviders(containingPsiClass);
    }

    private static void annotateAdviceMethod(Collection<? super LineMarkerInfo<?>> result, AopAdviceImpl advice, PsiIdentifier nameIdentifier) {
        PsiPointcutExpression expression = advice.getPointcutExpression();
        if (expression != null) {
            AopAdvisedElementsSearcher searcher = AopPointcutUtil.getHolder(expression).getAopModel().getAdvisedElementsSearcher();
            result.add((LineMarkerInfo<?>)AopUastAnnotator.addNavigationToInterceptedMethods(advice, searcher).createLineMarkerInfo((PsiElement)nameIdentifier));
        }
    }

    @NotNull
    public static NavigationGutterIconBuilder<AopIntroduction> addNavigationToBoundIntroductions(List<? extends AopIntroduction> boundIntros) {
        NavigationGutterIconBuilder navigationGutterIconBuilder = JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)AopUastAnnotator.createToIcon(AopCommonIcons.Gutter.Introduction), AopIntroduction.class).setTargets(boundIntros).setTooltipText(AopBundle.message("tooltip.text.navigate.to.introductions", new Object[0])).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.introductions", new Object[0])).setAlignment(GutterIconRenderer.Alignment.LEFT);
        if (navigationGutterIconBuilder == null) {
            AopUastAnnotator.$$$reportNull$$$0(7);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public static NavigationGutterIconBuilder<AopAdvice> addNavigationToBoundAdvices(Map<AopAdvice, Integer> boundAdvices) {
        ArrayList<AopAdvice> adviceList = new ArrayList<AopAdvice>(boundAdvices.keySet());
        adviceList.sort((o1, o2) -> {
            boolean onTheWayIn = o1.getAdviceType().isOnTheWayIn();
            if (onTheWayIn != o2.getAdviceType().isOnTheWayIn()) {
                return onTheWayIn ? -1 : 1;
            }
            int i1 = (Integer)boundAdvices.get(o1);
            int i2 = (Integer)boundAdvices.get(o2);
            int diff = i2 - i1;
            return onTheWayIn ? -diff : diff;
        });
        HashMap psi2Advice = new HashMap();
        NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AopUastAnnotator.createToIcon(AopCommonIcons.Gutter.Abstract_advice), advice -> {
            PsiElement[] psiElements;
            for (PsiElement element : psiElements = JamCommonUtil.getTargetPsiElements((CommonModelElement)advice)) {
                psi2Advice.put(element, advice);
            }
            return Arrays.asList(psiElements);
        }).setTargets(adviceList).setTooltipText(AopBundle.message("tooltip.text.navigate.to.advices", new Object[0])).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.advices", new Object[0])).setAlignment(GutterIconRenderer.Alignment.LEFT).setTargetRenderer(() -> AopUastAnnotator.getPsiElementCellRenderer(boundAdvices, psi2Advice));
        if (navigationGutterIconBuilder == null) {
            AopUastAnnotator.$$$reportNull$$$0(8);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    private static PsiTargetPresentationRenderer<PsiElement> getPsiElementCellRenderer(final Map<AopAdvice, Integer> boundAdvices, final Map<PsiElement, AopAdvice> psi2Advice) {
        return new PsiTargetPresentationRenderer<PsiElement>(){

            @NotNull
            public String getElementText(@NotNull PsiElement element) {
                Integer integer;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                String superText = super.getElementText(element);
                AopAdvice advice = (AopAdvice)psi2Advice.get(element);
                if (advice != null && advice.isValid() && (integer = (Integer)boundAdvices.get(advice)) != null && integer < Integer.MAX_VALUE) {
                    String string = AopBundle.message("0.order.1", superText, integer);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = superText;
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            public String getContainerText(@NotNull PsiElement element) {
                PsiFile file;
                String superText;
                if (element == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (StringUtil.isEmpty((String)(superText = super.getContainerText(element))) && (file = element.getContainingFile()) != null) {
                    return AopBundle.message("in.file", file.getName());
                }
                return superText;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/aop/jam/AopUastAnnotator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/aop/jam/AopUastAnnotator$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElementText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getElementText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getContainerText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static List<AopIntroduction> getBoundIntroductions(PsiClass psiClass) {
        Project project = psiClass.getProject();
        return DumbService.isDumb((Project)project) ? Collections.emptyList() : (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(AopModelUtils.calcBoundIntroductions(psiClass, true), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean isAcceptableAdviceMethod(PsiClass psiClass, List<? extends AopProvider> providers) {
        for (AopProvider aopProvider : providers) {
            if (aopProvider.getAdvisedElementsSearcher(psiClass) == null) continue;
            return true;
        }
        return false;
    }

    private static PsiClassType createPsiType(PsiClass psiClass) {
        return JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> addNavigationToInterceptedMethods(final AopAdvice advice, final AopAdvisedElementsSearcher searcher) {
        NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AopUastAnnotator.createFromIcon(advice.getAdviceType().getAdviceIcon())).setTargets(NotNullLazyValue.lazy(() -> {
            if (!advice.isValid()) {
                return Collections.emptyList();
            }
            final HashSet result = new HashSet();
            ContainerUtil.process(searcher.collectAdvisedClasses(), (Processor)new ReadActionProcessor<PsiClass>(){

                public boolean processInReadAction(PsiClass psiClass) {
                    if (advice.isValid()) {
                        for (PsiMethod psiMethod : psiClass.getMethods()) {
                            if (!AopModelUtils.isAdviceAcceptingMethod(advice, psiMethod, searcher, false)) continue;
                            result.add(psiMethod);
                        }
                    }
                    return true;
                }
            });
            return result;
        })).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.methods", new Object[0])).setTooltipText(AopBundle.message("tooltip.text.navigate.to.methods", new Object[0])).setEmptyPopupText(AopBundle.message("empty.popup.text.navigate.to.methods", new Object[0]));
        if (navigationGutterIconBuilder == null) {
            AopUastAnnotator.$$$reportNull$$$0(9);
        }
        return navigationGutterIconBuilder;
    }

    @Nullable
    public static NavigationGutterIconBuilder<PsiElement> addNavigationToIntroducedClasses(AopIntroduction introduction) {
        final AopReferenceHolder expression = (AopReferenceHolder)introduction.getTypesMatching().getValue();
        if (expression == null) {
            return null;
        }
        final AopAdvisedElementsSearcher searcher = AopPointcutUtil.getHolder((PsiElement)expression).getAopModel().getAdvisedElementsSearcher();
        NotNullLazyValue targets = NotNullLazyValue.lazy(() -> {
            final HashSet result = new HashSet();
            ContainerUtil.process(searcher.collectAdvisedClasses(), (Processor)new ReadActionProcessor<PsiClass>(){

                public boolean processInReadAction(PsiClass psiClass) {
                    if (expression.accepts((PsiType)AopUastAnnotator.createPsiType(psiClass)) == PointcutMatchDegree.TRUE && searcher.isInherentlyAdvisable(psiClass) && searcher.isAdvisableInModel(psiClass)) {
                        result.add(psiClass);
                    }
                    return true;
                }
            });
            return result;
        });
        return NavigationGutterIconBuilder.create((Icon)AopUastAnnotator.createFromIcon(AopCommonIcons.Gutter.Introduction)).setTargets(targets).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.classes", new Object[0])).setTooltipText(AopBundle.message("tooltip.text.navigate.to.classes", new Object[0])).setEmptyPopupText(AopBundle.message("empty.popup.text.navigate.to.classes", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/jam/AopUastAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/jam/AopUastAnnotator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToBoundIntroductions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToBoundAdvices";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToInterceptedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAopProviders";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

