/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 49365608662031L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-745395090 + -23684, 745395090 + (char)-28506, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-745395090 + -23683, -745395090 + -((char)-22802), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 84567511920633L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.D();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-394127490 + -29536, 394127490 + 6132, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-394127490 + -29535, -394127490 + -((char)-28876), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-394127490 + -29542, 394127490 + 7776, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 26233447494755L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.D();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-212726610 + -3371, -212726610 + -15789, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-212726610 + -3374, 212726610 + 22884, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-212726610 + -3373, -212726610 + -5266, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-212726610 + -3360, 212726610 + (char)-31755, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-212726610 + -3359, -212726610 + -17111, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-212726610 + -3362, 212726610 + 17096, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-212726610 + -3360, 212726610 + (char)-31755, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-212726610 + -3361, -212726610 + -((char)-32296), (int)l2));
            if (!ActionTimestamp.D()) {
                SshAgentIpcService.D(new int[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 137966144200753L;
                    nArray = SshAgentIpcService.D();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    int[] nArray;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 19834903307860L;
                            int[] nArray2 = SshAgentIpcService.D();
                            this.assertConnectionThread();
                            nArray = nArray2;
                            Object object3 = this.lock;
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (nArray == null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(744346530 + 6683, -744346530 - -9192, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(744346530 + 6679, -744346530 - -14610, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(744346530 + 6682, -744346530 - -14988, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(744346530 + 6679, -744346530 - -14610, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(744346530 + 6685, -744346530 + -9141, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(744346530 + 6683, -744346530 - -9192, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(744346530 + 6679, -744346530 - -14610, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(744346530 + 6684, 744346530 + 6359, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (nArray == null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n = Kernel32.INSTANCE.GetLastError();
                            if (n == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(744346530 + 6683, -744346530 - -9192, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(744346530 + 6679, -744346530 - -14610, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(744346530 + 6655, 744346530 - 16213, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(744346530 + 6679, -744346530 - -14610, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(744346530 + 6654, -744346530 + -7276, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(744346530 + 6679, -744346530 - -14610, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(744346530 + 6685, -744346530 + -9141, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(744346530 + 6683, -744346530 - -9192, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(744346530 + 6679, -744346530 - -14610, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(744346530 + 6657, 744346530 + 2916, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 46943934831510L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(57670800 + (char)-2804, -57670800 + -((char)-19721), (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 48890086001962L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-473293770 - -2795, 473293770 - 3705, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "\u00c0\u00eew\u00fd\u0087)'\u00cc\u00a6\u00ac?\u0094<7\u0001\u00c2\u0098=O\u0014\u00d8't\u00c2\u00fc\f5\u00edf\u008e\u00e2\u0004E\u00dc\u00ef4\u00a8%N\u00e0";
                                        var4_3 = "\u00c0\u00eew\u00fd\u0087)'\u00cc\u00a6\u00ac?\u0094<7\u0001\u00c2\u0098=O\u0014\u00d8't\u00c2\u00fc\f5\u00edf\u008e\u00e2\u0004E\u00dc\u00ef4\u00a8%N\u00e0".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 96;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 70;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 79;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 31;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 37;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 17;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 78;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 79;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n, int n2, int n3) {
                                    int n4 = (n ^ n3 ^ 0xFFFFAA0A) & 0xFFFF;
                                    if (b[n4] == null) {
                                        int n5;
                                        char[] cArray = a[n4].toCharArray();
                                        int n6 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 187;
                                            case 1 -> 155;
                                            case 2 -> 174;
                                            case 3 -> 96;
                                            case 4 -> 83;
                                            case 5 -> 10;
                                            case 6 -> 139;
                                            case 7 -> 160;
                                            case 8 -> 249;
                                            case 9 -> 69;
                                            case 10 -> 164;
                                            case 11 -> 218;
                                            case 12 -> 122;
                                            case 13 -> 244;
                                            case 14 -> 180;
                                            case 15 -> 220;
                                            case 16 -> 46;
                                            case 17 -> 253;
                                            case 18 -> 181;
                                            case 19 -> 178;
                                            case 20 -> 93;
                                            case 21 -> 177;
                                            case 22 -> 190;
                                            case 23 -> 50;
                                            case 24 -> 205;
                                            case 25 -> 232;
                                            case 26 -> 129;
                                            case 27 -> 106;
                                            case 28 -> 216;
                                            case 29 -> 121;
                                            case 30 -> 231;
                                            case 31 -> 111;
                                            case 32 -> 89;
                                            case 33 -> 42;
                                            case 34 -> 104;
                                            case 35 -> 29;
                                            case 36 -> 73;
                                            case 37 -> 162;
                                            case 38 -> 41;
                                            case 39 -> 92;
                                            case 40 -> 237;
                                            case 41 -> 68;
                                            case 42 -> 4;
                                            case 43 -> 102;
                                            case 44 -> 186;
                                            case 45 -> 78;
                                            case 46 -> 19;
                                            case 47 -> 207;
                                            case 48 -> 214;
                                            case 49 -> 184;
                                            case 50 -> 246;
                                            case 51 -> 240;
                                            case 52 -> 21;
                                            case 53 -> 208;
                                            case 54 -> 157;
                                            case 55 -> 80;
                                            case 56 -> 158;
                                            case 57 -> 97;
                                            case 58 -> 0;
                                            case 59 -> 43;
                                            case 60 -> 109;
                                            case 61 -> 154;
                                            case 62 -> 211;
                                            case 63 -> 233;
                                            case 64 -> 57;
                                            case 65 -> 91;
                                            case 66 -> 169;
                                            case 67 -> 25;
                                            case 68 -> 120;
                                            case 69 -> 200;
                                            case 70 -> 204;
                                            case 71 -> 52;
                                            case 72 -> 18;
                                            case 73 -> 144;
                                            case 74 -> 67;
                                            case 75 -> 119;
                                            case 76 -> 167;
                                            case 77 -> 39;
                                            case 78 -> 210;
                                            case 79 -> 142;
                                            case 80 -> 63;
                                            case 81 -> 165;
                                            case 82 -> 12;
                                            case 83 -> 135;
                                            case 84 -> 228;
                                            case 85 -> 36;
                                            case 86 -> 20;
                                            case 87 -> 86;
                                            case 88 -> 5;
                                            case 89 -> 53;
                                            case 90 -> 37;
                                            case 91 -> 145;
                                            case 92 -> 227;
                                            case 93 -> 23;
                                            case 94 -> 107;
                                            case 95 -> 62;
                                            case 96 -> 45;
                                            case 97 -> 113;
                                            case 98 -> 40;
                                            case 99 -> 251;
                                            case 100 -> 146;
                                            case 101 -> 189;
                                            case 102 -> 171;
                                            case 103 -> 215;
                                            case 104 -> 32;
                                            case 105 -> 24;
                                            case 106 -> 61;
                                            case 107 -> 197;
                                            case 108 -> 59;
                                            case 109 -> 209;
                                            case 110 -> 250;
                                            case 111 -> 149;
                                            case 112 -> 229;
                                            case 113 -> 182;
                                            case 114 -> 212;
                                            case 115 -> 137;
                                            case 116 -> 141;
                                            case 117 -> 77;
                                            case 118 -> 9;
                                            case 119 -> 71;
                                            case 120 -> 234;
                                            case 121 -> 15;
                                            case 122 -> 105;
                                            case 123 -> 75;
                                            case 124 -> 185;
                                            case 125 -> 195;
                                            case 126 -> 72;
                                            case 127 -> 222;
                                            case 128 -> 56;
                                            case 129 -> 114;
                                            case 130 -> 27;
                                            case 131 -> 6;
                                            case 132 -> 219;
                                            case 133 -> 85;
                                            case 134 -> 17;
                                            case 135 -> 238;
                                            case 136 -> 143;
                                            case 137 -> 55;
                                            case 138 -> 16;
                                            case 139 -> 74;
                                            case 140 -> 131;
                                            case 141 -> 132;
                                            case 142 -> 49;
                                            case 143 -> 1;
                                            case 144 -> 198;
                                            case 145 -> 172;
                                            case 146 -> 108;
                                            case 147 -> 199;
                                            case 148 -> 94;
                                            case 149 -> 213;
                                            case 150 -> 98;
                                            case 151 -> 179;
                                            case 152 -> 26;
                                            case 153 -> 99;
                                            case 154 -> 126;
                                            case 155 -> 51;
                                            case 156 -> 87;
                                            case 157 -> 130;
                                            case 158 -> 241;
                                            case 159 -> 148;
                                            case 160 -> 33;
                                            case 161 -> 230;
                                            case 162 -> 65;
                                            case 163 -> 11;
                                            case 164 -> 170;
                                            case 165 -> 226;
                                            case 166 -> 117;
                                            case 167 -> 254;
                                            case 168 -> 2;
                                            case 169 -> 100;
                                            case 170 -> 173;
                                            case 171 -> 255;
                                            case 172 -> 7;
                                            case 173 -> 252;
                                            case 174 -> 13;
                                            case 175 -> 14;
                                            case 176 -> 124;
                                            case 177 -> 161;
                                            case 178 -> 66;
                                            case 179 -> 196;
                                            case 180 -> 168;
                                            case 181 -> 163;
                                            case 182 -> 58;
                                            case 183 -> 81;
                                            case 184 -> 201;
                                            case 185 -> 64;
                                            case 186 -> 150;
                                            case 187 -> 191;
                                            case 188 -> 84;
                                            case 189 -> 70;
                                            case 190 -> 166;
                                            case 191 -> 38;
                                            case 192 -> 147;
                                            case 193 -> 3;
                                            case 194 -> 136;
                                            case 195 -> 175;
                                            case 196 -> 31;
                                            case 197 -> 79;
                                            case 198 -> 194;
                                            case 199 -> 248;
                                            case 200 -> 8;
                                            case 201 -> 134;
                                            case 202 -> 47;
                                            case 203 -> 76;
                                            case 204 -> 35;
                                            case 205 -> 128;
                                            case 206 -> 60;
                                            case 207 -> 127;
                                            case 208 -> 236;
                                            case 209 -> 202;
                                            case 210 -> 188;
                                            case 211 -> 221;
                                            case 212 -> 203;
                                            case 213 -> 116;
                                            case 214 -> 101;
                                            case 215 -> 193;
                                            case 216 -> 239;
                                            case 217 -> 152;
                                            case 218 -> 224;
                                            case 219 -> 206;
                                            case 220 -> 115;
                                            case 221 -> 123;
                                            case 222 -> 22;
                                            case 223 -> 192;
                                            case 224 -> 90;
                                            case 225 -> 151;
                                            case 226 -> 54;
                                            case 227 -> 242;
                                            case 228 -> 28;
                                            case 229 -> 82;
                                            case 230 -> 103;
                                            case 231 -> 88;
                                            case 232 -> 118;
                                            case 233 -> 153;
                                            case 234 -> 133;
                                            case 235 -> 125;
                                            case 236 -> 183;
                                            case 237 -> 140;
                                            case 238 -> 34;
                                            case 239 -> 159;
                                            case 240 -> 30;
                                            case 241 -> 243;
                                            case 242 -> 217;
                                            case 243 -> 95;
                                            case 244 -> 223;
                                            case 245 -> 110;
                                            case 246 -> 48;
                                            case 247 -> 156;
                                            case 248 -> 176;
                                            case 249 -> 44;
                                            case 250 -> 247;
                                            case 251 -> 138;
                                            case 252 -> 112;
                                            case 253 -> 225;
                                            case 254 -> 235;
                                            default -> 245;
                                        };
                                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                                        if (n7 < 0) {
                                            n7 += 256;
                                        }
                                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                                            n5 += 256;
                                        }
                                        int n8 = 0;
                                        while (n8 < cArray.length) {
                                            int n9 = n8 % 2;
                                            int n10 = n8;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n10];
                                            if (n9 == 0) {
                                                cArray2[n10] = (char)(c2 ^ n7);
                                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                                            } else {
                                                cArray2[n10] = (char)(c2 ^ n5);
                                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                                            }
                                            ++n8;
                                        }
                                        accept.3.b[n4] = new String(cArray).intern();
                                    }
                                    return b[n4];
                                }
                            };
                            if (nArray != null) break block32;
                            if (ActionTimestamp.D()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.D(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 38232621015604L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.D();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1177926090 - -((char)-7257), 1177795020 + (char)-9638, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1177926090 - -((char)-7261), 1177795020 + (char)-6332, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177926090 - -((char)-7284), -1177795020 + -((char)-3405), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1177926090 - -((char)-7257), 1177795020 + (char)-9638, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1177926090 - -((char)-7261), 1177795020 + (char)-6332, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177926090 - -((char)-7281), -1177926090 - -((char)-13939), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 25549192588983L;
                        int[] nArray2 = SshAgentIpcService.D();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1567859340 + -14381, -1567859340 - -2464, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1567859340 + -14384, 1567859340 - 6228, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 61821344840473L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    nArray = SshAgentIpcService.D();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-414443340 - -6204, 414443340 - 23105, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-414443340 - -6208, 414443340 - 12047, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-414443340 - -6199, 414443340 - 19960, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-414443340 - -6208, 414443340 - 12047, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-414443340 - -6206, 414443340 - 4456, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-414443340 - -6204, 414443340 - 23105, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-414443340 - -6208, 414443340 - 12047, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-414443340 - -6192, -414443340 - -16983, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-414443340 - -6204, 414443340 - 23105, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-414443340 - -6208, 414443340 - 12047, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-414443340 - -6193, -414443340 + -4837, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-414443340 - -6204, 414443340 - 23105, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-414443340 - -6208, 414443340 - 12047, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-414443340 - -6194, 414443340 + 5382, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 92767992124308L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.D();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(993510600 + 5045, -993510600 - -10830, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(993510600 + 5041, -993510600 - -5496, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(993510600 + 5026, 993510600 - 5307, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(993510600 + 5029, -993510600 - -10110, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(993510600 + 5045, -993510600 - -10830, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(993510600 + 5041, -993510600 - -5496, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(993510600 + 5028, 993510600 - 11437, (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(993510600 + 5045, -993510600 - -10830, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(993510600 + 5041, -993510600 - -5496, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(993510600 + 5031, -993510600 + -5219, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(993510600 + 5045, -993510600 - -10830, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(993510600 + 5041, -993510600 - -5496, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(993510600 + 5030, 993510600 + 6175, (int)l2));
                    if (nArray == null) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(993510600 + 5045, -993510600 - -10830, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(993510600 + 5041, -993510600 - -5496, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(993510600 + 5001, 993510600 + 328, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(993510600 + 5000, -993510600 - -4188, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00af\u0003SY-\u00a4\u0004K\u0014V\u00bdTi3*h\u0080,M\u0092\u00ed\u00be\u00bb\u00b7i\u00ab\u00e5 \u001b\u0006\u0088/\u00b7\u00dc\u00dbU\u0018e\u00f8R\u00f1q\u00fc\"\u009a\u00ads\u00adZ?\u00b2\u00d5\u00caN\u00f8\u00b2%d4\u00b7\u00da\t\u00f62\u00be\u0019\u0087~\u00e4\u0082I\u0005\u00a5\u008d\u0012\u0088u\b\u0088o\u00b7\u00a5\u00e3\u001d\u00db\u009e\u0014\f\u00ecg\u00d88\u0014<\u00d0\u00c8\u009a\u00a5\u00a3\u0012\u00d1\u0099\u00c9|\"#\u00a1\u0005\u0091w\u0094\u00d7\u00a5\u001ez\u0087\u00fc\u00ad5\u00b3\b\tM\u0015\u00fa\u0011\u0099\u00fb\u00a3\u0087a\u00c0\u0085\u00d6.e\u00f2=\u001eF{\u0014\u00db\u0098\u0010\u001b\u000e4Y{\u001f7e\u00d7*$\u000bD\u00ed\u00b7\u00da\t|\u00c19v$\u00b4\u00b6D\u00ed\u00107\u00d7\u00b1b\u00cbx!\u0089\u0015\u00b7|\u00b8O\u009b\u00d6\u0014?\u00ad\u00ab\u000e(f\n\u00e7R\u00c1\u00af.\u00bd\u00bc\u0098:\u00d2\u0097\u000f&\u00ea\u00d4\u00b0\u00d6\u00e1\u008a5\u00e4\u00ce\u001f\u0095\u00cc\u00fcR\u00e7\u008df\u0086\u008f\u00bb\u00bb\u00dfS\u00cb\u008a\u00b0j\u00b3\u00bd[\u00d6\u0089\\C\u009d\u00f2l~\u00b07r\u0001Ah\b\u00b4\u00e10t\u0013'\u00c5\u00d9\f\u001a\u00fb\u00f5,\u00b6N\u009f\u00f3\u00eb\u00b0\u00f1\\F\u00de\u00b3m%\u00a5o\u00fd\u00d7\u00a78r\u0089\u00a1\u0016\u0086%\u00fc\u0096Kvkq\"\u00eb\"_\u0002\u0088|t\u009a\u00fc\u00a4Q\u0091\u0091\u00df<;\t\\\u00100\u0019\u0011\u009d\u00d3>\u00b0^\u0092\u00e7\u00cf|uK\u0011 L\u00dc]\u00fd\u00bf\u00afz\u00f9\u00ce\u00d7\u00d4T\u001f\u001e\u001dp\u00fe\u00a4\u00d9:D\u000b\u00bc2$\u0080@\u008bA\u001f\u00f07\u001a\u00b3|\u0096\u00b5\u00f3\u0087\u00d1\u00e0\u0093\u00f7e\u000bQ<\u009c\u00d4\u009bQ:\u0010_\u00c0m\u0015\u00c3C\u00ce8\u00d6\u00a4\u007f\u00d3\u00c9Xws\u0096\u0006T\u00df\u001f\u00b7\u00ea\u008b>)\u00aa$\u00e6\u00d9v=`\u00d8@/[V\u00a9\u00040\u00cc7\u00c9\u00e9\u009a\u0098\u00145\u00a0\u00e8le\u00e5*\u00a3\u00d08\u0013l\u0001\u00bb\u00d3d1\u00ab\u00be\u0007\u00c4b!\u000b\u00aa:`\u0007\u0000\u00b1\u00dd\u001d\u00d2\u0017y(7\u00f7\u0019\u00829<\u007f\u00df\u00d3\u0018\u0003\u0086\u0081\u009fw<\u00d8z\u00ba\u00af\u0093\u008c;x\u00b9\u00cb\u00f9j\u008e2\u009f\u0013\u0001b\u00dd\u00d7\u00f2\u0094\u0086F\u000f]'\u001a\u00b1\u00b16\u00cb]0\u00c5\u00del\u009a\u0096\u008a\"F\u00aa{\b\u00c5\u0007\u0016\u009f\u008e\u00c7\u0082K\u0091\u00abS\u00f7\u00b0\u0087\u0093\u0011=e!\u00de\u00f9\u00f7\u008aH\u00f3$I\u00cf\u000ea\u000e\u0015\u00cd\u0013\u00ec\u0090\u009d\u00ef(\u00b4kN\u00b9\u0084&\u001b\u00f7}H\u00ff\u0000Jh\u008e\u001387\u00d2\u00fb}8;u\u00b4\u0096\u00eb\u00a6\u000e!\u0015\u00b2\u00e3\u00b6\n\u0006#\u00b23K7\u00d2\u000b\u00ef\u00ea\u0018\u00ba:\u00e1\u001a4J\u00cf\u00d0\u00f9:\u00a8\r\u00b1\u00d5\u008d\u000f\u00b43yb#t\u00ca\t)\u0095\u0005\u0001\u00fd\u008a\u00b9\u00ffH\u00b3=%\u0014bE\u00d6\u009f\u0095\u00d6b\u00bc\u00d3\u00c0\u00156\u0099,\u00d6\u0001\u000fc\u00cf\u00b1\u00d5\u0083\f\u00d2\u00acm\u00de\u008aC\t\u00ed\u0005\u000b\u00f0h\u00abi\u00fc\u00ab";
                var4_3 = "\u00af\u0003SY-\u00a4\u0004K\u0014V\u00bdTi3*h\u0080,M\u0092\u00ed\u00be\u00bb\u00b7i\u00ab\u00e5 \u001b\u0006\u0088/\u00b7\u00dc\u00dbU\u0018e\u00f8R\u00f1q\u00fc\"\u009a\u00ads\u00adZ?\u00b2\u00d5\u00caN\u00f8\u00b2%d4\u00b7\u00da\t\u00f62\u00be\u0019\u0087~\u00e4\u0082I\u0005\u00a5\u008d\u0012\u0088u\b\u0088o\u00b7\u00a5\u00e3\u001d\u00db\u009e\u0014\f\u00ecg\u00d88\u0014<\u00d0\u00c8\u009a\u00a5\u00a3\u0012\u00d1\u0099\u00c9|\"#\u00a1\u0005\u0091w\u0094\u00d7\u00a5\u001ez\u0087\u00fc\u00ad5\u00b3\b\tM\u0015\u00fa\u0011\u0099\u00fb\u00a3\u0087a\u00c0\u0085\u00d6.e\u00f2=\u001eF{\u0014\u00db\u0098\u0010\u001b\u000e4Y{\u001f7e\u00d7*$\u000bD\u00ed\u00b7\u00da\t|\u00c19v$\u00b4\u00b6D\u00ed\u00107\u00d7\u00b1b\u00cbx!\u0089\u0015\u00b7|\u00b8O\u009b\u00d6\u0014?\u00ad\u00ab\u000e(f\n\u00e7R\u00c1\u00af.\u00bd\u00bc\u0098:\u00d2\u0097\u000f&\u00ea\u00d4\u00b0\u00d6\u00e1\u008a5\u00e4\u00ce\u001f\u0095\u00cc\u00fcR\u00e7\u008df\u0086\u008f\u00bb\u00bb\u00dfS\u00cb\u008a\u00b0j\u00b3\u00bd[\u00d6\u0089\\C\u009d\u00f2l~\u00b07r\u0001Ah\b\u00b4\u00e10t\u0013'\u00c5\u00d9\f\u001a\u00fb\u00f5,\u00b6N\u009f\u00f3\u00eb\u00b0\u00f1\\F\u00de\u00b3m%\u00a5o\u00fd\u00d7\u00a78r\u0089\u00a1\u0016\u0086%\u00fc\u0096Kvkq\"\u00eb\"_\u0002\u0088|t\u009a\u00fc\u00a4Q\u0091\u0091\u00df<;\t\\\u00100\u0019\u0011\u009d\u00d3>\u00b0^\u0092\u00e7\u00cf|uK\u0011 L\u00dc]\u00fd\u00bf\u00afz\u00f9\u00ce\u00d7\u00d4T\u001f\u001e\u001dp\u00fe\u00a4\u00d9:D\u000b\u00bc2$\u0080@\u008bA\u001f\u00f07\u001a\u00b3|\u0096\u00b5\u00f3\u0087\u00d1\u00e0\u0093\u00f7e\u000bQ<\u009c\u00d4\u009bQ:\u0010_\u00c0m\u0015\u00c3C\u00ce8\u00d6\u00a4\u007f\u00d3\u00c9Xws\u0096\u0006T\u00df\u001f\u00b7\u00ea\u008b>)\u00aa$\u00e6\u00d9v=`\u00d8@/[V\u00a9\u00040\u00cc7\u00c9\u00e9\u009a\u0098\u00145\u00a0\u00e8le\u00e5*\u00a3\u00d08\u0013l\u0001\u00bb\u00d3d1\u00ab\u00be\u0007\u00c4b!\u000b\u00aa:`\u0007\u0000\u00b1\u00dd\u001d\u00d2\u0017y(7\u00f7\u0019\u00829<\u007f\u00df\u00d3\u0018\u0003\u0086\u0081\u009fw<\u00d8z\u00ba\u00af\u0093\u008c;x\u00b9\u00cb\u00f9j\u008e2\u009f\u0013\u0001b\u00dd\u00d7\u00f2\u0094\u0086F\u000f]'\u001a\u00b1\u00b16\u00cb]0\u00c5\u00del\u009a\u0096\u008a\"F\u00aa{\b\u00c5\u0007\u0016\u009f\u008e\u00c7\u0082K\u0091\u00abS\u00f7\u00b0\u0087\u0093\u0011=e!\u00de\u00f9\u00f7\u008aH\u00f3$I\u00cf\u000ea\u000e\u0015\u00cd\u0013\u00ec\u0090\u009d\u00ef(\u00b4kN\u00b9\u0084&\u001b\u00f7}H\u00ff\u0000Jh\u008e\u001387\u00d2\u00fb}8;u\u00b4\u0096\u00eb\u00a6\u000e!\u0015\u00b2\u00e3\u00b6\n\u0006#\u00b23K7\u00d2\u000b\u00ef\u00ea\u0018\u00ba:\u00e1\u001a4J\u00cf\u00d0\u00f9:\u00a8\r\u00b1\u00d5\u008d\u000f\u00b43yb#t\u00ca\t)\u0095\u0005\u0001\u00fd\u008a\u00b9\u00ffH\u00b3=%\u0014bE\u00d6\u009f\u0095\u00d6b\u00bc\u00d3\u00c0\u00156\u0099,\u00d6\u0001\u000fc\u00cf\u00b1\u00d5\u0083\f\u00d2\u00acm\u00de\u008aC\t\u00ed\u0005\u000b\u00f0h\u00abi\u00fc\u00ab".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 22;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00b8o\u00f2\u00e6\u00a2\u008c\u00ac\u00b8\u008fu\u00f4K\u000e\u00f8\r~\u00b8\u00b0\u00c1\u00a2\u00a4j^\u00eb\r\u00dd\u0083,c\u0014v\u0087\u0006x/^\u00bdX\u00c0\u0000Y\u0012\u0091\u0012\u0004\n\u008b\u00dfr\n";
                    var4_3 = "\u00b8o\u00f2\u00e6\u00a2\u008c\u00ac\u00b8\u008fu\u00f4K\u000e\u00f8\r~\u00b8\u00b0\u00c1\u00a2\u00a4j^\u00eb\r\u00dd\u0083,c\u0014v\u0087\u0006x/^\u00bdX\u00c0\u0000Y\u0012\u0091\u0012\u0004\n\u008b\u00dfr\n".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 111;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 72;
                            break;
                        }
                        case 1: {
                            v15 = 86;
                            break;
                        }
                        case 2: {
                            v15 = 117;
                            break;
                        }
                        case 3: {
                            v15 = 6;
                            break;
                        }
                        case 4: {
                            v15 = 19;
                            break;
                        }
                        case 5: {
                            v15 = 51;
                            break;
                        }
                        default: {
                            v15 = 57;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0x4BE5) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 54;
                case 1 -> 200;
                case 2 -> 211;
                case 3 -> 217;
                case 4 -> 69;
                case 5 -> 99;
                case 6 -> 172;
                case 7 -> 64;
                case 8 -> 78;
                case 9 -> 75;
                case 10 -> 77;
                case 11 -> 171;
                case 12 -> 179;
                case 13 -> 170;
                case 14 -> 137;
                case 15 -> 29;
                case 16 -> 38;
                case 17 -> 63;
                case 18 -> 238;
                case 19 -> 230;
                case 20 -> 193;
                case 21 -> 92;
                case 22 -> 224;
                case 23 -> 178;
                case 24 -> 180;
                case 25 -> 5;
                case 26 -> 65;
                case 27 -> 247;
                case 28 -> 236;
                case 29 -> 16;
                case 30 -> 208;
                case 31 -> 1;
                case 32 -> 242;
                case 33 -> 46;
                case 34 -> 157;
                case 35 -> 251;
                case 36 -> 150;
                case 37 -> 220;
                case 38 -> 104;
                case 39 -> 112;
                case 40 -> 86;
                case 41 -> 74;
                case 42 -> 121;
                case 43 -> 129;
                case 44 -> 155;
                case 45 -> 243;
                case 46 -> 120;
                case 47 -> 116;
                case 48 -> 168;
                case 49 -> 206;
                case 50 -> 62;
                case 51 -> 66;
                case 52 -> 115;
                case 53 -> 204;
                case 54 -> 149;
                case 55 -> 55;
                case 56 -> 222;
                case 57 -> 49;
                case 58 -> 83;
                case 59 -> 152;
                case 60 -> 221;
                case 61 -> 109;
                case 62 -> 72;
                case 63 -> 237;
                case 64 -> 44;
                case 65 -> 158;
                case 66 -> 82;
                case 67 -> 176;
                case 68 -> 175;
                case 69 -> 87;
                case 70 -> 183;
                case 71 -> 52;
                case 72 -> 114;
                case 73 -> 9;
                case 74 -> 136;
                case 75 -> 218;
                case 76 -> 34;
                case 77 -> 88;
                case 78 -> 192;
                case 79 -> 27;
                case 80 -> 187;
                case 81 -> 232;
                case 82 -> 110;
                case 83 -> 216;
                case 84 -> 48;
                case 85 -> 58;
                case 86 -> 2;
                case 87 -> 209;
                case 88 -> 174;
                case 89 -> 229;
                case 90 -> 18;
                case 91 -> 67;
                case 92 -> 163;
                case 93 -> 124;
                case 94 -> 98;
                case 95 -> 248;
                case 96 -> 126;
                case 97 -> 91;
                case 98 -> 194;
                case 99 -> 8;
                case 100 -> 253;
                case 101 -> 56;
                case 102 -> 143;
                case 103 -> 225;
                case 104 -> 79;
                case 105 -> 4;
                case 106 -> 190;
                case 107 -> 105;
                case 108 -> 240;
                case 109 -> 140;
                case 110 -> 100;
                case 111 -> 255;
                case 112 -> 195;
                case 113 -> 146;
                case 114 -> 145;
                case 115 -> 40;
                case 116 -> 17;
                case 117 -> 246;
                case 118 -> 50;
                case 119 -> 93;
                case 120 -> 162;
                case 121 -> 3;
                case 122 -> 128;
                case 123 -> 227;
                case 124 -> 198;
                case 125 -> 30;
                case 126 -> 135;
                case 127 -> 0;
                case 128 -> 95;
                case 129 -> 202;
                case 130 -> 241;
                case 131 -> 173;
                case 132 -> 244;
                case 133 -> 167;
                case 134 -> 42;
                case 135 -> 122;
                case 136 -> 132;
                case 137 -> 125;
                case 138 -> 148;
                case 139 -> 60;
                case 140 -> 249;
                case 141 -> 134;
                case 142 -> 127;
                case 143 -> 212;
                case 144 -> 159;
                case 145 -> 106;
                case 146 -> 89;
                case 147 -> 24;
                case 148 -> 188;
                case 149 -> 21;
                case 150 -> 33;
                case 151 -> 102;
                case 152 -> 226;
                case 153 -> 231;
                case 154 -> 185;
                case 155 -> 252;
                case 156 -> 153;
                case 157 -> 14;
                case 158 -> 228;
                case 159 -> 223;
                case 160 -> 35;
                case 161 -> 47;
                case 162 -> 118;
                case 163 -> 138;
                case 164 -> 164;
                case 165 -> 201;
                case 166 -> 7;
                case 167 -> 133;
                case 168 -> 151;
                case 169 -> 6;
                case 170 -> 20;
                case 171 -> 22;
                case 172 -> 214;
                case 173 -> 207;
                case 174 -> 235;
                case 175 -> 169;
                case 176 -> 254;
                case 177 -> 94;
                case 178 -> 141;
                case 179 -> 234;
                case 180 -> 113;
                case 181 -> 59;
                case 182 -> 119;
                case 183 -> 161;
                case 184 -> 210;
                case 185 -> 181;
                case 186 -> 25;
                case 187 -> 107;
                case 188 -> 84;
                case 189 -> 144;
                case 190 -> 73;
                case 191 -> 123;
                case 192 -> 23;
                case 193 -> 61;
                case 194 -> 19;
                case 195 -> 139;
                case 196 -> 197;
                case 197 -> 97;
                case 198 -> 213;
                case 199 -> 31;
                case 200 -> 68;
                case 201 -> 26;
                case 202 -> 43;
                case 203 -> 80;
                case 204 -> 71;
                case 205 -> 117;
                case 206 -> 186;
                case 207 -> 101;
                case 208 -> 39;
                case 209 -> 165;
                case 210 -> 85;
                case 211 -> 13;
                case 212 -> 191;
                case 213 -> 53;
                case 214 -> 233;
                case 215 -> 130;
                case 216 -> 11;
                case 217 -> 28;
                case 218 -> 96;
                case 219 -> 103;
                case 220 -> 90;
                case 221 -> 142;
                case 222 -> 160;
                case 223 -> 10;
                case 224 -> 57;
                case 225 -> 51;
                case 226 -> 111;
                case 227 -> 239;
                case 228 -> 177;
                case 229 -> 196;
                case 230 -> 156;
                case 231 -> 189;
                case 232 -> 37;
                case 233 -> 250;
                case 234 -> 45;
                case 235 -> 36;
                case 236 -> 147;
                case 237 -> 203;
                case 238 -> 81;
                case 239 -> 76;
                case 240 -> 70;
                case 241 -> 182;
                case 242 -> 199;
                case 243 -> 245;
                case 244 -> 41;
                case 245 -> 219;
                case 246 -> 154;
                case 247 -> 131;
                case 248 -> 12;
                case 249 -> 205;
                case 250 -> 15;
                case 251 -> 215;
                case 252 -> 184;
                case 253 -> 166;
                case 254 -> 108;
                default -> 32;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 8376911763283L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1725536550 + -10402, -1725536550 + -18848, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 40939747955588L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.D();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-119666910 + -3124, -119666910 + -26741, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-119666910 + -3125, -119666910 + -((char)-32669), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-119666910 + -3126, -119666910 + -20524, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0094\u00c5\u0093\u00f8{\u009f\u00f3\u00ca\u0010n\u00e1=\u00dd\u0014\u0080\u00e7p\u007f/H\u00e5\u00c6\r\u0001t";
                    var4_3 = "\u0094\u00c5\u0093\u00f8{\u009f\u00f3\u00ca\u0010n\u00e1=\u00dd\u0014\u0080\u00e7p\u007f/H\u00e5\u00c6\r\u0001t".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 80;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00cd\u0007\u0082\u009a\u00135\u0007\u00e7\u00cc\u00ea\beF]\u0006\u000b\u00cf\u009b\u00fb\u0012\u0099'`;;\u00c8l\u00ad\u00e5\u008b\u00ce\u00a3F1\u0007\u00d2\u0083\u00103\u00f3\u00a2y.\u00db\u00a9.\u0018\u00c9x\u00b9\u000e\u00a4\u00e2\u00c3\u00c23!XP";
                        var4_3 = "\u00cd\u0007\u0082\u009a\u00135\u0007\u00e7\u00cc\u00ea\beF]\u0006\u000b\u00cf\u009b\u00fb\u0012\u0099'`;;\u00c8l\u00ad\u00e5\u008b\u00ce\u00a3F1\u0007\u00d2\u0083\u00103\u00f3\u00a2y.\u00db\u00a9.\u0018\u00c9x\u00b9\u000e\u00a4\u00e2\u00c3\u00c23!XP".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 73;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 96;
                                break;
                            }
                            case 1: {
                                v15 = 9;
                                break;
                            }
                            case 2: {
                                v15 = 89;
                                break;
                            }
                            case 3: {
                                v15 = 26;
                                break;
                            }
                            case 4: {
                                v15 = 86;
                                break;
                            }
                            case 5: {
                                v15 = 49;
                                break;
                            }
                            default: {
                                v15 = 34;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFA96B) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 239;
                    case 1 -> 39;
                    case 2 -> 197;
                    case 3 -> 236;
                    case 4 -> 226;
                    case 5 -> 187;
                    case 6 -> 6;
                    case 7 -> 4;
                    case 8 -> 103;
                    case 9 -> 210;
                    case 10 -> 215;
                    case 11 -> 151;
                    case 12 -> 195;
                    case 13 -> 44;
                    case 14 -> 24;
                    case 15 -> 164;
                    case 16 -> 20;
                    case 17 -> 18;
                    case 18 -> 93;
                    case 19 -> 212;
                    case 20 -> 48;
                    case 21 -> 244;
                    case 22 -> 235;
                    case 23 -> 63;
                    case 24 -> 253;
                    case 25 -> 162;
                    case 26 -> 21;
                    case 27 -> 60;
                    case 28 -> 58;
                    case 29 -> 201;
                    case 30 -> 117;
                    case 31 -> 36;
                    case 32 -> 10;
                    case 33 -> 143;
                    case 34 -> 79;
                    case 35 -> 250;
                    case 36 -> 91;
                    case 37 -> 113;
                    case 38 -> 216;
                    case 39 -> 7;
                    case 40 -> 232;
                    case 41 -> 165;
                    case 42 -> 234;
                    case 43 -> 242;
                    case 44 -> 108;
                    case 45 -> 35;
                    case 46 -> 94;
                    case 47 -> 88;
                    case 48 -> 193;
                    case 49 -> 217;
                    case 50 -> 188;
                    case 51 -> 85;
                    case 52 -> 13;
                    case 53 -> 147;
                    case 54 -> 122;
                    case 55 -> 9;
                    case 56 -> 27;
                    case 57 -> 69;
                    case 58 -> 177;
                    case 59 -> 125;
                    case 60 -> 78;
                    case 61 -> 138;
                    case 62 -> 219;
                    case 63 -> 182;
                    case 64 -> 87;
                    case 65 -> 205;
                    case 66 -> 196;
                    case 67 -> 50;
                    case 68 -> 175;
                    case 69 -> 33;
                    case 70 -> 17;
                    case 71 -> 252;
                    case 72 -> 146;
                    case 73 -> 3;
                    case 74 -> 118;
                    case 75 -> 74;
                    case 76 -> 56;
                    case 77 -> 49;
                    case 78 -> 173;
                    case 79 -> 254;
                    case 80 -> 107;
                    case 81 -> 68;
                    case 82 -> 96;
                    case 83 -> 102;
                    case 84 -> 41;
                    case 85 -> 77;
                    case 86 -> 128;
                    case 87 -> 208;
                    case 88 -> 14;
                    case 89 -> 54;
                    case 90 -> 40;
                    case 91 -> 71;
                    case 92 -> 0;
                    case 93 -> 229;
                    case 94 -> 240;
                    case 95 -> 29;
                    case 96 -> 115;
                    case 97 -> 90;
                    case 98 -> 145;
                    case 99 -> 66;
                    case 100 -> 38;
                    case 101 -> 67;
                    case 102 -> 95;
                    case 103 -> 166;
                    case 104 -> 190;
                    case 105 -> 220;
                    case 106 -> 129;
                    case 107 -> 62;
                    case 108 -> 214;
                    case 109 -> 89;
                    case 110 -> 46;
                    case 111 -> 137;
                    case 112 -> 202;
                    case 113 -> 22;
                    case 114 -> 92;
                    case 115 -> 159;
                    case 116 -> 37;
                    case 117 -> 218;
                    case 118 -> 224;
                    case 119 -> 153;
                    case 120 -> 150;
                    case 121 -> 104;
                    case 122 -> 199;
                    case 123 -> 25;
                    case 124 -> 112;
                    case 125 -> 59;
                    case 126 -> 139;
                    case 127 -> 123;
                    case 128 -> 16;
                    case 129 -> 248;
                    case 130 -> 19;
                    case 131 -> 142;
                    case 132 -> 207;
                    case 133 -> 176;
                    case 134 -> 98;
                    case 135 -> 163;
                    case 136 -> 158;
                    case 137 -> 251;
                    case 138 -> 223;
                    case 139 -> 185;
                    case 140 -> 144;
                    case 141 -> 75;
                    case 142 -> 140;
                    case 143 -> 181;
                    case 144 -> 194;
                    case 145 -> 30;
                    case 146 -> 47;
                    case 147 -> 121;
                    case 148 -> 111;
                    case 149 -> 179;
                    case 150 -> 222;
                    case 151 -> 55;
                    case 152 -> 186;
                    case 153 -> 246;
                    case 154 -> 180;
                    case 155 -> 249;
                    case 156 -> 133;
                    case 157 -> 51;
                    case 158 -> 211;
                    case 159 -> 64;
                    case 160 -> 12;
                    case 161 -> 135;
                    case 162 -> 189;
                    case 163 -> 245;
                    case 164 -> 149;
                    case 165 -> 221;
                    case 166 -> 233;
                    case 167 -> 73;
                    case 168 -> 120;
                    case 169 -> 169;
                    case 170 -> 243;
                    case 171 -> 200;
                    case 172 -> 106;
                    case 173 -> 8;
                    case 174 -> 5;
                    case 175 -> 127;
                    case 176 -> 132;
                    case 177 -> 34;
                    case 178 -> 192;
                    case 179 -> 247;
                    case 180 -> 170;
                    case 181 -> 209;
                    case 182 -> 241;
                    case 183 -> 105;
                    case 184 -> 70;
                    case 185 -> 204;
                    case 186 -> 61;
                    case 187 -> 213;
                    case 188 -> 225;
                    case 189 -> 230;
                    case 190 -> 152;
                    case 191 -> 160;
                    case 192 -> 178;
                    case 193 -> 42;
                    case 194 -> 134;
                    case 195 -> 31;
                    case 196 -> 53;
                    case 197 -> 184;
                    case 198 -> 141;
                    case 199 -> 183;
                    case 200 -> 154;
                    case 201 -> 191;
                    case 202 -> 116;
                    case 203 -> 99;
                    case 204 -> 124;
                    case 205 -> 130;
                    case 206 -> 198;
                    case 207 -> 114;
                    case 208 -> 171;
                    case 209 -> 131;
                    case 210 -> 81;
                    case 211 -> 157;
                    case 212 -> 110;
                    case 213 -> 156;
                    case 214 -> 52;
                    case 215 -> 2;
                    case 216 -> 174;
                    case 217 -> 82;
                    case 218 -> 119;
                    case 219 -> 45;
                    case 220 -> 238;
                    case 221 -> 206;
                    case 222 -> 15;
                    case 223 -> 101;
                    case 224 -> 155;
                    case 225 -> 76;
                    case 226 -> 84;
                    case 227 -> 237;
                    case 228 -> 167;
                    case 229 -> 172;
                    case 230 -> 227;
                    case 231 -> 1;
                    case 232 -> 126;
                    case 233 -> 32;
                    case 234 -> 57;
                    case 235 -> 28;
                    case 236 -> 203;
                    case 237 -> 255;
                    case 238 -> 100;
                    case 239 -> 136;
                    case 240 -> 228;
                    case 241 -> 97;
                    case 242 -> 72;
                    case 243 -> 161;
                    case 244 -> 26;
                    case 245 -> 83;
                    case 246 -> 86;
                    case 247 -> 148;
                    case 248 -> 43;
                    case 249 -> 23;
                    case 250 -> 11;
                    case 251 -> 231;
                    case 252 -> 109;
                    case 253 -> 65;
                    case 254 -> 80;
                    default -> 168;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 24915365931917L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "dK:Hug\u0015=\tcA)B8%\b!\u0007";
                    var5_4 = "dK:Hug\u0015=\tcA)B8%\b!\u0007".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 92;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 83;
                                    break;
                                }
                                case 1: {
                                    v11 = 114;
                                    break;
                                }
                                case 2: {
                                    v11 = 20;
                                    break;
                                }
                                case 3: {
                                    v11 = 122;
                                    break;
                                }
                                case 4: {
                                    v11 = 76;
                                    break;
                                }
                                case 5: {
                                    v11 = 87;
                                    break;
                                }
                                default: {
                                    v11 = 122;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 37759031302078L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "cA%)q*(\u0004e_)3\ni@\"3}(0CA+\ti@\"3}(0OK\rnF?>w%*OL84v,";
                    var5_4 = "cA%)q*(\u0004e_)3\ni@\"3}(0CA+\ti@\"3}(0OK\rnF?>w%*OL84v,".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 30;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0003)ID\u001bOI\u0006\u0003)ID\u0017E";
                        var5_4 = "\u0003)ID\u001bOI\u0006\u0003)ID\u0017E".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 116;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 52;
                                break;
                            }
                            case 1: {
                                v15 = 49;
                                break;
                            }
                            case 2: {
                                v15 = 82;
                                break;
                            }
                            case 3: {
                                v15 = 67;
                                break;
                            }
                            case 4: {
                                v15 = 6;
                                break;
                            }
                            case 5: {
                                v15 = 85;
                                break;
                            }
                            default: {
                                v15 = 90;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 21721865892988L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-2078639130 + -((char)-6811), 2078639130 + (char)-7994, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 31175120616252L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0018h\u00b5\u000e\u00f5\u0003o\u00df\u00ef\u0005V\u00d1Z\u00fd\u00eb\r\u00e5\u00c2\u001a\u00d5\u0016\u0010*\u00a4'\u00a0'\u0080\u00c9\u0010\u0087/\u0091\u0083XO\u00c8r\u00b2\u00fev\u0006\u0005\u00d7\u0082\u0007\u0005\u00b8&\u0087\u0003P3\u0001\u00d4\u00a1*\u008b>\u0082H\u0086D{xbIB\u00cb\u0080\u0000\u00b3\u0091FA\u00d45\u009e\b\u009b\u008e\u00c3\u0083\u008f\u00da\u00902\u00aa\u00eb\u00c7`\u0099\u00b0\u00bd\u00dc\u001c;X;\u00a5$?>|";
                    var4_3 = "\u0018h\u00b5\u000e\u00f5\u0003o\u00df\u00ef\u0005V\u00d1Z\u00fd\u00eb\r\u00e5\u00c2\u001a\u00d5\u0016\u0010*\u00a4'\u00a0'\u0080\u00c9\u0010\u0087/\u0091\u0083XO\u00c8r\u00b2\u00fev\u0006\u0005\u00d7\u0082\u0007\u0005\u00b8&\u0087\u0003P3\u0001\u00d4\u00a1*\u008b>\u0082H\u0086D{xbIB\u00cb\u0080\u0000\u00b3\u0091FA\u00d45\u009e\b\u009b\u008e\u00c3\u0083\u008f\u00da\u00902\u00aa\u00eb\u00c7`\u0099\u00b0\u00bd\u00dc\u001c;X;\u00a5$?>|".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 42;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00fe0\u00a6x\u00a6(\u000f\u0086Rxr\u00ce\u009d\u00d6\u0089?L\r\u00cf/M\u00bdF\u0002%z\u009f\u00db\u008b\u00a6\u00f0}\u0082z\u00e0\u000bc!c\n\u00cb~$\u00ba\u00d5\u0005\u00b9\u00a0\u00ea}\u00c2~\u00f1w\u00e5\u00ad~\u0015\u00e0\u00de\u00d9\r\u00a1\u00dcW\u00fa|4\u0096=\u0092\u00d1\u00fc\u001b\u00f4z%\u0013\u00c0\u0001xZ-\u00d6\u00a3m\u000eR\u008dp>G/";
                        var4_3 = "\u00fe0\u00a6x\u00a6(\u000f\u0086Rxr\u00ce\u009d\u00d6\u0089?L\r\u00cf/M\u00bdF\u0002%z\u009f\u00db\u008b\u00a6\u00f0}\u0082z\u00e0\u000bc!c\n\u00cb~$\u00ba\u00d5\u0005\u00b9\u00a0\u00ea}\u00c2~\u00f1w\u00e5\u00ad~\u0015\u00e0\u00de\u00d9\r\u00a1\u00dcW\u00fa|4\u0096=\u0092\u00d1\u00fc\u001b\u00f4z%\u0013\u00c0\u0001xZ-\u00d6\u00a3m\u000eR\u008dp>G/".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 120;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 109;
                                break;
                            }
                            case 1: {
                                v15 = 87;
                                break;
                            }
                            case 2: {
                                v15 = 92;
                                break;
                            }
                            case 3: {
                                v15 = 99;
                                break;
                            }
                            case 4: {
                                v15 = 26;
                                break;
                            }
                            case 5: {
                                v15 = 47;
                                break;
                            }
                            default: {
                                v15 = 56;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x22FD) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 129;
                    case 1 -> 74;
                    case 2 -> 242;
                    case 3 -> 243;
                    case 4 -> 62;
                    case 5 -> 181;
                    case 6 -> 48;
                    case 7 -> 76;
                    case 8 -> 153;
                    case 9 -> 159;
                    case 10 -> 212;
                    case 11 -> 10;
                    case 12 -> 247;
                    case 13 -> 88;
                    case 14 -> 16;
                    case 15 -> 219;
                    case 16 -> 182;
                    case 17 -> 238;
                    case 18 -> 152;
                    case 19 -> 14;
                    case 20 -> 91;
                    case 21 -> 52;
                    case 22 -> 188;
                    case 23 -> 234;
                    case 24 -> 120;
                    case 25 -> 30;
                    case 26 -> 86;
                    case 27 -> 140;
                    case 28 -> 136;
                    case 29 -> 220;
                    case 30 -> 13;
                    case 31 -> 203;
                    case 32 -> 12;
                    case 33 -> 5;
                    case 34 -> 29;
                    case 35 -> 217;
                    case 36 -> 184;
                    case 37 -> 154;
                    case 38 -> 250;
                    case 39 -> 138;
                    case 40 -> 18;
                    case 41 -> 53;
                    case 42 -> 116;
                    case 43 -> 72;
                    case 44 -> 164;
                    case 45 -> 228;
                    case 46 -> 137;
                    case 47 -> 17;
                    case 48 -> 245;
                    case 49 -> 143;
                    case 50 -> 156;
                    case 51 -> 61;
                    case 52 -> 85;
                    case 53 -> 33;
                    case 54 -> 24;
                    case 55 -> 252;
                    case 56 -> 20;
                    case 57 -> 205;
                    case 58 -> 167;
                    case 59 -> 174;
                    case 60 -> 186;
                    case 61 -> 4;
                    case 62 -> 210;
                    case 63 -> 112;
                    case 64 -> 124;
                    case 65 -> 236;
                    case 66 -> 21;
                    case 67 -> 209;
                    case 68 -> 43;
                    case 69 -> 34;
                    case 70 -> 235;
                    case 71 -> 36;
                    case 72 -> 27;
                    case 73 -> 128;
                    case 74 -> 132;
                    case 75 -> 104;
                    case 76 -> 115;
                    case 77 -> 108;
                    case 78 -> 37;
                    case 79 -> 50;
                    case 80 -> 246;
                    case 81 -> 60;
                    case 82 -> 169;
                    case 83 -> 8;
                    case 84 -> 101;
                    case 85 -> 92;
                    case 86 -> 38;
                    case 87 -> 55;
                    case 88 -> 22;
                    case 89 -> 202;
                    case 90 -> 161;
                    case 91 -> 227;
                    case 92 -> 173;
                    case 93 -> 87;
                    case 94 -> 237;
                    case 95 -> 94;
                    case 96 -> 197;
                    case 97 -> 113;
                    case 98 -> 150;
                    case 99 -> 148;
                    case 100 -> 26;
                    case 101 -> 157;
                    case 102 -> 180;
                    case 103 -> 224;
                    case 104 -> 171;
                    case 105 -> 240;
                    case 106 -> 2;
                    case 107 -> 114;
                    case 108 -> 35;
                    case 109 -> 196;
                    case 110 -> 59;
                    case 111 -> 66;
                    case 112 -> 253;
                    case 113 -> 251;
                    case 114 -> 105;
                    case 115 -> 172;
                    case 116 -> 102;
                    case 117 -> 130;
                    case 118 -> 58;
                    case 119 -> 187;
                    case 120 -> 79;
                    case 121 -> 123;
                    case 122 -> 193;
                    case 123 -> 142;
                    case 124 -> 122;
                    case 125 -> 170;
                    case 126 -> 211;
                    case 127 -> 39;
                    case 128 -> 198;
                    case 129 -> 111;
                    case 130 -> 134;
                    case 131 -> 54;
                    case 132 -> 56;
                    case 133 -> 89;
                    case 134 -> 82;
                    case 135 -> 175;
                    case 136 -> 249;
                    case 137 -> 1;
                    case 138 -> 208;
                    case 139 -> 81;
                    case 140 -> 93;
                    case 141 -> 179;
                    case 142 -> 145;
                    case 143 -> 155;
                    case 144 -> 7;
                    case 145 -> 163;
                    case 146 -> 185;
                    case 147 -> 64;
                    case 148 -> 177;
                    case 149 -> 109;
                    case 150 -> 189;
                    case 151 -> 218;
                    case 152 -> 3;
                    case 153 -> 190;
                    case 154 -> 178;
                    case 155 -> 165;
                    case 156 -> 133;
                    case 157 -> 141;
                    case 158 -> 162;
                    case 159 -> 11;
                    case 160 -> 232;
                    case 161 -> 194;
                    case 162 -> 226;
                    case 163 -> 47;
                    case 164 -> 160;
                    case 165 -> 151;
                    case 166 -> 23;
                    case 167 -> 46;
                    case 168 -> 176;
                    case 169 -> 65;
                    case 170 -> 204;
                    case 171 -> 223;
                    case 172 -> 135;
                    case 173 -> 32;
                    case 174 -> 244;
                    case 175 -> 127;
                    case 176 -> 69;
                    case 177 -> 199;
                    case 178 -> 80;
                    case 179 -> 68;
                    case 180 -> 207;
                    case 181 -> 97;
                    case 182 -> 166;
                    case 183 -> 15;
                    case 184 -> 31;
                    case 185 -> 107;
                    case 186 -> 117;
                    case 187 -> 73;
                    case 188 -> 106;
                    case 189 -> 51;
                    case 190 -> 125;
                    case 191 -> 254;
                    case 192 -> 248;
                    case 193 -> 131;
                    case 194 -> 239;
                    case 195 -> 121;
                    case 196 -> 63;
                    case 197 -> 222;
                    case 198 -> 99;
                    case 199 -> 42;
                    case 200 -> 77;
                    case 201 -> 183;
                    case 202 -> 49;
                    case 203 -> 241;
                    case 204 -> 215;
                    case 205 -> 119;
                    case 206 -> 192;
                    case 207 -> 100;
                    case 208 -> 191;
                    case 209 -> 6;
                    case 210 -> 195;
                    case 211 -> 206;
                    case 212 -> 158;
                    case 213 -> 41;
                    case 214 -> 201;
                    case 215 -> 225;
                    case 216 -> 233;
                    case 217 -> 67;
                    case 218 -> 149;
                    case 219 -> 84;
                    case 220 -> 9;
                    case 221 -> 71;
                    case 222 -> 45;
                    case 223 -> 44;
                    case 224 -> 103;
                    case 225 -> 139;
                    case 226 -> 146;
                    case 227 -> 95;
                    case 228 -> 147;
                    case 229 -> 118;
                    case 230 -> 57;
                    case 231 -> 230;
                    case 232 -> 40;
                    case 233 -> 216;
                    case 234 -> 90;
                    case 235 -> 110;
                    case 236 -> 221;
                    case 237 -> 28;
                    case 238 -> 70;
                    case 239 -> 255;
                    case 240 -> 229;
                    case 241 -> 200;
                    case 242 -> 98;
                    case 243 -> 231;
                    case 244 -> 144;
                    case 245 -> 96;
                    case 246 -> 78;
                    case 247 -> 213;
                    case 248 -> 75;
                    case 249 -> 0;
                    case 250 -> 214;
                    case 251 -> 25;
                    case 252 -> 19;
                    case 253 -> 126;
                    case 254 -> 83;
                    default -> 168;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 95166827586465L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1057734900 + (char)-31603, 1057734900 + (char)-30170, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 97668696007048L;
                    int[] nArray = SshAgentIpcService.D();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1139653650 + -31813, 1139653650 + (char)-32021, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 15967079738479L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00ab\u0084\u00c6%\u00e1\u0003\u00c6\u0081=";
                var4_3 = "\u00ab\u0084\u00c6%\u00e1\u0003\u00c6\u0081=".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 43;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 87;
                                break;
                            }
                            case 1: {
                                v11 = 107;
                                break;
                            }
                            case 2: {
                                v11 = 63;
                                break;
                            }
                            case 3: {
                                v11 = 115;
                                break;
                            }
                            case 4: {
                                v11 = 45;
                                break;
                            }
                            case 5: {
                                v11 = 42;
                                break;
                            }
                            default: {
                                v11 = 20;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFFA620) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 0;
                    case 1 -> 30;
                    case 2 -> 63;
                    case 3 -> 205;
                    case 4 -> 208;
                    case 5 -> 23;
                    case 6 -> 49;
                    case 7 -> 83;
                    case 8 -> 234;
                    case 9 -> 25;
                    case 10 -> 71;
                    case 11 -> 233;
                    case 12 -> 78;
                    case 13 -> 241;
                    case 14 -> 202;
                    case 15 -> 153;
                    case 16 -> 92;
                    case 17 -> 245;
                    case 18 -> 72;
                    case 19 -> 86;
                    case 20 -> 15;
                    case 21 -> 65;
                    case 22 -> 249;
                    case 23 -> 6;
                    case 24 -> 76;
                    case 25 -> 200;
                    case 26 -> 191;
                    case 27 -> 62;
                    case 28 -> 134;
                    case 29 -> 216;
                    case 30 -> 254;
                    case 31 -> 1;
                    case 32 -> 106;
                    case 33 -> 48;
                    case 34 -> 170;
                    case 35 -> 85;
                    case 36 -> 227;
                    case 37 -> 53;
                    case 38 -> 163;
                    case 39 -> 60;
                    case 40 -> 115;
                    case 41 -> 209;
                    case 42 -> 126;
                    case 43 -> 122;
                    case 44 -> 159;
                    case 45 -> 128;
                    case 46 -> 152;
                    case 47 -> 138;
                    case 48 -> 80;
                    case 49 -> 91;
                    case 50 -> 214;
                    case 51 -> 26;
                    case 52 -> 135;
                    case 53 -> 146;
                    case 54 -> 145;
                    case 55 -> 107;
                    case 56 -> 199;
                    case 57 -> 226;
                    case 58 -> 120;
                    case 59 -> 253;
                    case 60 -> 79;
                    case 61 -> 220;
                    case 62 -> 246;
                    case 63 -> 242;
                    case 64 -> 124;
                    case 65 -> 139;
                    case 66 -> 192;
                    case 67 -> 37;
                    case 68 -> 244;
                    case 69 -> 131;
                    case 70 -> 190;
                    case 71 -> 10;
                    case 72 -> 229;
                    case 73 -> 195;
                    case 74 -> 35;
                    case 75 -> 67;
                    case 76 -> 151;
                    case 77 -> 173;
                    case 78 -> 176;
                    case 79 -> 17;
                    case 80 -> 22;
                    case 81 -> 210;
                    case 82 -> 255;
                    case 83 -> 250;
                    case 84 -> 54;
                    case 85 -> 36;
                    case 86 -> 236;
                    case 87 -> 140;
                    case 88 -> 150;
                    case 89 -> 105;
                    case 90 -> 9;
                    case 91 -> 47;
                    case 92 -> 160;
                    case 93 -> 143;
                    case 94 -> 41;
                    case 95 -> 21;
                    case 96 -> 221;
                    case 97 -> 102;
                    case 98 -> 100;
                    case 99 -> 8;
                    case 100 -> 118;
                    case 101 -> 69;
                    case 102 -> 58;
                    case 103 -> 7;
                    case 104 -> 157;
                    case 105 -> 111;
                    case 106 -> 171;
                    case 107 -> 212;
                    case 108 -> 34;
                    case 109 -> 4;
                    case 110 -> 2;
                    case 111 -> 177;
                    case 112 -> 198;
                    case 113 -> 218;
                    case 114 -> 45;
                    case 115 -> 211;
                    case 116 -> 219;
                    case 117 -> 132;
                    case 118 -> 224;
                    case 119 -> 166;
                    case 120 -> 147;
                    case 121 -> 204;
                    case 122 -> 113;
                    case 123 -> 104;
                    case 124 -> 189;
                    case 125 -> 180;
                    case 126 -> 87;
                    case 127 -> 196;
                    case 128 -> 38;
                    case 129 -> 230;
                    case 130 -> 231;
                    case 131 -> 108;
                    case 132 -> 98;
                    case 133 -> 101;
                    case 134 -> 52;
                    case 135 -> 123;
                    case 136 -> 32;
                    case 137 -> 59;
                    case 138 -> 207;
                    case 139 -> 75;
                    case 140 -> 88;
                    case 141 -> 77;
                    case 142 -> 66;
                    case 143 -> 31;
                    case 144 -> 137;
                    case 145 -> 94;
                    case 146 -> 252;
                    case 147 -> 169;
                    case 148 -> 57;
                    case 149 -> 130;
                    case 150 -> 56;
                    case 151 -> 127;
                    case 152 -> 148;
                    case 153 -> 70;
                    case 154 -> 243;
                    case 155 -> 201;
                    case 156 -> 187;
                    case 157 -> 181;
                    case 158 -> 46;
                    case 159 -> 89;
                    case 160 -> 232;
                    case 161 -> 116;
                    case 162 -> 19;
                    case 163 -> 155;
                    case 164 -> 149;
                    case 165 -> 39;
                    case 166 -> 61;
                    case 167 -> 11;
                    case 168 -> 223;
                    case 169 -> 93;
                    case 170 -> 112;
                    case 171 -> 158;
                    case 172 -> 161;
                    case 173 -> 125;
                    case 174 -> 114;
                    case 175 -> 136;
                    case 176 -> 183;
                    case 177 -> 81;
                    case 178 -> 175;
                    case 179 -> 215;
                    case 180 -> 174;
                    case 181 -> 20;
                    case 182 -> 97;
                    case 183 -> 43;
                    case 184 -> 162;
                    case 185 -> 103;
                    case 186 -> 172;
                    case 187 -> 156;
                    case 188 -> 90;
                    case 189 -> 96;
                    case 190 -> 206;
                    case 191 -> 50;
                    case 192 -> 186;
                    case 193 -> 238;
                    case 194 -> 154;
                    case 195 -> 18;
                    case 196 -> 194;
                    case 197 -> 164;
                    case 198 -> 3;
                    case 199 -> 99;
                    case 200 -> 33;
                    case 201 -> 188;
                    case 202 -> 185;
                    case 203 -> 68;
                    case 204 -> 64;
                    case 205 -> 213;
                    case 206 -> 237;
                    case 207 -> 184;
                    case 208 -> 225;
                    case 209 -> 129;
                    case 210 -> 16;
                    case 211 -> 51;
                    case 212 -> 203;
                    case 213 -> 13;
                    case 214 -> 42;
                    case 215 -> 5;
                    case 216 -> 142;
                    case 217 -> 117;
                    case 218 -> 84;
                    case 219 -> 28;
                    case 220 -> 119;
                    case 221 -> 248;
                    case 222 -> 239;
                    case 223 -> 95;
                    case 224 -> 251;
                    case 225 -> 178;
                    case 226 -> 193;
                    case 227 -> 14;
                    case 228 -> 110;
                    case 229 -> 167;
                    case 230 -> 182;
                    case 231 -> 29;
                    case 232 -> 228;
                    case 233 -> 168;
                    case 234 -> 12;
                    case 235 -> 133;
                    case 236 -> 222;
                    case 237 -> 55;
                    case 238 -> 82;
                    case 239 -> 74;
                    case 240 -> 73;
                    case 241 -> 197;
                    case 242 -> 217;
                    case 243 -> 235;
                    case 244 -> 44;
                    case 245 -> 179;
                    case 246 -> 165;
                    case 247 -> 24;
                    case 248 -> 240;
                    case 249 -> 144;
                    case 250 -> 247;
                    case 251 -> 141;
                    case 252 -> 121;
                    case 253 -> 109;
                    case 254 -> 27;
                    default -> 40;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

