/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.snapshot;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.jest.snapshot.JestSnapshotEventsListener;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectors;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSTestingSnapshotReferenceLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    JSTestingSnapshotReferenceLineMarkerProvider() {
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element2, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        RelatedItemLineMarkerInfo<PsiElement> info;
        JSReferenceExpression parentReferenceExpression;
        PsiElement parent;
        LeafPsiElement leaf;
        if (element2 == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element2.isValid() && element2 instanceof LeafPsiElement && (leaf = (LeafPsiElement)element2).getElementType() == JSTokenTypes.IDENTIFIER && JSTestingSnapshotReferenceLineMarkerProvider.textMatches(leaf) && (parent = leaf.getParent()) instanceof JSReferenceExpression && (parentReferenceExpression = (JSReferenceExpression)parent).getQualifier() != null && parentReferenceExpression.getReferenceNameElement() == element2 && (info = JSTestingSnapshotReferenceLineMarkerProvider.createNavigationMarkerIfNeeded(element2)) != null) {
            result2.add(info);
        }
    }

    private static boolean textMatches(@NotNull LeafPsiElement element2) {
        if (element2 == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(2);
        }
        CharSequence elementText = element2.getChars();
        return ContainerUtil.exists(JestSnapshotEventsListener.EXTERNAL_SNAPSHOT_METHOD_NAMES, name -> StringUtil.equals((CharSequence)name, (CharSequence)elementText));
    }

    @Nullable
    private static JsTestElementPath findTestElementPath(@NotNull JSFile testFile, @NotNull PsiElement element2) {
        if (testFile == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(4);
        }
        for (JsTestFrameworkDetector detector : JsTestFrameworkDetectors.Companion.getDetectors()) {
            AbstractTestFileStructure currentTestFileStructure;
            if (!detector.hasSupportSnapshotTestIntegrations() || (currentTestFileStructure = detector.findTestsStructure(testFile)) == null || currentTestFileStructure.isEmpty()) continue;
            return currentTestFileStructure.findTestElementPath(element2.getTextRange());
        }
        return null;
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiElement> createNavigationMarkerIfNeeded(@NotNull PsiElement element2) {
        PsiFile snapshotPsiFile;
        JSFile testFile;
        if (element2 == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if ((testFile = (JSFile)ObjectUtils.tryCast((Object)element2.getContainingFile(), JSFile.class)) == null || !testFile.isTestFile()) {
            return null;
        }
        @Nullable JsTestElementPath currentTestElementPath = JSTestingSnapshotReferenceLineMarkerProvider.findTestElementPath(testFile, element2);
        if (currentTestElementPath == null) {
            return null;
        }
        VirtualFile snapshotFile = JSTestingSnapshotReferenceLineMarkerProvider.findSnapshotFile(testFile.getVirtualFile());
        PsiFile psiFile = snapshotPsiFile = snapshotFile != null ? element2.getManager().findFile(snapshotFile) : null;
        if (snapshotPsiFile == null) {
            return null;
        }
        final GutterIconNavigationHandler<PsiElement> navigationHandler = JSTestingSnapshotReferenceLineMarkerProvider.createNavigationHandler(element2.getProject(), snapshotFile, currentTestElementPath);
        return new RelatedItemLineMarkerInfo(element2, element2.getTextRange(), JavaScriptLanguageIcons.Jest.SnapshotGutter, (Function)new ConstantFunction((Object)JavaScriptBundle.message((String)"jest.go.to.snapshot.text", (Object[])new Object[]{StringUtil.join(currentTestElementPath.getAllNames(), (String)" ")})), navigationHandler, GutterIconRenderer.Alignment.RIGHT, () -> Collections.singletonList(new GotoRelatedItem((PsiElement)snapshotPsiFile, JavaScriptBundle.message((String)"jest.snapshot.label", (Object[])new Object[0])){

            public void navigate() {
                navigationHandler.navigate(null, (PsiElement)snapshotPsiFile);
            }
        }));
    }

    @NotNull
    private static GutterIconNavigationHandler<PsiElement> createNavigationHandler(@NotNull Project project, @NotNull VirtualFile snapshotFile, @NotNull JsTestElementPath path2) {
        if (project == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (snapshotFile == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (path2 == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(8);
        }
        GutterIconNavigationHandler gutterIconNavigationHandler = (e, elt) -> {
            Document document = FileDocumentManager.getInstance().getDocument(snapshotFile);
            int offset = -1;
            if (document != null) {
                offset = document.getTextLength();
                String prefix = "exports[`";
                int ind = StringUtil.indexOf((CharSequence)document.getCharsSequence(), (CharSequence)(prefix + StringUtil.join(path2.getAllNames(), (String)" ")));
                if (ind != -1) {
                    offset = ind + prefix.length();
                }
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, snapshotFile, offset).navigate(true);
        };
        if (gutterIconNavigationHandler == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(9);
        }
        return gutterIconNavigationHandler;
    }

    @Nullable
    private static VirtualFile findSnapshotFile(@Nullable VirtualFile testFile) {
        if (testFile == null) {
            return null;
        }
        VirtualFile dir = testFile.getParent();
        if (dir == null) {
            return null;
        }
        VirtualFile snapshotDir = dir.findChild("__snapshots__");
        if (snapshotDir != null) {
            return snapshotDir.findChild(testFile.getName() + ".snap");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/snapshot/JSTestingSnapshotReferenceLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/snapshot/JSTestingSnapshotReferenceLineMarkerProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTestElementPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationMarkerIfNeeded";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationHandler";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

