/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSCustomIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableDialog;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceVariableHandler
extends JSBaseIntroduceHandler<JSSourceElement, BaseIntroduceSettings, JSIntroduceVariableDialog> {
    private static final String LAST_INTRODUCE = "js.last.introduce.type";

    @Override
    @Nullable
    @NonNls
    public String getRefactoringId() {
        return "refactoring.javascript.introduceVariable";
    }

    public JSIntroduceVariableHandler(@NotNull JSIntroduceTargetChooser<JSExpression> introducedExpressionChooser) {
        if (introducedExpressionChooser == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        super(introducedExpressionChooser);
    }

    public JSIntroduceVariableHandler() {
    }

    public static boolean varTypeEnabled(@Nullable DialectOptionHolder holder, @NotNull Settings.IntroducedVarType type2) {
        if (type2 == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        if (type2 == Settings.IntroducedVarType.LET) {
            return holder != null && holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS);
        }
        if (type2 == Settings.IntroducedVarType.CONST) {
            return holder != null && holder.hasFeature(JSLanguageFeature.CONST_DEFINITIONS);
        }
        return true;
    }

    public static Settings.IntroducedVarType getLastIntroduceType(Project project, @Nullable DialectOptionHolder holder) {
        Settings.IntroducedVarType defaultValue = JSIntroduceVariableHandler.varTypeEnabled(holder, Settings.IntroducedVarType.LET) ? Settings.IntroducedVarType.LET : Settings.IntroducedVarType.VAR;
        String value = PropertiesComponent.getInstance((Project)project).getValue(LAST_INTRODUCE, defaultValue.name());
        Settings.IntroducedVarType storedValue = Settings.IntroducedVarType.valueOf(value);
        return JSIntroduceVariableHandler.varTypeEnabled(holder, storedValue) ? storedValue : defaultValue;
    }

    public static void setLastIntroduceType(Project project, Settings.IntroducedVarType value) {
        PropertiesComponent.getInstance((Project)project).setValue(LAST_INTRODUCE, value.name());
    }

    @Override
    protected String getProductivityFeatureId() {
        return "refactoring.introduceVariable";
    }

    @Override
    @NotNull
    protected String getRefactoringName() {
        String string = JavaScriptBundle.message((String)"javascript.introduce.variable.title", (Object[])new Object[0]);
        if (string == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.variable.error.expression.has.void.type";
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.variable.error.no.expression.selected";
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> baseIntroduceContext, JSSourceElement anchor) {
        return this.calcDeclText(baseIntroduceContext, StringUtil.toLowerCase((String)((Settings)baseIntroduceContext.settings).getIntroducedVarType().toString()), anchor);
    }

    @Override
    protected JSElement getElementForContextTypeCheck(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> baseIntroduceContext, JSSourceElement anchor) {
        return DialectDetector.isActionScript((PsiElement)anchor) ? super.getElementForContextTypeCheck(baseIntroduceContext, anchor) : anchor;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(3);
        }
        if (editor != null) {
            for (JSCustomIntroduceVariableHandler handler : JSCustomIntroduceVariableHandler.EP_NAME.getExtensionList()) {
                if (!handler.isAvailableOnEditorAndFile(editor, file)) continue;
                handler.invoke(editor, file);
                return;
            }
        }
        super.invoke(project, editor, file, dataContext);
    }

    @Override
    protected JSBaseInplaceIntroducer<BaseIntroduceSettings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context2, PsiElement scope2, Editor editor, Project project, JSExpression[] occurrences, Runnable callback) {
        JSExpression first = (JSExpression)context2.expressionDescriptor.first;
        if (first.getParent() instanceof JSExpressionStatement) {
            for (int i = 0; i < occurrences.length; ++i) {
                if (occurrences[i] != first) continue;
                occurrences = (JSExpression[])ArrayUtil.remove((Object[])occurrences, (int)i);
                break;
            }
        }
        return this.createIntroducer(context2, scope2, editor, project, occurrences, callback);
    }

    @NotNull
    protected JSBaseInplaceIntroducer<BaseIntroduceSettings> createIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context2, PsiElement scope2, Editor editor, Project project, JSExpression[] occurrences, Runnable callback) {
        return new JSVariableInplaceIntroducer(project, editor, occurrences, this, context2, callback, this.isSilent());
    }

    @Override
    protected JSIntroduceVariableDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope2) {
        return new JSIntroduceVariableDialog(project, occurrences, expression, scope2, this.getDefaultIntroduceType(scope2));
    }

    @Override
    protected InplaceSettings<BaseIntroduceSettings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, final PsiElement scope2, final OccurrencesChooser.ReplaceChoice choice) {
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider((JSExpression)expr.first, occurrences, scope2);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : JSNameSuggestionsUtil.ensureUniqueVariableName("newVar", scope2, new HashSet<String>(), false);
        return new InplaceSettings<BaseIntroduceSettings>(){

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public Settings getSettings() {
                return new Settings(){

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return null;
                    }

                    @Override
                    public Settings.IntroducedVarType getIntroducedVarType() {
                        return JSIntroduceVariableHandler.this.getDefaultIntroduceType(scope2);
                    }
                };
            }
        };
    }

    @Override
    protected JSExecutionScope getScopeWhenHavingAwait(JSExecutionScope scope2) {
        return scope2;
    }

    protected Settings.IntroducedVarType getDefaultIntroduceType(PsiElement scope2) {
        return JSIntroduceVariableHandler.getDefaultVariableType(scope2);
    }

    static Settings.IntroducedVarType getDefaultVariableType(PsiElement scope2) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)scope2);
        Settings.IntroducedVarType type2 = JSIntroduceVariableHandler.getLastIntroduceType(scope2.getProject(), holder);
        if (type2 == Settings.IntroducedVarType.LET && holder != null && !holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS)) {
            return Settings.IntroducedVarType.VAR;
        }
        return type2;
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> introduceContext, Project project, @Nullable JSLanguageDialect languageDialect, JSSourceElement sourceElement, Editor editor) throws IncorrectOperationException {
        Pair<JSVarStatement, Boolean> preparedDeclarationStatus = super.prepareDeclaration(varDeclText, introduceContext, project, languageDialect, sourceElement, editor);
        JSVarStatement declaration = (JSVarStatement)preparedDeclarationStatus.first;
        if (this.isForExpressionStatement(introduceContext.expressionDescriptor, sourceElement)) {
            declaration = (JSVarStatement)sourceElement.replace((PsiElement)declaration);
            editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
            return Pair.create((Object)declaration, (Object)Boolean.TRUE);
        }
        JSExpression first = (JSExpression)introduceContext.expressionDescriptor.first;
        if (first instanceof JSElvisOwner && JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)((JSElvisOwner)first))) {
            for (JSExpression occurrence : introduceContext.occurrences) {
                JSChangeUtil.setElvisAfter((PsiElement)occurrence);
            }
        }
        return preparedDeclarationStatus;
    }

    @Override
    protected boolean validateSelectedExpression(@NotNull PsiFile file, @Nullable Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        JSSourceElement anchor;
        if (file == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(4);
        }
        if (expressionDescriptor == null) {
            JSIntroduceVariableHandler.$$$reportNull$$$0(5);
        }
        if (!super.validateSelectedExpression(file, editor, expressionDescriptor)) {
            return false;
        }
        JSExpression expression = (JSExpression)expressionDescriptor.first;
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return true;
        }
        if (file.getContext() instanceof XmlElement) {
            this.showErrorHint(editor, file, JavaScriptBundle.message((String)"javascript.introduce.variable.xml.embedded", (Object[])new Object[0]));
            return false;
        }
        if (!JSIntroduceVariableHandler.skipFunction((PsiElement)expression) && ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)expression).forceIgnore(e -> JSIntroduceVariableHandler.skipFunction(e))).filter(JSThisExpression.class).isNotEmpty() && (anchor = JSUtils.findSourceAnchor((PsiElement)expression, (boolean)false)) instanceof JSClass) {
            this.showErrorHint(editor, file, JavaScriptBundle.message((String)"javascript.introduce.incorrect.context", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected boolean canInplaceIntroduceForSubexpression() {
        return true;
    }

    private static boolean skipFunction(PsiElement e) {
        return e instanceof JSFunction && !((JSFunction)e).isArrowFunction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedExpressionChooser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceVariableHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceVariableHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "varTypeEnabled";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateSelectedExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

