/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JSInterfaceMemberDependencyGraph
implements MemberDependencyGraph<JSAttributeListOwner, JSMemberInfo> {
    private HashSet<JSAttributeListOwner> myInterfaceDependencies = null;
    private HashMap<JSElement, HashSet<JSClass>> myMembersToInterfacesMap = new HashMap();
    private final HashSet<JSClass> myImplementedInterfaces;
    private final HashMap<JSClass, HashSet<JSAttributeListOwner>> myMethodsFromInterfaces;
    private final JSClass myClass;

    public JSInterfaceMemberDependencyGraph(JSClass aClass) {
        this.myClass = aClass;
        this.myImplementedInterfaces = new HashSet();
        this.myMethodsFromInterfaces = new HashMap();
    }

    public synchronized void memberChanged(JSMemberInfo memberInfo) {
        PsiElement psiElement = memberInfo.getMember();
        if (psiElement instanceof JSClass) {
            JSClass aClass = (JSClass)psiElement;
            this.myInterfaceDependencies = null;
            this.myMembersToInterfacesMap = null;
            if (memberInfo.isChecked()) {
                this.myImplementedInterfaces.add(aClass);
            } else {
                this.myImplementedInterfaces.remove(aClass);
            }
        }
    }

    public synchronized Set<? extends JSAttributeListOwner> getDependent() {
        if (this.myInterfaceDependencies == null) {
            HashSet<JSAttributeListOwner> dependencies = new HashSet<JSAttributeListOwner>();
            HashMap<JSElement, HashSet<JSClass>> membersToInterfacesMap = new HashMap<JSElement, HashSet<JSClass>>();
            for (JSClass implementedInterface : this.myImplementedInterfaces) {
                this.addInterfaceDeps(implementedInterface, membersToInterfacesMap, dependencies);
            }
            this.myInterfaceDependencies = dependencies;
            this.myMembersToInterfacesMap = membersToInterfacesMap;
        }
        return this.myInterfaceDependencies;
    }

    public synchronized Set<? extends JSAttributeListOwner> getDependenciesOf(JSAttributeListOwner member) {
        Set<? extends JSAttributeListOwner> dependent = this.getDependent();
        if (dependent.contains(member)) {
            return this.myMembersToInterfacesMap.get(member);
        }
        return null;
    }

    @NlsContexts.Tooltip
    public String getElementTooltip(JSAttributeListOwner member) {
        Set<? extends JSAttributeListOwner> dependencies = this.getDependenciesOf(member);
        if (dependencies == null || dependencies.isEmpty()) {
            return null;
        }
        String interfaces = StringUtil.join(dependencies, NavigationItem::getName, (String)", ");
        return RefactoringBundle.message((String)"interface.member.dependency.required.by.interfaces.list", (Object[])new Object[]{dependencies.size(), interfaces});
    }

    private void addInterfaceDeps(JSClass intf, HashMap<JSElement, HashSet<JSClass>> membersToInterfacesMap, HashSet<JSAttributeListOwner> dependencies) {
        HashSet<Object> interfaceMethods = this.myMethodsFromInterfaces.get(intf);
        if (interfaceMethods == null) {
            interfaceMethods = new HashSet();
            this.buildInterfaceMethods(interfaceMethods, intf);
            this.myMethodsFromInterfaces.put(intf, interfaceMethods);
        }
        for (JSElement jSElement : interfaceMethods) {
            HashSet<Object> interfaces = membersToInterfacesMap.get(jSElement);
            if (interfaces == null) {
                interfaces = new HashSet();
                membersToInterfacesMap.put(jSElement, interfaces);
            }
            interfaces.add(intf);
        }
        dependencies.addAll(interfaceMethods);
    }

    private void buildInterfaceMethods(HashSet<JSAttributeListOwner> interfaceMethods, JSClass intf) {
        JSReferenceList extendsList;
        for (JSFunction method1 : intf.getFunctions()) {
            JSFunction method = this.myClass.findFunctionByName(method1.getName());
            if (method == null) continue;
            interfaceMethods.add((JSAttributeListOwner)method);
        }
        JSReferenceList implementsList = intf.getImplementsList();
        if (implementsList != null) {
            for (JSClass aImplemented : implementsList.getReferencedClasses()) {
                this.buildInterfaceMethods(interfaceMethods, aImplemented);
            }
        }
        if ((extendsList = intf.getExtendsList()) != null) {
            for (JSClass aExtended : extendsList.getReferencedClasses()) {
                this.buildInterfaceMethods(interfaceMethods, aExtended);
            }
        }
    }
}

