/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.ide;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.ide.JSCompletionSource;
import com.intellij.lang.typescript.compiler.languageService.ide.ServiceResultsState;
import com.intellij.lang.typescript.compiler.languageService.ide.TypeScriptServiceCompletionContributorKt;
import com.intellij.lang.typescript.compiler.languageService.ide.TypeScriptServiceOverloadLookupElementDecorator;
import com.intellij.openapi.editor.Document;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0014J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010#J\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010%\u001a\u00020\u001fH\u0002J\u0014\u0010&\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190#J\b\u0010'\u001a\u00020\u001fH\u0002J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/ide/TypeScriptServiceCompletionProcessor;", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "resultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "tsService", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "strategy", "Lcom/intellij/lang/typescript/compiler/TypeScriptService$CompletionMergeStrategy;", "isRapidContributorCompletion", "", "<init>", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/openapi/editor/Document;ILcom/intellij/codeInsight/completion/CompletionResultSet;Lcom/intellij/lang/typescript/compiler/TypeScriptService;Lcom/intellij/lang/typescript/compiler/TypeScriptService$CompletionMergeStrategy;Z)V", "deferredItems", "", "Lcom/intellij/codeInsight/completion/CompletionResult;", "remainingCollectedItems", "", "", "namesWithServiceCompletionEntries", "Lcom/intellij/lang/typescript/compiler/TypeScriptService$CompletionEntry;", "explicitItems", "", "acceptPriorityCompletionResult", "completionResult", "flushCollectedContributorResultsAfterServiceFutureIsDone", "", "state", "Lcom/intellij/lang/typescript/compiler/languageService/ide/ServiceResultsState;", "completionEntries", "", "flushEverythingAfterBothSourcesFinished", "removeDuplicatesByExplicitItems", "putAllServiceCompletionEntries", "processAllServiceCompletionEntries", "addElementToRemainingMap", "newCompletionResult", "processRemainingItem", "result", "overridePriority", "Lcom/intellij/codeInsight/lookup/LookupElement;", "baseElement", "completionEntry2Name", "completionEntry", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServiceCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServiceCompletionContributor.kt\ncom/intellij/lang/typescript/compiler/languageService/ide/TypeScriptServiceCompletionProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,467:1\n1321#2,2:468\n1321#2,2:470\n1321#2,2:472\n1321#2,2:486\n1869#3,2:474\n1869#3,2:476\n1869#3,2:478\n1208#3,2:480\n1236#3,4:482\n360#3,7:488\n*S KotlinDebug\n*F\n+ 1 TypeScriptServiceCompletionContributor.kt\ncom/intellij/lang/typescript/compiler/languageService/ide/TypeScriptServiceCompletionProcessor\n*L\n270#1:468,2\n275#1:470,2\n284#1:472,2\n312#1:486,2\n287#1:474,2\n295#1:476,2\n302#1:478,2\n308#1:480,2\n308#1:482,4\n327#1:488,7\n*E\n"})
final class TypeScriptServiceCompletionProcessor {
    @NotNull
    private final CompletionParameters parameters;
    @NotNull
    private final Document document;
    private final int offset;
    @NotNull
    private final CompletionResultSet resultSet;
    @NotNull
    private final TypeScriptService tsService;
    @NotNull
    private final TypeScriptService.CompletionMergeStrategy strategy;
    private final boolean isRapidContributorCompletion;
    @NotNull
    private final List<CompletionResult> deferredItems;
    @NotNull
    private final Map<String, List<CompletionResult>> remainingCollectedItems;
    @NotNull
    private final Map<String, TypeScriptService.CompletionEntry> namesWithServiceCompletionEntries;
    @NotNull
    private final Set<String> explicitItems;

    public TypeScriptServiceCompletionProcessor(@NotNull CompletionParameters parameters2, @NotNull Document document, int offset, @NotNull CompletionResultSet resultSet, @NotNull TypeScriptService tsService, @NotNull TypeScriptService.CompletionMergeStrategy strategy, boolean isRapidContributorCompletion) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)tsService, (String)"tsService");
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        this.parameters = parameters2;
        this.document = document;
        this.offset = offset;
        this.resultSet = resultSet;
        this.tsService = tsService;
        this.strategy = strategy;
        this.isRapidContributorCompletion = isRapidContributorCompletion;
        this.deferredItems = (List)new SmartList();
        this.remainingCollectedItems = new LinkedHashMap();
        this.namesWithServiceCompletionEntries = new LinkedHashMap();
        this.explicitItems = new HashSet();
    }

    public final boolean acceptPriorityCompletionResult(@NotNull CompletionResult completionResult) {
        boolean isHighPriority;
        Intrinsics.checkNotNullParameter((Object)completionResult, (String)"completionResult");
        LookupElement lookupElement = completionResult.getLookupElement();
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"getLookupElement(...)");
        LookupElement element2 = lookupElement;
        String string = element2.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        String lookupString = string;
        double priority = JSCompletionUtil.getLookupElementPriority(element2);
        boolean isDeferred = !JSUtils.isIdentifierNameOrPrivateIdentifier((String)lookupString);
        boolean bl = isHighPriority = priority >= (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue();
        if (this.isRapidContributorCompletion || isHighPriority || isDeferred) {
            if (isDeferred && !this.isRapidContributorCompletion) {
                this.deferredItems.add(completionResult);
            } else {
                this.resultSet.passResult(completionResult);
            }
            this.explicitItems.add(lookupString);
            this.namesWithServiceCompletionEntries.remove(lookupString);
            return true;
        }
        return false;
    }

    public final void flushCollectedContributorResultsAfterServiceFutureIsDone(@NotNull ServiceResultsState state, @Nullable List<? extends TypeScriptService.CompletionEntry> completionEntries) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (state == ServiceResultsState.COMPLETED_ACCEPTED && completionEntries != null) {
            this.putAllServiceCompletionEntries(completionEntries);
            this.removeDuplicatesByExplicitItems();
            Sequence $this$forEach$iv = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.remainingCollectedItems.values()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompletionResult result2 = (CompletionResult)element$iv;
                boolean bl = false;
                this.processRemainingItem(result2);
            }
        } else {
            Sequence $this$forEach$iv = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.remainingCollectedItems.values()));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompletionResult result3 = (CompletionResult)element$iv;
                boolean bl = false;
                this.resultSet.passResult(result3);
            }
        }
        this.remainingCollectedItems.clear();
    }

    public final void flushEverythingAfterBothSourcesFinished(@NotNull ServiceResultsState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (state == ServiceResultsState.COMPLETED_DISCARDED) {
            CompletionResult result2;
            Object element$iv;
            Object $this$forEach$iv = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.remainingCollectedItems.values()));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                result2 = (CompletionResult)element$iv;
                boolean bl = false;
                this.resultSet.passResult(result2);
            }
            $this$forEach$iv = this.deferredItems;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                result2 = (CompletionResult)element$iv;
                boolean bl = false;
                this.resultSet.passResult(result2);
            }
            this.resultSet.stopHere();
            return;
        }
        this.removeDuplicatesByExplicitItems();
        this.processAllServiceCompletionEntries();
        Iterable $this$forEach$iv = this.deferredItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompletionResult result3 = (CompletionResult)element$iv;
            boolean bl = false;
            this.resultSet.passResult(result3);
        }
        this.resultSet.stopHere();
    }

    private final void removeDuplicatesByExplicitItems() {
        Iterable $this$forEach$iv = this.explicitItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String lookupStr = (String)element$iv;
            boolean bl = false;
            this.namesWithServiceCompletionEntries.remove(lookupStr);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void putAllServiceCompletionEntries(@NotNull List<? extends TypeScriptService.CompletionEntry> completionEntries) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(completionEntries, (String)"completionEntries");
        Iterable iterable = completionEntries;
        Map<String, TypeScriptService.CompletionEntry> map2 = this.namesWithServiceCompletionEntries;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            TypeScriptService.CompletionEntry completionEntry = (TypeScriptService.CompletionEntry)element$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            map3.put(this.completionEntry2Name((TypeScriptService.CompletionEntry)p0), element$iv$iv);
        }
        map2.putAll(destination$iv$iv);
    }

    private final void processAllServiceCompletionEntries() {
        Sequence $this$forEach$iv = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.remainingCollectedItems.values()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompletionResult current = (CompletionResult)element$iv;
            boolean bl = false;
            this.processRemainingItem(current);
        }
        List entriesWithoutDetails = new ArrayList<TypeScriptService.CompletionEntry>(this.namesWithServiceCompletionEntries.values());
        if (!entriesWithoutDetails.isEmpty()) {
            CompletionResultSet completionResultSet = this.resultSet.withRelevanceSorter(JSCompletionContributor.createOwnSorter(this.parameters));
            Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withRelevanceSorter(...)");
            CompletionResultSet decoratedResultSet = completionResultSet;
            this.tsService.processCompletionEntries(this.document, this.offset, decoratedResultSet, entriesWithoutDetails);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addElementToRemainingMap(@NotNull CompletionResult newCompletionResult) {
        int oldCompletionResultIndex;
        List listByLookupString;
        block4: {
            int n;
            void $this$indexOfFirst$iv;
            Intrinsics.checkNotNullParameter((Object)newCompletionResult, (String)"newCompletionResult");
            String string = newCompletionResult.getLookupElement().getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
            String lookupString = string;
            List list = this.remainingCollectedItems.computeIfAbsent(lookupString, arg_0 -> TypeScriptServiceCompletionProcessor.addElementToRemainingMap$lambda$1(TypeScriptServiceCompletionProcessor::addElementToRemainingMap$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
            List list2 = listByLookupString = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                CompletionResult it = (CompletionResult)item$iv;
                boolean bl = false;
                if (!(it.getLookupElement() instanceof TypeScriptServiceOverloadLookupElementDecorator) && !Intrinsics.areEqual((Object)it.getLookupElement(), (Object)newCompletionResult.getLookupElement()) && !JSCompletionKeyword.ALL_LOOKUP_STRINGS.contains(it.getLookupElement().getLookupString())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = oldCompletionResultIndex = -1;
        }
        if (oldCompletionResultIndex != -1) {
            CompletionResult oldCompletionResult = (CompletionResult)listByLookupString.get(oldCompletionResultIndex);
            LookupElement lookupElement = oldCompletionResult.getLookupElement();
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"getLookupElement(...)");
            CompletionResult completionResult = oldCompletionResult.withLookupElement(TypeScriptServiceCompletionContributorKt.access$overloadDecorator(lookupElement));
            Intrinsics.checkNotNullExpressionValue((Object)completionResult, (String)"withLookupElement(...)");
            CompletionResult decoratedCompletionResult = completionResult;
            listByLookupString.set(oldCompletionResultIndex, decoratedCompletionResult);
        } else {
            ((Collection)listByLookupString).add(newCompletionResult);
        }
    }

    public final void processRemainingItem(@NotNull CompletionResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        LookupElement lookupElement = result2.getLookupElement();
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"getLookupElement(...)");
        LookupElement element2 = lookupElement;
        if (this.namesWithServiceCompletionEntries.isEmpty()) {
            if (this.strategy == TypeScriptService.CompletionMergeStrategy.MERGE) {
                this.resultSet.passResult(result2);
            }
            return;
        }
        TypeScriptService.CompletionEntry item = this.namesWithServiceCompletionEntries.remove(element2.getLookupString());
        if (item != null) {
            CompletionResult completionResult;
            LookupElement newElement = this.overridePriority(element2);
            if (newElement == element2) {
                TypeScriptServiceCompletionContributorKt.access$markWithCompletionSource(newElement, JSCompletionSource.SERVICE);
                completionResult = result2;
            } else {
                TypeScriptServiceCompletionContributorKt.access$markWithCompletionSource(newElement, JSCompletionSource.SERVICE_AND_IDE_CONTRIBUTORS);
                CompletionResult completionResult2 = result2.withLookupElement(newElement);
                Intrinsics.checkNotNull((Object)completionResult2);
                completionResult = completionResult2;
            }
            CompletionResult newResult = completionResult;
            this.resultSet.passResult(newResult);
            return;
        }
        if (this.strategy == TypeScriptService.CompletionMergeStrategy.MERGE) {
            this.resultSet.passResult(result2);
        }
    }

    private final LookupElement overridePriority(LookupElement baseElement) {
        LookupElement lookupElement;
        LookupElement lookupElement2 = JSLookupUtilImpl.withPartial(baseElement, false);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"withPartial(...)");
        LookupElement element2 = lookupElement2;
        if (JSCompletionUtil.getLookupElementPriority(element2) >= (double)JSLookupPriority.RELEVANT_NO_SMARTNESS_PRIORITY.getPriorityValue()) {
            lookupElement = element2;
        } else {
            LookupElement lookupElement3 = JSCompletionUtil.withJSLookupPriority(element2, JSLookupPriority.RELEVANT_NO_SMARTNESS_PRIORITY);
            lookupElement = lookupElement3;
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement3, (String)"withJSLookupPriority(...)");
        }
        return lookupElement;
    }

    private final String completionEntry2Name(TypeScriptService.CompletionEntry completionEntry) {
        return StringsKt.removePrefix((String)completionEntry.getName(), (CharSequence)"#");
    }

    private static final List addElementToRemainingMap$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List addElementToRemainingMap$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

