/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.config;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.MergeQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jpa/jpb/model/backend/config/SpringConfigurationSearch;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFacade", "Lcom/intellij/psi/JavaPsiFacade;", "walkConfigurationClasses", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiClass;", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nSpringConfigurationSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringConfigurationSearch.kt\ncom/intellij/jpa/jpb/model/backend/config/SpringConfigurationSearch\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n11879#2,9:60\n13805#2:69\n13806#2:71\n11888#2:72\n1#3:70\n1563#4:73\n1634#4,3:74\n2783#4,7:77\n*S KotlinDebug\n*F\n+ 1 SpringConfigurationSearch.kt\ncom/intellij/jpa/jpb/model/backend/config/SpringConfigurationSearch\n*L\n30#1:60,9\n30#1:69\n30#1:71\n30#1:72\n30#1:70\n31#1:73\n31#1:74,3\n41#1:77,7\n*E\n"})
public final class SpringConfigurationSearch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JavaPsiFacade psiFacade;
    @NotNull
    private static final Logger log;

    public SpringConfigurationSearch(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"getInstance(...)");
        this.psiFacade = javaPsiFacade;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void walkConfigurationClasses(@NotNull GlobalSearchScope scope, @NotNull Processor<PsiClass> processor) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        DumbService.Companion.getInstance(this.project).runReadActionInSmartMode(() -> SpringConfigurationSearch.walkConfigurationClasses$lambda$0(this, processor, scope));
    }

    /*
     * WARNING - void declaration
     */
    private static final void walkConfigurationClasses$lambda$0(SpringConfigurationSearch this$0, Processor $processor, GlobalSearchScope $scope) {
        if (!this$0.project.isInitialized()) {
            return;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        GlobalSearchScope allSearchScope = globalSearchScope;
        try {
            Query query;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            String[] stringArray = new String[]{"org.springframework.context.annotation.Configuration", "org.springframework.boot.autoconfigure.SpringBootApplication"};
            boolean $i$f$mapNotNull = false;
            void var7_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PsiClass it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (this$0.psiFacade.findClass((String)it, allSearchScope) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void configurationClass;
                PsiClass psiClass = (PsiClass)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Class[] classArray = new Class[]{PsiClass.class};
                collection.add(AnnotatedElementsSearch.searchElements((PsiClass)configurationClass, (SearchScope)((SearchScope)$scope), (Class[])classArray));
            }
            List annotatedQueries = (List)destination$iv$iv;
            if (annotatedQueries.isEmpty()) {
                return;
            }
            if (annotatedQueries.size() == 1) {
                query = (Query)CollectionsKt.first((List)annotatedQueries);
            } else {
                Iterable $this$reduce$iv = annotatedQueries;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void query2;
                    Query item$iv$iv = (Query)iterator$iv.next();
                    Query query1 = (Query)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = (Query)new MergeQuery(query1, (Query)query2);
                }
                query = (Query)accumulator$iv;
            }
            Query query2 = query;
            Intrinsics.checkNotNull((Object)query2);
            Query mergeQuery = query2;
            mergeQuery.forEach($processor);
        }
        catch (IndexNotReadyException e) {
            log.warn("Index Not Ready exception during Spring configuration search", (Throwable)e);
        }
    }

    @JvmStatic
    @NotNull
    public static final SpringConfigurationSearch getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Logger logger = Logger.getInstance(SpringConfigurationSearch.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jpa/jpb/model/backend/config/SpringConfigurationSearch$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/jpa/jpb/model/backend/config/SpringConfigurationSearch;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpringConfigurationSearch getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new SpringConfigurationSearch(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

