/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;

@Service(value={Service.Level.PROJECT})
public final class IoFileSynchronizationHelper {
    private List<File> createdFiles = new ArrayList<File>();
    private boolean updateScheduled = false;
    private Project project;

    public IoFileSynchronizationHelper(Project project) {
        this.project = project;
    }

    public static IoFileSynchronizationHelper getInstance(Project project) {
        return (IoFileSynchronizationHelper)project.getService(IoFileSynchronizationHelper.class);
    }

    public void scheduleSynchronization(File ioFile) {
        this.createdFiles.add(ioFile);
        if (!this.updateScheduled) {
            this.updateScheduled = true;
            this.invokeLater(this::syncFiles);
        }
    }

    private void syncFiles() {
        this.updateScheduled = false;
        ArrayList<File> filesToRefresh = new ArrayList<File>(this.createdFiles);
        this.createdFiles.clear();
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        AppExecutorUtil.getAppExecutorService().submit(() -> localFileSystem.refreshIoFiles((Iterable)filesToRefresh, true, false, () -> this.invokeLater(() -> {
            List filesToAddToVcs = StreamEx.of((Collection)filesToRefresh).map(arg_0 -> ((LocalFileSystem)localFileSystem).findFileByIoFile(arg_0)).nonNull().toList();
            AppExecutorUtil.getAppExecutorService().submit(() -> VcsFileUtil.addFilesToVcsWithConfirmation((Project)this.project, (Collection)filesToAddToVcs));
        })));
    }

    private void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable, this.project.getDisposed());
    }
}

