/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.Annotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEnum;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeService;
import com.intellij.jpa.jpb.model.backend.ed.indexing.JdbcCodeCustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.JpaConverterModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.JpaConverterService;
import com.intellij.jpa.jpb.model.core.model.ConstantAttributeValue;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.liquibase.ns.SpringImplicitNamingStrategy;
import com.intellij.jpa.jpb.model.model.ArrayDatatype;
import com.intellij.jpa.jpb.model.model.AssociationType;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.CollectionTable;
import com.intellij.jpa.jpb.model.model.CompositeTypeEntity;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.EnumType;
import com.intellij.jpa.jpb.model.model.ForeignKeyModel;
import com.intellij.jpa.jpb.model.model.MapDatatype;
import com.intellij.jpa.jpb.model.model.MapKeyColumn;
import com.intellij.jpa.jpb.model.model.OrderColumn;
import com.intellij.jpa.jpb.model.model.SimpleEnumPsiType;
import com.intellij.jpa.jpb.model.model.UnknownDatatype;
import com.intellij.jpa.jpb.model.model.constraint.AnnotationConstraintProcessorEP;
import com.intellij.jpa.jpb.model.model.constraint.Constraint;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.jpa.jpb.model.util.StudioPropertyUtil;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class EntityAttributeCacheProvider {
    public static EntityAttributeCacheProvider getInstance(Project project) {
        return (EntityAttributeCacheProvider)project.getService(EntityAttributeCacheProvider.class);
    }

    private static Map<String, Annotation> getAttrAnnotations(PsiElement psiElement) {
        return AnnotationHelper.getAttrAnnotations(psiElement);
    }

    public boolean isMandatory(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            Boolean optionalValue;
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Id, JpaAttributeAnnotation.EmbeddedId)) {
                return true;
            }
            PsiAnnotation columnAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column, JpaAttributeAnnotation.JoinColumn);
            if (columnAnn != null && EntityAttributeCacheProvider.isColumnAnnMandatory(columnAnn)) {
                return true;
            }
            PsiAnnotation cardinalityAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne, JpaAttributeAnnotation.ManyToOne);
            if (cardinalityAnn != null && (optionalValue = StudioAnnotationUtil.getDeclaredBooleanAttributeValue(cardinalityAnn, "optional")) != null) {
                return optionalValue == false;
            }
            PsiAnnotation joinColumnsAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumns);
            if (joinColumnsAnn != null) {
                PsiAnnotationMemberValue joinColumnValue = joinColumnsAnn.findAttributeValue("value");
                if (joinColumnValue instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)joinColumnValue;
                    return StreamEx.of((Object[])array.getInitializers()).select(PsiAnnotation.class).anyMatch(EntityAttributeCacheProvider::isColumnAnnMandatory);
                }
                if (joinColumnValue instanceof PsiAnnotation) {
                    return EntityAttributeCacheProvider.isColumnAnnMandatory((PsiAnnotation)joinColumnValue);
                }
            }
            return false;
        });
    }

    public boolean isPersistent(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> (Boolean)ReadAction.nonBlocking(() -> {
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            EntityPsi entityPsi = EntityPsi.getInstance(containingClass);
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Transient) || EntityUtil.hasAnnotation((PsiModifierListOwner)member, "org.hibernate.annotations.Formula")) {
                return false;
            }
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumns)) {
                return true;
            }
            return entityPsi.isPersistentEntity() || entityPsi.isEmbeddable() || entityPsi.isMappedSuperclass();
        }).executeSynchronously());
    }

    public static boolean isUnique(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation columnAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column, JpaAttributeAnnotation.JoinColumn);
            return columnAnn != null && (EntityAttributeCacheProvider.isUniquePhysicallySet(columnAnn) || EntityAttributeCacheProvider.isHibernateOneToOne(member));
        });
    }

    private static boolean isHibernateOneToOne(PsiMember member) {
        if (JpaUtils.isHibernateProject(member.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)member))) {
            return StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne) != null;
        }
        return false;
    }

    private static boolean isUniquePhysicallySet(PsiAnnotation columnAnn) {
        return Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)columnAnn, (String)"unique"));
    }

    public static boolean isInsertable(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityAttributeCacheProvider.getBooleanColumnAttributeValue(member, "insertable"));
    }

    public static boolean isUpdatable(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityAttributeCacheProvider.getBooleanColumnAttributeValue(member, "updatable"));
    }

    private static Boolean getBooleanColumnAttributeValue(PsiMember member, String attrName) {
        PsiAnnotation columnAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column, JpaAttributeAnnotation.JoinColumn);
        if (columnAnn == null) {
            return true;
        }
        Boolean value = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)columnAnn, (String)attrName);
        return Boolean.TRUE.equals(value);
    }

    public boolean isVersion(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Version));
    }

    public boolean isLombokGetter(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            EntityPsi entityPsi = EntityPsi.getInstance(containingClass);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"lombok.Getter"});
            if (annotation == null) {
                return entityPsi.isLombokGetter();
            }
            String value = StudioAnnotationUtil.getDeclaredEnumStringValue(annotation, "value");
            return !"NONE".equals(value);
        });
    }

    public boolean isLombokToStringInclude(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            EntityPsi entityPsi = EntityPsi.getInstance(containingClass);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"lombok.ToString.Include"});
            if (annotation != null) {
                return true;
            }
            if (entityPsi.isLombokToString() && entityPsi.isLombokOnlyExplicitlyIncluded()) {
                return false;
            }
            return !EntityUtil.hasAnnotation((PsiModifierListOwner)member, "lombok.ToString.Exclude");
        });
    }

    public boolean isOrphanRemoval(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation cardinalityAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne, JpaAttributeAnnotation.OneToMany);
            if (cardinalityAnn == null) {
                return false;
            }
            Boolean value = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)cardinalityAnn, (String)"orphanRemoval");
            return value != null && value != false;
        });
    }

    public boolean isLombokSetter(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            EntityPsi entityPsi = EntityPsi.getInstance(containingClass);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"lombok.Setter"});
            if (annotation == null) {
                return entityPsi.isLombokSetter();
            }
            String value = StudioAnnotationUtil.getDeclaredEnumStringValue(annotation, "value");
            return !"NONE".equals(value);
        });
    }

    public List<EntityAttribute.CascadeType> getCascadeTypes(PsiMember member) {
        Project project = member.getProject();
        return (List)EntityUtil.raPsiCached((PsiElement)member, () -> {
            String declaredEnumStringValue;
            PsiAnnotation cardinalityAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne, JpaAttributeAnnotation.ManyToOne, JpaAttributeAnnotation.OneToMany, JpaAttributeAnnotation.ManyToMany);
            if (cardinalityAnn == null) {
                return Collections.emptyList();
            }
            Collection<String> arrayAttributeValue = StudioAnnotationUtil.getArrayAttributeValue(cardinalityAnn, "cascade");
            if (arrayAttributeValue.isEmpty() && (declaredEnumStringValue = StudioAnnotationUtil.getDeclaredEnumStringValue(cardinalityAnn, "cascade")) != null) {
                arrayAttributeValue = Collections.singletonList(JpaEnum.CascadeType.getEnumEntryFqn(project, ModuleUtilCore.findModuleForPsiElement((PsiElement)member), declaredEnumStringValue));
            }
            return StreamEx.of(arrayAttributeValue).map(fqn -> StringUtils.substringAfterLast((String)fqn, (String)".")).map(s -> (EntityAttribute.CascadeType)StringUtil.parseEnum((String)s, null, EntityAttribute.CascadeType.class)).nonNull().toList();
        });
    }

    public boolean isSqlType(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiType type = AttributeUtil.getMemberType(member);
            String typeFqn = type.getCanonicalText();
            return Datatypes.BasicDatatype.SqlDate == Datatypes.BasicDatatype.getInstance(typeFqn) || Datatypes.BasicDatatype.SqlTime == Datatypes.BasicDatatype.getInstance(typeFqn);
        });
    }

    public boolean isTransient(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Transient));
    }

    public boolean isLob(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Lob));
    }

    public boolean isNaturalId(PsiMember member) {
        return (Boolean)EntityUtil.ra(() -> AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.NaturalId"}) != null);
    }

    @Nullable
    public Integer getJdbcTypeCode(PsiMember member) {
        return (Integer)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation jdbcTypeCodeAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.JdbcTypeCode"});
            Long jdbcCode = jdbcTypeCodeAnnotation == null ? null : StudioAnnotationUtil.getDeclaredLongAttributeValue(jdbcTypeCodeAnnotation, "value");
            return jdbcCode != null ? Integer.valueOf(jdbcCode.intValue()) : null;
        });
    }

    @Nullable
    public String getDefaultValue(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, "org.hibernate.annotations.ColumnDefault", "value"));
    }

    public Integer getProcessedLength(PsiMember member) {
        return (Integer)EntityUtil.raPsiCached((PsiElement)member, () -> {
            Long lengthValue;
            PsiAnnotation columnAnnotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column);
            Long l = lengthValue = columnAnnotation == null ? null : StudioAnnotationUtil.getDeclaredLongAttributeValue(columnAnnotation, "length");
            if (lengthValue != null) {
                return lengthValue.intValue();
            }
            if (!StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Lob) && EntityAttributeCacheProvider.isPotentiallyHaveColumn(member)) {
                return 255;
            }
            return null;
        });
    }

    public String getLength(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> {
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Lob)) {
                return null;
            }
            PsiAnnotation columnAnnotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column);
            if (columnAnnotation == null) {
                return EntityAttributeCacheProvider.isPotentiallyHaveColumn(member) ? String.valueOf(255) : null;
            }
            PsiAnnotationMemberValue lengthValue = columnAnnotation.findDeclaredAttributeValue("length");
            if (lengthValue instanceof PsiExpression) {
                return lengthValue.getText();
            }
            return String.valueOf(255);
        });
    }

    public String getOrderBy(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation orderByAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OrderBy);
            if (orderByAnn != null) {
                String orderByValue = AnnotationUtil.getStringAttributeValue((PsiAnnotation)orderByAnn, (String)"value");
                if (StringUtils.isNotBlank((CharSequence)orderByValue)) {
                    return orderByValue;
                }
                return "id";
            }
            return null;
        });
    }

    private static boolean isColumnAnnMandatory(@NotNull PsiAnnotation columnAnn) {
        Boolean nullableValue;
        if (columnAnn == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(0);
        }
        return (nullableValue = StudioAnnotationUtil.getDeclaredBooleanAttributeValue(columnAnn, "nullable")) != null && nullableValue == false;
    }

    public static Map<String, String> getUnknownAnnotations(PsiMember member) {
        return (Map)EntityUtil.raPsiCached((PsiElement)member, () -> {
            Project project = member.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (PsiAnnotation psiAnnotation : member.getAnnotations()) {
                String annFqn;
                if (!psiAnnotation.isPhysical() || StringUtils.isBlank((CharSequence)(annFqn = psiAnnotation.getQualifiedName())) || JpaAttributeAnnotation.Lob.getFqn(project, module).equals(annFqn)) continue;
                String annClassName = ClassUtil.extractClassName((String)annFqn);
                Annotation foundAnnotation = EntityAttributeCacheProvider.getAttrAnnotations((PsiElement)member).get(annClassName);
                if (foundAnnotation != null) continue;
                result.put(annFqn, psiAnnotation.getText());
            }
            return result;
        });
    }

    public static Map<String, Map<String, String>> getAnnotationUnknownParams(PsiMember member) {
        return (Map)EntityUtil.raPsiCached((PsiElement)member, () -> {
            EntityAttributePsi entityAttributePsi = EntityAttributePsi.getInstance(member);
            Project project = member.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
            HashMap result = new HashMap();
            for (PsiAnnotation psiAnnotation : member.getAnnotations()) {
                String annFqn = psiAnnotation.getQualifiedName();
                if (StringUtils.isBlank((CharSequence)annFqn) || JpaAttributeAnnotation.Lob.getFqn(project, module).equals(annFqn)) continue;
                String annClassName = ClassUtil.extractClassName((String)annFqn);
                Annotation annotation = EntityAttributeCacheProvider.getAttrAnnotations((PsiElement)member).get(annClassName);
                if (annotation == null) continue;
                LinkedHashMap<String, String> unknownParams = new LinkedHashMap<String, String>();
                for (PsiNameValuePair annAttr : psiAnnotation.getParameterList().getAttributes()) {
                    String annAttrName = annAttr.getName();
                    if (annAttrName == null) {
                        annAttrName = "value";
                    }
                    if (annotation.knownAttributes(entityAttributePsi).contains(annAttrName)) continue;
                    unknownParams.put(annAttrName, annAttr.getValue() == null ? null : annAttr.getValue().getText());
                }
                if (unknownParams.isEmpty()) continue;
                result.put(annClassName, unknownParams);
            }
            return result;
        });
    }

    public ForeignKeyModel getForeignKey(PsiMember member) {
        return (ForeignKeyModel)EntityUtil.raPsiCached((PsiElement)member, () -> {
            for (PsiAnnotation annotation : member.getAnnotations()) {
                ForeignKeyModel foreignKey = ForeignKeyModel.Companion.getInstance(member.getProject(), annotation, "foreignKey");
                if (foreignKey == null) continue;
                return foreignKey;
            }
            return null;
        });
    }

    public static List<ConstantAttributeValue> getConstantAttributeValues(PsiMember member) {
        return (List)EntityUtil.raPsiCached((PsiElement)member, () -> {
            EntityAttributePsi entityAttributePsi = EntityAttributePsi.getInstance(member);
            Project project = member.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
            ArrayList<ConstantAttributeValue> result = new ArrayList<ConstantAttributeValue>();
            for (PsiAnnotation psiAnnotation : member.getAnnotations()) {
                String annFqn = psiAnnotation.getQualifiedName();
                if (StringUtils.isBlank((CharSequence)annFqn) || JpaAttributeAnnotation.Lob.getFqn(project, module).equals(annFqn)) continue;
                String annClassName = ClassUtil.extractClassName((String)annFqn);
                Annotation annotation = EntityAttributeCacheProvider.getAttrAnnotations((PsiElement)member).get(annClassName);
                if (annotation == null) continue;
                for (PsiNameValuePair annAttr : psiAnnotation.getParameterList().getAttributes()) {
                    PsiReferenceExpression referenceExpression;
                    PsiElement psiElement;
                    PsiAnnotationMemberValue patt0$temp;
                    String annAttrName = annAttr.getName();
                    if (annAttrName == null) {
                        annAttrName = "value";
                    }
                    if (!annotation.knownAttributes(entityAttributePsi).contains(annAttrName) || !((patt0$temp = annAttr.getValue()) instanceof PsiReferenceExpression) || !((psiElement = (referenceExpression = (PsiReferenceExpression)patt0$temp).resolve()) instanceof PsiField) || !((PsiField)psiElement).getType().equalsToText("java.lang.String")) continue;
                    result.add(new ConstantAttributeValue(annFqn, annAttrName, psiElement, referenceExpression.getText()));
                }
            }
            return result;
        });
    }

    public PsiType getMemberType(PsiMember member) {
        return (PsiType)EntityUtil.raPsiCached((PsiElement)member, () -> {
            if (member instanceof PsiField) {
                return ((PsiField)member).getType();
            }
            if (member instanceof PsiMethod) {
                return ((PsiMethod)member).getReturnType();
            }
            return null;
        });
    }

    public CustomTypeModel getConverter(@NotNull PsiMember member) {
        if (member == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(1);
        }
        return (CustomTypeModel)EntityUtil.ra(() -> {
            Project project = member.getProject();
            JpaConverterService jpaConverterService = JpaConverterService.getInstance(project);
            PsiClass entityPsiClass = member.getContainingClass();
            if (entityPsiClass == null) {
                return null;
            }
            Boolean isDisableConversion = this.isDisableConversion(member);
            CustomTypeModel model2 = (CustomTypeModel)EntityUtil.raPsiCached((PsiElement)member, () -> Optional.ofNullable(Optional.ofNullable(EntityAttributeCacheProvider.getJpaConverter(member, isDisableConversion)).orElseGet(() -> EntityAttributeCacheProvider.getJdbcTypeModel(member))).orElseGet(() -> this.getHibernateCustomType(member)));
            if (model2 == null && isDisableConversion != null && !isDisableConversion.booleanValue()) {
                PsiType type = this.getMemberType(member);
                if (type == null) {
                    return null;
                }
                List<JpaConverterModel> converters = jpaConverterService.getAutoApplyConvertersForEntityType(type.getCanonicalText(), entityPsiClass);
                return StreamEx.of(converters).findFirst().orElse(null);
            }
            return model2;
        });
    }

    private static JpaConverterModel getJpaConverter(@NotNull PsiMember member, Boolean isDisableConversion) {
        if (member == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(2);
        }
        Project project = member.getProject();
        JpaConverterService jpaConverterService = JpaConverterService.getInstance(project);
        PsiAnnotation annotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Convert);
        if (annotation == null || Boolean.TRUE.equals(isDisableConversion)) {
            return null;
        }
        String converterFqn = StudioAnnotationUtil.getDeclaredReferenceFqnStringValue(annotation, "converter");
        if (converterFqn != null) {
            return jpaConverterService.getModelFromFqn(converterFqn);
        }
        return null;
    }

    private static CustomTypeModel getJdbcTypeModel(@NotNull PsiMember member) {
        if (member == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(3);
        }
        return Optional.ofNullable(AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.JdbcType"})).map(it -> StudioAnnotationUtil.getDeclaredReferenceTypeValue(it, "value")).map(it -> it instanceof PsiClassType ? ((PsiClassType)it).resolve() : null).map(JdbcCodeCustomTypeModel::new).orElse(null);
    }

    private HibernateCustomTypeModel getHibernateCustomType(@NotNull PsiMember member) {
        HibernateCustomTypeModel javaTypeModel;
        String converterFqn;
        Module module;
        Project project;
        if (member == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(4);
        }
        if (!JpaUtils.isHibernateProject(project = member.getProject(), module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member))) {
            return null;
        }
        HibernateCustomTypeService hibernateCustomTypeService = HibernateCustomTypeService.getInstance(project);
        PsiClass entityPsiClass = member.getContainingClass();
        if (entityPsiClass == null) {
            return null;
        }
        EntityPsi entityPsi = EntityPsi.getInstance(member.getContainingClass());
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.Type"});
        if (annotation != null && (converterFqn = JpaUtils.isHibernate6Project(project, module) ? StudioAnnotationUtil.getDeclaredReferenceFqnStringValue(annotation, "value") : AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"type")) != null) {
            if (converterFqn.contains(".")) {
                HibernateCustomTypeModel hibernateCustomTypeModel = hibernateCustomTypeService.getCustomTypeByFqn(converterFqn);
                if (hibernateCustomTypeModel != null) {
                    return hibernateCustomTypeModel;
                }
            } else {
                HibernateCustomTypeModel hibernateCustomType = StreamEx.of(entityPsi.getHibernateTypes()).findFirst(it -> converterFqn.equals(it.getName())).orElse(null);
                if (hibernateCustomType == null) {
                    PsiPackage entityPackage;
                    PsiFile containingFile = entityPsiClass.getContainingFile();
                    PsiDirectory classDir = containingFile == null ? null : containingFile.getContainingDirectory();
                    PsiPackage psiPackage = entityPackage = classDir == null ? null : JavaDirectoryService.getInstance().getPackage(classDir);
                    while (hibernateCustomType == null && entityPackage != null && !entityPackage.getQualifiedName().isEmpty()) {
                        hibernateCustomType = EntityAttributeCacheProvider.getHibernateCustomTypePackageLevel(entityPackage, converterFqn, hibernateCustomTypeService);
                        entityPackage = entityPackage.getParentPackage();
                    }
                }
                return hibernateCustomType;
            }
        }
        if ((javaTypeModel = this.getHibernateJavaType(member)) != null) {
            return javaTypeModel;
        }
        PsiType type = this.getMemberType(member);
        return StreamEx.of(entityPsi.getHibernateTypes()).findFirst(it -> it.getJavaTypeFqn().equals(type.getCanonicalText()) && it.getDefaultForType()).orElse(null);
    }

    private static HibernateCustomTypeModel getHibernateCustomTypePackageLevel(PsiPackage entityPackage, String converterFqn, HibernateCustomTypeService hibernateCustomTypeService) {
        ArrayList annotationsTypeDef = new ArrayList(AnnotationUtil.findAllAnnotations((PsiModifierListOwner)entityPackage, Collections.singletonList("org.hibernate.annotations.TypeDef"), (boolean)false));
        AnnotationUtil.findAllAnnotations((PsiModifierListOwner)entityPackage, Collections.singletonList("org.hibernate.annotations.TypeDefs"), (boolean)false).forEach(typeDefsAnnotation -> annotationsTypeDef.addAll(StudioAnnotationUtil.getArrayValueAnnotations(typeDefsAnnotation, "value")));
        for (PsiAnnotation psiAnnotation : annotationsTypeDef) {
            PsiAnnotationMemberValue hibernateType;
            PsiNameValuePair typeClassParameter;
            String nameParameter = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)psiAnnotation, (String)"name");
            if (nameParameter == null || !nameParameter.equals(converterFqn) || (typeClassParameter = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)psiAnnotation, (String)"typeClass")) == null || (hibernateType = typeClassParameter.getValue()) == null) continue;
            hibernateType = hibernateType.getFirstChild();
            String hibernateTypeName = hibernateType.getText();
            List<HibernateCustomTypeModel> allCustomTypes = hibernateCustomTypeService.getAllCustomTypes(false);
            Optional<HibernateCustomTypeModel> hibernateCustomTypeModel = allCustomTypes.stream().filter(h -> h.getTypeClass().getName().equals(hibernateTypeName)).findFirst();
            if (!hibernateCustomTypeModel.isPresent()) continue;
            return hibernateCustomTypeModel.get();
        }
        return null;
    }

    private HibernateCustomTypeModel getHibernateJavaType(@NotNull PsiMember member) {
        if (member == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(5);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
        if (!JpaUtils.isHibernate6Project(member.getProject(), module)) {
            return null;
        }
        PsiType memberType = this.getMemberType(member);
        if (memberType == null) {
            return null;
        }
        Optional<PsiType> descriptorClassType = Optional.ofNullable(AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.JavaType"})).map(it -> StudioAnnotationUtil.getDeclaredReferenceTypeValue(it, "value"));
        if (descriptorClassType.isEmpty()) {
            descriptorClassType = Optional.ofNullable(AnnotationUtil.findAnnotation((PsiModifierListOwner)member.getContainingClass(), (String[])new String[]{"org.hibernate.annotations.JavaTypeRegistration"})).filter(it -> memberType.equals(StudioAnnotationUtil.getDeclaredReferenceTypeValue(it, "javaType"))).map(it -> StudioAnnotationUtil.getDeclaredReferenceTypeValue(it, "descriptorClass"));
        }
        if (descriptorClassType.isEmpty()) {
            descriptorClassType = ((Collection)Optional.ofNullable(AnnotationUtil.findAnnotation((PsiModifierListOwner)member.getContainingClass(), (String[])new String[]{"org.hibernate.annotations.JavaTypeRegistrations"})).map(it -> StudioAnnotationUtil.getArrayValueAnnotations(it, "value", "org.hibernate.annotations.JavaTypeRegistration")).orElse(Collections.emptyList())).stream().filter(it -> memberType.equals(StudioAnnotationUtil.getDeclaredReferenceTypeValue(it, "javaType"))).findFirst().map(it -> StudioAnnotationUtil.getDeclaredReferenceTypeValue(it, "descriptorClass"));
        }
        return descriptorClassType.filter(it -> it instanceof PsiClassType).map(it -> ((PsiClassType)it).resolve()).map(it -> HibernateCustomTypeService.getInstance(member.getProject()).getCustomTypeByClass((PsiClass)it)).orElse(null);
    }

    public Boolean isDisableConversion(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation annotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Convert);
            if (annotation != null) {
                Boolean disableConversion = StudioAnnotationUtil.getDeclaredBooleanAttributeValue(annotation, "disableConversion");
                return disableConversion != null ? disableConversion : false;
            }
            return false;
        });
    }

    public EntityAttribute.TemporalType getTemporalType(PsiMember member) {
        return (EntityAttribute.TemporalType)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            String temporalValue;
            String typeFqn = AttributeUtil.getMemberType(member).getCanonicalText();
            if (Datatypes.BasicDatatype.getInstance(typeFqn) == Datatypes.BasicDatatype.SqlDate) {
                return EntityAttribute.TemporalType.DATE;
            }
            if (Datatypes.BasicDatatype.SqlTime == Datatypes.BasicDatatype.getInstance(typeFqn)) {
                return EntityAttribute.TemporalType.TIME;
            }
            PsiAnnotation temporalAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Temporal);
            String string = temporalValue = temporalAnn == null ? null : StudioAnnotationUtil.getDeclaredEnumStringValue(temporalAnn, "value");
            if (StringUtils.isNotBlank((CharSequence)temporalValue)) {
                String correctPart = temporalValue.contains(".") ? StringUtils.substringAfterLast((String)temporalValue, (String)".") : temporalValue;
                return (EntityAttribute.TemporalType)StringUtil.parseEnum((String)correctPart, null, EntityAttribute.TemporalType.class);
            }
            return null;
        }));
    }

    public EntityAttribute.TimeZoneStorageType getTimeZoneStorageType(PsiMember member) {
        return (EntityAttribute.TimeZoneStorageType)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            if (Optional.ofNullable(AttributeUtil.getMemberType(member)).map(Datatypes.BasicDatatype::getInstanceStrict).filter(Datatypes.BasicDatatype::isZonedTime).isEmpty()) {
                return null;
            }
            String timeZoneStorageTypeString = StudioAnnotationUtil.getDeclaredEnumStringValue((PsiModifierListOwner)member, "org.hibernate.annotations.TimeZoneStorage", "value");
            if (timeZoneStorageTypeString != null) {
                return (EntityAttribute.TimeZoneStorageType)StringUtil.parseEnum((String)timeZoneStorageTypeString, null, EntityAttribute.TimeZoneStorageType.class);
            }
            return null;
        }));
    }

    public String getTimeZoneColumn(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, "org.hibernate.annotations.TimeZoneColumn", "name"));
    }

    public boolean isGenericType(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiType memberType = AttributeUtil.getMemberType(member);
            if (memberType instanceof PsiClassReferenceType) {
                PsiClassReferenceType psiClassReferenceType = (PsiClassReferenceType)memberType;
                PsiClass resolvedType = null;
                if (!psiClassReferenceType.hasParameters()) {
                    resolvedType = ((PsiClassReferenceType)memberType).resolve();
                } else if (psiClassReferenceType.getParameters().length == 1) {
                    PsiType innerType = psiClassReferenceType.getParameters()[0];
                    if (innerType instanceof PsiClassReferenceType) {
                        resolvedType = ((PsiClassReferenceType)innerType).resolve();
                    }
                } else {
                    return false;
                }
                return resolvedType instanceof PsiTypeParameter;
            }
            return false;
        });
    }

    @NotNull
    public Datatype getDatatype(PsiMember member, boolean allowCached) {
        PsiClass parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)member, PsiClass.class);
        Datatype datatype = this.getDatatype(member, parent, allowCached);
        if (datatype == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(6);
        }
        return datatype;
    }

    public Datatype getDatatype(PsiMember member, @Nullable PsiClass owner, boolean allowCached) {
        return (Datatype)EntityUtil.ra(() -> {
            if (!allowCached) {
                return EntityAttributeCacheProvider.getDatatypeNonCache(member, owner);
            }
            SmartPsiElementPointer ownerPointer = owner != null ? SmartPointerManager.getInstance((Project)member.getProject()).createSmartPsiElementPointer((PsiElement)owner) : null;
            return (Datatype)CachedValuesManager.getCachedValue((PsiElement)member, (Key)Key.create((String)"JPA_DATATYPE_CACHE"), () -> EntityAttributeCacheProvider.getDatatypeInternal(member, (SmartPsiElementPointer<PsiClass>)ownerPointer));
        });
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CachedValueProvider.Result<Datatype> getDatatypeInternal(PsiMember psiMember, SmartPsiElementPointer<PsiClass> ownerPointer) {
        PsiClass owner;
        PsiClass psiClass = owner = ownerPointer != null ? (PsiClass)ownerPointer.getElement() : null;
        if (psiMember == null) {
            CachedValueProvider.Result result = CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
            if (result == null) {
                EntityAttributeCacheProvider.$$$reportNull$$$0(7);
            }
            return result;
        }
        Datatype resultDatatype = EntityAttributeCacheProvider.getDatatypeNonCache(psiMember, owner);
        if (resultDatatype instanceof UnknownDatatype) {
            PsiType memberType = AttributeUtil.getMemberType(psiMember);
            if (memberType instanceof PsiClassType && ((PsiClassType)memberType).resolve() == null) {
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)resultDatatype, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
                if (result == null) {
                    EntityAttributeCacheProvider.$$$reportNull$$$0(8);
                }
                return result;
            }
            if (memberType != null) {
                String fqn = memberType.getCanonicalText();
                resultDatatype = new UnknownDatatype(StringUtils.substringBeforeLast((String)fqn, (String)"."), StringUtils.substringAfterLast((String)fqn, (String)"."));
            }
        }
        CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)resultDatatype, EntityAttributeCacheProvider.getExternalDependencies(psiMember, resultDatatype));
        if (result == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(9);
        }
        return result;
    }

    public EntityAttribute.GeneratedStrategy getGeneratedStrategy(PsiMember member) {
        return (EntityAttribute.GeneratedStrategy)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation generatedAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.GeneratedValue);
            if (generatedAnn == null) {
                return null;
            }
            String strategyValue = StudioAnnotationUtil.getDeclaredEnumStringValue(generatedAnn, "strategy");
            if (strategyValue != null) {
                return (EntityAttribute.GeneratedStrategy)StringUtil.parseEnum((String)strategyValue, null, EntityAttribute.GeneratedStrategy.class);
            }
            return EntityAttribute.GeneratedStrategy.AUTO;
        }));
    }

    public String getGeneratorName(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.GeneratedValue.getFqn(member.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)member)), "generator"));
    }

    public String getSequenceOrTableGeneratorName(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.getSequenceOrTableGeneratorName(member));
    }

    public boolean isSequenceGeneratorOnAttribute(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation seqGeneratorAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.SequenceGenerator);
            if (seqGeneratorAnn != null) {
                return true;
            }
            PsiAnnotation genericGeneratorAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.GenericGenerator"});
            if (genericGeneratorAnn == null) {
                return false;
            }
            String generationStrategy = AnnotationUtil.getStringAttributeValue((PsiAnnotation)genericGeneratorAnn, (String)"strategy");
            return EntityAttribute.GENERIC_GENERATOR_SEQUENCE_STRATEGIES.contains(generationStrategy);
        });
    }

    public String getTargetEntityFqn(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation annotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ManyToOne, JpaAttributeAnnotation.OneToOne);
            return annotation == null ? null : StudioAnnotationUtil.getDeclaredReferenceFqnStringValue(annotation, "targetEntity");
        });
    }

    private static Collection<Object> getExternalDependencies(@NotNull PsiMember member, @Nullable Datatype datatype) {
        PsiClass referencedClass;
        if (member == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(10);
        }
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(EntityUtil.getCacheDependency((PsiElement)member));
        if ((datatype == null || datatype instanceof UnknownDatatype || datatype instanceof Datatypes.BasicDatatype && !Datatypes.BasicDatatype.HARD_TYPES.contains(datatype)) && (referencedClass = AttributeUtil.getReferencedClass(member)) != null) {
            dependencies.add(EntityUtil.getCacheDependency((PsiElement)referencedClass));
        }
        return dependencies;
    }

    @NotNull
    private static Datatype getDatatypeNonCache(PsiMember member, PsiClass owner) {
        PsiClassType refType;
        Datatypes.BasicDatatype basicDatatype;
        PsiType memberType = AttributeUtil.getMemberType(member);
        if (memberType != null && (basicDatatype = Datatypes.BasicDatatype.getInstanceStrict(memberType)) != null) {
            Datatypes.BasicDatatype basicDatatype2 = basicDatatype;
            if (basicDatatype2 == null) {
                EntityAttributeCacheProvider.$$$reportNull$$$0(11);
            }
            return basicDatatype2;
        }
        Datatype elementCollectionDatatype = AttributeUtil.getElementCollectionType(member);
        if (elementCollectionDatatype != null) {
            Datatype datatype = elementCollectionDatatype;
            if (datatype == null) {
                EntityAttributeCacheProvider.$$$reportNull$$$0(12);
            }
            return datatype;
        }
        if (memberType instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)memberType).getComponentType();
            return new ArrayDatatype(memberType.getCanonicalText(), Datatypes.BasicDatatype.getInstanceWrapIfNull(componentType));
        }
        PsiClass referencedClass = AttributeUtil.getReferencedClass(member, owner);
        if (referencedClass == null) {
            String canonicalText = memberType != null ? memberType.getCanonicalText() : "<unknown>";
            return new UnknownDatatype(ClassUtil.extractPackageName((String)canonicalText), ClassUtil.extractClassName((String)canonicalText));
        }
        PsiClass compositeTypeEmbeddable = AttributeUtil.getCompositeTypeEmbeddable(member, memberType);
        if (compositeTypeEmbeddable != null) {
            CompositeTypeEntity compositeTypeEntity = CompositeTypeEntity.Companion.getInstance(compositeTypeEmbeddable);
            if (compositeTypeEntity == null) {
                EntityAttributeCacheProvider.$$$reportNull$$$0(13);
            }
            return compositeTypeEntity;
        }
        if (EntityUtil.isEntity(referencedClass) || EntityUtil.isEmbeddable(referencedClass) || StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Embedded)) {
            EntityPsi entityPsi = EntityPsi.getInstance(referencedClass);
            if (entityPsi == null) {
                EntityAttributeCacheProvider.$$$reportNull$$$0(14);
            }
            return entityPsi;
        }
        if (referencedClass.isEnum()) {
            SimpleEnumPsiType simpleEnumPsiType = SimpleEnumPsiType.getInstance(referencedClass);
            if (simpleEnumPsiType == null) {
                EntityAttributeCacheProvider.$$$reportNull$$$0(15);
            }
            return simpleEnumPsiType;
        }
        if (memberType == null) {
            String qualifiedName = referencedClass.getQualifiedName();
            return new UnknownDatatype(ClassUtil.extractPackageName((String)qualifiedName), referencedClass.getName());
        }
        if (memberType instanceof PsiClassType && (refType = (PsiClassType)memberType).getParameters().length == 1) {
            PsiClass collectionClass = refType.resolve();
            if (InheritanceUtil.isInheritor((PsiClass)collectionClass, (boolean)false, (String)Datatypes.CollectionDatatype.Collection.getFqn())) {
                PsiType arrayType = refType.getParameters()[0];
                if (arrayType instanceof PsiWildcardType) {
                    arrayType = ((PsiWildcardType)arrayType).getBound();
                }
                if (arrayType != null) {
                    return new ArrayDatatype(memberType.getCanonicalText(), Datatypes.BasicDatatype.getInstanceWrapIfNull(arrayType));
                }
            } else if (collectionClass != null && Datatypes.BasicDatatype.Class.isSame(collectionClass.getQualifiedName())) {
                Datatypes.BasicDatatype basicDatatype3 = Datatypes.BasicDatatype.Class;
                if (basicDatatype3 == null) {
                    EntityAttributeCacheProvider.$$$reportNull$$$0(16);
                }
                return basicDatatype3;
            }
        }
        Datatypes.BasicDatatype basicDatatype4 = Datatypes.BasicDatatype.createUnsafe(memberType.getCanonicalText(), InheritanceUtil.isInheritor((PsiClass)referencedClass, (String)"java.io.Serializable"));
        if (basicDatatype4 == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(17);
        }
        return basicDatatype4;
    }

    public EntityAttribute.MappingType getMappingType(PsiMember member) {
        return (EntityAttribute.MappingType)((Object)EntityUtil.ra(() -> (EntityAttribute.MappingType)((Object)((Object)CachedValuesManager.getCachedValue((PsiElement)member, () -> {
            EntityAttribute.MappingType mappingType = AttributeUtil.getMappingType(member);
            return CachedValueProvider.Result.create((Object)((Object)mappingType), EntityAttributeCacheProvider.getExternalDependencies(member, null));
        })))));
    }

    public EntityAttribute.FetchType getFetchType(PsiMember member) {
        return (EntityAttribute.FetchType)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation cardinalityAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne, JpaAttributeAnnotation.ManyToOne, JpaAttributeAnnotation.OneToMany, JpaAttributeAnnotation.ManyToMany, JpaAttributeAnnotation.Basic);
            EntityAttribute.FetchType defaultFetchType = EntityAttribute.FetchType.getDefault(this.getCardinality(member));
            if (cardinalityAnn == null) {
                return defaultFetchType;
            }
            String fetchValue = StudioAnnotationUtil.getDeclaredEnumStringValue(cardinalityAnn, "fetch");
            if (fetchValue != null) {
                return (EntityAttribute.FetchType)StringUtil.parseEnum((String)fetchValue, (Enum)defaultFetchType, EntityAttribute.FetchType.class);
            }
            return defaultFetchType;
        }));
    }

    @Nullable
    public EntityAttribute.FetchMode getFetchMode(PsiMember member) {
        return (EntityAttribute.FetchMode)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation fetchAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.hibernate.annotations.Fetch"});
            if (fetchAnn == null) {
                return null;
            }
            String fetchModeValue = StudioAnnotationUtil.getDeclaredEnumStringValue(fetchAnn, "value");
            if (fetchModeValue != null) {
                return (EntityAttribute.FetchMode)StringUtil.parseEnum((String)fetchModeValue, null, EntityAttribute.FetchMode.class);
            }
            return null;
        }));
    }

    public LinkedHashSet<AttributeOverride> getAttributeOverrides(PsiMember member) {
        return (LinkedHashSet)EntityUtil.raPsiCached((PsiElement)member, () -> {
            LinkedHashSet<AttributeOverride> attributeOverrides = new LinkedHashSet<AttributeOverride>();
            attributeOverrides.addAll(EntityUtil.getAttributeOverrides((PsiModifierListOwner)member, false));
            attributeOverrides.addAll(EntityUtil.getAttributeOverrides((PsiModifierListOwner)member, true));
            return attributeOverrides;
        });
    }

    @NotNull
    public JoinTable getJoinTable(PsiMember member) {
        JoinTable joinTable = (JoinTable)EntityUtil.ra(() -> AttributeUtil.getJoinTable(member));
        if (joinTable == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(18);
        }
        return joinTable;
    }

    @NotNull
    public JoinTable getJoinTable(@Nullable Entity ownerEntity, PsiMember member) {
        JoinTable joinTable = (JoinTable)EntityUtil.ra(() -> AttributeUtil.getJoinTable(ownerEntity, member));
        if (joinTable == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(19);
        }
        return joinTable;
    }

    @Nullable
    public CollectionTable getCollectionTable(@Nullable Entity ownerEntity, PsiMember member) {
        if (ownerEntity instanceof EntityPsi) {
            EntityPsi entityPsi = (EntityPsi)ownerEntity;
            SmartPsiElementPointer entityPsiClassPointer = SmartPointerManager.createPointer((PsiElement)entityPsi.getPsiClass());
            return (CollectionTable)CachedValuesManager.getCachedValue((PsiElement)member, () -> {
                PsiClass entityPsiClass = (PsiClass)entityPsiClassPointer.getElement();
                if (entityPsiClass == null) {
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{member});
                }
                CollectionTable result = AttributeUtil.getCollectionTable(EntityPsi.getInstance(entityPsiClass), member);
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{entityPsiClass, member});
            });
        }
        return AttributeUtil.getCollectionTable(ownerEntity, member);
    }

    public static LinkedHashSet<Constraint> getConstraints(PsiMember member) {
        return (LinkedHashSet)EntityUtil.raPsiCached((PsiElement)member, () -> {
            LinkedHashSet<Constraint> constraints = new LinkedHashSet<Constraint>();
            for (PsiAnnotation annotation : member.getAnnotations()) {
                Constraint constraint = EntityAttributeCacheProvider.processConstraintAnnotations(annotation);
                if (constraint == null) continue;
                constraints.add(constraint);
            }
            return constraints;
        });
    }

    public boolean isReadOnly(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            if (member.getContainingClass() != null) {
                List<PsiMethod> setters = StudioPropertyUtil.getSetters(member.getContainingClass(), this.getName(member));
                return setters.isEmpty() && !this.isLombokSetter(member);
            }
            return true;
        });
    }

    @NlsSafe
    public String getName(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.getPropertyName(member));
    }

    public String getGetterPropertyName(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.getGetterPropertyName(member));
    }

    @Nullable
    private static Constraint processConstraintAnnotations(PsiAnnotation annotation) {
        return (Constraint)((Object)EntityUtil.raPsiCached((PsiElement)annotation, () -> {
            ExtensionPointName extensionName = ExtensionPointName.create((String)"com.intellij.jpa.annotationConstraintProcessor");
            return StreamEx.of((Object[])((AnnotationConstraintProcessorEP[])extensionName.getExtensions())).map(it -> it.getConstraint(annotation)).findFirst(Objects::nonNull).orElse(null);
        }));
    }

    public int getScale(PsiMember member) {
        return (Integer)EntityUtil.raPsiCached((PsiElement)member, () -> {
            Long scale = StudioAnnotationUtil.getDeclaredLongAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.Column, "scale");
            return scale == null ? 0 : scale.intValue();
        });
    }

    public int getPrecision(PsiMember member) {
        return (Integer)EntityUtil.raPsiCached((PsiElement)member, () -> {
            Long precision = StudioAnnotationUtil.getDeclaredLongAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.Column, "precision");
            return precision == null ? 0 : precision.intValue();
        });
    }

    @Nullable
    public String getColumnNameValue(PsiMember member) {
        return (String)EntityUtil.raPsiCachedWithDependencies((PsiElement)member, "com.intellij.jpa.jpb.model.model.EntityAttributeCacheProvider.columnNameValue", () -> {
            PsiAnnotation columnAnn = (PsiAnnotation)ReadAction.nonBlocking(() -> StudioAnnotationUtil.findAllJpbAnnotationsWithContainer((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumns, JpaAttributeAnnotation.JoinColumn).stream().findFirst().orElseGet(() -> StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column))).executeSynchronously();
            String result = null;
            if (columnAnn != null || EntityAttributeCacheProvider.isPotentiallyHaveColumn(member)) {
                String columnName = this.getColumnNamePhysical(member);
                result = StringUtils.isNotBlank((CharSequence)columnName) ? columnName : EntityAttributeCacheProvider.generateDefaultColumnName(member);
            }
            return new EntityUtil.ResultWithDependenciesWrapper<String>(result, EntityAttributeCacheProvider.getExternalDependencies(member, null).stream().toList());
        });
    }

    @Nullable
    public OrderColumn getOrderColumn(PsiMember member) {
        return (OrderColumn)EntityUtil.raPsiCached((PsiElement)member, () -> {
            Datatypes.CollectionDatatype collectionType;
            PsiType memberType = this.getMemberType(member);
            if (!(memberType instanceof PsiArrayType) && (collectionType = EntityUtil.getCollectionType(member)) != Datatypes.CollectionDatatype.List) {
                return null;
            }
            Project project = member.getProject();
            PsiAnnotation columnAnn = (PsiAnnotation)ReadAction.nonBlocking(() -> StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OrderColumn)).executeSynchronously();
            if (columnAnn == null) {
                return null;
            }
            Object columnName = AnnotationUtil.getStringAttributeValue((PsiAnnotation)columnAnn, (String)"name");
            if (StringUtil.isEmpty((String)columnName)) {
                String defaultColumnName = EntityAttributeCacheProvider.generateDefaultColumnName(member);
                defaultColumnName = defaultColumnName == null || defaultColumnName.isEmpty() ? PhysicalNamingStrategy.getInstance(project).toColumnName(this.getName(member)) : defaultColumnName;
                columnName = defaultColumnName + "_order";
            }
            if (StringUtil.isEmpty((String)columnName)) {
                return null;
            }
            OrderColumn orderColumn = new OrderColumn((String)columnName);
            orderColumn.setColumnDefinition(AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)columnAnn, (String)"columnDefinition"));
            Boolean nullable = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)columnAnn, (String)"nullable");
            if (nullable != null) {
                orderColumn.setNullable(nullable);
            }
            return orderColumn;
        });
    }

    @Nullable
    public MapKeyColumn getMapKeyColumn(PsiMember member) {
        return (MapKeyColumn)EntityUtil.raPsiCached((PsiElement)member, () -> {
            Long scale;
            Long precision;
            Boolean nullable;
            EntityAttribute.EnumType enumType;
            String enumTypeValue;
            Object columnName;
            Project project = member.getProject();
            PsiAnnotation columnAnn = (PsiAnnotation)ReadAction.nonBlocking(() -> StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.MapKeyColumn, JpaAttributeAnnotation.MapKeyJoinColumn)).executeSynchronously();
            if (columnAnn == null && !this.isPotentiallyHaveMapKeyColumn(member)) {
                return null;
            }
            Object object = columnName = columnAnn == null ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)columnAnn, (String)"name");
            if (columnAnn == null || ((String)columnName).isEmpty()) {
                String defaultColumnName = EntityAttributeCacheProvider.generateDefaultColumnName(member);
                defaultColumnName = defaultColumnName == null || defaultColumnName.isEmpty() ? PhysicalNamingStrategy.getInstance(project).toColumnName(this.getName(member)) : defaultColumnName;
                columnName = defaultColumnName + "_key";
            }
            if (StringUtil.isEmpty((String)columnName)) {
                return null;
            }
            MapKeyColumn mapKeyColumn = new MapKeyColumn((String)columnName);
            PsiAnnotation enumeratedAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.MapKeyEnumerated);
            if (enumeratedAnn != null && (enumTypeValue = StudioAnnotationUtil.getDeclaredEnumStringValue(enumeratedAnn, "value")) != null && (enumType = (EntityAttribute.EnumType)StringUtil.parseEnum((String)enumTypeValue, null, EntityAttribute.EnumType.class)) != null) {
                mapKeyColumn.setEnumType(enumType);
            }
            if (columnAnn == null) {
                return mapKeyColumn;
            }
            Boolean unique = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)columnAnn, (String)"unique");
            if (unique != null) {
                mapKeyColumn.setUnique(unique);
            }
            if ((nullable = AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)columnAnn, (String)"nullable")) != null) {
                mapKeyColumn.setNullable(nullable);
            }
            mapKeyColumn.setColumnDefinition(AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)columnAnn, (String)"columnDefinition"));
            Long length = AnnotationUtil.getLongAttributeValue((PsiAnnotation)columnAnn, (String)"length");
            if (length != null) {
                mapKeyColumn.setLength(length.intValue());
            }
            if ((precision = AnnotationUtil.getLongAttributeValue((PsiAnnotation)columnAnn, (String)"precision")) != null) {
                mapKeyColumn.setPrecision(precision.intValue());
            }
            if ((scale = AnnotationUtil.getLongAttributeValue((PsiAnnotation)columnAnn, (String)"scale")) != null) {
                mapKeyColumn.setScale(scale.intValue());
            }
            return mapKeyColumn;
        });
    }

    @Nullable
    public Datatype getMapKeyType(PsiMember member) {
        return (Datatype)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiType memberType = this.getMemberType(member);
            if (!(memberType instanceof PsiClassType)) {
                return null;
            }
            MapDatatype mapDatatype = AttributeUtil.getMapDatatype((PsiClassType)memberType);
            return mapDatatype != null ? mapDatatype.getKeyType() : null;
        });
    }

    @Nullable
    public String getColumnNamePhysical(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> {
            String columnName;
            PsiAnnotation columnAnn = this.isElementCollection(member) ? StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column) : StudioAnnotationUtil.findAllJpbAnnotationsWithContainer((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumns, JpaAttributeAnnotation.JoinColumn).stream().findFirst().orElseGet(() -> StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column));
            String string = columnName = columnAnn == null ? null : EntityUtil.getAttributeValue(columnAnn, "name", "");
            if (StringUtils.isNotBlank((CharSequence)columnName) && (columnName.contains("\"") || columnName.contains("'") || columnName.contains("`"))) {
                return StringEscapeUtils.escapeJava((String)columnName);
            }
            return columnName;
        });
    }

    public String getColumnDefinition(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation columnAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column, JpaAttributeAnnotation.JoinColumn);
            return columnAnn == null ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)columnAnn, (String)"columnDefinition");
        });
    }

    public EntityAttribute.EnumType getEnumType(PsiMember member) {
        Project project = member.getProject();
        return (EntityAttribute.EnumType)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation enumeratedAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Enumerated);
            if (enumeratedAnn == null) {
                if (AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{JpaAttributeAnnotation.Convert.getFqn(project, ModuleUtilCore.findModuleForPsiElement((PsiElement)member)), "org.hibernate.annotations.Type"}) != null) {
                    return null;
                }
                PsiClass referencedClass = AttributeUtil.getReferencedClass(member);
                return referencedClass != null && referencedClass.isEnum() ? EntityAttribute.EnumType.ORDINAL : null;
            }
            String enumTypeValue = StudioAnnotationUtil.getEnumStringValue(enumeratedAnn, "value");
            if (enumTypeValue != null) {
                return (EntityAttribute.EnumType)StringUtil.parseEnum((String)enumTypeValue, null, EntityAttribute.EnumType.class);
            }
            return null;
        }));
    }

    @Nullable
    private static String generateDefaultColumnName(@NotNull PsiMember member) {
        if (member == null) {
            EntityAttributeCacheProvider.$$$reportNull$$$0(20);
        }
        EntityAttributePsi attr = EntityAttributePsi.getInstance(member);
        return EntityUtil.generateDefaultColumnName(member.getProject(), attr);
    }

    private boolean isPotentiallyHaveMapKeyColumn(PsiMember member) {
        PsiAnnotation elementCollectionAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ElementCollection, JpaAttributeAnnotation.OneToMany, JpaAttributeAnnotation.ManyToMany);
        if (elementCollectionAnn == null || StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.MapKey)) {
            return false;
        }
        PsiType type = this.getMemberType(member);
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedRefClass = ((PsiClassType)type).resolve();
        return InheritanceUtil.isInheritor((PsiClass)resolvedRefClass, (boolean)false, (String)"java.util.Map");
    }

    public static boolean isPotentiallyHaveColumn(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiClass psiClass;
            if (member.hasModifierProperty("static") || member.hasModifierProperty("transient")) {
                return false;
            }
            if (member.getLanguage() == JavaLanguage.INSTANCE && member.hasModifierProperty("final") && ((psiClass = member.getContainingClass()) == null || !psiClass.isRecord())) {
                return false;
            }
            PsiAnnotation oneToOneAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne);
            if (oneToOneAnn != null && StringUtil.isNotEmpty((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)oneToOneAnn, (String)"mappedBy"))) {
                return false;
            }
            if (StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToMany, JpaAttributeAnnotation.ManyToMany, JpaAttributeAnnotation.Transient, JpaAttributeAnnotation.EmbeddedId, JpaAttributeAnnotation.Embedded, JpaAttributeAnnotation.AttributeOverrides, JpaAttributeAnnotation.AssociationOverrides) != null) {
                return false;
            }
            PsiAnnotation elemColl = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ElementCollection);
            if (elemColl != null) {
                Datatype elementCollectionType = AttributeUtil.getElementCollectionType(member);
                if (elementCollectionType instanceof MapDatatype) {
                    elementCollectionType = ((MapDatatype)elementCollectionType).getValueType();
                }
                return elementCollectionType instanceof Datatypes.BasicDatatype || elementCollectionType instanceof EnumType;
            }
            return true;
        });
    }

    public AssociationType getAssociationType(PsiMember member) {
        return (AssociationType)((Object)EntityUtil.raPsiCachedWithDependencies((PsiElement)member, "com.intellij.jpa.jpb.model.model.EntityAttributeCacheProvider.getAssociationType", () -> {
            Datatype datatype = this.getDatatype(member, true);
            EntityAttribute.Cardinality cardinality = this.getCardinality(member);
            if (cardinality != null && datatype instanceof EntityPsi) {
                AssociationType result = this.getAssociationTypeNotCached(cardinality, member);
                return new EntityUtil.ResultWithDependenciesWrapper<AssociationType>(result, Collections.singletonList(((EntityPsi)datatype).getPsiClass()));
            }
            return new EntityUtil.ResultWithDependenciesWrapper<Object>(null, Collections.singletonList(ModificationTracker.EVER_CHANGED));
        }));
    }

    @Nullable
    private AssociationType getAssociationTypeNotCached(EntityAttribute.Cardinality cardinality, PsiMember member) {
        PsiClass containingClass = member.getContainingClass();
        if (containingClass != null) {
            PsiMember relatedAttributeMember = EntityAttributeCacheProvider.getRelatedAttributeMember(member, cardinality);
            PsiAnnotation joinColumnAnnotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumn);
            String mappedBy = this.getMappedBy(member);
            switch (cardinality) {
                case ONE_TO_MANY: {
                    if (mappedBy != null) {
                        return AssociationType.MappedByJoinColumn;
                    }
                    if (joinColumnAnnotation != null) {
                        return AssociationType.JoinColumnUnidirectional;
                    }
                    return AssociationType.WithoutJoinColumnOtM;
                }
                case ONE_TO_ONE: {
                    if (mappedBy != null) {
                        return AssociationType.MappedByJoinTable;
                    }
                    if (joinColumnAnnotation != null) {
                        if (relatedAttributeMember != null) {
                            return AssociationType.JoinColumnMappedBy;
                        }
                        return AssociationType.JoinColumnUnidirectional;
                    }
                }
                case MANY_TO_ONE: {
                    if (relatedAttributeMember != null) {
                        return AssociationType.JoinColumnMappedBy;
                    }
                    return AssociationType.JoinColumnUnidirectional;
                }
                case MANY_TO_MANY: {
                    if (mappedBy != null) {
                        return AssociationType.MappedByJoinTable;
                    }
                    if (relatedAttributeMember != null) {
                        return AssociationType.JoinTableMappedBy;
                    }
                    return AssociationType.JoinTableMtM;
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiMember getRelatedAttributeMember(PsiMember member, EntityAttribute.Cardinality cardinality) {
        PsiElement relatedAttrPsiElement;
        EntityAttribute relatedAttr;
        PsiClass containingClass = member.getContainingClass();
        if (containingClass != null && (relatedAttr = EntityDesignHelper.getRelatedAttr(EntityPsi.getInstance(containingClass), EntityAttributePsi.getInstance(member), cardinality)) != null && (relatedAttrPsiElement = relatedAttr.getPsiElement()) != null) {
            return (PsiMember)relatedAttrPsiElement;
        }
        return null;
    }

    public EntityAttribute.Cardinality getCardinality(PsiMember member) {
        return (EntityAttribute.Cardinality)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne)) {
                return EntityAttribute.Cardinality.ONE_TO_ONE;
            }
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToMany)) {
                return EntityAttribute.Cardinality.ONE_TO_MANY;
            }
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ManyToOne)) {
                return EntityAttribute.Cardinality.MANY_TO_ONE;
            }
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ManyToMany)) {
                return EntityAttribute.Cardinality.MANY_TO_MANY;
            }
            PsiAnnotation joinColumnAnnotation = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumn);
            if (joinColumnAnnotation != null) {
                return EntityAttribute.Cardinality.MANY_TO_ONE;
            }
            return null;
        }));
    }

    public boolean isMapsId(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.MapsId));
    }

    public String getMapsIdValue(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.getDeclaredStringAttributeValue((PsiModifierListOwner)member, JpaAttributeAnnotation.MapsId, "value"));
    }

    public LinkedHashMap<String, String> getJoinColumns(PsiMember member) {
        return (LinkedHashMap)EntityUtil.ra(() -> {
            LinkedHashMap<Object, Object> annJoinColumns;
            Project project = member.getProject();
            PsiAnnotation joinColumnAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumns);
            if (joinColumnAnn != null) {
                annJoinColumns = new LinkedHashMap<String, String>(AttributeUtil.getJoinColumns(joinColumnAnn, "value"));
            } else {
                annJoinColumns = new LinkedHashMap();
                for (PsiAnnotation joinColumnAnnotation : StudioAnnotationUtil.findAllJpbAnnotations((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumn)) {
                    JoinColumn joinColumnModel = AttributeUtil.createJoinColumnModel(joinColumnAnnotation);
                    if (joinColumnModel == null) continue;
                    annJoinColumns.put(joinColumnModel.getName(), joinColumnModel.getReferencedColumnName());
                }
            }
            Datatype type = this.getDatatype(member, true);
            if (!(type instanceof Entity)) {
                return annJoinColumns;
            }
            List<EntityAttribute> compKeyIdAttrs = ((Entity)type).getCompKeyIdAttrs();
            if (compKeyIdAttrs.isEmpty() || !annJoinColumns.isEmpty() && compKeyIdAttrs.size() != annJoinColumns.size()) {
                return annJoinColumns;
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            SpringImplicitNamingStrategy implicitNamingStrategy = SpringImplicitNamingStrategy.getInstance(project);
            for (int i = 0; i < compKeyIdAttrs.size(); ++i) {
                EntityAttribute embAttr = compKeyIdAttrs.get(i);
                String embAttrColumnName = EntityDesignHelper.getEmbeddedAttrColumnName((Entity)type, embAttr);
                if (embAttrColumnName == null) continue;
                String columnName = JpaUtils.getKeyFromValue(annJoinColumns, embAttrColumnName);
                if (!StringUtils.isBlank((CharSequence)columnName)) {
                    result.put(columnName, embAttrColumnName);
                    continue;
                }
                if (!annJoinColumns.isEmpty()) {
                    Map.Entry<Object, Object> entry = new ArrayList<Map.Entry<Object, Object>>(annJoinColumns.entrySet()).get(i);
                    result.put((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                result.put(implicitNamingStrategy.determineJoinColumnName(member.getName(), embAttrColumnName), embAttrColumnName);
            }
            return result;
        });
    }

    public boolean isOwner(PsiMember member) {
        Project project = member.getProject();
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> {
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinTable)) {
                return true;
            }
            PsiAnnotation cardinalityAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne, JpaAttributeAnnotation.ManyToOne, JpaAttributeAnnotation.OneToMany, JpaAttributeAnnotation.ManyToMany);
            if (cardinalityAnn == null) {
                return false;
            }
            if (StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumn)) {
                return true;
            }
            String mappedByValue = AnnotationUtil.getStringAttributeValue((PsiAnnotation)cardinalityAnn, (String)"mappedBy");
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)member);
            return StringUtils.isBlank((CharSequence)mappedByValue) && Arrays.asList(JpaAttributeAnnotation.OneToOne.getFqn(project, module), JpaAttributeAnnotation.ManyToMany.getFqn(project, module)).contains(cardinalityAnn.getQualifiedName());
        });
    }

    public EntityAttribute.NumberFormatStyle getNumberFormatStyle(PsiMember member) {
        return (EntityAttribute.NumberFormatStyle)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation numberFormatAnn = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"org.springframework.format.annotation.NumberFormat"});
            if (numberFormatAnn == null) {
                return null;
            }
            String styleValue = StudioAnnotationUtil.getDeclaredEnumStringValue(numberFormatAnn, "style");
            if (styleValue != null) {
                return (EntityAttribute.NumberFormatStyle)StringUtil.parseEnum((String)styleValue, null, EntityAttribute.NumberFormatStyle.class);
            }
            return EntityAttribute.NumberFormatStyle.DEFAULT;
        }));
    }

    public boolean isColumnNameExists(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Column, JpaAttributeAnnotation.JoinColumn));
    }

    public String getMappedBy(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation cardinalityAnn = StudioAnnotationUtil.findJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.OneToOne, JpaAttributeAnnotation.ManyToOne, JpaAttributeAnnotation.OneToMany, JpaAttributeAnnotation.ManyToMany);
            return cardinalityAnn == null || !cardinalityAnn.hasAttribute("mappedBy") ? null : AnnotationUtil.getStringAttributeValue((PsiAnnotation)cardinalityAnn, (String)"mappedBy");
        });
    }

    public String getNumberFormat(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.getStringAttributeValue((PsiModifierListOwner)member, "org.springframework.format.annotation.NumberFormat", "pattern"));
    }

    public boolean isId(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> (Boolean)ReadAction.nonBlocking(() -> StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.Id, JpaAttributeAnnotation.EmbeddedId)).executeSynchronously());
    }

    public boolean isElementCollection(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.hasJpbAnnotation((PsiModifierListOwner)member, JpaAttributeAnnotation.ElementCollection));
    }

    public boolean isNationalized(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)member, "org.hibernate.annotations.Nationalized"));
    }

    public String getReferencedColumnName(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> StudioAnnotationUtil.findAllJpbAnnotationsWithContainer((PsiModifierListOwner)member, JpaAttributeAnnotation.JoinColumns, JpaAttributeAnnotation.JoinColumn).stream().map(it -> AnnotationUtil.getStringAttributeValue((PsiAnnotation)it, (String)"referencedColumnName")).filter(it -> it != null && !it.isEmpty()).findFirst().orElse(null));
    }

    public String getCollectionTable(PsiMember member) {
        return (String)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotationMemberValue memberValue;
            PsiAnnotation collectionTableAnnotation = AttributeUtil.getCollectionTableAnnotation(member);
            if (collectionTableAnnotation != null && (memberValue = collectionTableAnnotation.findAttributeValue("name")) != null) {
                return AnnotationUtil.getStringAttributeValue((PsiAnnotationMemberValue)memberValue);
            }
            return null;
        });
    }

    public List<JoinColumn> getCollectionTableJoinColumns(PsiMember member) {
        return (List)EntityUtil.raPsiCached((PsiElement)member, () -> {
            PsiAnnotation collectionTableAnnotation = AttributeUtil.getCollectionTableAnnotation(member);
            if (collectionTableAnnotation != null) {
                return AttributeUtil.getJoinColumnModels(collectionTableAnnotation, "joinColumns");
            }
            return Collections.emptyList();
        });
    }

    public boolean isCreatedDateAudit(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)member, "org.springframework.data.annotation.CreatedDate"));
    }

    public boolean isCreatedByAudit(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)member, "org.springframework.data.annotation.CreatedBy"));
    }

    public boolean isLastModifiedByAudit(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)member, "org.springframework.data.annotation.LastModifiedBy"));
    }

    public boolean isLastModifiedDateAudit(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)member, "org.springframework.data.annotation.LastModifiedDate"));
    }

    public boolean isHibernateEnversAudited(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)member, "org.hibernate.envers.Audited"));
    }

    public boolean isHibernateEnversNotAudited(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasOneOfAnnotations((PsiModifierListOwner)member, "org.hibernate.envers.NotAudited"));
    }

    public boolean isRevisionNumber(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasAnnotation((PsiModifierListOwner)member, "org.hibernate.envers.RevisionNumber"));
    }

    public boolean isRevisionTimestamp(PsiMember member) {
        return (Boolean)EntityUtil.raPsiCached((PsiElement)member, () -> EntityUtil.hasAnnotation((PsiModifierListOwner)member, "org.hibernate.envers.RevisionTimestamp"));
    }

    public EntityAttribute.OnDeleteAction getOnDeleteAction(PsiMember member) {
        return (EntityAttribute.OnDeleteAction)((Object)EntityUtil.raPsiCached((PsiElement)member, () -> {
            String stringValue;
            PsiAnnotation annotation = member.getAnnotation("org.hibernate.annotations.OnDelete");
            if (annotation != null && (stringValue = StudioAnnotationUtil.getDeclaredEnumStringValue(annotation, "action")) != null) {
                return EntityAttribute.OnDeleteAction.valueOf(stringValue);
            }
            return null;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnAnn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/model/EntityAttributeCacheProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/model/EntityAttributeCacheProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatatype";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatatypeInternal";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatatypeNonCache";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isColumnAnnMandatory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJpaConverter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcTypeModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHibernateCustomType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHibernateJavaType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExternalDependencies";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultColumnName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

