/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.facet.nodes.ConfigFileNode;
import com.intellij.spring.facet.nodes.FileSetNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FilesetGroupNode
extends SimpleNode {
    private final Set<VirtualFilePointer> myChildren;
    private final FileSetNode myFilesetNode;

    protected FilesetGroupNode(@NotNull FileSetNode parent, @NotNull Set<VirtualFilePointer> children) {
        if (parent == null) {
            FilesetGroupNode.$$$reportNull$$$0(0);
        }
        if (children == null) {
            FilesetGroupNode.$$$reportNull$$$0(1);
        }
        super((SimpleNode)parent);
        this.myFilesetNode = parent;
        this.myChildren = children;
    }

    public SimpleNode @NotNull [] getChildren() {
        ArrayList<ConfigFileNode> nodes = new ArrayList<ConfigFileNode>(this.myChildren.size());
        for (VirtualFilePointer file : this.myChildren) {
            nodes.add(this.createNode(file));
        }
        if (this.getFilesetNode().getConfigurationTabSettings().isSortAlpha()) {
            nodes.sort(FileSetNode.FILENAME_COMPARATOR);
        }
        SimpleNode[] simpleNodeArray = nodes.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            FilesetGroupNode.$$$reportNull$$$0(2);
        }
        return simpleNodeArray;
    }

    protected ConfigFileNode createNode(VirtualFilePointer virtualFilePointer) {
        return new ConfigFileNode(this.getFilesetNode().getConfigurationTabSettings(), this.getFilesetNode().getFileSet(), virtualFilePointer, this);
    }

    protected FileSetNode getFilesetNode() {
        return this.myFilesetNode;
    }

    public Set<VirtualFilePointer> getFilePointers() {
        return this.myChildren;
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            FilesetGroupNode.$$$reportNull$$$0(3);
        }
        super.update(presentation);
        presentation.setPresentableText(this.getGroupName());
        presentation.setIcon(this.getGroupNodeIcon());
    }

    protected abstract String getGroupName();

    protected abstract Icon getGroupNodeIcon();

    public Object @NotNull [] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.getGroupName(), this.getParent()};
        if (objectArray == null) {
            FilesetGroupNode.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/nodes/FilesetGroupNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/nodes/FilesetGroupNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

