/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.SlowFacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.validation.SpringConfigurationCheckService;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnmappedConfigurationFilesValidator
extends FacetEditorValidator
implements SlowFacetEditorValidator {
    private static final int MAX_FILES_TO_SHOW = 5;
    private final Collection<SpringFileSet> myFileSets;
    private final Module myModule;

    public UnmappedConfigurationFilesValidator(Collection<SpringFileSet> fileSets, Module module) {
        this.myFileSets = fileSets;
        this.myModule = module;
    }

    @NotNull
    public ValidationResult check() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public CompletableFuture<ValidationResult> checkAsync() {
        HashSet<SpringFileSet> fileSets = new HashSet<SpringFileSet>(this.myFileSets);
        return SpringConfigurationCheckService.getInstance(this.myModule.getProject()).checkConfigurations(this.myModule, fileSets).thenApply(unmappedFiles -> {
            if (unmappedFiles.isEmpty()) {
                return ValidationResult.OK;
            }
            if (unmappedFiles.size() <= 5) {
                String filesText = StringUtil.join((Collection)unmappedFiles, (String)"<br/>");
                return new ValidationResult(SpringBundle.message("unmapped.configuration.files.full", unmappedFiles.size(), filesText));
            }
            return new ValidationResult(SpringBundle.message("unmapped.configuration.files.short", unmappedFiles.size()));
        });
    }
}

