/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiType;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransactionProxyFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.transaction.interceptor.TransactionProxyFactoryBean";
    @NonNls
    private static final String PROXY_INTERFACES_PROPERTY_NAME = "proxyInterfaces";
    @NonNls
    private static final String TARGET_PROPERTY_NAME = "target";

    @Override
    @NotNull
    public Set<PsiType> getObjectType(@Nullable CommonSpringBean context) {
        if (context instanceof SpringBean) {
            SpringBean springBean = (SpringBean)context;
            PsiType type = TransactionProxyFactoryBeanTypeResolver.getTargetType(springBean);
            if (type != null && this.isCglibExplicitlyEnabled(springBean)) {
                Set<PsiType> set = Collections.singleton(type);
                if (set == null) {
                    TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(0);
                }
                return set;
            }
            Set<String> proxyInterfaceNames = TransactionProxyFactoryBeanTypeResolver.getTypesFromClassArrayProperty(springBean, PROXY_INTERFACES_PROPERTY_NAME);
            if (!proxyInterfaceNames.isEmpty()) {
                Set<PsiType> set = SpringBeanCoreUtils.convertToNonNullTypes(proxyInterfaceNames, context);
                if (set == null) {
                    TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(1);
                }
                return set;
            }
            if (type != null) {
                Set<String> targetInterfaceNames = TransactionProxyFactoryBeanTypeResolver.getAllInterfaceNames(type);
                if (!targetInterfaceNames.isEmpty()) {
                    Set<PsiType> set = SpringBeanCoreUtils.convertToNonNullTypes(targetInterfaceNames, context);
                    if (set == null) {
                        TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(2);
                    }
                    return set;
                }
                Set<PsiType> set = Collections.singleton(type);
                if (set == null) {
                    TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(3);
                }
                return set;
            }
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    private static PsiType getTargetType(@NotNull SpringBean context) {
        if (context == null) {
            TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(5);
        }
        return TransactionProxyFactoryBeanTypeResolver.getTypeFromProperty(context, TARGET_PROPERTY_NAME);
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            TransactionProxyFactoryBeanTypeResolver.$$$reportNull$$$0(6);
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

