/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.beans;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.microservices.jvm.beans.BeanPresentation;
import com.intellij.microservices.jvm.beans.BeanStereotype;
import com.intellij.microservices.jvm.beans.BeansFilter;
import com.intellij.microservices.jvm.beans.BeansProvider;
import com.intellij.microservices.jvm.beans.BeansViewListener;
import com.intellij.microservices.jvm.beans.FrameworkBeansPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointAdapter;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.SpringInfrastructureBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.SpringToolWindowService;
import com.intellij.spring.toolWindow.beans.SpringBeanItem;
import com.intellij.spring.toolWindow.beans.SpringBeanStereotype;
import com.intellij.spring.toolWindow.beans.SpringBeansGroup;
import com.intellij.spring.toolWindow.beans.SpringBeansProviderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010 \u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0!H\u0016J\u001c\u0010\"\u001a\u00020\u00032\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0&2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0016\u0010,\u001a\u0004\u0018\u00010-2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010 \u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0003H\u0016J\u001a\u00102\u001a\u0004\u0018\u0001012\u0006\u0010 \u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0003H\u0016J \u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010 \u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00067"}, d2={"Lcom/intellij/spring/toolWindow/beans/SpringBeansProvider;", "Lcom/intellij/microservices/jvm/beans/BeansProvider;", "Lcom/intellij/spring/toolWindow/beans/SpringBeansGroup;", "Lcom/intellij/spring/toolWindow/beans/SpringBeanItem;", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/spring/toolWindow/beans/SpringBeanStereotype;", "stereotypes", "", "Lcom/intellij/microservices/jvm/beans/BeanStereotype;", "getStereotypes", "()Ljava/util/Collection;", "presentation", "Lcom/intellij/microservices/jvm/beans/FrameworkBeansPresentation;", "getPresentation", "()Lcom/intellij/microservices/jvm/beans/FrameworkBeansPresentation;", "getStatus", "Lcom/intellij/microservices/jvm/beans/BeansProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getBeanGroups", "", "filter", "Lcom/intellij/microservices/jvm/beans/BeansFilter;", "getSpringModels", "", "Lcom/intellij/spring/CommonSpringModel;", "module", "Lcom/intellij/openapi/module/Module;", "getBeans", "group", "", "convertToItem", "pointer", "Lcom/intellij/spring/model/SpringBeanPointer;", "getFilterCondition", "Lcom/intellij/openapi/util/Condition;", "isValidBean", "", "bean", "getBeanPresentation", "Lcom/intellij/microservices/jvm/beans/BeanPresentation;", "getPresentableType", "", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getNavigationElement", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringBeansProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeansProvider.kt\ncom/intellij/spring/toolWindow/beans/SpringBeansProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1374#2:205\n1460#2,5:206\n1563#2:211\n1634#2,3:212\n774#2:216\n865#2,2:217\n1563#2:219\n1634#2,3:220\n774#2:223\n865#2,2:224\n1617#2,9:226\n1869#2:235\n1870#2:237\n1626#2:238\n1#3:215\n1#3:236\n*S KotlinDebug\n*F\n+ 1 SpringBeansProvider.kt\ncom/intellij/spring/toolWindow/beans/SpringBeansProvider\n*L\n91#1:205\n91#1:206,5\n98#1:211\n98#1:212,3\n110#1:216\n110#1:217,2\n111#1:219\n111#1:220,3\n115#1:223\n115#1:224,2\n116#1:226,9\n116#1:235\n116#1:237\n116#1:238\n116#1:236\n*E\n"})
public final class SpringBeansProvider
implements BeansProvider<SpringBeansGroup, SpringBeanItem> {
    @NotNull
    private final ExtensionPointName<SpringBeanStereotype> EP_NAME = ExtensionPointName.Companion.create("com.intellij.spring.beans.stereotype");
    @NotNull
    private final FrameworkBeansPresentation presentation;

    public SpringBeansProvider() {
        this.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointAdapter<SpringBeanStereotype>(){

            public void extensionListChanged() {
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                for (Project project : projectArray) {
                    Intrinsics.checkNotNull((Object)project);
                    Project project2 = project;
                    ((BeansViewListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BeansViewListener.Companion.getTOPIC())).beansChanged(new BeansViewListener.ChangeEvent(project2, BeansViewListener.ChangeType.FLUSH));
                }
            }
        });
        this.presentation = SpringBeansProviderKt.getSPRING_FRAMEWORK_PRESENTATION();
    }

    @NotNull
    public Collection<BeanStereotype> getStereotypes() {
        ArrayList result2 = new ArrayList(SpringBeansProviderKt.access$getSPRING_STEREOTYPES$p());
        result2.addAll(this.EP_NAME.getExtensionList());
        return result2;
    }

    @NotNull
    public FrameworkBeansPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public BeansProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SpringLibraryUtil.hasSpringLibrary((Project)project) ? BeansProvider.Status.AVAILABLE : BeansProvider.Status.UNAVAILABLE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<SpringBeansGroup> getBeanGroups(@NotNull Project project, @NotNull BeansFilter filter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Module module = filter.getModule();
        if (!SpringCommonUtils.isSpringConfigured((Module)module)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = this.getSpringModels(module);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CommonSpringModel model = (CommonSpringModel)element$iv$iv;
            boolean bl = false;
            Collection collection = model instanceof CombinedSpringModel ? (Collection)((CombinedSpringModel)model).getUnderlyingModels() : (Collection)CollectionsKt.listOf((Object)model);
            Intrinsics.checkNotNull((Object)collection);
            list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (CommonSpringModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new SpringBeansGroup(module, (CommonSpringModel)it));
        }
        return (List)destination$iv$iv;
    }

    private final Set<CommonSpringModel> getSpringModels(Module module) {
        Set<LocalModel<?>> models;
        Set<LocalModel<?>> set;
        Set<LocalModel<?>> set2 = SpringManager.getInstance((Project)module.getProject()).getAllModelsWithoutDependencies(module);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAllModelsWithoutDependencies(...)");
        Set<LocalModel<?>> it = set = (models = set2);
        boolean bl = false;
        Set<Object> set3 = !((Collection)it).isEmpty() ? set : null;
        if (set3 == null) {
            Set<LocalModel<?>> set4 = SpringAutoConfiguredModels.getAutoConfiguredLocalModels(module);
            set3 = set4;
            Intrinsics.checkNotNullExpressionValue(set4, (String)"getAutoConfiguredLocalModels(...)");
        }
        return set3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<SpringBeanItem> getBeans(@NotNull SpringBeansGroup group, @NotNull List<? extends BeanStereotype> stereotypes) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(stereotypes, (String)"stereotypes");
        Project project = group.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Condition<SpringBeanPointer<?>> filterCondition = this.getFilterCondition(project);
        if (stereotypes.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            SpringBeanPointer it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection collection = group.getModel().getAllCommonBeans();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllCommonBeans(...)");
            Iterable iterable2 = collection;
            boolean $i$f$filter = false;
            void var6_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SpringBeanPointer)element$iv$iv;
                bl = false;
                if (!filterCondition.value((Object)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SpringBeanPointer)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection2.add(this.convertToItem(it, group.getModule()));
            }
            iterable = (List)destination$iv$iv;
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection collection = group.getModel().getAllCommonBeans();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllCommonBeans(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$filter = false;
            void $this$mapTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SpringBeanPointer it = (SpringBeanPointer)element$iv$iv;
                boolean bl = false;
                if (!filterCondition.value((Object)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SpringBeanItem springBeanItem;
                block7: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    SpringBeanPointer pointer = (SpringBeanPointer)element$iv$iv;
                    boolean bl2 = false;
                    for (BeanStereotype beanStereotype : stereotypes) {
                        Intrinsics.checkNotNull((Object)beanStereotype, (String)"null cannot be cast to non-null type com.intellij.spring.toolWindow.beans.SpringBeanStereotype");
                        SpringBeanStereotype springBeanStereotype = (SpringBeanStereotype)beanStereotype;
                        Intrinsics.checkNotNull((Object)pointer);
                        if (!springBeanStereotype.accept(pointer, group.getModule())) continue;
                        springBeanItem = new SpringBeanItem(pointer, (SpringBeanStereotype)beanStereotype);
                        break block7;
                    }
                    springBeanItem = null;
                }
                if (springBeanItem == null) continue;
                SpringBeanItem it$iv$iv = springBeanItem;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        }
        return iterable;
    }

    private final SpringBeanItem convertToItem(SpringBeanPointer<?> pointer, Module module) {
        for (SpringBeanStereotype stereotype : this.EP_NAME.getExtensionList()) {
            if (!stereotype.accept(pointer, module)) continue;
            return new SpringBeanItem(pointer, stereotype);
        }
        return new SpringBeanItem(pointer, null);
    }

    private final Condition<SpringBeanPointer<?>> getFilterCondition(Project project) {
        SpringBeansViewSettings settings = SpringBeansViewSettings.getInstance(project);
        boolean showImplicitBeans = settings.isShowImplicitBeans();
        boolean showInfrastructureBeans = settings.isShowInfrastructureBeans();
        return arg_0 -> SpringBeansProvider.getFilterCondition$lambda$0(showImplicitBeans, showInfrastructureBeans, arg_0);
    }

    public boolean isValidBean(@NotNull SpringBeansGroup group, @NotNull SpringBeanItem bean) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getPointer().isValid();
    }

    @NotNull
    public BeanPresentation getBeanPresentation(@NotNull SpringBeansGroup group, @NotNull SpringBeanItem bean) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        SpringBeanPointer pointer = bean.getPointer();
        PresentationData itemPresentation = new PresentationData(SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)pointer), FileUtilRt.getNameWithoutExtension((String)pointer.getContainingFile().getName()), SpringPresentationProvider.getSpringIcon((Object)pointer), null);
        String beanClassType = this.getPresentableType(pointer);
        return new BeanPresentation((ItemPresentation)itemPresentation, beanClassType, null);
    }

    private final String getPresentableType(SpringBeanPointer<?> pointer) {
        PsiType type = pointer.getSpringBean().getBeanType(true);
        if (type instanceof PsiLambdaExpressionType) {
            type = pointer.getSpringBean().getBeanType();
        }
        if (type instanceof PsiLambdaExpressionType) {
            return null;
        }
        PsiType psiType = type;
        return psiType != null ? psiType.getCanonicalText() : null;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SpringToolWindowService.Companion.getInstance(project).getBeansModificationTracker();
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull SpringBeansGroup group, @NotNull SpringBeanItem bean) {
        PsiMethod psiElement;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        SpringBeanPointer pointer = bean.getPointer();
        SpringBeanStereotype springBeanStereotype = bean.getStereotype();
        if (springBeanStereotype != null && (psiElement2 = springBeanStereotype.getDocumentationElement(pointer)) != null) {
            PsiElement it = psiElement2;
            boolean bl = false;
            return it;
        }
        PsiElement identifyingPsiElement = ((CommonModelElement)pointer.getSpringBean()).getIdentifyingPsiElement();
        if (!(identifyingPsiElement instanceof PomTargetPsiElement)) {
            return identifyingPsiElement;
        }
        PomTarget pomTarget = ((PomTargetPsiElement)identifyingPsiElement).getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)pomTarget, (String)"getTarget(...)");
        PomTarget target = pomTarget;
        JamPomTarget jamPomTarget = target instanceof JamPomTarget ? (JamPomTarget)target : null;
        JamElement jamElement = jamPomTarget != null ? jamPomTarget.getJamElement() : null;
        SpringJavaBean springJavaBean = jamElement instanceof SpringJavaBean ? (SpringJavaBean)jamElement : null;
        PsiMethod psiMethod = psiElement = springJavaBean != null ? springJavaBean.getPsiElement() : null;
        return psiMethod != null ? (PsiElement)psiMethod : identifyingPsiElement;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull SpringBeansGroup group, @NotNull SpringBeanItem bean) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getPointer().getPsiElement();
    }

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull SpringBeansGroup group, @NotNull SpringBeanItem bean) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        DataKey dataKey = LangDataKeys.MODULE_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"MODULE_CONTEXT");
        sink.lazy(dataKey, () -> SpringBeansProvider.uiDataSnapshot$lambda$0(group));
        DataKey dataKey2 = LangDataKeys.PSI_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PSI_ELEMENT");
        sink.lazy(dataKey2, () -> SpringBeansProvider.uiDataSnapshot$lambda$1(bean));
    }

    private static final boolean getFilterCondition$lambda$0(boolean $showImplicitBeans, boolean $showInfrastructureBeans, SpringBeanPointer it) {
        if (!$showImplicitBeans && it.getSpringBean() instanceof SpringImplicitBeanMarker) {
            return false;
        }
        return $showInfrastructureBeans || !(it.getSpringBean() instanceof SpringInfrastructureBean);
    }

    private static final Module uiDataSnapshot$lambda$0(SpringBeansGroup $group) {
        return $group.getModule();
    }

    private static final PsiElement uiDataSnapshot$lambda$1(SpringBeanItem $bean) {
        PsiElement psiElement = ((CommonModelElement)$bean.getPointer().getSpringBean()).getIdentifyingPsiElement();
        return psiElement != null ? psiElement.getNavigationElement() : null;
    }
}

