/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.DataGridUrlNavigationActionHelper;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.actions.NavigateUrlActionKt;
import com.intellij.database.run.actions.URLResolver;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/run/actions/NavigateUrlAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/database/run/actions/GridAction;", "urlResolver", "Lcom/intellij/database/run/actions/URLResolver;", "<init>", "(Lcom/intellij/database/run/actions/URLResolver;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.database.impl"})
public class NavigateUrlAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    private final URLResolver urlResolver;

    public NavigateUrlAction(@NotNull URLResolver urlResolver) {
        Intrinsics.checkNotNullParameter((Object)urlResolver, (String)"urlResolver");
        this.urlResolver = urlResolver;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (DataGridUrlNavigationActionHelper.INSTANCE.isMouseEventWithModifiers(e.getInputEvent(), ClientSystemInfo.Companion.isMac() ? 256 : 128)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (project == null || dataGrid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        URL url = this.urlResolver.tryParseUrl(DataGridUrlNavigationActionHelper.INSTANCE.getSelectedValue(dataGrid));
        boolean enabled = url != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || !Intrinsics.areEqual((Object)e.getPlace(), (Object)"TableFloatingToolbar"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (project == null || dataGrid == null) {
            return;
        }
        URL uRL = this.urlResolver.tryParseUrl(DataGridUrlNavigationActionHelper.INSTANCE.getSelectedValue(dataGrid));
        if (uRL == null) {
            return;
        }
        URL url = uRL;
        String string = url.getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProtocol(...)");
        if (!NavigateUrlActionKt.access$isPermissionForProtocolGiven(string)) {
            String string2 = url.getProtocol();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProtocol(...)");
            NavigateUrlActionKt.access$showNotificationToAllowUrlProtocolOpening(string2, project);
            return;
        }
        this.urlResolver.navigateUrl(url, project);
    }
}

