/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceExportImportHelperKt;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceSettingsCapsule;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.DbElementPasteProvider;
import com.intellij.database.view.DvUndoableAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import com.thoughtworks.xstream.io.StreamException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 d2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004abcdB\u0019\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010$\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0016\u0010(\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010/\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00100\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u00101\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0013J\u0010\u00103\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u00104\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0013H\u0002J\u0010\u00106\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u00107\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0010\u00108\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u00132\u0006\u0010;\u001a\u00020<H\u0002J\u001d\u0010>\u001a\u00020\u00132\u000e\u0010?\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010@H\u0002\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010D\u001a\u00020 2\u0006\u0010E\u001a\u00020:2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010F\u001a\u00020 2\u0006\u0010G\u001a\u00020A2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020I0&2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0JH\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010A2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010L\u001a\u0004\u0018\u00010A2\u0006\u0010M\u001a\u00020NH\u0002J\u0006\u0010O\u001a\u00020 J\u001a\u0010P\u001a\u00020 2\b\b\u0001\u0010Q\u001a\u00020A2\u0006\u0010R\u001a\u00020SH\u0002J5\u0010T\u001a\u00020 2\b\u0010U\u001a\u0004\u0018\u00010V2\b\b\u0001\u0010Q\u001a\u00020A2\u0012\u0010W\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150@\"\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010XJ=\u0010T\u001a\u00020 2\u0006\u0010Y\u001a\u00020Z2\b\u0010U\u001a\u0004\u0018\u00010V2\b\b\u0001\u0010Q\u001a\u00020A2\u0012\u0010W\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150@\"\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010[J.\u0010\\\u001a\u00020 2\b\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010]\u001a\u00020^2\b\b\u0001\u0010_\u001a\u00020A2\b\b\u0001\u0010`\u001a\u00020AH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006e"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/ide/CutProvider;", "Lcom/intellij/ide/PasteProvider;", "context", "Lcom/intellij/database/view/DatabaseTreeContext;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "<init>", "(Lcom/intellij/database/view/DatabaseTreeContext;Lcom/intellij/ui/treeStructure/Tree;)V", "defaultDelegator", "Lcom/intellij/ide/CopyPasteSupport;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isNodeCut", "", "node", "", "defaultCopyProvider", "getDefaultCopyProvider", "()Lcom/intellij/ide/CopyProvider;", "defaultCutProvider", "getDefaultCutProvider", "()Lcom/intellij/ide/CutProvider;", "defaultPasteProvider", "getDefaultPasteProvider", "()Lcom/intellij/ide/PasteProvider;", "performCopy", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "performCut", "doCopyDataSources", "dataSources", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "doCutDataSources", "isCopyEnabled", "isCopyVisible", "isCutEnabled", "isCutVisible", "isDataSourceCopyAndCutEnabled", "clipboardContainsDataSourcesOnlyAndItCanBeCopied", "isPastePossible", "isPasteEnabled", "isDataSourcePasteEnabled", "andVisible", "performPaste", "canPaste", "canShow", "doPaste", "doPasteDataSourceOrShowError", "tryToPasteDataSource", "tryToGetCapsule", "Lcom/intellij/database/dataSource/DataSourceSettingsCapsule;", "t", "Ljava/awt/datatransfer/Transferable;", "isOurFlavourSupported", "areCutDataSourcesSameAs", "ids", "", "", "([Ljava/lang/String;)Z", "doMoveDataSources", "doPasteDataSourcesFromCapsule", "capsule", "doPasteDataSourcesFromText", "text", "findDataSources", "Lcom/intellij/database/dataSource/AbstractDataSource;", "", "getPasteGroupPath", "getDataSourceGroupPath", "element", "Lcom/intellij/database/model/basic/BasicElement;", "undoCut", "doInsideCommand", "messageKey", "runnable", "Ljava/lang/Runnable;", "sayInBalloon", "icon", "Ljavax/swing/Icon;", "params", "(Ljavax/swing/Icon;Ljava/lang/String;[Ljava/lang/Object;)V", "notificationType", "Lcom/intellij/notification/NotificationType;", "(Lcom/intellij/notification/NotificationType;Ljavax/swing/Icon;Ljava/lang/String;[Ljava/lang/Object;)V", "sayInBalloon2", "number", "", "messageKey1", "messageKey2", "CutDataSourceUndoableAction", "MoveDataSourceUndoableAction", "PasteDataSourceUndoableAction", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseCopyPasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseCopyPasteProvider.kt\ncom/intellij/database/view/DatabaseCopyPasteProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,510:1\n1634#2,3:511\n1222#2,2:516\n1252#2,4:518\n1563#2:522\n1634#2,3:523\n1563#2:526\n1634#2,3:527\n13805#3,2:514\n*S KotlinDebug\n*F\n+ 1 DatabaseCopyPasteProvider.kt\ncom/intellij/database/view/DatabaseCopyPasteProvider\n*L\n109#1:511,3\n266#1:516,2\n266#1:518,4\n283#1:522\n283#1:523,3\n312#1:526\n312#1:527,3\n113#1:514,2\n*E\n"})
public final class DatabaseCopyPasteProvider
implements CopyProvider,
CutProvider,
PasteProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseTreeContext context;
    @NotNull
    private final Tree tree;
    @Nullable
    private final CopyPasteSupport defaultDelegator;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String notificationGroupId = "Data Source clipboard action";
    @NotNull
    private static final Icon iconOfCopy;
    @NotNull
    private static final Icon iconOfCut;
    @NotNull
    private static final Icon iconOfPaste;

    private final Project getProject() {
        return this.context.getProject();
    }

    public DatabaseCopyPasteProvider(@NotNull DatabaseTreeContext context, @NotNull Tree tree) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.context = context;
        this.tree = tree;
        this.defaultDelegator = (CopyPasteSupport)new CopyPasteDelegator(this.getProject(), (JComponent)tree);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final boolean isNodeCut(@NotNull Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.context.isNodeCut(node);
    }

    private final CopyProvider getDefaultCopyProvider() {
        CopyPasteSupport copyPasteSupport = this.defaultDelegator;
        return copyPasteSupport != null ? copyPasteSupport.getCopyProvider() : null;
    }

    private final CutProvider getDefaultCutProvider() {
        CopyPasteSupport copyPasteSupport = this.defaultDelegator;
        return copyPasteSupport != null ? copyPasteSupport.getCutProvider() : null;
    }

    private final PasteProvider getDefaultPasteProvider() {
        CopyPasteSupport copyPasteSupport = this.defaultDelegator;
        return copyPasteSupport != null ? copyPasteSupport.getPasteProvider() : null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        block1: {
            Collection<LocalDataSource> dataSources;
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (DatabaseCopyPasteProvider.Companion.getCopyDataSourceEnabled() && (dataSources = DatabaseViewTreeFun.getSelectedLocalDataSourcesIfOnly(dataContext)) != null) {
                this.doCopyDataSources(dataSources);
                return;
            }
            CopyProvider copyProvider = this.getDefaultCopyProvider();
            if (copyProvider == null) break block1;
            copyProvider.performCopy(dataContext);
        }
    }

    public void performCut(@NotNull DataContext dataContext) {
        block1: {
            Collection<LocalDataSource> dataSources;
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            if (DatabaseCopyPasteProvider.Companion.getCopyDataSourceEnabled() && (dataSources = DatabaseViewTreeFun.getSelectedLocalDataSourcesIfOnly(dataContext)) != null) {
                this.doInsideCommand("database.view.command.name.cut.data.sources", () -> DatabaseCopyPasteProvider.performCut$lambda$0(this, dataSources));
                return;
            }
            CutProvider cutProvider = this.getDefaultCutProvider();
            if (cutProvider == null) break block1;
            cutProvider.performCut(dataContext);
        }
    }

    private final void doCopyDataSources(Collection<? extends LocalDataSource> dataSources) {
        DataSourceSettingsHelperKt.doCopyDataSourceSettings(dataSources);
        this.sayInBalloon2(iconOfCopy, dataSources.size(), "database.view.data.sources.copied.1", "database.view.data.sources.copied.2");
    }

    /*
     * WARNING - void declaration
     */
    private final void doCutDataSources(Collection<? extends LocalDataSource> dataSources) {
        void $this$mapTo$iv;
        String string = DataSourceSettingsHelperKt.doCopyDataSourceSettings(dataSources);
        if (string == null) {
            return;
        }
        String text = string;
        Iterable iterable = dataSources;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            LocalDataSource localDataSource = (LocalDataSource)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getUniqueId());
        }
        LinkedHashSet cutIds = (LinkedHashSet)destination$iv;
        CutDataSourceUndoableAction undoableAction = new CutDataSourceUndoableAction(cutIds, text);
        UndoManager.getInstance((Project)this.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        this.context.assignCutDataSources((Iterable<? extends LocalDataSource>)dataSources);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            TreePath[] $this$forEach$iv = treePathArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                TreePath element$iv;
                TreePath path = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.tree.collapsePath(path);
            }
        }
        this.tree.clearSelection();
        this.sayInBalloon2(iconOfCut, dataSources.size(), "database.view.data.sources.cut.1", "database.view.data.sources.cut.2");
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourceCopyAndCutEnabled(dataContext)) {
            return true;
        }
        CopyProvider copyProvider = this.getDefaultCopyProvider();
        if (copyProvider == null) {
            return false;
        }
        CopyProvider dcp = copyProvider;
        return dcp.isCopyEnabled(dataContext);
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourceCopyAndCutEnabled(dataContext)) {
            return true;
        }
        CopyProvider copyProvider = this.getDefaultCopyProvider();
        if (copyProvider == null) {
            return false;
        }
        CopyProvider dcp = copyProvider;
        return dcp.isCopyVisible(dataContext);
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourceCopyAndCutEnabled(dataContext)) {
            return true;
        }
        CutProvider cutProvider = this.getDefaultCutProvider();
        if (cutProvider == null) {
            return false;
        }
        CutProvider dcp = cutProvider;
        return dcp.isCutEnabled(dataContext);
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (this.isDataSourceCopyAndCutEnabled(dataContext)) {
            return true;
        }
        CutProvider cutProvider = this.getDefaultCutProvider();
        if (cutProvider == null) {
            return false;
        }
        CutProvider dcp = cutProvider;
        return dcp.isCutVisible(dataContext);
    }

    public final boolean isDataSourceCopyAndCutEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.clipboardContainsDataSourcesOnlyAndItCanBeCopied(dataContext);
    }

    private final boolean clipboardContainsDataSourcesOnlyAndItCanBeCopied(DataContext dataContext) {
        if (DatabaseCopyPasteProvider.Companion.getCopyDataSourceEnabled()) {
            Collection<LocalDataSource> dataSources = DatabaseViewTreeFun.getSelectedLocalDataSourcesIfOnly(dataContext);
            return dataSources != null;
        }
        return false;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (DbElementPasteProvider.INSTANCE.canPasteElement(dataContext)) {
            return true;
        }
        if (this.isDataSourcePasteEnabled(dataContext, false)) {
            return true;
        }
        PasteProvider pasteProvider = this.getDefaultPasteProvider();
        if (pasteProvider == null) {
            return false;
        }
        PasteProvider dpp = pasteProvider;
        return dpp.isPastePossible(dataContext);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (DbElementPasteProvider.INSTANCE.canPasteElement(dataContext)) {
            return true;
        }
        if (this.isDataSourcePasteEnabled(dataContext, false)) {
            return true;
        }
        PasteProvider pasteProvider = this.getDefaultPasteProvider();
        if (pasteProvider == null) {
            return false;
        }
        PasteProvider dpp = pasteProvider;
        return dpp.isPasteEnabled(dataContext);
    }

    public final boolean isDataSourcePasteEnabled(@NotNull DataContext dataContext, boolean andVisible) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.canPaste(dataContext, andVisible);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        this.doPaste(dataContext);
    }

    private final boolean canPaste(DataContext dataContext, boolean canShow) {
        boolean ok2;
        Transferable transferable = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (transferable == null) {
            return false;
        }
        Transferable t = transferable;
        boolean bl = ok2 = t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR) || t.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (!ok2) {
            return false;
        }
        Object[] selectedNodes = DatabaseContextFun.getSelectedNodesArray(dataContext);
        int selectedNodesCount = selectedNodes.length;
        if (selectedNodesCount == 0) {
            return true;
        }
        if (selectedNodesCount >= 2) {
            return false;
        }
        if (!canShow) {
            return true;
        }
        BasicNode selectedNode = (BasicNode)ArraysKt.firstOrNull((Object[])selectedNodes);
        return selectedNode instanceof DasDataSource;
    }

    private final void doPaste(DataContext dataContext) {
        block2: {
            PasteProvider dpp;
            boolean ok2 = this.tryToPasteDataSource(dataContext);
            if (ok2) {
                return;
            }
            if (DbElementPasteProvider.INSTANCE.tryPasteElement(dataContext)) {
                return;
            }
            PasteProvider pasteProvider = dpp = this.getDefaultPasteProvider();
            if (pasteProvider == null) break block2;
            pasteProvider.performPaste(dataContext);
        }
    }

    public final void doPasteDataSourceOrShowError(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        boolean ok2 = this.tryToPasteDataSource(dataContext);
        if (!ok2) {
            this.sayInBalloon(NotificationType.ERROR, iconOfPaste, "database.view.clipboard.contains.no.data.source", new Object[0]);
        }
    }

    private final boolean tryToPasteDataSource(DataContext dataContext) {
        Transferable transferable = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (transferable == null) {
            return false;
        }
        Transferable t = transferable;
        DataSourceSettingsCapsule capsule = this.tryToGetCapsule(t);
        if (capsule != null) {
            if (this.context.isSomeDataSourceCut() && this.areCutDataSourcesSameAs(capsule.ids)) {
                this.doInsideCommand("database.view.command.name.move.data.sources", () -> DatabaseCopyPasteProvider.tryToPasteDataSource$lambda$0(this, dataContext));
            } else {
                this.doInsideCommand("database.view.command.name.paste.data.sources", () -> DatabaseCopyPasteProvider.tryToPasteDataSource$lambda$1(this, capsule, dataContext));
            }
            return true;
        }
        String string = ClipboardUtil.getTextInClipboard();
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return false;
        }
        String text = string;
        if (DataSourceExportImportHelperKt.isDataSourceSettings((String)text)) {
            if (DatabaseCopyPasteProvider.Companion.getCopyDataSourceEnabled()) {
                this.doInsideCommand("database.view.command.name.paste.data.sources", () -> DatabaseCopyPasteProvider.tryToPasteDataSource$lambda$2(this, text, dataContext));
            }
            return true;
        }
        return false;
    }

    private final DataSourceSettingsCapsule tryToGetCapsule(Transferable t) {
        if (this.isOurFlavourSupported(t)) {
            try {
                Object capsule = t.getTransferData(DataSourceSerializedSettingsTransferable.FLAVOR);
                return capsule instanceof DataSourceSettingsCapsule ? (DataSourceSettingsCapsule)capsule : null;
            }
            catch (UnsupportedFlavorException ufe) {
                log.debug("Failed to get capsule \u2014 unsupported flavor: " + ufe.getMessage(), (Throwable)ufe);
            }
            catch (IOException ioe) {
                log.debug("Failed to get capsule \u2014 IO error: " + ioe.getMessage(), (Throwable)ioe);
            }
            catch (Exception e) {
                log.warn("Failed to get capsule \u2014 unexpected exception " + e.getClass() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private final boolean isOurFlavourSupported(Transferable t) {
        return t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR);
    }

    private final boolean areCutDataSourcesSameAs(String[] ids) {
        String[] stringArray = ids;
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        if (!this.context.isSomeDataSourceCut()) {
            return false;
        }
        Set<String> set = this.context.getCutDataSourcesIds();
        if (set == null) {
            return false;
        }
        Set<String> cutIds = set;
        if (cutIds.isEmpty()) {
            return false;
        }
        Set set2 = ArraysKt.toSet((Object[])ids);
        return Intrinsics.areEqual(cutIds, (Object)set2);
    }

    /*
     * WARNING - void declaration
     */
    private final void doMoveDataSources(DataContext dataContext) {
        void $this$associateByTo$iv$iv;
        Set<String> set = this.context.getCutDataSourcesIds();
        if (set == null) {
            return;
        }
        Set<String> dataSourcesIds = set;
        Collection<AbstractDataSource> dataSources = this.findDataSources(dataSourcesIds);
        Iterable $this$associateBy$iv = dataSources;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string;
            AbstractDataSource it;
            AbstractDataSource abstractDataSource = (AbstractDataSource)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getUniqueId(), (String)"getUniqueId(...)");
            it = (AbstractDataSource)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.getGroupName();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string2;
            map2.put(string, string3);
        }
        Map oldPaths = destination$iv$iv;
        String newPath = this.getPasteGroupPath(dataContext);
        for (AbstractDataSource dataSource : dataSources) {
            DataSourceManager dataSourceManager = DataSourceManager.byDataSource((Project)this.getProject(), (RawDataSource)((RawDataSource)dataSource));
            if (dataSourceManager == null) continue;
            dataSourceManager.setGroupName((RawDataSource)dataSource, newPath);
        }
        MoveDataSourceUndoableAction undoableAction = new MoveDataSourceUndoableAction(dataSourcesIds, oldPaths, newPath);
        this.context.clearCut();
        UndoManager.getInstance((Project)this.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        this.context.invokeRefresh();
        this.sayInBalloon2(iconOfPaste, dataSources.size(), "database.view.data.sources.moved.1", "database.view.data.sources.moved.2");
    }

    /*
     * WARNING - void declaration
     */
    private final void doPasteDataSourcesFromCapsule(DataSourceSettingsCapsule capsule, DataContext dataContext) {
        void $this$mapTo$iv$iv;
        this.context.clearCut();
        String groupPath = this.getPasteGroupPath(dataContext);
        String string = capsule.content;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"content");
        String text = string;
        List<DbDataSource> importedDataSources = DataSourceSettingsHelperKt.importDataSourcesFromTextViaDialog(text, this.getProject(), groupPath);
        Iterable $this$map$iv = importedDataSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbDataSource dbDataSource = (DbDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUniqueId());
        }
        List importedIds = (List)destination$iv$iv;
        PasteDataSourceUndoableAction undoableAction = new PasteDataSourceUndoableAction(importedIds, text);
        UndoManager.getInstance((Project)this.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        this.sayInBalloon2(iconOfPaste, importedDataSources.size(), "database.view.data.sources.pasted.1", "database.view.data.sources.pasted.2");
    }

    /*
     * WARNING - void declaration
     */
    private final void doPasteDataSourcesFromText(String text, DataContext dataContext) {
        void $this$mapTo$iv$iv;
        List<DbDataSource> list;
        this.context.clearCut();
        String groupPath = this.getPasteGroupPath(dataContext);
        try {
            list = DataSourceSettingsHelperKt.importDataSourcesFromTextViaDialog(text, this.getProject(), groupPath);
        }
        catch (XmlPullParserException xpe) {
            DatabaseCopyPasteProvider.doPasteDataSourcesFromText$reportParsingError(this, (Exception)((Object)xpe));
            return;
        }
        catch (StreamException se) {
            DatabaseCopyPasteProvider.doPasteDataSourcesFromText$reportParsingError(this, (Exception)((Object)se));
            return;
        }
        List<DbDataSource> importedDataSources = list;
        Iterable $this$map$iv = importedDataSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbDataSource dbDataSource = (DbDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUniqueId());
        }
        List importedIds = (List)destination$iv$iv;
        PasteDataSourceUndoableAction undoableAction = new PasteDataSourceUndoableAction(importedIds, text);
        UndoManager.getInstance((Project)this.getProject()).undoableActionPerformed((UndoableAction)undoableAction);
        this.sayInBalloon2(iconOfPaste, importedDataSources.size(), "database.view.data.sources.pasted.1", "database.view.data.sources.pasted.2");
    }

    private final Collection<AbstractDataSource> findDataSources(Set<String> ids) {
        JBIterable jBIterable = DbUtil.getDataSources((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getDataSources(...)");
        Iterable allDataSources = (Iterable)jBIterable;
        ArrayList found = new ArrayList(ids.size());
        for (DbDataSource dds : allDataSources) {
            RawDataSource ds;
            if (!ids.contains(dds.getUniqueId()) || !((ds = DbImplUtil.unwrapDS((DasDataSource)((DasDataSource)dds))) instanceof AbstractDataSource)) continue;
            ((Collection)found).add(ds);
        }
        return found;
    }

    private final String getPasteGroupPath(DataContext dataContext) {
        BasicNode[] selectedNodes = DatabaseContextFun.getSelectedNodesArray(dataContext);
        if (selectedNodes.length == 0) {
            return null;
        }
        BasicNode node = selectedNodes[0];
        BasicNode basicNode = node;
        return basicNode instanceof DataSourceNode ? ((DataSourceNode)node).dataSource.getGroupName() : (basicNode instanceof BasicElement ? this.getDataSourceGroupPath((BasicElement)node) : null);
    }

    private final String getDataSourceGroupPath(BasicElement element) {
        RawDataSource dataSource;
        BasicModel basicModel = element.getModel();
        if (basicModel == null) {
            return null;
        }
        BasicModel model = basicModel;
        RawDataSource rawDataSource = dataSource = BasicModelRegistry.Companion.instance().getDataSource(model);
        return rawDataSource != null ? rawDataSource.getGroupName() : null;
    }

    public final void undoCut() {
        this.context.clearCut();
        this.context.invokeRefresh();
    }

    private final void doInsideCommand(@NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey, Runnable runnable) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), runnable, DatabaseBundle.message((String)messageKey, (Object[])new Object[0]), null);
    }

    private final void sayInBalloon(Icon icon, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey, Object ... params) {
        this.sayInBalloon(NotificationType.INFORMATION, icon, messageKey, Arrays.copyOf(params, params.length));
    }

    private final void sayInBalloon(NotificationType notificationType, Icon icon, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey, Object ... params) {
        ActionsKt.invokeLater$default(null, () -> DatabaseCopyPasteProvider.sayInBalloon$lambda$0(messageKey, params, notificationType, icon, this), (int)1, null);
    }

    private final void sayInBalloon2(Icon icon, int number, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey1, @NotNull @PropertyKey(resourceBundle="messages.DatabaseBundle") String messageKey2) {
        if (number == 1) {
            this.sayInBalloon(icon, messageKey1, new Object[0]);
        } else if (number >= 2) {
            Object[] objectArray = new Object[]{number};
            this.sayInBalloon(icon, messageKey2, objectArray);
        }
    }

    private static final void performCut$lambda$0(DatabaseCopyPasteProvider this$0, Collection $dataSources) {
        this$0.doCutDataSources($dataSources);
    }

    private static final void tryToPasteDataSource$lambda$0(DatabaseCopyPasteProvider this$0, DataContext $dataContext) {
        this$0.doMoveDataSources($dataContext);
    }

    private static final void tryToPasteDataSource$lambda$1(DatabaseCopyPasteProvider this$0, DataSourceSettingsCapsule $capsule, DataContext $dataContext) {
        this$0.doPasteDataSourcesFromCapsule($capsule, $dataContext);
    }

    private static final void tryToPasteDataSource$lambda$2(DatabaseCopyPasteProvider this$0, String $text, DataContext $dataContext) {
        this$0.doPasteDataSourcesFromText($text, $dataContext);
    }

    private static final void doPasteDataSourcesFromText$reportParsingError(DatabaseCopyPasteProvider this$0, Exception exception) {
        Throwable e = exception;
        while (e.getCause() != null) {
            Intrinsics.checkNotNull((Object)e.getCause());
        }
        String exceptionMessage = e.getClass().getName() + ": " + e.getMessage();
        log.warn("Failed to import data sources from text: " + exceptionMessage);
        Object[] objectArray = new Object[]{exceptionMessage};
        this$0.sayInBalloon(NotificationType.ERROR, iconOfPaste, "database.view.clipboard.contains.unexpected.data", objectArray);
    }

    private static final Unit sayInBalloon$lambda$0(String $messageKey, Object[] $params, NotificationType $notificationType, Icon $icon, DatabaseCopyPasteProvider this$0) {
        String string = DatabaseBundle.message((String)$messageKey, (Object[])Arrays.copyOf($params, $params.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String messageText = string;
        new Notification(notificationGroupId, messageText, $notificationType).setIcon($icon).notify(this$0.context.getProject());
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(DatabaseCopyPasteProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        Icon icon = AllIcons.Actions.Copy;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Copy");
        iconOfCopy = icon;
        Icon icon2 = AllIcons.Actions.MenuCut;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"MenuCut");
        iconOfCut = icon2;
        Icon icon3 = AllIcons.Actions.MenuPaste;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"MenuPaste");
        iconOfPaste = icon3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "copyDataSourceEnabled", "", "getCopyDataSourceEnabled", "()Z", "notificationGroupId", "", "iconOfCopy", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "iconOfCut", "iconOfPaste", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getCopyDataSourceEnabled() {
            return Registry.Companion.is("database.view.copy.datasource", true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$CutDataSourceUndoableAction;", "Lcom/intellij/database/view/DvUndoableAction;", "dataSourceIds", "", "", "dataSourcesText", "<init>", "(Lcom/intellij/database/view/DatabaseCopyPasteProvider;Ljava/lang/Iterable;Ljava/lang/String;)V", "getDataSourcesText", "()Ljava/lang/String;", "performedNanoTime", "", "dsIds", "", "cancelled", "", "getPerformedNanoTime", "setPerformedNanoTime", "", "l", "undo", "redo", "intellij.database.impl"})
    public final class CutDataSourceUndoableAction
    implements DvUndoableAction {
        @NotNull
        private final String dataSourcesText;
        private long performedNanoTime;
        @NotNull
        private final Set<String> dsIds;
        private boolean cancelled;

        public CutDataSourceUndoableAction(@NotNull Iterable<String> dataSourceIds, String dataSourcesText) {
            Intrinsics.checkNotNullParameter(dataSourceIds, (String)"dataSourceIds");
            Intrinsics.checkNotNullParameter((Object)dataSourcesText, (String)"dataSourcesText");
            this.dataSourcesText = dataSourcesText;
            this.performedNanoTime = -1L;
            this.dsIds = CollectionsKt.toSet(dataSourceIds);
        }

        @NotNull
        public final String getDataSourcesText() {
            return this.dataSourcesText;
        }

        public long getPerformedNanoTime() {
            return this.performedNanoTime;
        }

        public void setPerformedNanoTime(long l) {
            this.performedNanoTime = l;
        }

        public void undo() {
            if (this.cancelled) {
                return;
            }
            DatabaseCopyPasteProvider.this.undoCut();
            this.cancelled = true;
        }

        public void redo() {
            if (!this.cancelled) {
                return;
            }
            DatabaseCopyPasteProvider.this.context.assignCutDataSourcesIds((Iterable<String>)this.dsIds);
            this.cancelled = false;
            DatabaseCopyPasteProvider.this.context.invokeRefresh();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$MoveDataSourceUndoableAction;", "Lcom/intellij/database/view/DvUndoableAction;", "dataSourceIds", "", "", "oldPaths", "", "newPath", "<init>", "(Lcom/intellij/database/view/DatabaseCopyPasteProvider;Ljava/util/Set;Ljava/util/Map;Ljava/lang/String;)V", "getNewPath", "()Ljava/lang/String;", "performedNanoTime", "", "undone", "", "getPerformedNanoTime", "setPerformedNanoTime", "", "l", "undo", "redo", "intellij.database.impl"})
    public final class MoveDataSourceUndoableAction
    implements DvUndoableAction {
        @NotNull
        private final Set<String> dataSourceIds;
        @NotNull
        private final Map<String, String> oldPaths;
        @Nullable
        private final String newPath;
        private long performedNanoTime;
        private boolean undone;

        public MoveDataSourceUndoableAction(@NotNull Set<String> dataSourceIds, @Nullable Map<String, String> oldPaths, String newPath) {
            Intrinsics.checkNotNullParameter(dataSourceIds, (String)"dataSourceIds");
            Intrinsics.checkNotNullParameter(oldPaths, (String)"oldPaths");
            this.dataSourceIds = dataSourceIds;
            this.oldPaths = oldPaths;
            this.newPath = newPath;
            this.performedNanoTime = -1L;
        }

        @Nullable
        public final String getNewPath() {
            return this.newPath;
        }

        public long getPerformedNanoTime() {
            return this.performedNanoTime;
        }

        public void setPerformedNanoTime(long l) {
            this.performedNanoTime = l;
        }

        public void undo() {
            if (this.undone) {
                return;
            }
            Collection dataSources = DatabaseCopyPasteProvider.this.findDataSources(this.dataSourceIds);
            for (AbstractDataSource dataSource : dataSources) {
                DataSourceManager dataSourceManager = DataSourceManager.byDataSource((Project)DatabaseCopyPasteProvider.this.getProject(), (RawDataSource)((RawDataSource)dataSource));
                if (dataSourceManager == null) continue;
                dataSourceManager.setGroupName((RawDataSource)dataSource, StringKt.nullize$default((String)this.oldPaths.get(dataSource.getUniqueId()), (boolean)false, (int)1, null));
            }
            DatabaseCopyPasteProvider.this.context.assignCutDataSourcesIds((Iterable<String>)this.dataSourceIds);
            this.undone = true;
            DatabaseCopyPasteProvider.this.context.invokeRefresh();
        }

        public void redo() {
            if (!this.undone) {
                return;
            }
            Collection dataSources = DatabaseCopyPasteProvider.this.findDataSources(this.dataSourceIds);
            for (AbstractDataSource dataSource : dataSources) {
                DataSourceManager dataSourceManager = DataSourceManager.byDataSource((Project)DatabaseCopyPasteProvider.this.getProject(), (RawDataSource)((RawDataSource)dataSource));
                if (dataSourceManager == null) continue;
                dataSourceManager.setGroupName((RawDataSource)dataSource, this.newPath);
            }
            this.undone = false;
            DatabaseCopyPasteProvider.this.context.invokeRefresh();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/view/DatabaseCopyPasteProvider$PasteDataSourceUndoableAction;", "Lcom/intellij/database/view/DvUndoableAction;", "dataSourceIds", "", "", "dataSourcesText", "<init>", "(Lcom/intellij/database/view/DatabaseCopyPasteProvider;Ljava/lang/Iterable;Ljava/lang/String;)V", "performedNanoTime", "", "dsIds", "", "undone", "", "getPerformedNanoTime", "setPerformedNanoTime", "", "l", "undo", "redo", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseCopyPasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseCopyPasteProvider.kt\ncom/intellij/database/view/DatabaseCopyPasteProvider$PasteDataSourceUndoableAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,510:1\n1634#2,3:511\n*S KotlinDebug\n*F\n+ 1 DatabaseCopyPasteProvider.kt\ncom/intellij/database/view/DatabaseCopyPasteProvider$PasteDataSourceUndoableAction\n*L\n457#1:511,3\n*E\n"})
    public final class PasteDataSourceUndoableAction
    implements DvUndoableAction {
        @NotNull
        private final String dataSourcesText;
        private long performedNanoTime;
        @NotNull
        private Set<String> dsIds;
        private boolean undone;

        public PasteDataSourceUndoableAction(@NotNull Iterable<String> dataSourceIds, String dataSourcesText) {
            Intrinsics.checkNotNullParameter(dataSourceIds, (String)"dataSourceIds");
            Intrinsics.checkNotNullParameter((Object)dataSourcesText, (String)"dataSourcesText");
            this.dataSourcesText = dataSourcesText;
            this.performedNanoTime = -1L;
            this.dsIds = CollectionsKt.toSet(dataSourceIds);
        }

        public long getPerformedNanoTime() {
            return this.performedNanoTime;
        }

        public void setPerformedNanoTime(long l) {
            this.performedNanoTime = l;
        }

        public void undo() {
            if (this.undone) {
                return;
            }
            DataSourceSettingsHelperKt.removeDataSources(DatabaseCopyPasteProvider.this.getProject(), this.dsIds);
            this.undone = true;
        }

        /*
         * WARNING - void declaration
         */
        public void redo() {
            void $this$mapTo$iv;
            if (!this.undone) {
                return;
            }
            Collection<LocalDataSource> dataSources = DataSourceSettingsHelperKt.importDataSourcesFromTextDirectly(this.dataSourcesText, DatabaseCopyPasteProvider.this.getProject(), null);
            Iterable iterable = dataSources;
            Collection collection = new LinkedHashSet();
            PasteDataSourceUndoableAction pasteDataSourceUndoableAction = this;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                void destination$iv;
                LocalDataSource localDataSource = (LocalDataSource)item$iv;
                void var10_10 = destination$iv;
                boolean bl = false;
                var10_10.add(it.getUniqueId());
            }
            pasteDataSourceUndoableAction.dsIds = (Set)collection;
            this.undone = false;
        }
    }
}

