/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprBinary;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtTransformer;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.Arrays;

public class StmtRelAssign
extends Stmt {
    private final String relname;
    private final String[] domainNames;
    private RelExpr expr;

    public StmtRelAssign(String relname, String[] domainNames, RelExpr expr, Context context) {
        super(context, expr);
        this.relname = relname;
        this.domainNames = domainNames;
        this.expr = expr;
    }

    public String getRelName() {
        return this.relname;
    }

    public String[] getDomainNames() {
        return this.domainNames;
    }

    public RelExpr getExpr() {
        return this.expr;
    }

    @Override
    public void accept(StmtVisitor visitor2) {
        if (visitor2.visitRelAssignStart(this)) {
            this.expr.accept(visitor2);
        }
        visitor2.visitRelAssignEnd(this);
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.expr = this.expr.transform(transformer);
        return transformer.transformRelAssign(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        IRelation result;
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        cancellation.checkCancelled();
        Domain[] canonicalDomains = variablesManager.getRelationDomains(this.relname);
        Domain[] domains = this.pushDomains(variablesManager, domainsPool);
        IRelation oldResult = result = this.expr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        if (this.expr instanceof RelExprBinary && ((RelExprBinary)this.expr).isUpdateOperation()) {
            result = result.reorderDomains(canonicalDomains);
        } else {
            result = result.reorderDomains(domains);
            result = result.fastRename(canonicalDomains, cancellation);
        }
        oldResult.kill();
        this.popDomains(variablesManager);
        variablesManager.storeRelation(this.relname, result);
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
    }

    public Domain[] pushDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain[] domains = new Domain[this.domainNames.length];
        for (int i = 0; i < this.domainNames.length; ++i) {
            domains[i] = domainsPool.getDomain(this, this.domainNames[i]);
            variablesManager.storeDomain(this.domainNames[i], domains[i]);
        }
        return domains;
    }

    public void popDomains(RuntimeVariablesManager variablesManager) {
        for (String name : this.domainNames) {
            variablesManager.removeDomain(name);
        }
    }

    @Override
    public String toLongString() {
        return "StmtRelAssign{\n\trelname='" + this.relname + "'\n\tnames=" + Arrays.toString(this.domainNames) + "\n\texpr=" + this.expr.toLongString() + "\n}";
    }

    @Override
    public String toShortString() {
        return this.relname + "(" + String.join((CharSequence)", ", this.domainNames) + ") = " + this.expr.toShortString();
    }
}

