/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommon;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFileImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeFacetNodeDescriptor<F extends JavaeeFacet>
extends JamNodeDescriptor<F> {
    public static final DataKey<JavaeeFacet> FACET_NODE_KEY = DataKey.create((String)"javaee.facet.context");
    private final F myFacet;

    protected JavaeeFacetNodeDescriptor(F facet, Object parameters) {
        super(facet.getModule().getProject(), null, parameters, facet);
        this.myFacet = facet;
    }

    protected JavaeeFacetNodeDescriptor(F facet, NodeDescriptor parentDescriptor, Object parameters) {
        super(facet.getModule().getProject(), parentDescriptor, parameters, facet);
        this.myFacet = facet;
    }

    public F getFacet() {
        return this.myFacet;
    }

    public String getNewTooltip() {
        F facet = this.getFacet();
        return facet.getType().getPresentableName();
    }

    public String getNewNodeText() {
        if (this.getFacet().isDisposed()) {
            return null;
        }
        return JavaeeUtil.getFacetWithModuleName(this.getFacet());
    }

    @Nullable
    protected final FacetAsVirtualFileImpl getVirtualFile() {
        return FacetAsVirtualFileImpl.fileByPath(this.getFacet());
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            JavaeeFacetNodeDescriptor.$$$reportNull$$$0(0);
        }
        super.uiDataSnapshot(sink);
        sink.set(FACET_NODE_KEY, this.getFacet());
        sink.lazy(LangDataKeys.MODULE_CONTEXT, () -> ((JavaeeFacet)this.getJamElement()).getModule());
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> this.getVirtualFile());
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            FacetAsVirtualFileImpl file = this.getVirtualFile();
            return file != null ? new OpenFileDescriptor(this.getProject(), (VirtualFile)file) : null;
        });
    }

    public DeleteProvider getDeleteProvider() {
        return null;
    }

    public boolean isValid() {
        return !((JavaeeFacet)this.getJamElement()).isDisposed() && !((JavaeeFacet)this.getJamElement()).getModule().isDisposed() && ((JavaeeFacetCommon)this.getFacet()).getCommonPart().isAllDescriptorsValid();
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Nullable
    public Icon getNewIcon() {
        return this.getFacet().getType().getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/javaee/module/view/nodes/JavaeeFacetNodeDescriptor", "uiDataSnapshot"));
    }
}

