/*
 * Decompiled with CFR 0.152.
 */
package org.testng.util;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.TimeZone;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static String formatTimeInLocalOrSpecifiedTimeZone(long timeInMilliSeconds, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        TimeZone timeZone = RuntimeBehavior.getTimeZone();
        sdf.setTimeZone(timeZone);
        return sdf.format(timeInMilliSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void computeAndShowTime(String msg, Task task) {
        Instant start = Instant.now();
        try {
            task.execute();
        }
        finally {
            Instant finish = Instant.now();
            long timeElapsed = Duration.between(start, finish).toMillis();
            String text = msg + " took " + timeElapsed + " ms.";
            Utils.log(text);
            if (timeElapsed > 20000L) {
                Utils.log("[WARNING] Probable slow call ( > 20 seconds): " + text);
            }
        }
    }

    @FunctionalInterface
    public static interface Task {
        public void execute();
    }
}

