/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.split;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionBase;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtil;
import com.intellij.jupyter.core.core.impl.actions.mode.JupyterCommandModeActionsHelper;
import com.intellij.jupyter.core.core.impl.actions.split.NotebookSplitCellActionKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/split/NotebookSplitCellAction;", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellLinesActionBase;", "<init>", "()V", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "intellij.jupyter.core"})
public final class NotebookSplitCellAction
extends NotebookCellLinesActionBase {
    private NotebookSplitCellAction() {
    }

    @Override
    @NotNull
    public JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive((Function1<? super JupyterActonUpdater.Builder, Unit>)((Function1)NotebookSplitCellAction::createActionUpdater$lambda$0));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event, @NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        if (SystemInfo.isMac) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - NotebookSplitCellActionKt.access$getLastTimeActionPerformed$p() < 200L) {
                return;
            }
            NotebookSplitCellActionKt.access$setLastTimeActionPerformed$p(currentTime);
        }
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        WriteCommandAction.writeCommandAction((Project)project2).withName(this.getTemplateText()).run(() -> NotebookSplitCellAction.actionPerformed$lambda$0(cellLines, editor));
    }

    private static final Unit createActionUpdater$lambda$0(JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)NotebookSplitCellAction::createActionUpdater$lambda$0$0));
        $this$derive.addEnabledAndVisibleProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)NotebookSplitCellAction::createActionUpdater$lambda$0$1));
        return Unit.INSTANCE;
    }

    private static final boolean createActionUpdater$lambda$0$0(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return !JupyterCommandModeActionsHelper.INSTANCE.isCommandModeActionEnabled(dataContext);
    }

    private static final boolean createActionUpdater$lambda$0$1(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JupyterCell jupyterCell = JupyterDataContextExtensionsKt.getSelectedJupyterCell(dataContext);
        if (jupyterCell == null || (jupyterCell = jupyterCell.getCellTypeProvider()) == null) {
            return true;
        }
        return jupyterCell.isSplitActionSupported();
    }

    private static final void actionPerformed$lambda$0(NotebookCellLines $cellLines, EditorImpl $editor) {
        NotebookCellLines.Interval cell = (NotebookCellLines.Interval)$cellLines.intervalsIterator($editor.getCaretModel().getLogicalPosition().line).next();
        NotebookCellLinesEditHelper helper = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)$editor);
        NotebookCellLinesActionUtil.INSTANCE.trySplitCellAtOffset((Editor)$editor, cell, $editor.getCaretModel().getOffset(), $cellLines, helper);
    }
}

