/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.jdbc.JdbcRowFetcher;
import com.intellij.database.remote.jdba.jdbc.JdbcRowsCollector;
import com.intellij.database.remote.jdba.jdbc.JdbcValueGetter;
import com.intellij.util.ArrayUtilRt;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public final class JdbcRowsCollectors {
    public static ExistenceCollector createExistenceCollector() {
        return new ExistenceCollector();
    }

    public static <R> SingleRowCollector<R> createSingleRowCollector(JdbcRowFetcher<R> fetcher) {
        return new SingleRowCollector(fetcher);
    }

    public static <R> ArrayCollector<R> createArrayCollector(JdbcRowFetcher<R> fetcher) {
        return new ArrayCollector(fetcher);
    }

    public static ArrayOfIntsCollector createArrayOfIntsCollector(int initialCapacity) {
        return new ArrayOfIntsCollector(initialCapacity);
    }

    public static ArrayOfLongsCollector createArrayOfLongsCollector(int initialCapacity) {
        return new ArrayOfLongsCollector(initialCapacity);
    }

    public static <R> ListCollector<R> createListCollector(JdbcRowFetcher<R> fetcher) {
        return new ListCollector(fetcher);
    }

    public static <K, V> HashMapCollector<K, V> createHashMapCollector(JdbcValueGetter<K> keyGetter, JdbcValueGetter<V> valueGetter) {
        return new HashMapCollector(keyGetter, valueGetter);
    }

    public static <K extends Comparable<K>, V> SortedMapCollector<K, V> createSortedMapCollector(JdbcValueGetter<K> keyGetter, JdbcValueGetter<V> valueGetter) {
        return new SortedMapCollector(keyGetter, valueGetter);
    }

    protected static class ExistenceCollector
    extends JdbcRowsCollector<Boolean> {
        protected ExistenceCollector() {
        }

        @Override
        protected Boolean collectRows(@NotNull ResultSet rset, int limit) {
            if (rset == null) {
                ExistenceCollector.$$$reportNull$$$0(0);
            }
            return this.hasMoreRows;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowsCollectors$ExistenceCollector", "collectRows"));
        }
    }

    protected static final class SingleRowCollector<R>
    extends JdbcRowsCollector<R> {
        private final JdbcRowFetcher<R> fetcher;

        private SingleRowCollector(JdbcRowFetcher<R> fetcher) {
            this.fetcher = fetcher;
        }

        @Override
        protected R collectRows(@NotNull ResultSet rset, int limit) throws SQLException {
            if (rset == null) {
                SingleRowCollector.$$$reportNull$$$0(0);
            }
            R result = this.fetcher.fetchRow(rset);
            this.hasMoreRows = rset.next();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowsCollectors$SingleRowCollector", "collectRows"));
        }
    }

    protected static final class ArrayCollector<R>
    extends CollectionCollector<R, R[]> {
        private ArrayCollector(JdbcRowFetcher<R> fetcher) {
            super(fetcher);
        }

        @Override
        protected R[] collectRows(@NotNull ResultSet rset, int limit) throws SQLException {
            Object[] array;
            List list;
            int n;
            if (rset == null) {
                ArrayCollector.$$$reportNull$$$0(0);
            }
            if ((n = (list = this.collectRowsAsList(rset, limit)).size()) > 0) {
                Class<?> rowClass = list.get(0).getClass();
                array = (Object[])Array.newInstance(rowClass, n);
                array = list.toArray(array);
            } else {
                array = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            return array;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowsCollectors$ArrayCollector", "collectRows"));
        }
    }

    protected static final class ArrayOfIntsCollector
    extends JdbcRowsCollector<int[]> {
        private final int initialCapacity;

        private ArrayOfIntsCollector(int initialCapacity) {
            this.initialCapacity = initialCapacity;
        }

        @Override
        protected int[] collectRows(@NotNull ResultSet rset, int limit) throws SQLException {
            if (rset == null) {
                ArrayOfIntsCollector.$$$reportNull$$$0(0);
            }
            int k = 0;
            int[] array = new int[this.initialCapacity];
            int len = array.length;
            while (this.hasMoreRows && k < limit) {
                if (k >= len) {
                    int newSize = len <= 4096 ? len << 1 : len + (len >> 1);
                    array = Arrays.copyOf(array, newSize);
                    len = array.length;
                }
                int value = rset.getInt(1);
                array[k++] = value;
                this.hasMoreRows = rset.next();
            }
            if (k != array.length) {
                array = Arrays.copyOf(array, k);
            }
            return array;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowsCollectors$ArrayOfIntsCollector", "collectRows"));
        }
    }

    protected static final class ArrayOfLongsCollector
    extends JdbcRowsCollector<long[]> {
        private final int initialCapacity;

        private ArrayOfLongsCollector(int initialCapacity) {
            this.initialCapacity = initialCapacity;
        }

        @Override
        protected long[] collectRows(@NotNull ResultSet rset, int limit) throws SQLException {
            if (rset == null) {
                ArrayOfLongsCollector.$$$reportNull$$$0(0);
            }
            int k = 0;
            long[] array = new long[this.initialCapacity];
            int len = array.length;
            while (this.hasMoreRows && k < limit) {
                if (k >= len) {
                    int newSize = len <= 4096 ? len << 1 : len + (len >> 1);
                    array = Arrays.copyOf(array, newSize);
                    len = array.length;
                }
                long value = rset.getLong(1);
                array[k++] = value;
                this.hasMoreRows = rset.next();
            }
            if (k != array.length) {
                array = Arrays.copyOf(array, k);
            }
            return array;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowsCollectors$ArrayOfLongsCollector", "collectRows"));
        }
    }

    protected static final class ListCollector<R>
    extends CollectionCollector<R, List<R>> {
        private ListCollector(JdbcRowFetcher<R> fetcher) {
            super(fetcher);
        }

        @Override
        protected List<R> collectRows(@NotNull ResultSet rset, int limit) throws SQLException {
            if (rset == null) {
                ListCollector.$$$reportNull$$$0(0);
            }
            return this.collectRowsAsList(rset, limit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowsCollectors$ListCollector", "collectRows"));
        }
    }

    protected static final class HashMapCollector<K, V>
    extends MapCollector<K, V> {
        private HashMapCollector(JdbcValueGetter<K> keyGetter, JdbcValueGetter<V> valueGetter) {
            super(keyGetter, valueGetter);
        }

        @Override
        @NotNull
        protected Map<K, V> instantiate(int limit) {
            return new HashMap(Math.min(limit, 1000));
        }
    }

    protected static final class SortedMapCollector<K extends Comparable<K>, V>
    extends MapCollector<K, V> {
        private SortedMapCollector(JdbcValueGetter<K> keyGetter, JdbcValueGetter<V> valueGetter) {
            super(keyGetter, valueGetter);
        }

        @Override
        @NotNull
        protected Map<K, V> instantiate(int limit) {
            return new TreeMap();
        }
    }

    protected static abstract class MapCollector<K, V>
    extends JdbcRowsCollector<Map<K, V>> {
        private final JdbcValueGetter<K> keyGetter;
        private final JdbcValueGetter<V> valueGetter;

        private MapCollector(JdbcValueGetter<K> keyGetter, JdbcValueGetter<V> valueGetter) {
            this.keyGetter = keyGetter;
            this.valueGetter = valueGetter;
        }

        @Override
        protected Map<K, V> collectRows(@NotNull ResultSet rset, int limit) throws SQLException {
            if (rset == null) {
                MapCollector.$$$reportNull$$$0(0);
            }
            Map<K, V> result = this.instantiate(limit);
            while (this.hasMoreRows && result.size() < limit) {
                K k = this.keyGetter.getValue(rset, 1);
                V v = this.valueGetter.getValue(rset, 2);
                result.put(k, v);
                this.hasMoreRows = rset.next();
            }
            return result;
        }

        @NotNull
        protected abstract Map<K, V> instantiate(int var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowsCollectors$MapCollector", "collectRows"));
        }
    }

    protected static abstract class CollectionCollector<R, C>
    extends JdbcRowsCollector<C> {
        private final JdbcRowFetcher<R> fetcher;

        private CollectionCollector(JdbcRowFetcher<R> fetcher) {
            this.fetcher = fetcher;
        }

        protected List<R> collectRowsAsList(@NotNull ResultSet rset, int limit) throws SQLException {
            if (rset == null) {
                CollectionCollector.$$$reportNull$$$0(0);
            }
            ArrayList<R> result = new ArrayList<R>(Math.min(limit, 1000));
            while (this.hasMoreRows && result.size() < limit) {
                R row = this.fetcher.fetchRow(rset);
                result.add(row);
                this.hasMoreRows = rset.next();
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rset", "com/intellij/database/remote/jdba/jdbc/JdbcRowsCollectors$CollectionCollector", "collectRowsAsList"));
        }
    }
}

