/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.mapping.svg;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.canvas.CanvasProvider;
import org.jetbrains.letsPlot.datamodel.mapping.framework.Mapper;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLocatable;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPlatformPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextContent;
import org.jetbrains.letsPlot.datamodel.svg.style.StyleSheet;
import org.jetbrains.letsPlot.raster.mapping.svg.SvgNodeMapper;
import org.jetbrains.letsPlot.raster.mapping.svg.TextMeasurer;
import org.jetbrains.letsPlot.raster.shape.Container;
import org.jetbrains.letsPlot.raster.shape.Element;
import org.jetbrains.letsPlot.raster.shape.Node;
import org.jetbrains.letsPlot.raster.shape.Text;
import org.jetbrains.letsPlot.raster.shape.UtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0010J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J&\u0010'\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000b2\u0016\u0010(\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u000b\u0012\u0006\b\u0001\u0012\u00020\r0)J \u0010*\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRJ\u0010\t\u001a>\u0012\u0004\u0012\u00020\u000b\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u000b\u0012\u0006\b\u0001\u0012\u00020\r0\f0\nj\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u000b\u0012\u0006\b\u0001\u0012\u00020\r0\f`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006."}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgCanvasPeer;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPlatformPeer;", "textMeasurer", "Lorg/jetbrains/letsPlot/raster/mapping/svg/TextMeasurer;", "canvasProvider", "Lorg/jetbrains/letsPlot/core/canvas/CanvasProvider;", "(Lorg/jetbrains/letsPlot/raster/mapping/svg/TextMeasurer;Lorg/jetbrains/letsPlot/core/canvas/CanvasProvider;)V", "getCanvasProvider", "()Lorg/jetbrains/letsPlot/core/canvas/CanvasProvider;", "myMappingMap", "Ljava/util/HashMap;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;", "Lorg/jetbrains/letsPlot/raster/shape/Element;", "Lkotlin/collections/HashMap;", "<set-?>", "Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "styleSheet", "getStyleSheet", "()Lorg/jetbrains/letsPlot/datamodel/svg/style/StyleSheet;", "getTextMeasurer", "()Lorg/jetbrains/letsPlot/raster/mapping/svg/TextMeasurer;", "applyStyleSheet", "", "applyTransform", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "relative", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgLocatable;", "point", "ensureSourceRegistered", "source", "getBBox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "element", "getComputedTextLength", "", "node", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextContent;", "invertTransform", "registerMapper", "mapper", "Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgNodeMapper;", "transformCoordinates", "inverse", "", "unregisterMapper", "plot-raster"})
@SourceDebugExtension(value={"SMAP\nSvgCanvasPeer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvgCanvasPeer.kt\norg/jetbrains/letsPlot/raster/mapping/svg/SvgCanvasPeer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,110:1\n1313#2,2:111\n*S KotlinDebug\n*F\n+ 1 SvgCanvasPeer.kt\norg/jetbrains/letsPlot/raster/mapping/svg/SvgCanvasPeer\n*L\n102#1:111,2\n*E\n"})
public final class SvgCanvasPeer
implements SvgPlatformPeer {
    @NotNull
    private final TextMeasurer textMeasurer;
    @NotNull
    private final CanvasProvider canvasProvider;
    @NotNull
    private final HashMap<SvgNode, Mapper<? extends SvgNode, ? extends Element>> myMappingMap;
    @Nullable
    private StyleSheet styleSheet;

    public SvgCanvasPeer(@NotNull TextMeasurer textMeasurer, @NotNull CanvasProvider canvasProvider) {
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        Intrinsics.checkNotNullParameter((Object)canvasProvider, (String)"canvasProvider");
        this.textMeasurer = textMeasurer;
        this.canvasProvider = canvasProvider;
        this.myMappingMap = new HashMap();
    }

    @NotNull
    public final TextMeasurer getTextMeasurer() {
        return this.textMeasurer;
    }

    @NotNull
    public final CanvasProvider getCanvasProvider() {
        return this.canvasProvider;
    }

    @Nullable
    public final StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public final void applyStyleSheet(@NotNull StyleSheet styleSheet) {
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        this.styleSheet = styleSheet;
    }

    private final void ensureSourceRegistered(SvgNode source) {
        if (!this.myMappingMap.containsKey(source)) {
            throw new IllegalStateException("Trying to call platform peer method of unmapped node: " + Reflection.getOrCreateKotlinClass(source.getClass()).getSimpleName());
        }
    }

    public final void registerMapper(@NotNull SvgNode source, @NotNull SvgNodeMapper<? extends SvgNode, ? extends Element> mapper) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        ((Map)this.myMappingMap).put(source, mapper);
    }

    public final void unregisterMapper(@NotNull SvgNode source) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Object object = this.myMappingMap.remove(source);
            if (object == null || (object = (Element)object.getTarget()) == null) break block0;
            ((Node)object).release();
        }
    }

    public double getComputedTextLength(@NotNull SvgTextContent node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        throw new IllegalStateException("UNSUPPORTED: getComputedTextLength".toString());
    }

    private final DoubleVector transformCoordinates(SvgLocatable relative, DoubleVector point, boolean inverse) {
        throw new IllegalStateException("UNSUPPORTED: transformCoordinates".toString());
    }

    @NotNull
    public DoubleVector invertTransform(@NotNull SvgLocatable relative, @NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.transformCoordinates(relative, point, true);
    }

    @NotNull
    public DoubleVector applyTransform(@NotNull SvgLocatable relative, @NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.transformCoordinates(relative, point, false);
    }

    @NotNull
    public DoubleRectangle getBBox(@NotNull SvgLocatable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.ensureSourceRegistered((SvgNode)element);
        Mapper<? extends SvgNode, ? extends Element> mapper = this.myMappingMap.get(element);
        Intrinsics.checkNotNull(mapper);
        Element target = (Element)mapper.getTarget();
        if (target instanceof Container) {
            Sequence<Element> $this$forEach$iv = UtilKt.breadthFirstTraversal(target);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it = (Element)element$iv;
                boolean bl = false;
                if (!(it instanceof Text)) continue;
                ((Text)it).layoutChildren();
            }
        }
        return target.getLocalBounds();
    }
}

