/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiDecoratorInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass psiClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        PsiAnnotation decoratorAnno;
        if (psiClass == null) {
            CdiDecoratorInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiDecoratorInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiDecoratorInspection.$$$reportNull$$$0(2);
        }
        if ((decoratorAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{CdiAnnoConstants.DECORATOR_ANNOTATION.fqn((PsiElement)psiClass)})) != null) {
            CdiDecoratorInspection.checkDecoratorIsNotFinal(psiClass, holder);
            CdiDecoratorInspection.checkDecoratesInjectionPoints(psiClass, holder, decoratorAnno);
            CdiDecoratorInspection.checkInconsistentAnnotations(psiClass, holder, decoratorAnno, CdiAnnoConstants.INTERCEPTOR_ANNOTATION.fqn((PsiElement)psiClass));
        } else {
            CdiDecoratorInspection.checkDelegateInconsistency(psiClass, holder);
        }
    }

    private static void checkDecoratorIsNotFinal(PsiClass psiClass, ProblemsHolder holder) {
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty("final")) {
            CdiDecoratorInspection.registerProblem(holder, CdiDecoratorInspection.getIdentifyingElement((PsiModifierListOwner)psiClass), CdiInspectionBundle.message("CdiDecoratorInspection.class.cannot.be.final", new Object[0]));
        }
    }

    private static void checkDelegateInconsistency(PsiClass psiClass, ProblemsHolder holder) {
        for (Pair<PsiAnnotation, PsiModifierListOwner> pair : CdiDecoratorInspection.getDecoratesInjectionPoints(psiClass)) {
            CdiDecoratorInspection.registerProblem(holder, CdiDecoratorInspection.getIdentifyingElement((PsiModifierListOwner)pair.getSecond()), CdiInspectionBundle.message("CdiDecoratorInspection.class.must.be.decorator", new Object[0]));
        }
    }

    private static void checkInconsistentAnnotations(PsiClass psiClass, ProblemsHolder holder, PsiAnnotation decoratorAnno, String annotation) {
        PsiAnnotation anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{annotation});
        if (anno != null) {
            CdiDecoratorInspection.registerProblem(holder, CdiDecoratorInspection.getIdentifyingElement(decoratorAnno), CdiInspectionBundle.message("CdiDecoratorInspection.annotation.not.allowed.for.decorator", anno.getQualifiedName()));
        }
    }

    private static void checkDecoratesInjectionPoints(PsiClass psiClass, ProblemsHolder holder, PsiAnnotation decoratorAnno) {
        Set<Pair<PsiAnnotation, PsiModifierListOwner>> decorates = CdiDecoratorInspection.getDecoratesInjectionPoints(psiClass);
        if (decorates.isEmpty()) {
            CdiDecoratorInspection.registerProblem(holder, CdiDecoratorInspection.getIdentifyingElement(decoratorAnno), CdiInspectionBundle.message("CdiDecoratorInspection.cannot.find.decorates", new Object[0]));
        }
        if (decorates.size() > 1) {
            CdiDecoratorInspection.registerProblem(holder, CdiDecoratorInspection.getIdentifyingElement(decoratorAnno), CdiInspectionBundle.message("CdiDecoratorInspection.too.many.decorates.in.decorator", new Object[0]));
        }
        for (Pair<PsiAnnotation, PsiModifierListOwner> decorate : decorates) {
            CdiDecoratorInspection.checkIsInterfaceAndImplementsAllDecoratorInterfaces(holder, decorate, psiClass);
            CdiDecoratorInspection.checkIsDelegateInjected(holder, decorate);
        }
    }

    private static void checkIsDelegateInjected(ProblemsHolder holder, Pair<PsiAnnotation, PsiModifierListOwner> decorate) {
        PsiField field;
        PsiModifierListOwner owner = (PsiModifierListOwner)decorate.getSecond();
        if (owner instanceof PsiParameter) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiMethod.class);
            if (method != null && method.getNameIdentifier() != null) {
                if (method.isConstructor() || CdiAnnoConstants.INJECT_ANNOTATION.isAnnotated((PsiModifierListOwner)method, 0)) {
                    return;
                }
                CdiDecoratorInspection.registerProblem(holder, CdiDecoratorInspection.getIdentifyingElement((PsiModifierListOwner)method), CdiInspectionBundle.message("CdiDecoratorInspection.injection.point.must.be.constructor.or.initializer", new Object[0]));
            }
        } else if (owner instanceof PsiField && !CdiAnnoConstants.INJECT_ANNOTATION.isAnnotated((PsiModifierListOwner)(field = (PsiField)owner), 1)) {
            CdiDecoratorInspection.registerProblem(holder, CdiDecoratorInspection.getIdentifyingElement((PsiModifierListOwner)field), CdiInspectionBundle.message("CdiDecoratorInspection.delegate.injection.point.expected", new Object[0]));
        }
    }

    private static void checkIsInterfaceAndImplementsAllDecoratorInterfaces(ProblemsHolder holder, Pair<PsiAnnotation, PsiModifierListOwner> decorate, PsiClass psiClass) {
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)decorate.second;
        PsiType type = CdiDecoratorInspection.getType(modifierListOwner);
        if (type == null) {
            return;
        }
        PsiClass decoratesClass = ((PsiClassType)type).resolve();
        HashSet unsupportedInterfaces = new HashSet();
        InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, superPsiClass -> {
            if ("java.io.Serializable".equals(superPsiClass.getQualifiedName())) {
                return true;
            }
            if (superPsiClass.isInterface() && !InheritanceUtil.isInheritorOrSelf((PsiClass)decoratesClass, (PsiClass)superPsiClass, (boolean)true)) {
                unsupportedInterfaces.add(superPsiClass.getQualifiedName());
            }
            return true;
        });
        if (!unsupportedInterfaces.isEmpty()) {
            String[] strings = ArrayUtilRt.toStringArray(unsupportedInterfaces);
            CdiDecoratorInspection.registerProblem(holder, CdiDecoratorInspection.getIdentifyingElement(modifierListOwner), CdiInspectionBundle.message("CdiDecoratorInspection.decorates.type.must.implements.all.decorator.interfaces", StringUtil.join((String[])strings, (String)",")));
        }
    }

    @Nullable
    private static PsiType getType(PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner instanceof PsiField) {
            return ((PsiField)modifierListOwner).getType();
        }
        if (modifierListOwner instanceof PsiParameter) {
            return ((PsiParameter)modifierListOwner).getType();
        }
        return null;
    }

    @NotNull
    private static Set<Pair<PsiAnnotation, PsiModifierListOwner>> getDecoratesInjectionPoints(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiDecoratorInspection.$$$reportNull$$$0(3);
        }
        HashSet<Pair<PsiAnnotation, PsiModifierListOwner>> decorates = new HashSet<Pair<PsiAnnotation, PsiModifierListOwner>>();
        String delegateAnno = CdiAnnoConstants.DELEGATE_ANNOTATION.fqn((PsiElement)psiClass);
        for (PsiField psiField : psiClass.getFields()) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, (String[])new String[]{delegateAnno});
            if (annotation == null) continue;
            decorates.add((Pair<PsiAnnotation, PsiModifierListOwner>)new Pair((Object)annotation, (Object)psiField));
        }
        for (PsiField psiField : psiClass.getMethods()) {
            for (PsiParameter psiParameter : psiField.getParameterList().getParameters()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiParameter, (String[])new String[]{delegateAnno});
                if (annotation == null) continue;
                decorates.add((Pair<PsiAnnotation, PsiModifierListOwner>)new Pair((Object)annotation, (Object)psiParameter));
            }
        }
        HashSet<Pair<PsiAnnotation, PsiModifierListOwner>> hashSet = decorates;
        if (hashSet == null) {
            CdiDecoratorInspection.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiDecoratorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiDecoratorInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecoratesInjectionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDecoratesInjectionPoints";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

