/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "<init>", "()V", "canImport", "", "typeName", "", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfig", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "TestKind", "Companion", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnitRunConfigurationImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitRunConfigurationImporter.kt\ncom/intellij/execution/junit/JUnitRunConfigurationImporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n295#2:115\n296#2:120\n11561#3:116\n11896#3,3:117\n1#4:121\n*S KotlinDebug\n*F\n+ 1 JUnitRunConfigurationImporter.kt\ncom/intellij/execution/junit/JUnitRunConfigurationImporter\n*L\n56#1:115\n56#1:120\n56#1:116\n56#1:117,3\n*E\n"})
public final class JUnitRunConfigurationImporter
implements RunConfigurationImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)"junit", (Object)typeName);
    }

    /*
     * WARNING - void declaration
     */
    public void process(@NotNull Project project, @NotNull RunConfiguration runConfig, @NotNull Map<String, ?> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Object object;
        Object v0;
        JUnitConfiguration.Data data;
        block12: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
            if (!(runConfig instanceof JUnitConfiguration)) {
                throw new IllegalArgumentException("Unexpected type of run configuration: " + runConfig.getClass());
            }
            data = ((JUnitConfiguration)runConfig).getPersistentData();
            Iterable $this$firstOrNull$iv = cfg.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                void $this$mapTo$iv$iv;
                String it = (String)element$iv;
                boolean bl = false;
                TestKind[] $this$map$iv = TestKind.values();
                boolean $i$f$map = false;
                TestKind[] testKindArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void testKind;
                    void item$iv$iv;
                    void var21_22 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(testKind.getDslName());
                }
                if (!(((List)destination$iv$iv).contains(it) && cfg.get(it) != null)) continue;
                v0 = element$iv;
                break block12;
            }
            v0 = null;
        }
        String testKindName = v0;
        if (testKindName != null) {
            ObjectUtils.consumeIfCast(cfg.get(testKindName), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$2(arg_0 -> JUnitRunConfigurationImporter.process$lambda$1(data, testKindName, arg_0), arg_0));
        }
        Object repeatValue = cfg.get("repeat");
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)runConfig;
        Object obj = repeatValue;
        if (Intrinsics.areEqual(obj, (Object)"untilStop")) {
            object = "Until Stopped";
        } else if (Intrinsics.areEqual(obj, (Object)"untilFailure")) {
            object = "Until Failure";
        } else if (Intrinsics.areEqual(obj, (Object)"untilSuccess")) {
            object = "Until Success";
        } else if (obj instanceof Number) {
            Object element$iv;
            String string = "N Times";
            element$iv = string;
            JUnitConfiguration jUnitConfiguration2 = jUnitConfiguration;
            boolean bl = false;
            ((JUnitConfiguration)runConfig).setRepeatCount(((Number)repeatValue).intValue());
            jUnitConfiguration = jUnitConfiguration2;
            object = string;
        } else {
            object = ((JUnitConfiguration)runConfig).getRepeatMode();
        }
        jUnitConfiguration.setRepeatMode((String)object);
        ObjectUtils.consumeIfCast(cfg.get("vmParameters"), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$5(arg_0 -> JUnitRunConfigurationImporter.process$lambda$4(runConfig, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("workingDirectory"), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$7(arg_0 -> JUnitRunConfigurationImporter.process$lambda$6(runConfig, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("passParentEnvs"), Boolean.TYPE, arg_0 -> JUnitRunConfigurationImporter.process$lambda$9(arg_0 -> JUnitRunConfigurationImporter.process$lambda$8(runConfig, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("envs"), Map.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$11(arg_0 -> JUnitRunConfigurationImporter.process$lambda$10(runConfig, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("moduleName"), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$13(arg_0 -> JUnitRunConfigurationImporter.process$lambda$12(modelsProvider, runConfig, arg_0), arg_0));
        ObjectUtils.consumeIfCast(cfg.get("shortenCommandLine"), String.class, arg_0 -> JUnitRunConfigurationImporter.process$lambda$15(arg_0 -> JUnitRunConfigurationImporter.process$lambda$14(runConfig, arg_0), arg_0));
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = ((JUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(JUnitConfigurationType.class)).getConfigurationFactories()[0];
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"get(...)");
        return configurationFactory;
    }

    private static final Unit process$lambda$1(JUnitConfiguration.Data $data, String $testKindName, String testKindValue) {
        JUnitConfiguration.Data data = $data;
        TestKind testKind = TestKind.Companion.byDslName($testKindName);
        data.TEST_OBJECT = switch (testKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[testKind.ordinal()]) {
            case 1 -> {
                String var3_3;
                String var4_9 = var3_3 = "package";
                JUnitConfiguration.Data var8_15 = data;
                boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$1 = false;
                $data.PACKAGE_NAME = testKindValue;
                data = var8_15;
                yield var3_3;
            }
            case 2 -> {
                String var3_4;
                String it = var3_4 = "directory";
                JUnitConfiguration.Data var8_16 = data;
                boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$2 = false;
                $data.setDirName(testKindValue);
                data = var8_16;
                yield var3_4;
            }
            case 3 -> {
                String var3_5;
                String it = var3_5 = "pattern";
                JUnitConfiguration.Data var8_17 = data;
                boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$3 = false;
                Intrinsics.checkNotNull((Object)testKindValue);
                char[] var6_27 = new char[]{','};
                $data.setPatterns(new LinkedHashSet<String>(StringsKt.split$default((CharSequence)testKindValue, (char[])var6_27, (boolean)false, (int)0, (int)6, null)));
                data = var8_17;
                yield var3_5;
            }
            case 4 -> {
                String var3_6;
                String it = var3_6 = "class";
                JUnitConfiguration.Data var8_18 = data;
                boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$4 = false;
                $data.MAIN_CLASS_NAME = testKindValue;
                data = var8_18;
                yield var3_6;
            }
            case 5 -> {
                String var3_7;
                String it = var3_7 = "method";
                JUnitConfiguration.Data var8_19 = data;
                boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$5 = false;
                Intrinsics.checkNotNull((Object)testKindValue);
                String className = StringsKt.substringBefore$default((String)testKindValue, (char)'#', null, (int)2, null);
                String methodName = StringsKt.substringAfter$default((String)testKindValue, (char)'#', null, (int)2, null);
                $data.MAIN_CLASS_NAME = className;
                $data.METHOD_NAME = methodName;
                data = var8_19;
                yield var3_7;
            }
            case 6 -> {
                String var3_8;
                String it = var3_8 = "category";
                JUnitConfiguration.Data var8_20 = data;
                boolean $i$a$-also-JUnitRunConfigurationImporter$process$1$6 = false;
                $data.setCategoryName(testKindValue);
                data = var8_20;
                yield var3_8;
            }
            case -1 -> $data.TEST_OBJECT;
            default -> throw new NoWhenBranchMatchedException();
        };
        return Unit.INSTANCE;
    }

    private static final void process$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$4(RunConfiguration $runConfig, String it) {
        ((JUnitConfiguration)$runConfig).setVMParameters(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$6(RunConfiguration $runConfig, String it) {
        ((JUnitConfiguration)$runConfig).setWorkingDirectory(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$8(RunConfiguration $runConfig, Boolean it) {
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)$runConfig;
        Intrinsics.checkNotNull((Object)it);
        jUnitConfiguration.setPassParentEnvs(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$10(RunConfiguration $runConfig, Map it) {
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)$runConfig;
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        jUnitConfiguration.setEnvs(it);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$12(IdeModifiableModelsProvider $modelsProvider, RunConfiguration $runConfig, String it) {
        Module module = $modelsProvider.getModifiableModuleModel().findModuleByName(it);
        if (module != null) {
            ((JUnitConfiguration)$runConfig).setModule(module);
        }
        return Unit.INSTANCE;
    }

    private static final void process$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$14(RunConfiguration $runConfig, String it) {
        try {
            JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)$runConfig;
            Intrinsics.checkNotNull((Object)it);
            jUnitConfiguration.setShortenCommandLine(ShortenCommandLine.valueOf((String)it));
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Illegal value of 'shortenCommandLine': " + it, (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final void process$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(JUnitRunConfigurationImporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.junit"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0082\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind;", "", "dslName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDslName", "()Ljava/lang/String;", "PACKAGE_NAME", "DIRECTORY", "PATTERN", "CLASS", "METHOD", "CATEGORY", "Companion", "intellij.junit"})
    private static final class TestKind
    extends Enum<TestKind> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String dslName;
        public static final /* enum */ TestKind PACKAGE_NAME;
        public static final /* enum */ TestKind DIRECTORY;
        public static final /* enum */ TestKind PATTERN;
        public static final /* enum */ TestKind CLASS;
        public static final /* enum */ TestKind METHOD;
        public static final /* enum */ TestKind CATEGORY;
        private static final /* synthetic */ TestKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TestKind(String dslName) {
            this.dslName = dslName;
        }

        @NotNull
        public final String getDslName() {
            return this.dslName;
        }

        public static TestKind[] values() {
            return (TestKind[])$VALUES.clone();
        }

        public static TestKind valueOf(String value) {
            return Enum.valueOf(TestKind.class, value);
        }

        @NotNull
        public static EnumEntries<TestKind> getEntries() {
            return $ENTRIES;
        }

        static {
            PACKAGE_NAME = new TestKind("packageName");
            DIRECTORY = new TestKind("directory");
            PATTERN = new TestKind("pattern");
            CLASS = new TestKind("class");
            METHOD = new TestKind("method");
            CATEGORY = new TestKind("category");
            $VALUES = testKindArray = new TestKind[]{TestKind.PACKAGE_NAME, TestKind.DIRECTORY, TestKind.PATTERN, TestKind.CLASS, TestKind.METHOD, TestKind.CATEGORY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind$Companion;", "", "<init>", "()V", "byDslName", "Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind;", "dslName", "", "intellij.junit"})
        @SourceDebugExtension(value={"SMAP\nJUnitRunConfigurationImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitRunConfigurationImporter.kt\ncom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final TestKind byDslName(@NotNull String dslName) {
                TestKind testKind;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)dslName, (String)"dslName");
                    TestKind[] testKindArray = TestKind.values();
                    int n = testKindArray.length;
                    for (int i = 0; i < n; ++i) {
                        TestKind testKind2;
                        TestKind it = testKind2 = testKindArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDslName(), (Object)dslName)) continue;
                        testKind = testKind2;
                        break block1;
                    }
                    testKind = null;
                }
                return testKind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestKind.values().length];
            try {
                nArray[TestKind.PACKAGE_NAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestKind.DIRECTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestKind.PATTERN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestKind.CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestKind.METHOD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestKind.CATEGORY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

