/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.profiler.api.monitor.JavaProcessMonitor;
import com.intellij.util.ConcurrencyUtil;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.module.FindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 52\u00020\u0001:\u000245B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u0010J-\u0010(\u001a\u0002H)\"\b\b\u0000\u0010)*\u00020*2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H)0.H\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020'H\u0016J\b\u00101\u001a\u00020,H\u0016J\u0010\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020,H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0016\u001a\u0004\b#\u0010$\u00a8\u00066"}, d2={"Lcom/intellij/profiler/api/monitor/JMXProcessMonitor;", "Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "pid", "", "<init>", "(I)V", "getPid", "()I", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "Lorg/jetbrains/annotations/NotNull;", "vm", "Lcom/sun/tools/attach/VirtualMachine;", "connector", "Ljavax/management/remote/JMXConnector;", "notificationListener", "Ljavax/management/NotificationListener;", "osBean", "Lcom/sun/management/OperatingSystemMXBean;", "getOsBean", "()Lcom/sun/management/OperatingSystemMXBean;", "osBean$delegate", "Lkotlin/Lazy;", "memoryBean", "Ljava/lang/management/MemoryMXBean;", "getMemoryBean", "()Ljava/lang/management/MemoryMXBean;", "memoryBean$delegate", "threadBean", "Ljava/lang/management/ThreadMXBean;", "getThreadBean", "()Ljava/lang/management/ThreadMXBean;", "threadBean$delegate", "diagnosticBean", "Lcom/sun/management/HotSpotDiagnosticMXBean;", "getDiagnosticBean", "()Lcom/sun/management/HotSpotDiagnosticMXBean;", "diagnosticBean$delegate", "addNotificationListener", "", "getMXBean", "T", "Ljava/lang/management/PlatformManagedObject;", "beanName", "", "beanInterface", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/management/PlatformManagedObject;", "close", "dumpThreads", "dumpHeap", "filePath", "NonLocalAddressException", "Companion", "intellij.profiler.common"})
public final class JMXProcessMonitor
extends JavaProcessMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pid;
    @NotNull
    private final ThreadPoolExecutor executor;
    @Nullable
    private final VirtualMachine vm;
    @Nullable
    private final JMXConnector connector;
    @Nullable
    private NotificationListener notificationListener;
    @NotNull
    private final Lazy osBean$delegate;
    @NotNull
    private final Lazy memoryBean$delegate;
    @NotNull
    private final Lazy threadBean$delegate;
    @NotNull
    private final Lazy diagnosticBean$delegate;
    @NotNull
    public static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXProcessMonitor(int pid) {
        this.pid = pid;
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)("JavaProcessMonitor-" + this.pid));
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolExecutor, (String)"newSingleThreadExecutor(...)");
        this.executor = threadPoolExecutor;
        this.osBean$delegate = LazyKt.lazy(() -> JMXProcessMonitor.osBean_delegate$lambda$0(this));
        this.memoryBean$delegate = LazyKt.lazy(() -> JMXProcessMonitor.memoryBean_delegate$lambda$0(this));
        this.threadBean$delegate = LazyKt.lazy(() -> JMXProcessMonitor.threadBean_delegate$lambda$0(this));
        this.diagnosticBean$delegate = LazyKt.lazy(() -> JMXProcessMonitor.diagnosticBean_delegate$lambda$0(this));
        if (this.pid == OSProcessUtil.getCurrentProcessId()) {
            this.vm = null;
            this.connector = null;
        } else {
            JMXConnector jMXConnector;
            this.vm = VirtualMachine.attach(String.valueOf(this.pid));
            Future<JMXConnector> f = this.executor.submit(() -> JMXProcessMonitor._init_$lambda$0(this));
            JMXProcessMonitor jMXProcessMonitor = this;
            try {
                JMXProcessMonitor jMXProcessMonitor2 = jMXProcessMonitor;
                jMXConnector = f.get(7L, TimeUnit.SECONDS);
            }
            finally {
                f.cancel(true);
                this.executor.shutdown();
            }
            jMXProcessMonitor2.connector = jMXConnector;
        }
    }

    public final int getPid() {
        return this.pid;
    }

    @NotNull
    public final OperatingSystemMXBean getOsBean() {
        Lazy lazy = this.osBean$delegate;
        return (OperatingSystemMXBean)lazy.getValue();
    }

    @NotNull
    public final MemoryMXBean getMemoryBean() {
        Lazy lazy = this.memoryBean$delegate;
        return (MemoryMXBean)lazy.getValue();
    }

    @NotNull
    public final ThreadMXBean getThreadBean() {
        Lazy lazy = this.threadBean$delegate;
        return (ThreadMXBean)lazy.getValue();
    }

    @NotNull
    public final HotSpotDiagnosticMXBean getDiagnosticBean() {
        Lazy lazy = this.diagnosticBean$delegate;
        return (HotSpotDiagnosticMXBean)lazy.getValue();
    }

    public final void addNotificationListener(@NotNull NotificationListener notificationListener) {
        Intrinsics.checkNotNullParameter((Object)notificationListener, (String)"notificationListener");
        JMXConnector jMXConnector = this.connector;
        if (jMXConnector != null) {
            jMXConnector.addConnectionNotificationListener(notificationListener, null, null);
        }
        this.notificationListener = notificationListener;
    }

    private final <T extends PlatformManagedObject> T getMXBean(String beanName, Class<T> beanInterface) {
        Object object;
        block3: {
            block2: {
                object = this.connector;
                if (object == null || (object = object.getMBeanServerConnection()) == null) break block2;
                Object server = object;
                boolean bl = false;
                PlatformManagedObject platformManagedObject = (PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy((MBeanServerConnection)server, beanName, beanInterface);
                object = platformManagedObject;
                if (platformManagedObject != null) break block3;
            }
            T t = ManagementFactory.getPlatformMXBean(beanInterface);
            object = t;
            Intrinsics.checkNotNullExpressionValue(t, (String)"getPlatformMXBean(...)");
        }
        return (T)object;
    }

    @Override
    public void close() {
        try {
            if (this.notificationListener != null) {
                JMXConnector jMXConnector = this.connector;
                if (jMXConnector != null) {
                    jMXConnector.removeConnectionNotificationListener(this.notificationListener);
                }
            }
            VirtualMachine virtualMachine = this.vm;
            if (virtualMachine != null) {
                virtualMachine.detach();
            }
            JMXConnector jMXConnector = this.connector;
            if (jMXConnector != null) {
                jMXConnector.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String dumpThreads() {
        ThreadInfo[] threadInfoArray;
        try {
            threadInfoArray = this.getThreadBean().dumpAllThreads(true, true);
        }
        catch (Throwable ignore) {
            threadInfoArray = this.getThreadBean().getThreadInfo(this.getThreadBean().getAllThreadIds(), Integer.MAX_VALUE);
        }
        ThreadInfo[] threads = threadInfoArray;
        ThreadDumper.sort((ThreadInfo[])threads);
        StringWriter writer = new StringWriter();
        Intrinsics.checkNotNull((Object)threads);
        for (ThreadInfo threadInfo : threads) {
            ThreadDumper.dumpThreadInfo((ThreadInfo)threadInfo, (Writer)writer);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void dumpHeap(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.getDiagnosticBean().dumpHeap(filePath, true);
    }

    private static final OperatingSystemMXBean osBean_delegate$lambda$0(JMXProcessMonitor this$0) {
        return this$0.getMXBean("java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
    }

    private static final MemoryMXBean memoryBean_delegate$lambda$0(JMXProcessMonitor this$0) {
        return this$0.getMXBean("java.lang:type=Memory", MemoryMXBean.class);
    }

    private static final ThreadMXBean threadBean_delegate$lambda$0(JMXProcessMonitor this$0) {
        return this$0.getMXBean("java.lang:type=Threading", ThreadMXBean.class);
    }

    private static final HotSpotDiagnosticMXBean diagnosticBean_delegate$lambda$0(JMXProcessMonitor this$0) {
        return this$0.getMXBean("com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
    }

    private static final JMXConnector _init_$lambda$0(JMXProcessMonitor this$0) {
        JMXConnector jMXConnector;
        String string = this$0.vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
        if (string == null) {
            string = this$0.vm.startLocalManagementAgent();
        }
        String address = string;
        JMXServiceURL serviceURL = new JMXServiceURL(address);
        String host = serviceURL.getHost();
        InetAddress inetAddress = InetAddress.getByName(host);
        Intrinsics.checkNotNull((Object)inetAddress);
        if (!Companion.isLocal(inetAddress)) {
            Intrinsics.checkNotNull((Object)host);
            throw new NonLocalAddressException(host);
        }
        JMXConnector $this$lambda_u240_u240 = jMXConnector = JMXConnectorFactory.connect(serviceURL);
        boolean bl = false;
        if (this$0.notificationListener != null) {
            $this$lambda_u240_u240.addConnectionNotificationListener(this$0.notificationListener, null, null);
        }
        return jMXConnector;
    }

    @JvmStatic
    @NotNull
    public static final JMXProcessMonitor connect(int pid) {
        return Companion.connect(pid);
    }

    @JvmStatic
    @Nullable
    public static final JMXProcessMonitor connectOrNull$intellij_profiler_common(int pid) {
        return Companion.connectOrNull$intellij_profiler_common(pid);
    }

    @JvmStatic
    public static final <T> T connect(int pid, @NotNull Function1<? super JMXProcessMonitor, ? extends T> block) {
        return Companion.connect(pid, block);
    }

    @JvmStatic
    public static final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
        Companion.dumpHeap(pid, filePath);
    }

    @JvmStatic
    @NotNull
    public static final String dumpThreads(int pid) {
        return Companion.dumpThreads(pid);
    }

    public /* synthetic */ JMXProcessMonitor(int pid, DefaultConstructorMarker $constructor_marker) {
        this(pid);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0017\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u000bJ/\u0010\u0006\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\f0\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/api/monitor/JMXProcessMonitor$Companion;", "", "<init>", "()V", "CONNECTOR_ADDRESS", "", "connect", "Lcom/intellij/profiler/api/monitor/JMXProcessMonitor;", "pid", "", "connectOrNull", "connectOrNull$intellij_profiler_common", "T", "block", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "dumpHeap", "", "filePath", "dumpThreads", "isLocal", "", "Ljava/net/InetAddress;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JMXProcessMonitor connect(int pid) {
            JMXProcessMonitor jMXProcessMonitor;
            try {
                jMXProcessMonitor = new JMXProcessMonitor(pid, null);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable == null) {
                    throwable = e;
                }
                throw throwable;
            }
            return jMXProcessMonitor;
        }

        @JvmStatic
        @Nullable
        public final JMXProcessMonitor connectOrNull$intellij_profiler_common(int pid) {
            try {
                return this.connect(pid);
            }
            catch (AttachOperationFailedException attachOperationFailedException) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T connect(int pid, @NotNull Function1<? super JMXProcessMonitor, ? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            AutoCloseable autoCloseable = this.connect(pid);
            Throwable throwable = null;
            try {
                object = block.invoke((Object)autoCloseable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return (T)object;
        }

        @JvmStatic
        public final void dumpHeap(int pid, @NotNull String filePath) throws IOException, FindException {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.connect(pid, arg_0 -> Companion.dumpHeap$lambda$0(filePath, arg_0));
        }

        @JvmStatic
        @NotNull
        public final String dumpThreads(int pid) {
            return (String)this.connect(pid, Companion::dumpThreads$lambda$0);
        }

        public final boolean isLocal(@NotNull InetAddress $this$isLocal) {
            Intrinsics.checkNotNullParameter((Object)$this$isLocal, (String)"<this>");
            return $this$isLocal.isAnyLocalAddress() || $this$isLocal.isLoopbackAddress() || NetworkInterface.getByInetAddress($this$isLocal) != null;
        }

        private static final Unit dumpHeap$lambda$0(String $filePath, JMXProcessMonitor connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            connection.dumpHeap($filePath);
            return Unit.INSTANCE;
        }

        private static final String dumpThreads$lambda$0(JMXProcessMonitor connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            return connection.dumpThreads();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/api/monitor/JMXProcessMonitor$NonLocalAddressException;", "Ljava/io/IOException;", "addr", "", "<init>", "(Ljava/lang/String;)V", "intellij.profiler.common"})
    public static final class NonLocalAddressException
    extends IOException {
        public NonLocalAddressException(@NotNull String addr) {
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            super("Unable to connect to remote process: JMX address is external: " + addr);
        }
    }
}

