/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.hints;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.microservices.jvm.config.hints.HintReferenceProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassHintReferenceProvider
implements HintReferenceProvider {
    private final List<String> myBaseClasses;
    private final boolean myAllowOtherValues;
    private final Boolean myConcrete;

    public ClassHintReferenceProvider(String baseClass, boolean allowOtherValues, Boolean concrete) {
        this(StringUtil.isNotEmpty((String)baseClass) ? Collections.singletonList(baseClass) : Collections.emptyList(), allowOtherValues, concrete);
    }

    public ClassHintReferenceProvider(@NotNull List<String> baseClasses, boolean allowOtherValues, Boolean concrete) {
        if (baseClasses == null) {
            ClassHintReferenceProvider.$$$reportNull$$$0(0);
        }
        this.myBaseClasses = baseClasses;
        this.myAllowOtherValues = allowOtherValues;
        this.myConcrete = concrete;
    }

    @Override
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        if (element == null) {
            ClassHintReferenceProvider.$$$reportNull$$$0(1);
        }
        if (textRanges == null) {
            ClassHintReferenceProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ClassHintReferenceProvider.$$$reportNull$$$0(3);
        }
        String valueText = element.getText();
        JavaClassReferenceProvider provider = this.createJavaClassReferenceProvider(element);
        Object[] allReferences = PsiReference.EMPTY_ARRAY;
        for (TextRange range : textRanges) {
            String rangeText = range.substring(valueText);
            if (StringUtil.contains((CharSequence)rangeText, (CharSequence)"${")) continue;
            Object[] references = provider.getReferencesByString(rangeText, element, range.getStartOffset());
            allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])references);
        }
        return allReferences;
    }

    @NotNull
    private JavaClassReferenceProvider createJavaClassReferenceProvider(PsiElement element) {
        final GlobalSearchScope resolveScope = ClassHintReferenceProvider.getResolveScope(element);
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider(this){

            @Nullable
            public GlobalSearchScope getScope(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return resolveScope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/microservices/jvm/config/hints/ClassHintReferenceProvider$1", "getScope"));
            }
        };
        if (!this.myBaseClasses.isEmpty()) {
            provider.setOption(JavaClassReferenceProvider.SUPER_CLASSES, this.myBaseClasses);
        }
        if (this.myAllowOtherValues) {
            provider.setSoft(true);
        }
        if (this.myConcrete.booleanValue()) {
            provider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
        }
        provider.setOption(JavaClassReferenceProvider.RESOLVE_QUALIFIED_CLASS_NAME, (Object)Boolean.TRUE);
        provider.setOption(JavaClassReferenceProvider.ADVANCED_RESOLVE, (Object)Boolean.TRUE);
        JavaClassReferenceProvider javaClassReferenceProvider = provider;
        if (javaClassReferenceProvider == null) {
            ClassHintReferenceProvider.$$$reportNull$$$0(4);
        }
        return javaClassReferenceProvider;
    }

    private static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            ClassHintReferenceProvider.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return GlobalSearchScope.allScope((Project)element.getProject());
        }
        boolean inTestSource = ProjectRootsUtil.isInTestSource((PsiFile)element.getContainingFile().getOriginalFile());
        return module.getModuleRuntimeScope(inTestSource);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClasses";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRanges";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/hints/ClassHintReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/hints/ClassHintReferenceProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaClassReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

