/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.analysis.filter.Replacements;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

final class ExhaustiveSwitchFilter
implements IFilter {
    ExhaustiveSwitchFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        int line = -1;
        for (AbstractInsnNode i : methodNode.instructions) {
            if (i.getType() == 15) {
                line = ((LineNumberNode)i).line;
            }
            matcher.match(i, line, output);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(AbstractInsnNode start, int line, IFilterOutput output) {
            LabelNode dflt;
            if (start.getOpcode() == 171) {
                dflt = ((LookupSwitchInsnNode)start).dflt;
            } else if (start.getOpcode() == 170) {
                dflt = ((TableSwitchInsnNode)start).dflt;
            } else {
                return;
            }
            this.cursor = Matcher.skipToLineNumberOrInstruction(dflt);
            if (this.cursor == null) {
                return;
            }
            if (this.cursor.getType() == 15) {
                if (line != ((LineNumberNode)this.cursor).line) {
                    return;
                }
                this.cursor = Matcher.skipNonOpcodes(this.cursor);
            }
            if (this.cursor == null || this.cursor.getOpcode() != 187) {
                return;
            }
            if ("java/lang/MatchException".equals(((TypeInsnNode)this.cursor).desc)) {
                this.nextIs(89);
                this.nextIs(1);
                this.nextIs(1);
                this.nextIsInvoke(183, "java/lang/MatchException", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V");
            } else if ("java/lang/IncompatibleClassChangeError".equals(((TypeInsnNode)this.cursor).desc)) {
                this.nextIs(89);
                this.nextIsInvoke(183, "java/lang/IncompatibleClassChangeError", "<init>", "()V");
            } else {
                return;
            }
            this.nextIs(191);
            if (this.cursor == null) {
                return;
            }
            output.ignore(dflt, this.cursor);
            output.replaceBranches(start, Replacements.ignoreDefaultBranch(start));
        }

        private static AbstractInsnNode skipToLineNumberOrInstruction(AbstractInsnNode cursor) {
            while (cursor != null && (cursor.getType() == 14 || cursor.getType() == 8)) {
                cursor = cursor.getNext();
            }
            return cursor;
        }
    }
}

