/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.color;

import com.intellij.psi.css.impl.util.CssLchColorUtils;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.color.ColorSpace;
import com.intellij.psi.css.impl.util.color.CssColor;
import com.intellij.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0017\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"XYZ_D65_WHITE", "", "XYZ_D65_BLACK", "convertColor", "Lcom/intellij/psi/css/impl/util/color/CssColor;", "color", "targetColorSpace", "Lcom/intellij/psi/css/impl/util/color/ColorSpace;", "toXYZ", "fromXyzTo", "intermediate", "newColorSpace", "analogousComponents", "", "source", "target", "cssColorArgumentsToLchsConversion", "lch", "cssColorArgumentsToLabsConversion", "lab", "lightnessBelow0", "", "lightness", "", "(Ljava/lang/Double;)Z", "naNsToZero", "values", "intellij.css.psi"})
@SourceDebugExtension(value={"SMAP\nCssColorConversionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssColorConversionUtil.kt\ncom/intellij/psi/css/impl/util/color/CssColorConversionUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,254:1\n1#2:255\n11621#3:256\n11956#3,3:257\n11621#3:260\n11956#3,3:261\n11621#3:264\n11956#3,3:265\n*S KotlinDebug\n*F\n+ 1 CssColorConversionUtil.kt\ncom/intellij/psi/css/impl/util/color/CssColorConversionUtilKt\n*L\n139#1:256\n139#1:257,3\n143#1:260\n143#1:261,3\n245#1:264\n245#1:265,3\n*E\n"})
public final class CssColorConversionUtilKt {
    @NotNull
    private static final double[] XYZ_D65_WHITE;
    @NotNull
    private static final double[] XYZ_D65_BLACK;

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final CssColor convertColor(@NotNull CssColor color, @NotNull ColorSpace targetColorSpace) {
        block14: {
            block16: {
                block15: {
                    block13: {
                        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                        Intrinsics.checkNotNullParameter((Object)targetColorSpace, (String)"targetColorSpace");
                        if (color.getColorSpaceId() == targetColorSpace) {
                            return color;
                        }
                        intermediate = CssColorConversionUtilKt.toXYZ(color);
                        targetComponents = CssColorConversionUtilKt.fromXyzTo(intermediate, targetColorSpace);
                        var5_4 = new Double[]{targetComponents[0], targetComponents[1], targetComponents[2]};
                        resultComponents = var5_4;
                        pairs = CssColorConversionUtilKt.analogousComponents(color.getColorSpaceId(), targetColorSpace);
                        if (pairs != null) {
                            for (i = 0; i < 3; ++i) {
                                if (pairs[i] < 0 || color.get(i) != null) continue;
                                resultComponents[pairs[i]] = null;
                            }
                        }
                        if ((var7_8 = WhenMappings.$EnumSwitchMapping$0[targetColorSpace.ordinal()]) != 1) break block13;
                        v0 = resultComponents[1];
                        if (v0 != null) {
                            it = ((Number)v0).doubleValue();
                            $i$a$-let-CssColorConversionUtilKt$convertColor$resColor$1 = false;
                            v1 = it <= 0.001;
                        } else {
                            v1 = false;
                        }
                        if (!v1) break block13;
                        var8_12 = new Double[]{null, resultComponents[1], resultComponents[2]};
                        v2 = new CssColor(targetColorSpace, var8_12);
                        v3 = v2;
                        break block14;
                    }
                    if (var7_8 != 2) break block15;
                    v4 = resultComponents[1];
                    if (v4 != null) {
                        it = v4 + targetComponents[2];
                        $i$a$-let-CssColorConversionUtilKt$convertColor$resColor$2 = false;
                        v5 = it >= 99.999;
                    } else {
                        v5 = false;
                    }
                    if (!v5) break block15;
                    var8_12 = new Double[]{null, resultComponents[1], resultComponents[2]};
                    v6 = new CssColor(targetColorSpace, var8_12);
                    v3 = v6;
                    break block14;
                }
                if (var7_8 != 3) break block16;
                v7 = resultComponents[1];
                if (v7 != null) {
                    it = ((Number)v7).doubleValue();
                    $i$a$-let-CssColorConversionUtilKt$convertColor$resColor$3 = false;
                    v8 = it <= 0.0015;
                } else {
                    v8 = false;
                }
                if (!v8) break block16;
                var8_12 = new Double[]{resultComponents[0], resultComponents[1], null};
                v9 = new CssColor(targetColorSpace, var8_12);
                v3 = v9;
                break block14;
            }
            if (var7_8 != 4) ** GOTO lbl-1000
            v10 = resultComponents[1];
            if (v10 != null) {
                it = ((Number)v10).doubleValue();
                $i$a$-let-CssColorConversionUtilKt$convertColor$resColor$4 = false;
                v11 = it <= 4.0E-6;
            } else {
                v11 = false;
            }
            if (v11) {
                var8_12 = new Double[]{resultComponents[0], resultComponents[1], null};
                v12 = new CssColor(targetColorSpace, var8_12);
                v3 = v12;
            } else lbl-1000:
            // 2 sources

            {
                var8_12 = new Double[]{resultComponents[0], resultComponents[1], resultComponents[2]};
                v13 = new CssColor(targetColorSpace, var8_12);
                v3 = v13;
            }
        }
        resColor = v3;
        resColor.setAlpha(color.getAlpha());
        return resColor;
    }

    private static final double[] toXYZ(CssColor color) {
        double[] dArray;
        switch (WhenMappings.$EnumSwitchMapping$0[color.getColorSpaceId().ordinal()]) {
            case 1: {
                Double d = color.get(0);
                Double d2 = color.get(1);
                Double d3 = color.get(2);
                double[] lsrgb = CssLchColorUtils.linSRgb(CssPsiColorUtil.getRgbByHsl(d != null ? d : 0.0, d2 != null ? d2 : 0.0, d3 != null ? d3 : 0.0));
                double[] dArray2 = CssLchColorUtils.linSRgbToD65Xyz(lsrgb);
                Intrinsics.checkNotNull((Object)dArray2);
                dArray = dArray2;
                break;
            }
            case 2: {
                Double d = color.get(0);
                Double d4 = color.get(1);
                Double d5 = color.get(2);
                double[] lsrgb = CssLchColorUtils.linSRgb(CssPsiColorUtil.getRgbByHwb(d != null ? d : 0.0, d4 != null ? d4 : 0.0, d5 != null ? d5 : 0.0));
                double[] dArray3 = CssLchColorUtils.linSRgbToD65Xyz(lsrgb);
                Intrinsics.checkNotNull((Object)dArray3);
                dArray = dArray3;
                break;
            }
            case 3: {
                if (CssColorConversionUtilKt.lightnessBelow0(color.get(0))) {
                    return XYZ_D65_BLACK;
                }
                double[] lch = CssColorConversionUtilKt.cssColorArgumentsToLchsConversion(color.componentsToDoubleArray());
                double[] dArray4 = CssLchColorUtils.d50ToD65(CssLchColorUtils.labToD50Xyz(CssLchColorUtils.lchToLab(lch[0], lch[1], lch[2])));
                Intrinsics.checkNotNull((Object)dArray4);
                dArray = dArray4;
                break;
            }
            case 4: {
                if (CssColorConversionUtilKt.lightnessBelow0(color.get(0))) {
                    return XYZ_D65_BLACK;
                }
                double[] oklch = CssColorConversionUtilKt.cssColorArgumentsToLchsConversion(color.componentsToDoubleArray());
                double[] dArray5 = CssLchColorUtils.oklabToD65Xyz(CssLchColorUtils.oklchToOklab(oklch[0], oklch[1], oklch[2]));
                Intrinsics.checkNotNull((Object)dArray5);
                dArray = dArray5;
                break;
            }
            case 5: {
                dArray = color.componentsToDoubleArray();
                break;
            }
            case 6: {
                double[] dArray6 = CssLchColorUtils.d50ToD65(CssLchColorUtils.labToD50Xyz(CssColorConversionUtilKt.cssColorArgumentsToLabsConversion(color.componentsToDoubleArray())));
                Intrinsics.checkNotNull((Object)dArray6);
                dArray = dArray6;
                break;
            }
            case 7: {
                if (CssColorConversionUtilKt.lightnessBelow0(color.get(0))) {
                    return XYZ_D65_BLACK;
                }
                double[] dArray7 = CssLchColorUtils.oklabToD65Xyz(CssColorConversionUtilKt.cssColorArgumentsToLabsConversion(color.componentsToDoubleArray()));
                Intrinsics.checkNotNull((Object)dArray7);
                dArray = dArray7;
                break;
            }
            case 8: {
                double[] dArray8 = CssLchColorUtils.linSRgbToD65Xyz(color.componentsToDoubleArray());
                Intrinsics.checkNotNull((Object)dArray8);
                dArray = dArray8;
                break;
            }
            case 9: {
                double[] dArray9 = CssLchColorUtils.linSRgbToD65Xyz(CssLchColorUtils.linSRgb(color.componentsToDoubleArray()));
                Intrinsics.checkNotNull((Object)dArray9);
                dArray = dArray9;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dArray;
    }

    private static final double[] fromXyzTo(double[] intermediate, ColorSpace newColorSpace) {
        return switch (WhenMappings.$EnumSwitchMapping$0[newColorSpace.ordinal()]) {
            case 1 -> {
                double[] rgb = CssLchColorUtils.gamSRgb(CssLchColorUtils.xyzToLinSRgb(intermediate));
                double[] v0 = CssPsiColorUtil.getHslByRgb((int)(rgb[0] * 255.0 + 0.5), (int)(rgb[1] * 255.0 + 0.5), (int)(rgb[2] * 255.0 + 0.5));
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getHslByRgb(...)");
                yield CssColorConversionUtilKt.naNsToZero(v0);
            }
            case 2 -> {
                double[] rgb = CssLchColorUtils.gamSRgb(CssLchColorUtils.xyzToLinSRgb(intermediate));
                double[] v2 = CssPsiColorUtil.getHwbByRgb((int)(rgb[0] * 255.0 + 0.5), (int)(rgb[1] * 255.0 + 0.5), (int)(rgb[2] * 255.0 + 0.5));
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getHwbByRgb(...)");
                yield CssColorConversionUtilKt.naNsToZero(v2);
            }
            case 3 -> {
                double[] res = CssLchColorUtils.labToLch(CssLchColorUtils.xyzD50ToLab(CssLchColorUtils.d65ToD50(intermediate)));
                res[0] = res[0] / 100.0;
                res[1] = res[1] / 100.0;
                res[2] = res[2] / 360.0;
                double[] rgb = res;
                Intrinsics.checkNotNull((Object)rgb);
                yield rgb;
            }
            case 4 -> {
                double[] res = CssLchColorUtils.oklabToOklch(CssLchColorUtils.xyzD65ToOklab(intermediate));
                res[0] = res[0] / 100.0;
                res[1] = res[1] / 100.0;
                res[2] = res[2] / 360.0;
                double[] rgb = res;
                Intrinsics.checkNotNull((Object)rgb);
                yield rgb;
            }
            case 5 -> intermediate;
            case 6 -> {
                void $this$mapTo$iv$iv;
                double[] res = CssLchColorUtils.xyzD50ToLab(CssLchColorUtils.d65ToD50(intermediate));
                Intrinsics.checkNotNull((Object)res);
                double[] $this$map$iv = res;
                boolean $i$f$map = false;
                double[] var5_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int var9_24 = ((void)$this$mapTo$iv$iv).length;
                for (int var8_22 = 0; var8_22 < var9_24; ++var8_22) {
                    void it;
                    void item$iv$iv;
                    void var12_28 = item$iv$iv = $this$mapTo$iv$iv[var8_22];
                    Collection var15_32 = destination$iv$iv;
                    boolean $i$a$-map-CssColorConversionUtilKt$fromXyzTo$1 = false;
                    var15_32.add((double)(it / 100.0));
                }
                yield CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv));
            }
            case 7 -> {
                double[] res = CssLchColorUtils.xyzD65ToOklab(intermediate);
                Intrinsics.checkNotNull((Object)res);
                double[] $this$map$iv = res;
                boolean $i$f$map = false;
                double[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int var9_25 = $this$mapTo$iv$iv.length;
                for (int var8_23 = 0; var8_23 < var9_25; ++var8_23) {
                    double item$iv$iv;
                    double it = item$iv$iv = $this$mapTo$iv$iv[var8_23];
                    Collection var15_33 = destination$iv$iv;
                    boolean $i$a$-map-CssColorConversionUtilKt$fromXyzTo$2 = false;
                    var15_33.add(it / 100.0);
                }
                yield CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv));
            }
            case 8 -> {
                double[] var2_8 = CssLchColorUtils.xyzToLinSRgb(intermediate);
                Intrinsics.checkNotNull((Object)var2_8);
                yield var2_8;
            }
            case 9 -> {
                double[] var2_9 = CssLchColorUtils.gamSRgb(CssLchColorUtils.xyzToLinSRgb(intermediate));
                Intrinsics.checkNotNull((Object)var2_9);
                yield var2_9;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final int[] analogousComponents(ColorSpace source, ColorSpace target) {
        int[] nArray;
        if (source == target) {
            int[] nArray2 = new int[]{0, 1, 2};
            return nArray2;
        }
        Pair pair = TuplesKt.to((Object)((Object)source), (Object)((Object)target));
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.HSL), (Object)((Object)ColorSpace.HWB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.HWB), (Object)((Object)ColorSpace.HSL))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LCH), (Object)((Object)ColorSpace.LAB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LCH), (Object)((Object)ColorSpace.OKLAB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLCH), (Object)((Object)ColorSpace.LAB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLCH), (Object)((Object)ColorSpace.OKLAB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LAB), (Object)((Object)ColorSpace.LCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LAB), (Object)((Object)ColorSpace.OKLCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLAB), (Object)((Object)ColorSpace.LCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLAB), (Object)((Object)ColorSpace.OKLCH)))) {
            int[] nArray3 = new int[]{0, -1, -1};
            nArray = nArray3;
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.HSL), (Object)((Object)ColorSpace.LCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.HSL), (Object)((Object)ColorSpace.OKLCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LCH), (Object)((Object)ColorSpace.HSL))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLCH), (Object)((Object)ColorSpace.HSL)))) {
            int[] nArray4 = new int[]{2, 1, 0};
            nArray = nArray4;
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.HWB), (Object)((Object)ColorSpace.LCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.HWB), (Object)((Object)ColorSpace.OKLCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LAB), (Object)((Object)ColorSpace.HSL))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLAB), (Object)((Object)ColorSpace.HSL)))) {
            int[] nArray5 = new int[]{2, -1, -1};
            nArray = nArray5;
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.HSL), (Object)((Object)ColorSpace.LAB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.HSL), (Object)((Object)ColorSpace.OKLAB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LCH), (Object)((Object)ColorSpace.HWB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLCH), (Object)((Object)ColorSpace.HWB)))) {
            int[] nArray6 = new int[]{-1, -1, 0};
            nArray = nArray6;
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LCH), (Object)((Object)ColorSpace.OKLCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLCH), (Object)((Object)ColorSpace.LCH))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.LAB), (Object)((Object)ColorSpace.OKLAB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.OKLAB), (Object)((Object)ColorSpace.LAB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.XYZ), (Object)((Object)ColorSpace.SRGB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.XYZ), (Object)((Object)ColorSpace.SRGB_LINEAR))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.SRGB_LINEAR), (Object)((Object)ColorSpace.XYZ))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.SRGB_LINEAR), (Object)((Object)ColorSpace.SRGB))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.SRGB), (Object)((Object)ColorSpace.XYZ))) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)ColorSpace.SRGB), (Object)((Object)ColorSpace.SRGB_LINEAR)))) {
            int[] nArray7 = new int[]{0, 1, 2};
            nArray = nArray7;
        } else {
            nArray = null;
        }
        return nArray;
    }

    private static final double[] cssColorArgumentsToLchsConversion(double[] lch) {
        double[] dArray = new double[]{lch[0] * 100.0, lch[1] * 100.0, lch[2] * 360.0};
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final double[] cssColorArgumentsToLabsConversion(double[] lab) {
        void $this$mapTo$iv$iv;
        double[] $this$map$iv = lab;
        boolean $i$f$map = false;
        double[] dArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)(it * (double)100));
        }
        return CollectionsKt.toDoubleArray((Collection)((List)destination$iv$iv));
    }

    private static final boolean lightnessBelow0(Double lightness) {
        return lightness != null && MathUtil.compare((double)lightness, (double)0.0, (double)1.0E-4) <= 0;
    }

    private static final double[] naNsToZero(double[] values) {
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            double d = values[i];
            if (!Double.isNaN(d)) continue;
            values[index] = 0.0;
        }
        return values;
    }

    static {
        double[] dArray = new double[]{0.9505, 1.0, 1.0891};
        XYZ_D65_WHITE = dArray;
        dArray = new double[]{0.0, 0.0, 0.0};
        XYZ_D65_BLACK = dArray;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorSpace.values().length];
            try {
                nArray[ColorSpace.HSL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.HWB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.LCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.OKLCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.XYZ.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.LAB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.OKLAB.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.SRGB_LINEAR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.SRGB.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

