/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.mvc;

import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.UCallExpressionSearchParams;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.spring.security.model.xml.Http;
import com.intellij.spring.security.model.xml.InterceptUrl;
import com.intellij.spring.security.mvc.UrlMatcher;
import com.intellij.spring.security.mvc.matchers.AntMatcher;
import com.intellij.spring.security.mvc.matchers.AnyRequestMatcher;
import com.intellij.spring.security.mvc.matchers.MvcMatcher;
import com.intellij.spring.security.mvc.matchers.PathMatcher;
import com.intellij.spring.security.mvc.matchers.RegexMatcher;
import com.intellij.spring.security.mvc.matchers.RequestMatcher;
import com.intellij.spring.security.mvc.matchers.SpringSecurityUrlMatcher;
import com.intellij.spring.security.references.SpringSecurityPatterns;
import com.intellij.spring.security.util.SpringSecurityUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class SpringSecuredUrlsUtils {
    public static final ElementPattern<@NotNull UCallExpression> MATCHERS_CALLS = StandardPatterns.or((ElementPattern[])new ElementPattern[]{SpringSecurityPatterns.REQUEST_MATCHER_REGISTRY_EXPRESSIONS, SpringSecurityPatterns.PATH_MATCHERS_EXPRESSION, SpringSecurityPatterns.REQUEST_MATCHERS_EXPRESSION, SpringSecurityPatterns.MVC_REQUEST_MATCHER_BUILDER_EXPRESSION, SpringSecurityPatterns.ANT_PATH_REQUEST_MATCHER_EXPRESSION, SpringSecurityPatterns.REGEX_PATH_REQUEST_MATCHER_EXPRESSION, SpringSecurityPatterns.HTTP_SECURITY_EXPRESSIONS, SpringSecurityPatterns.LOGOUT_CONFIGURER_EXPRESSIONS, SpringSecurityPatterns.FORM_LOGIN_CONFIGURER_EXPRESSIONS, SpringSecurityPatterns.AUTHENTICATION_FILTER_LOGIN_CONFIGURER_EXPRESSIONS});
    public static final UExpressionPattern.Capture<UExpression> MATCHERS_PATTERN = (UExpressionPattern.Capture)UastPatterns.uExpression().inCall(MATCHERS_CALLS);
    public static final XmlNamedElementPattern.XmlAttributePattern XML_ATTRIBUTE_PATTERN = (XmlNamedElementPattern.XmlAttributePattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withLocalName("pattern")).withParent((ElementPattern)XmlPatterns.xmlTag().withNamespace((ElementPattern)StandardPatterns.string().equalTo((Object)"http://www.springframework.org/schema/security")));

    @NotNull
    public static Set<UrlMatcher> collectMatchers(@NotNull Module module) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(0);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.createSingleDependency(SpringSecuredUrlsUtils.getMatchers(module), (Object)PsiModificationTracker.MODIFICATION_COUNT));
        if (set == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    private static Set<UrlMatcher> getMatchers(@NotNull Module module) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(2);
        }
        HashSet<UrlMatcher> matchers = new HashSet<UrlMatcher>();
        SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        matchers.addAll(SpringSecuredUrlsUtils.collectMatchers(model, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.web.SecurityFilterChain")));
        matchers.addAll(SpringSecuredUrlsUtils.collectMatchers(model, SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.web.server.SecurityWebFilterChain")));
        matchers.addAll(SpringSecuredUrlsUtils.collectWebSecurityConfigurerAdapterMatchers(model, module));
        matchers.addAll(SpringSecuredUrlsUtils.collectXmlMatchers(model, module));
        HashSet<UrlMatcher> hashSet = matchers;
        if (hashSet == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private static Set<UrlMatcher> collectWebSecurityConfigurerAdapterMatchers(@NotNull SpringModel model, @NotNull Module module) {
        PsiClass webSecurityConfigurer;
        if (model == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(5);
        }
        if ((webSecurityConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter")) != null) {
            HashSet<UrlMatcher> matchers = new HashSet<UrlMatcher>();
            for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)webSecurityConfigurer))) {
                CommonSpringBean springBean = bean.getSpringBean();
                if (!(springBean instanceof JamPsiClassSpringBean)) continue;
                PsiClass psiClass = ((JamPsiClassSpringBean)springBean).getPsiElement();
                for (PsiMethod configure : psiClass.findMethodsByName("configure", false)) {
                    matchers.addAll(SpringSecuredUrlsUtils.collectMatchers(module, configure));
                }
            }
            HashSet<UrlMatcher> hashSet = matchers;
            if (hashSet == null) {
                SpringSecuredUrlsUtils.$$$reportNull$$$0(6);
            }
            return hashSet;
        }
        Set<UrlMatcher> set = Collections.emptySet();
        if (set == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public static Set<UrlMatcher> collectMatchers(Module module, PsiMethod method) {
        return SpringSecuredUrlsUtils.collectMatchers(module, new LocalSearchScope((PsiElement)method));
    }

    @NotNull
    private static Set<UrlMatcher> collectMatchers(SpringModel model, @Nullable PsiClass aClass) {
        if (aClass == null) {
            Set<UrlMatcher> set = Collections.emptySet();
            if (set == null) {
                SpringSecuredUrlsUtils.$$$reportNull$$$0(8);
            }
            return set;
        }
        HashSet<UrlMatcher> matchers = new HashSet<UrlMatcher>();
        for (SpringBeanPointer pointer : SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)aClass).searchInLibraries(false))) {
            PsiElement beanElement = pointer.getSpringBean().getIdentifyingPsiElement();
            if (beanElement == null) continue;
            matchers.addAll(SpringSecuredUrlsUtils.collectMatchers(model.getModule(), new LocalSearchScope(beanElement)));
        }
        HashSet<UrlMatcher> hashSet = matchers;
        if (hashSet == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public static Set<PsiElement> getMatchedUrls(@NotNull Set<UrlMatcher> matchers, @NotNull UrlPathContext urlPathContext) {
        if (matchers == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(10);
        }
        if (urlPathContext == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(11);
        }
        HashSet<PsiElement> expressions = new HashSet<PsiElement>();
        for (UrlResolveRequest request : urlPathContext.getResolveRequests()) {
            expressions.addAll(SpringSecuredUrlsUtils.getMatchedUrls(matchers, request));
        }
        if (expressions.isEmpty()) {
            Set<PsiElement> set = matchers.stream().filter(AnyRequestMatcher.class::isInstance).map(matcher -> matcher.getIdentifyingElement()).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
            if (set == null) {
                SpringSecuredUrlsUtils.$$$reportNull$$$0(12);
            }
            return set;
        }
        HashSet<PsiElement> hashSet = expressions;
        if (hashSet == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    public static Set<PsiElement> getMatchedUrls(@NotNull Module module, @NotNull UrlPathContext urlPathContext) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(14);
        }
        if (urlPathContext == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(15);
        }
        return SpringSecuredUrlsUtils.getMatchedUrls(SpringSecuredUrlsUtils.collectMatchers(module), urlPathContext);
    }

    @NotNull
    public static Set<PsiElement> getMatchedUrls(@NotNull Set<UrlMatcher> matchers, @NotNull UrlResolveRequest request) {
        if (matchers == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(16);
        }
        if (request == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(17);
        }
        Set<PsiElement> set = matchers.stream().filter(matcher -> !(matcher instanceof AnyRequestMatcher)).filter(matcher -> matcher.accept(request.getPath().getPresentation())).filter(matcher -> matcher.acceptMethod(request.getMethod())).map(matcher -> matcher.getIdentifyingElement()).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        if (set == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    private static Set<UrlMatcher> collectMatchers(@Nullable Module module, @NotNull LocalSearchScope localSearchScope) {
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(19);
        }
        if (module == null) {
            Set<UrlMatcher> set = Collections.emptySet();
            if (set == null) {
                SpringSecuredUrlsUtils.$$$reportNull$$$0(20);
            }
            return set;
        }
        HashSet<UrlMatcher> matchers = new HashSet<UrlMatcher>();
        matchers.addAll(SpringSecuredUrlsUtils.getAntMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getMvcMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getRegexMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getPathMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getRequestMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getHttpSecurityMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getHttpAntMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getHttpRegexMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getAntPathRequestMatcherAntMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getMvcRequestMatcherBuilderPatterns(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getRegexRequestMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getLogoutPageMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getFormLoginPageMatchers(module, localSearchScope));
        matchers.addAll(SpringSecuredUrlsUtils.getAnyRequestMatchers(module, localSearchScope));
        HashSet<UrlMatcher> hashSet = matchers;
        if (hashSet == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @NotNull
    private static Set<UrlMatcher> getAnyRequestMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(22);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(23);
        }
        Set uCallExpressions = SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry", (String)"anyRequest"), (LocalSearchScope)localSearchScope);
        Set<UrlMatcher> set = uCallExpressions.stream().map(expression -> new AnyRequestMatcher(expression.getMethodIdentifier() != null ? expression.getMethodIdentifier().getSourcePsi() : expression.getSourcePsi())).collect(Collectors.toSet());
        if (set == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(24);
        }
        return set;
    }

    @NotNull
    private static Set<UrlMatcher> getAntMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(25);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(26);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry", (String)"antMatchers"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new AntMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getMvcMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(27);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(28);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry", (String)"mvcMatchers"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new MvcMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getRegexMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(29);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(30);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry", (String)"regexMatchers"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new RegexMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getPathMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(31);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(32);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.web.server.AbstractServerWebExchangeMatcherRegistry", (String)"pathMatchers"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new PathMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getRequestMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(33);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(34);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.AbstractRequestMatcherRegistry", (String)"requestMatchers"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new RequestMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getHttpSecurityMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(35);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(36);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.builders.HttpSecurity", (String)"securityMatcher"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new AntMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getHttpAntMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(37);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(38);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.builders.HttpSecurity", (String)"antMatcher"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new AntMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getHttpRegexMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(39);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(40);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.builders.HttpSecurity", (String)"regexMatcher"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new RegexMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getAntPathRequestMatcherAntMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(41);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(42);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.web.util.matcher.AntPathRequestMatcher", (String)"antMatcher"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new AntMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getRegexRequestMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(43);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(44);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.web.util.matcher.RegexRequestMatcher", (String)"regexMatcher"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new RegexMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getLogoutPageMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(45);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(46);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.configurers.LogoutConfigurer", (String)"logoutUrl"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new AntMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getFormLoginPageMatchers(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(47);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(48);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer", (String)"loginPage"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new AntMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getMvcRequestMatcherBuilderPatterns(@NotNull Module module, @NotNull LocalSearchScope localSearchScope) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(49);
        }
        if (localSearchScope == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(50);
        }
        return SpringSecuredUrlsUtils.getMatchers(SpringFunctionalSearchersUtils.findMethodCallsInLocalSearchScope((UCallExpressionSearchParams)UCallExpressionSearchParams.create((Module)module, (String)"org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher.Builder", (String)"pattern"), (LocalSearchScope)localSearchScope), (Function<UExpression, SpringSecurityUrlMatcher>)((Function)expression -> new RequestMatcher(UastUtils.evaluateString((UExpression)expression), expression.getSourcePsi())));
    }

    @NotNull
    private static Set<UrlMatcher> getMatchers(@NotNull Set<UCallExpression> methodsCalls, @NotNull Function<UExpression, SpringSecurityUrlMatcher> matcherProducer) {
        if (methodsCalls == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(51);
        }
        if (matcherProducer == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(52);
        }
        HashSet<UrlMatcher> matchers = new HashSet<UrlMatcher>();
        for (UCallExpression methodsCall : methodsCalls) {
            HashSet<SpringSecurityUrlMatcher> matchersForCall = new HashSet<SpringSecurityUrlMatcher>();
            String methodCallName = null;
            List arguments = methodsCall.getValueArguments();
            for (UExpression argument : arguments) {
                PsiType type = argument.getExpressionType();
                if (type != null && InheritanceUtil.isInheritor((PsiType)type, (String)"org.springframework.http.HttpMethod")) {
                    methodCallName = SpringSecuredUrlsUtils.getHttpMethodName(argument);
                    continue;
                }
                if (type instanceof PsiArrayType) {
                    for (UExpression uExpression : SpringSecuredUrlsUtils.getArrayInitializedExpressions(argument)) {
                        SpringSecurityUrlMatcher securityUrlMatcher = (SpringSecurityUrlMatcher)matcherProducer.fun((Object)uExpression);
                        securityUrlMatcher.setNavigationElement(argument.getSourcePsi());
                        matchersForCall.add(securityUrlMatcher);
                    }
                    continue;
                }
                if (argument instanceof UCallExpression && SpringSecuredUrlsUtils.isConstructorExpression(argument)) {
                    UExpression expression = SpringSecuredUrlsUtils.getConstructorPatternArgumentExpression((UCallExpression)argument);
                    if (expression == null) continue;
                    SpringSecurityUrlMatcher securityUrlMatcher = (SpringSecurityUrlMatcher)matcherProducer.fun((Object)expression);
                    securityUrlMatcher.setNavigationElement(argument.getSourcePsi());
                    matchersForCall.add(securityUrlMatcher);
                    continue;
                }
                if (argument instanceof USimpleNameReferenceExpression) {
                    List<@NotNull UExpression> expressions = SpringSecuredUrlsUtils.getClassInitializedExpressions(argument);
                    if (expressions.isEmpty()) {
                        matchersForCall.add((SpringSecurityUrlMatcher)matcherProducer.fun((Object)argument));
                        continue;
                    }
                    for (UExpression uExpression : expressions) {
                        SpringSecurityUrlMatcher securityUrlMatcher = (SpringSecurityUrlMatcher)matcherProducer.fun((Object)uExpression);
                        securityUrlMatcher.setNavigationElement(argument.getSourcePsi());
                        matchersForCall.add(securityUrlMatcher);
                    }
                    continue;
                }
                matchersForCall.add((SpringSecurityUrlMatcher)matcherProducer.fun((Object)argument));
            }
            if (methodCallName != null) {
                for (SpringSecurityUrlMatcher matcher : matchersForCall) {
                    matcher.setRequestMethod(methodCallName);
                }
            }
            matchers.addAll(matchersForCall);
        }
        HashSet<UrlMatcher> hashSet = matchers;
        if (hashSet == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(53);
        }
        return hashSet;
    }

    @NotNull
    public static @NotNull List<@NotNull UExpression> getArrayInitializedExpressions(@NotNull UExpression argument) {
        UExpression initializer;
        PsiElement element;
        UVariable uVariable;
        if (argument == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(54);
        }
        if (argument instanceof USimpleNameReferenceExpression && (uVariable = (UVariable)UastContextKt.toUElement((PsiElement)(element = UastUtils.tryResolve((UElement)argument)), UVariable.class)) != null && (initializer = uVariable.getUastInitializer()) instanceof UCallExpression) {
            List list = ((UCallExpression)initializer).getValueArguments();
            if (list == null) {
                SpringSecuredUrlsUtils.$$$reportNull$$$0(55);
            }
            return list;
        }
        List<UExpression> list = Collections.emptyList();
        if (list == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    public static @NotNull List<@NotNull UExpression> getClassInitializedExpressions(@NotNull UExpression argument) {
        UExpression parameter;
        UCallExpression call;
        UExpression initializer;
        PsiElement element;
        UVariable uVariable;
        if (argument == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(57);
        }
        if (argument instanceof USimpleNameReferenceExpression && (uVariable = (UVariable)UastContextKt.toUElement((PsiElement)(element = UastUtils.tryResolve((UElement)argument)), UVariable.class)) != null && (initializer = uVariable.getUastInitializer()) instanceof UCallExpression && SpringSecuredUrlsUtils.isConstructorExpression((UExpression)(call = (UCallExpression)initializer)) && (parameter = SpringSecuredUrlsUtils.getConstructorPatternArgumentExpression(call)) != null) {
            List<UExpression> list = Collections.singletonList(parameter);
            if (list == null) {
                SpringSecuredUrlsUtils.$$$reportNull$$$0(58);
            }
            return list;
        }
        List<UExpression> list = Collections.emptyList();
        if (list == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(59);
        }
        return list;
    }

    @Nullable
    private static UExpression getConstructorPatternArgumentExpression(UCallExpression call) {
        if (SpringSecurityPatterns.MVC_REQUEST_MATCHER_EXPRESSION.accepts((Object)call)) {
            return call.getArgumentForParameter(1);
        }
        return call.getArgumentForParameter(0);
    }

    private static boolean isConstructorExpression(UExpression call) {
        return SpringSecurityPatterns.ANT_PATH_REQUEST_CONSTRUCTOR_MATCHER_EXPRESSION.accepts((Object)call) || SpringSecurityPatterns.REGEX_PATH_REQUEST_CONSTRUCTOR_MATCHER_EXPRESSION.accepts((Object)call) || SpringSecurityPatterns.PATH_PATTERN_PARSER_SERVER_EXCHANGE_CONSTRUCTOR_MATCHER_EXPRESSION.accepts((Object)call) || SpringSecurityPatterns.MVC_REQUEST_MATCHER_EXPRESSION.accepts((Object)call);
    }

    @Nullable
    private static String getHttpMethodName(@NotNull UExpression uExpression) {
        UExpression selector;
        if (uExpression == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(60);
        }
        if (uExpression instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)uExpression).getSelector()) instanceof UReferenceExpression) {
            return ((UReferenceExpression)selector).getResolvedName();
        }
        if (uExpression instanceof UReferenceExpression) {
            return ((UReferenceExpression)uExpression).getResolvedName();
        }
        return null;
    }

    public static Set<UrlMappingElement> getUrlMappings(@NotNull UExpression uExpression) {
        PsiElement sourcePsi;
        if (uExpression == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(61);
        }
        if ((sourcePsi = uExpression.getSourcePsi()) == null) {
            return Collections.emptySet();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
        if (module == null) {
            return Collections.emptySet();
        }
        UrlMatcher matcher = SpringSecuredUrlsUtils.findMatcher(uExpression, module);
        if (matcher != null) {
            return SpringMvcUtils.getUrlMappings((Module)module).stream().filter(element -> SpringSecuredUrlsUtils.isUrlMatched(matcher, element)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static boolean isEndpointSecured(@NotNull Module module, @NotNull String urlPath, String[] methods) {
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(62);
        }
        if (urlPath == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(63);
        }
        Set<UrlMatcher> matchers = SpringSecuredUrlsUtils.collectMatchers(module);
        for (UrlMatcher matcher : matchers) {
            if (!SpringSecuredUrlsUtils.isUrlMatched(matcher, urlPath, methods)) continue;
            return true;
        }
        return ContainerUtil.exists(matchers, AnyRequestMatcher.class::isInstance);
    }

    public static boolean isUrlMatched(@NotNull UrlMatcher matcher, @NotNull UrlMappingElement element) {
        if (matcher == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(64);
        }
        if (element == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(65);
        }
        return SpringSecuredUrlsUtils.isUrlMatched(matcher, UrlMappingElement.getPathPresentation((UrlMappingElement)element), ArrayUtil.toStringArray(Arrays.stream(element.getMethod()).map(method -> method.name()).toList()));
    }

    private static boolean isUrlMatched(@NotNull UrlMatcher matcher, @NotNull String urlPath, String ... methods) {
        if (matcher == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(66);
        }
        if (urlPath == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(67);
        }
        return matcher.accept(urlPath) && matcher.acceptMethod(methods);
    }

    @Nullable
    private static UrlMatcher findMatcher(@NotNull UExpression uExpression, Module module) {
        UMethod uMethod;
        if (uExpression == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(68);
        }
        if ((uMethod = (UMethod)UastUtils.getParentOfType((UElement)uExpression, UMethod.class)) != null) {
            Set<UrlMatcher> matchers = SpringSecuredUrlsUtils.collectMatchers(module, new LocalSearchScope(uMethod.getSourcePsi()));
            for (UrlMatcher matcher : matchers) {
                PsiElement expression = uExpression.getSourcePsi();
                if (expression == null || !expression.equals((Object)matcher.getIdentifyingElement())) continue;
                return matcher;
            }
        }
        return null;
    }

    @NotNull
    private static Collection<UrlMatcher> collectXmlMatchers(@NotNull SpringModel model, @NotNull Module module) {
        if (model == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(69);
        }
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(70);
        }
        HashSet<UrlMatcher> matchers = new HashSet<UrlMatcher>();
        for (Http http : SpringSecuredUrlsUtils.getHttpConfiguresFromXml(model, module)) {
            for (InterceptUrl interceptUrl : http.getInterceptUrls()) {
                GenericAttributeValue<String> pattern = interceptUrl.getPattern();
                String stringValue = pattern.getStringValue();
                if (!StringUtil.isNotEmpty((String)stringValue)) continue;
                matchers.add(new AntMatcher(stringValue, (PsiElement)pattern.getXmlElement()));
            }
        }
        HashSet<UrlMatcher> hashSet = matchers;
        if (hashSet == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(71);
        }
        return hashSet;
    }

    @NotNull
    private static Set<Http> getHttpConfiguresFromXml(@NotNull SpringModel model, @NotNull Module module) {
        if (model == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(72);
        }
        if (module == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(73);
        }
        HashSet<Http> https = new HashSet<Http>();
        PsiClass httpConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.web.FilterChainProxy");
        if (httpConfigurer == null) {
            Set<Http> set = Collections.emptySet();
            if (set == null) {
                SpringSecuredUrlsUtils.$$$reportNull$$$0(74);
            }
            return set;
        }
        Set models = SpringModelVisitorUtils.getLocalXmlModels((CommonSpringModel)model);
        for (LocalXmlModel localXmlModel : models) {
            if (!SpringSecurityUtil.isSpringSecurityNamespaceUsed((DomFileElement<Beans>)localXmlModel.getRoot())) continue;
            for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)localXmlModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)httpConfigurer))) {
                CommonSpringBean springBean = bean.getSpringBean();
                if (!(springBean instanceof Http)) continue;
                https.add((Http)springBean);
            }
        }
        HashSet<Http> hashSet = https;
        if (hashSet == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(75);
        }
        return hashSet;
    }

    public static Set<UrlMappingElement> getUrlMappings(@NotNull XmlAttribute xmlAttribute) {
        Module module;
        if (xmlAttribute == null) {
            SpringSecuredUrlsUtils.$$$reportNull$$$0(76);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)xmlAttribute)) == null) {
            return Collections.emptySet();
        }
        String stringValue = xmlAttribute.getValue();
        if (StringUtil.isNotEmpty((String)stringValue)) {
            AntMatcher matcher = new AntMatcher(stringValue, (PsiElement)xmlAttribute);
            return SpringMvcUtils.getUrlMappings((Module)module).stream().filter(element -> SpringSecuredUrlsUtils.isUrlMatched(matcher, element)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 7, 8, 9, 12, 13, 18, 20, 21, 24, 53, 55, 56, 58, 59, 71, 74, 75 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 71: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/mvc/SpringSecuredUrlsUtils";
                break;
            }
            case 4: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchers";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPathContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSearchScope";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodsCalls";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcherProducer";
                break;
            }
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 60: 
            case 61: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uExpression";
                break;
            }
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPath";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/mvc/SpringSecuredUrlsUtils";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMatchers";
                break;
            }
            case 3: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebSecurityConfigurerAdapterMatchers";
                break;
            }
            case 12: 
            case 13: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchedUrls";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyRequestMatchers";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayInitializedExpressions";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassInitializedExpressions";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "collectXmlMatchers";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpConfiguresFromXml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchers";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 71: 
            case 74: 
            case 75: {
                break;
            }
            case 2: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getMatchers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectWebSecurityConfigurerAdapterMatchers";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedUrls";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAnyRequestMatchers";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAntMatchers";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMvcMatchers";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRegexMatchers";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPathMatchers";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRequestMatchers";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getHttpSecurityMatchers";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getHttpAntMatchers";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getHttpRegexMatchers";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAntPathRequestMatcherAntMatchers";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getRegexRequestMatchers";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLogoutPageMatchers";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getFormLoginPageMatchers";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMvcRequestMatcherBuilderPatterns";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getArrayInitializedExpressions";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getClassInitializedExpressions";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getHttpMethodName";
                break;
            }
            case 61: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getUrlMappings";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isEndpointSecured";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isUrlMatched";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findMatcher";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "collectXmlMatchers";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getHttpConfiguresFromXml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 7, 8, 9, 12, 13, 18, 20, 21, 24, 53, 55, 56, 58, 59, 71, 74, 75 -> new IllegalStateException(string);
        };
    }
}

